#include "salem.h"

Matrix Beziermatrix = {
	{-1,3,-3,1},
	{3,-6,3,0},
	{-3,3,0,0},
	{1,0,0,0}
};

Matrix Identity = {
	{1,0,0,0},
	{0,1,0,0},
	{0,0,1,0},
	{0,0,0,1}
};

initiailize_globals()
{
	static char *argv[1] = {"made at initialization"};
	push_input(stdin);
	Globalcolor 		= 0x7f7f7f;
	Backgroundcolor		= 0xffffff;
	Geometry_type		= EUCLIDEAN;
	Time_quantum		= 1;
	Lights_exist		= FALSE;
	Root			= new_subobject("/",0,1,argv);
	Root->flags		= 0;
	World			= new_subobject("world",Root,1,argv);
	World->flags		= 0;
	Selected.object	= World;
	Last_time = getvaluator(TIMER0);
}

parse_command_line(argc,argv)
int argc;
char **argv;
{
	
	int	i,n ;
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') argv[i]++;
		for ( n = 0; (i + n) < argc ;  n++ )
			if (argv[i + n][0]=='-') break ;
		do_command(n,&argv[i]);
		i += (n-1);
		}
}

parse_rc_file()
{
	FILE *fp, *my_fopen();
	if ((fp = my_fopen(".slrc",getenv("HOME"))) != NULL) push_input(fp);
	else	if ((fp = fopen(DEFAULTRC,"r")) != NULL) push_input(fp);
	else	ERR_RET("no DEFAULTRC, please contact your csstaff")
}
