#include <stdio.h>
#include <ctype.h>

#define	CBRA	1
#define	CCHR	2
#define	CANYSTAR	4
#define	CCL	6
#define	NCCL	8
#define	CDOL	10
#define	CEOF	11
#define	CKET	12
#define	CBRC	14
#define	CLET	15
#define	CBACK	18

#define	STAR	01

#define	ESIZE	256
#define	NBRA	9

static char bittab[] = {
	1,
	2,
	4,
	8,
	16,
	32,
	64,
	128
};

static ecmp(a, b, count)
char	*a, *b;
{
	register cc = count;
	while(--cc) if(*a++ != *b++)	return(0);
	return(1);
}

char* regex_compile(astr)
char *astr;
{
	register c;
	register char *ep, *sp;
	char *cstart, *lastep, bracket[NBRA], *bracketp, *expbuf, numbra, neg;
	int cclcnt, closed;

	expbuf = (char*)malloc(ESIZE);
	ep = expbuf;
	sp = astr;
	bracketp = bracket;
	lastep = NULL;
	closed = numbra = 0;
	for (;;) {
		if (ep >= &expbuf[ESIZE]) goto cerror;
		if ((c = *sp++) != '*') lastep = ep;
		switch (c) {

		case '\0': *ep++ = CDOL; *ep++ = CEOF; return expbuf;

		case '*':
			if (lastep && (*lastep==CBRA || *lastep==CKET ||
			    *lastep == CBRC || *lastep == CLET))
				goto defchar;
			*ep++ = CANYSTAR;
			continue;

		case '$':
			if (*sp != '\0') goto defchar;
			*ep++ = CDOL;
			continue;

		case '[':
			if(&ep[17] >= &expbuf[ESIZE]) goto cerror;
			*ep++ = CCL;
			neg = 0;
			if((c = *sp++) == '^') { neg = 1; c = *sp++; }
			cstart = sp;
			do {
				if (c=='\0') goto cerror;
				if (c=='-' && sp>cstart && *sp!=']') {
					for (c = sp[-2]; c<*sp; c++)
						ep[c>>3] |= bittab[c&07];
					sp++;
					}
				ep[c>>3] |= bittab[c&07];
				} while((c = *sp++) != ']');
			if(neg) {
				for(cclcnt = 0; cclcnt < 16; cclcnt++)
					ep[cclcnt] ^= -1;
				ep[0] &= 0376;
				}

			ep += 16;

			continue;

		case '\\':
			if((c = *sp++) == 0) goto cerror;
			if(c == '<') { *ep++ = CBRC; continue; }
			if(c == '>') { *ep++ = CLET; continue; }
			if(c == '(') {
				if(numbra >= NBRA) { goto cerror; }
				*bracketp++ = numbra;
				*ep++ = CBRA;
				*ep++ = numbra++;
				continue;
				}
			if(c == ')') {
				if(bracketp <= bracket) { goto cerror; }
				*ep++ = CKET;
				*ep++ = *--bracketp;
				closed++;
				continue;
				}

			if(c >= '1' && c <= '9') {
				if((c -= '1') >= closed) goto cerror;
				*ep++ = CBACK;
				*ep++ = c;
				continue;
				}

		defchar:
		default:
			*ep++ = CCHR;
			*ep++ = c;
			}
		}
    cerror:
	fprintf(stderr,"grep: RE error\n");
	return NULL;
}

regex_advance(lp, ep)
register char *lp, *ep;
{
	register char *curlp;
	char c, *bbeg, *expbuf;
	int ct;
	char	*braslist[NBRA], *braelist[NBRA];

	expbuf = ep;
	for (;;) switch (*ep++) {

	case CCHR: if (*ep++ == *lp++) continue; return(0);
	case CDOL: if (*lp==0) continue; return(0);
	case CEOF: return(1);
	case CCL: c = *lp++ & 0177;
		if(ep[c>>3] & bittab[c & 07]) { ep += 16; continue; }
		return(0);
	case CBRA: braslist[*ep++] = lp; continue;
	case CKET: braelist[*ep++] = lp; continue;
	case CBACK:
		bbeg = braslist[*ep];
		if (braelist[*ep]==0) return(0);
		ct = braelist[*ep++] - bbeg;
		if(ecmp(bbeg, lp, ct)) { lp += ct; continue; }
		return(0);
	case CBACK|STAR:
		bbeg = braslist[*ep];
		if (braelist[*ep]==0) return(0);
		ct = braelist[*ep++] - bbeg;
		curlp = lp;
		while(ecmp(bbeg, lp, ct)) lp += ct;
		while(lp >= curlp) { if(regex_advance(lp, ep)) return(1); lp -= ct; }
		return(0);

	case CANYSTAR: curlp = lp; while (*lp++); goto star;
	case CCHR|STAR: curlp = lp; while (*lp++ == *ep); ep++; goto star;

	case CCL|STAR:
		curlp = lp;
		do { c = *lp++ & 0177; } while(ep[c>>3] & bittab[c & 07]);
		ep += 16;
		goto star;

	star:
		if(--lp == curlp) { continue; }
		if(*ep == CCHR) {
			c = ep[1];
			do {
				if(*lp != c) continue;
				if(regex_advance(lp, ep)) return(1);
				} while(lp-- > curlp);
			return(0);
			}
		do { if (regex_advance(lp, ep)) return(1); } while (lp-- > curlp);
		return(0);

	case CBRC:
		if (lp == expbuf) continue;
#define	uletter(c)	(isalpha(c) || (c) == '_')
		if (uletter(*lp) || isdigit(*lp))
			if (!uletter(lp[-1]) && !isdigit(lp[-1])) continue;
		return (0);

	case CLET:
		if (!uletter(*lp) && !isdigit(*lp)) continue;
		return (0);

	default: fprintf(stderr,"grep RE botch\n"); return(0);
	}
}
