
/*	Winged edge data structure represented in Lincoln file format


		\               /	 
		 \             /
		  \           /
		   \         /
	     e[0][0]\       /e[1][0]
		     \     /
		      \   /
			v[0]
			|
			|
			|
        f[0]		|e                 f[1]
			|
			|
			|
			|
			v[1]
                       / \
                      /   \
              e[0][1]/     \e[1][1]
                    /       \
                   /         \
                  /           \

*/

#define BUFSIZE 256

struct equation	{
	float x,y,z,w;
	};

typedef struct lvertex_t	{	
	float position[4];
	struct ledge_t *e;
	int order;
	} lvertex_t;

typedef struct ledge_t	{
	lvertex_t *v[2] ;
	struct lface_t   *f[2] ;
	struct ledge_t   *e[2][2] ;
	} ledge_t ;

struct facechars	{  
	int color;	};

typedef struct lface_t	{	
	struct equation eqn;
	ledge_t *e;
	int order;
	struct facechars chars;			
	} lface_t ;

typedef struct ldata_t    { 
	char title[BUFSIZE]; 
	int dim, nvertices, nedges, nfaces, nobjects ;
	} ldata_t ;

typedef struct lincoln_t	{
	lvertex_t	*vlist;
	ledge_t		*elist;
	lface_t		*flist;
	ldata_t		data;
	} lincoln_t;

#define		Vint(v, orig) ( (int) ( v - orig) )
