
/*	Winged edge data structure represented in Lincoln file format


		\               /	 
		 \             /
		  \           /
		   \         /
		 e00\       /e10
		     \     /
		      \   /
			v0
			|
			|
			|
        f0		|e                 f1
			|
			|
			|
			|
			v1
                       / \
                      /   \
                  e01/     \e11
                    /       \
                   /         \
                  /           \

*/

#define BUFSIZE 256

struct position  {
	float x,y,z,w;
		};

struct equation	{
	float x,y,z,w;
		};

/*
struct vertexchars	{  information will be stored here
	to give the characteristics of an vertex (e.g. pointtype, color,...) }
*/

struct vertex	{	
	struct position pos;
	struct edge *e;
	int order;
/*	struct vertexchars chars;		*/
		};

/*
struct edgechars	{  information will be stored here
	to give the characteristics of an edge (e.g. thickness, color,...) }
*/

struct edge	{
	struct vertex *v0,*v1;
	struct face   *f0,*f1;
	struct edge   *e00,*e01,*e10,*e11;
/*	struct edgechars chars;			*/
		};

struct facechars	{  
	int color;	};

struct face	{	
	struct equation eqn;
	struct edge *e;
	int order;
	struct facechars chars;			
		};

struct data    { char title[BUFSIZE]; int dim, nvertices, nedges, nfaces, nobjects ;} ;
