#include "sli.h"
static int	N_polys,X_off;;
static float	Stroke_width;

static h_count(x,y,n)
short	x[],y[];
int		n;
{
	N_polys += (n - 1) ;
}

static nop () {}

static setp(vno)
int	vno;
{
	int	k, varr[4];
	for (k = 0; k < 4; k++) varr[k] = vno + k;
	sl_face(4, varr);
}

static setv(x,y,z,w)
float		x,y,z,w;
{
	sl_vertex( (double) x/10.0, (double) y/10.0, (double) z/10.0 );
}

h_stroke(x,y,n)
short	x[],y[];
int		n;
{
	int		i,k,i0,i1;
	float		theta,xfuzz,yfuzz,s;

	for (i = 0; i < n - 1; i++) {
		if (x[i+1] >= x[i]) {i0 = i; i1 = i+ 1;}
		else {i0 = i + 1; i1 = i;}
		theta = atan2((double)y[i1]-y[i0],(double)x[i1]-x[i0]);
		s = (theta > 0)? 1.0 : -1.0;
		xfuzz = s * fabs(sin(theta) * Stroke_width);
		yfuzz = fabs(cos(theta) * Stroke_width);
		setv(x[i0] + X_off + xfuzz, y[i0] - yfuzz, 0, 0);
		setv(x[i1] + X_off + xfuzz, y[i1] - yfuzz, 0, 0);
		setv(x[i1] + X_off - xfuzz, y[i1] + yfuzz, 0, 0);
		setv(x[i0] + X_off - xfuzz, y[i0] + yfuzz, 0, 0);
		setp(4*N_polys);
		N_polys++ ;
		}
}

count_polys(p)
char	*p;
{
	short	x[50],y[50];
	N_polys = 0;
	while (*p) h_draw(*p++,h_count,x,y);
}

draw_fonts(p)
char		*p;
{
	short	x[50],y[50];

	Stroke_width = h_draw('x',nop,x,y) / 15.;
	X_off = 0;
	N_polys = 0;
	while (*p) X_off += h_draw(*p++,h_stroke,x,y);
}

static int font_mounted;

showtext(argc,argv)
int		argc;
char	**argv;
{
	int			i;
	char		*p;

	if (font_mounted == FALSE) {
		h_mount(0,"roman");
		h_font(0);
		font_mounted = TRUE;
		}

	if (argc != 3) fprintf(stderr,"%s string objname\n",argv[0]);
	else {
		p = argv[1];
		count_polys(p);
		sl_create_object(argv[2],N_polys * 4, N_polys, argc,argv);
		draw_fonts(p);
		sl_default_color_object();
		sl_close_object();
	}
}

setfont(argc,argv)
int	argc;
char	**argv;
{
	if (argc > 1) {
		if (font_mounted = (h_mount(0,argv[1]) == 0)) h_mount(0);
		else fprintf(stderr,"no such font\n");
		}
}

initialize_hershey()
{
	register_client("showtext",showtext,"showtext string objname");
	register_client("setfont",setfont,"setfont fontname");
}
