#include "Default_utils_def.h"

#define TR(i, j,  k) ((j) + ( (i) * c[ (k) ]) + off[ (k) ])

#define TRIOUT( i0 , j0 , k0 , i1 , j1 , k1 , i2 , j2 , k2 )	\
	varr[0] = TR(i0,j0,k0) ;\
	varr[1] = TR(i1,j1,k1) ;\
	varr[2] = TR(i2,j2,k2) ;\
	sl_face(3, varr);

#define QUAD(i, i1, j, j1, k) \
	TRIOUT(i,j,k,i1,j,k,i,j1,k) TRIOUT(i1,j,k,i,j1,k,i1,j1,k)


#define BIQUAD(j, i, i1, k, J, I, I1, K)\
	TRIOUT(j,i,k,j,i1,k,J,I,K) TRIOUT(j,i1,k,J,I,K,J,I1,K)

#define TRIQUAD(j,i,k, j1,i1,k1, J,I,I1,K)\
	TRIOUT(j,i,k,J,I,K,J,I1,K) TRIOUT(j,i,k,j1,i1,k1,J,I1,K)

#define QUAD_LOOP(k, i )	\
	i1 = i + 1;\
	for (j = 0 ; j < c[k] ; j++ )	{\
		j1 = (j + 1)%c[ k ] ;\
		QUAD(i, i1, j, j1, k );\
		}

#define V3(x,y,z)	sl_vertex(x,y,z);

#define  TRIPLE( j, t, r, R, theta, xo )	\
		phi = M_PI + ((double) j) * (2.0 * M_PI/((double) (t))) ;\
		x = r * cos(theta) + R * cos(theta) * cos(phi);\
		y = r * sin(theta) + R * sin(theta) * cos(phi);\
		z = R * sin(phi);\
		V3( x + xo, y, z);

#define LOOP( fr, degs, steps, cs, r, R, xo)	\
		for (i = 0 ; i < steps ; i++ )	{\
		      theta = (RAD(fr)) + i*((RAD(degs))/((double) (steps-1)));\
		      for (j =0; j < cs ;j++) {TRIPLE( j, cs, r, R, theta, xo)}\
			}
#define NECK_LOOP(rad, xc, yc, ycd, sv, cv)\
	for (i = 0 ; i < sv ; i++ )	{\
		for (j = 0 ; j < cv ; j++ )	{\
			phi = M_PI + ((double)j)*(2.0 * M_PI/((double)cv));\
			V3( xc + (rad * cos(phi)), yc, rad * sin(phi) );\
			}\
		yc += ycd;\
		}

