#include "Genus_tor_def.h"

int make_torus();

initialize_torus()
{
	register_client("torus", make_torus, "torus s c r R n [objname]");
}

int make_torus(argc,argv)
int argc;
char **argv;
{
	int 		sv = 35, cv = 5, nholes = 3, a = 1, varr[3];
	double 		r = 1.0, R = 0.5;
	char 		tname[127];

	int nverts,nedges,nfaces,i,j,k,i1,j1,v1,v2,v3,s[100],c[100],off[100];
	double theta, phi, x, y, z, radius, xcenter, ycenter, ycenterdelta;
	int ni,n1,nk,i2,i21, ck2, ck21, ckmj, ckmj1, ckmjm, ckpj, ckpj1;
	int sv3,sv23,topl, botl, topr, botr, cnkj, cnkj1, snk1;

	(void) strcpy(tname, "torus");

	if (argc > a) sv =atoi(argv[a++]); set_int(sv,&sv,7,150,15);sv=(sv/3)*3;
	if (argc > a) cv = atoi(argv[a++]); set_int(cv,&cv,3,30,5); 
	if (argc > a) r = atof(argv[a++]); set_double(r,&r,.5,9.0,1.0);
	if (argc > a) R = atof(argv[a++]); set_double(R,&R,.1,2.0,.5);
	if (argc > a) nholes = atoi(argv[a++]); set_int(nholes,&nholes,1,20,3);
	if (argc > a) (void) strcpy(tname, argv[a++]);


	n1 = nholes - 1;

	sv3 = (int) ((float) sv)/3.0; sv23 = 2 * sv3;
	s[0] = sv; s[n1] = sv; c[0] = c[n1] = cv;
	for (i = 1 ; i < n1 ; i++ ) s[i] = sv23, c[i] = cv;

	for (i = 0; i < n1; i++ ) ni =nholes+i, s[ni] = sv3, c[ni] = 2*cv;

	off[0] = 0; for (i=1;i<(2*nholes);i++) off[i] = off[i-1]+c[i-1]*s[i-1];

	nverts = sv3 * cv * 4 * nholes ;
	nedges =  sv  * cv * 4 * nholes + 6 * n1 ;
	nfaces = sv3 * cv * 8 * nholes + 4 * n1;

	sl_create_object(tname, nverts, nfaces, argc, argv);

	if (nholes == 1)	{
		double tf;
		s[0] = 4*sv3;
		tf = ((double) 360.0) * ((double) (s[0]-1)/((double) (s[0])));
		LOOP( 0, tf, s[0], c[0], r, R, 0.0);
		for (i = 0 ; i < (s[0]-1) ; i++ )	{
			QUAD_LOOP(0, i ) 
			}
		for (j = 0 ; j < c[0] ; j++ )	{
			j1 = (j + 1)%c[0];
			QUAD( (s[0]-1), 0, j, j1, 0);
			}
		sl_color_object();
		sl_close_object();
		return;
		}

/* vertices of open curve 1 which goes from +50 degrees to +310 degrees */
	LOOP( 50, 260, s[0], c[0], r, R, 0.0);

/* now tops and bottoms of nholes-2 pieces  
   tops --> +130 to +50 degrees CW bottoms --> +230 to +310 degrees CCW 
*/
	for (k = 1 ; k < n1; k++ )	{
		LOOP( 130, -80, s[k]/2 , c[k], r, R, 2*k*r );
		LOOP( 230,  80, s[k]/2 , c[k], r, R, 2*k*r );
		}

/* vertices of last open curve which goes from +130 degree to +230 degrees CW */
	LOOP( 490, -260, s[n1], c[n1], r, R, 2*n1*r );

/* vertices of necks currently modelled as cylinder (to be ellipse eventually)*/

	radius = R;
	for (k = 0 ; k < n1; k++ )	{
		nk = nholes + k;
		xcenter = r * ( 2*k + 1 );
		ycenterdelta = (sqrt(2.0)*(r-R))/ ((double) (s[nk]+1));
		ycenter = ycenterdelta + (R - r)/sqrt(2.0);
		NECK_LOOP(radius, xcenter, ycenter, ycenterdelta, s[nk], c[nk])
		}

/* now we do the triangles */

/* curve first and last*/
	for (i = 0 ; i < (s[0]-1) ; i++ )	{
		QUAD_LOOP(0, i ) QUAD_LOOP(n1, i )
		}

/* tops and bottoms */
	for (k = 1 ; k < n1; k++ )
		for (i = 0 ; i < (s[k]/2-1) ; i++ )	{
			QUAD_LOOP(k, i) QUAD_LOOP(k, i + (s[k]/2) )
			}

/* the necks */			
	for (k = 0 ; k < n1 ; k++ )
		for (i = 0 ; i < (s[nholes+k]-1) ; i++ )	{
			QUAD_LOOP(nholes+k, i)
			}

/* attaching ends of toruses to bottom of neck 
0 gets atatched to nholes left
1 start gets attached to nholes right
1 end gets attached to nholes + 1 left
...
*/
	for (k = 0 ; k < n1 ; k++ )	{
		nk = nholes + k;
		ck2 = c[k]/2; ck21 = ck2+1;
		topr = 0; botl = s[k]-1;
		topl =  (k == 0) ? 0 : (s[k]/2 - 1);	
		botr = (k == (n1-1)) ? (s[n1]-1) : (s[k+1]/2);
		for (j = 0 ; j < c[k]/2; j++ )	{
			j1 = j+1;
			ckmj = c[k] - j; ckmj1 = ckmj - 1; ckmjm = ckmj%c[k];
			ckpj = c[k] + j; ckpj1 = ckpj + 1;
			cnkj = (c[nk]-j)%c[nk]; cnkj1 = c[nk]-j1;
			snk1 = s[nk] - 1;
		
			BIQUAD(snk1,j,j1,nk,topl,j,j1,k);
			BIQUAD(snk1,cnkj1,cnkj,nk,topl,ckmj1,ckmjm,k);
			BIQUAD(snk1,ckpj,ckpj1,nk,topr,ckmjm,ckmj1,k+1);
			BIQUAD(snk1,ckmj1,ckmj,nk,topr,j1,j,k+1);
			BIQUAD(0,j,j1,nk,botl,j,j1,k);
			BIQUAD(0,cnkj1,cnkj,nk,botl,ckmj1,ckmjm,k);
			BIQUAD(0,ckpj,ckpj1,nk,botr,ckmjm,ckmj1,k+1);
			BIQUAD(0,ckmj1,ckmj,nk,botr,j1,j,k+1);
			}
		BIQUAD(topl,ck21, ck2, k, topr, ck21, ck2, k+1);
		BIQUAD(botl,ck21, ck2, k, botr, ck21, ck2, k+1);
		TRIQUAD(topl,ck21,k,topr,ck21,k+1,snk1,c[nk]-ck2,c[nk]-ck21,nk);
		TRIQUAD(topl,ck2,k,topr,ck2,k+1,snk1,ck2,ck21,nk);
		TRIQUAD(botl,ck21,k,botr,ck21,k+1,0,c[nk]-ck2,c[nk]-ck21,nk);
		TRIQUAD(botl,ck2,k,botr,ck2,k+1,0,ck2,ck21,nk);
		}

	sl_color_object();
	sl_close_object();
}
