
/*=========================================================================
  Hull.c    This file contains the functions that make the rest of
  the hull after the initial tetrahedron is built.
 =========================================================================*/

#include "3DHull_structs.h"
#include "3DHull_macros.h"

/*-------------------------------------------------------------------------
        Complete_hull goes through the vertex list and adds them to the hull
   if they are not already used.  It will mark the vertex once it is 
   looked at.
  -------------------------------------------------------------------------*/
int volcount;
int zzz;

complete_hull()
{
	register struct tvertex *v, *w;


	v = vertices;
	do {w = v->next;
           if ( !v->mark ) {
                 v->mark = MARKED;
	         if (find_vis(v)) do_edges(v);
		 else DEL_QUEUE(vertices, v);
                 /* add_on( v ); replaced by 2 lines above */
                 clean_up();
		 break;
                 }
            v = w;
            } while ( v != vertices );

	v = vertices;
	do {w = v->next;
           if ( (!v->mark) && (!test_vis(v))) 
		    {	    zzz++;
		     DEL_QUEUE(vertices, v);}
            v = w;
            } while ( v != vertices );
/*	printf("work = %d, zzz= %d\n",volcount,zzz); */

	v = vertices;
	do {w = v->next;
           if ( !v->mark ) {
                 v->mark = MARKED;
		 /* next two lines are "add_on" */
	         if (find_vis(v)) do_edges(v);
		 else DEL_QUEUE(vertices, v);
                 clean_up();
                 }
            v = w;
            } while ( v != vertices );

/*	printf("work = %d\n",volcount);   */
/*	clean_vertices(); */
}

/*---------------------------------------------------------------------------
      Add_on is passed a vertex.  It will first determine all faces that
  are visible from that point.  If none are visible then the point is 
  deleted.  Then it will go through the edge list.  If both
  of the edges adjacent faces are  visible then the edge is marked
  deleted.  If one of the adjacent faces is visible then a new face is 
  made and the edges adjacent face[2] pointer is set to point to it.
  A temporary pointer is used so that any new edge just added to the 
  list will not be examined.
  --------------------------------------------------------------------------*/

test_vis(p) register struct tvertex *p;
{
	register struct tface *f; 

        f = faces;
	do {register double *fv = f->vert[0]->v;
	    volcount++;
	    if ( f->p[X]*(p->v[0] - fv[0]) +
		 f->p[Y]*(p->v[1] - fv[1]) +
		 f->p[Z]*(p->v[2] - fv[2])
	          < 0 )  return 1;
	   f=f->next;
	} while (f != faces);
        return 0;
}

find_vis(p) register struct tvertex *p;
{int vis;
	register struct tface *f; 

	vis=0;  /* initialize this, it's important!!! */

        f = faces;
	do {register double *fv = f->vert[0]->v;
	    volcount++;
	    if ( f->p[X]*(p->v[0] - fv[0]) +
		 f->p[Y]*(p->v[1] - fv[1]) +
		 f->p[Z]*(p->v[2] - fv[2])
	          < 0 ) {
			*(bad_faces + bad_face_no++) = f;
                	f->visible = VISIBLE;  
	                vis++;
		        }
	   f=f->next;
	} while (f != faces);
        return vis;
}

do_edges(p) struct tvertex *p;
{
	         struct tface *make_structs();
	register struct tedge *e;
        e = edges;
	do {
           struct tedge	*temp;
           temp = e->next;
           if ( e->adjface[0]->visible && e->adjface[1]->visible ) {
                /* if e is an interior edge, delete it */
		if (!e->deleted)	{
			*( bad_edges + bad_edge_no++) = e;
                	e->deleted = DELETED;
			}
		}

           else if ( e->adjface[0]->visible || e->adjface[1]->visible ) {
                /* if e is a border edge, make a new face */
                e->adjface[2] = make_structs( e, p );
		* (adj_2_edges + adj_2_edge_no++) = e ;
		}
           e = temp;
           } while ( e != edges );

}
