#define global
#include "3DHull_structs.h"
#include "3DHull_macros.h"
#define TWOPI 2*M_PI
#define SEED 1

int convex_hull();
int convex_hull_add();

char *Usage = "usage convex_hull [sN] [nN] [b] objname";

initialize_convex_hull()
{
        register_client("convex_hull", convex_hull, Usage);
}

int
convex_hull(argc,argv)
int argc;
char **argv;
{
	int seed = SEED;
	int i, nmax = 1000 ;
	int sphere_flag = 0 ;
	double x,y,z,l,ll,theta ;
	struct rvertex *vl, *vp;

	for (i = 1; i < argc - 1 ; i++ )
		switch(argv[i][0])	{
			case 's': seed = atoi(&argv[i][1]);  break;
			case 'n': nmax = atoi(&argv[i][1]);  break;
			case 'b': sphere_flag = 1 - sphere_flag ; break;
			default : if (isdigit(argv[i][0])) nmax = atoi(argv[i]); 
				else {
				      fprintf(stderr,"usage : %s\n",Usage);
				      return(0);
				      }
			}

	srand48(seed);

	vl = (struct rvertex *) malloc(nmax * sizeof (struct rvertex)) ;
	vp = vl ;
	bad_vertices = (struct tvertex **) malloc(nmax*sizeof(struct tvertex *));
	duplicate_vertices = (struct tvertex **) malloc(nmax*sizeof(struct tvertex *));
	bad_edges = (struct tedge **) malloc((3*nmax-6)*sizeof(struct tedge *));
	adj_2_edges=(struct tedge **) malloc((3*nmax-6)*sizeof(struct tedge *));
	bad_faces = (struct tface **) malloc((2*nmax-4)*sizeof(struct tface *));

	vertices = NULL;
	edges    = NULL;
	faces    = NULL;
	bad_vertex_no = 0 , bad_edge_no = 0 , adj_2_edge_no = 0 ; 
	bad_face_no = 0 , duplicate_vertex_no = 0 ;

	for (i = 0 ; i < nmax ; i++, vp++ )	{
		l =  ((double) (rand()%100000))/100000. ;
/* take log, take 1/3 exp the result    */
		l = exp(log(l)/3.);
                x = l * (-1.0 + drand48() * 2.0);
                theta = TWOPI * (-1.0 + drand48() * 2.0);
                ll = sqrt((l*l) - (x*x));
                y = ll * sin(theta);
                z = ll * cos(theta);

		if (sphere_flag)	{
			ll = sqrt(x*x + y*y + z*z) ;
			x /= ll ;
			y /= ll ;
			z /= ll ;
			}

		vp->v[0] = x;
		vp->v[1] = y;
		vp->v[2] = z;
		}


        get_from(vl,nmax);		/* read input */
        if (0 != init_tet())	{ 		/* find initial tetrahedron */
	        complete_hull();		/* find remainder of hull */
		sl_create_object(argv[argc-1], nmax, nmax, argc, argv);
		sl_object_data();		/* give salem info re hull */
		sl_color_object();
		sl_close_object();
		}

	free(vl);
	free(bad_vertices);
	free(duplicate_vertices);
	free(bad_edges);
	free(adj_2_edges);
	free(bad_faces);
}
