#define ODEFINE_GLOBALS
#include "2D-DT_defines.h"

/****************************************************************/
/*	Voronoi Output Routines
/****************************************************************/

output_voronoi_diagram(edge,nv)
EDGE_PTR edge;
int nv;
{
	EDGE_PTR nex, prev, snex, sprev, ce, dp;
	struct VEC2 cvxvec, center;
	double ln;
	int i,j, num_faces = -1;

	/* Plot DT edges and finite VD edges. */
	for (i = 0 ; i < nv ; i++ )	
		sl_vertex(VX(i), VY(i), (double) 0.0);

	my_stack.ptr = 0;
	push_ring(&my_stack, edge);
	while (my_stack.ptr != 0) {
		edge = pop_edge(&my_stack);
		if (seen(edge) == 1) {
			if ((VX(orig(edge)) > VX(dest(edge)))	||
   					((VX(orig(edge)) == VX(dest(edge))) && 
					(VY(orig(edge))>VY(dest(edge)))))    {
				ce = onext(edge);
				dp = dprev(edge);
				if ((VX(orig(ce)) > VX(dest(ce)))  ||
						((VX(orig(ce))==VX(dest(ce)))&&
						(VY(orig(ce))>VY(dest(ce)))))
					if (num_faces++ > -1)	
						sl_triangle(orig(edge),
							dest(edge), dest(ce));
				}
			}
		push_ring(&my_stack, sym(edge));
		}
	zero_seen(&my_stack, edge);

	return(num_faces);
}
