#include "2D-DT_defines.h"

/****************************************************************/
/*	Top-level Delaunay Triangulation Procedure
/****************************************************************/

build_delaunay_triangulation(size, edge, rows)
    /* builds delaunay triangulation.
       va is an array of vertices, from 0 to size.  Each vertex consists of
       a vector and a data pointer.   edge is a pointer to an
       edge on the convex hull of the constructed delaunay triangulation. */

int size,rows;
EDGE_PTR *edge;
{
    int i;
    EDGE_PTR left, right;

    /* compute norm of each vector, and initialize vp for sorting */
    for (i=0; i <= size; i++) {
	NORM(i) = VX(i) * VX(i)  +  VY(i) * VY(i);
	vp[i] = i;
    }
    /* A little diddle for our great sorting routines. */
    if (size < num_vertices-1) {vp[size+1] = size+1;};
    build_delaunay(vp, 0, size, &left, &right, rows, (double) 0.0,(double) 1.0);
    *edge = left;
};

/****************************************************************/
/*	Recursive Delaunay Triangulation Procedure
/*	Contains modifications for axis-switching division.
/****************************************************************/

build_delaunay(vp, lo, hi, le, re, rows, y, yy)
VERTEX_PTR vp[];
int lo,hi,rows;
EDGE_PTR *le,*re;
double y,yy;
{
    EDGE_PTR a,b,c,ldo,rdi,ldi,rdo;
    int split, lowrows;
    register int low, high, maxx, minx;
    VERTEX_PTR s1, s2, s3;
    low = lo; high = hi;

    if (low < (high-2)) {
        /* more than three elements; do recursion */
	minx = vp[low]; maxx = vp[high];
	if (rows == 1) {	/* time to switch axis of division */
	    vpsorty(low, high, y, yy);
	    rows = 65536;
	}	  
	lowrows = rows>>1;
	split = low - 1 + (int) (0.5 +
	    ((double)(high-low+1) * ((double)lowrows / (double)rows)));
	build_delaunay(vp, low, split, &ldo, &ldi, lowrows,y,yy);
	build_delaunay(vp, split+1, high, &rdi, &rdo, (rows-lowrows),y,yy);
	do_merge(&ldo, ldi, rdi, &rdo);
	while (orig(ldo) != minx) ldo = rprev(ldo);
	while (orig(rdo) != maxx) rdo = lprev(rdo);
	*le = ldo;
	*re = rdo;
    }
    else if (low >= (high - 1)) {	/* two or one points */
	a = makeedge(vp[low], vp[high]);
	*le = a;
	*re = sym(a);
	if (low==high) {printf("ERROR: Only 1 point!\n"); fflush(stdout);}
    }
    else { /*  (low == (high - 2))  */	/* three points */
	/* 3 cases: triangles of 2 orientations, and 3 points on a line. */
	a = makeedge((s1 = vp[low]), (s2 = vp[low+1]));
	b = makeedge(s2, (s3 = vp[high]));
	splice(sym(a), b);
	c = connect_left(b, a);
	if (ccw(s1, s3, s2)) {
	    *le = sym(c);
	    *re = c;
	}
	else {
	    *le = a;
	    *re = sym(b);
	    if (!ccw(s1, s2, s3)) deleteedge(c);    /* colinear */
	}
    }
};
