/*
 *----------------------------------------------------------------------
 *  File:  wff2bm.c
 *	Convert a wff bitmap image to an ascii representation.
 *----------------------------------------------------------------------
 */
#include <stdio.h>
#include <math.h>
#include <strings.h>
#include "wff.h"

#define MAX_SIZE 1300

char black = '#';
char white = '-';

PutBitmapPixel(p)
short p;
{
	if ( p == 0 ) {
		printf("%c",black);
	} else {
		printf("%c",white);
	}
}

main(argc,argv)
int argc;
char* argv[];
{
	int height;
	int width;
	FrameBufferType* fb;
	short p;
	int i,j;
	char buf[100];


	fb = NULL;
	OpenFB(&fb);
	ReadImage(stdin, fb);
	GetDescriptor(fb, "ColorSystem", buf);
	if ( strcmp("I",buf) != 0 ) {
		fprintf(stderr,"wff2bm: image isn't an intensity image.\n");
		exit(1);
	}
	GetDescriptor(fb, "width", buf);
	width = atoi(buf);
	GetDescriptor(fb, "height", buf);
	height = atoi(buf);
	for(i=0; i<height; i++) {
		for(j=0; j<width; j++) {
			GetPixel(fb, j, height-1-i, &p);
			PutBitmapPixel(p);
		}
		printf("\n");
	}
}


FormatError()
{
	fprintf(stderr,"Format: wff2a [-b c] [-w c]\n");
	exit(1);
}

ParseArgs(argc, argv)
int argc;
char* argv[];
{
	int i;

	for ( i=1; i<argc; i++ ) {
		if ( argv[i][0] != '-' ) {
			FormatError();
		}
		switch(argv[i][1]) {
		      case 'b':
			black = argv[i+1][0];
			i++;
			break;
		      case 'w':
			white = argv[i+1][0];
			i++;
			break;
		      default:
			FormatError();
		}
	}
}
