/*
  File: RLE.c 
  Authors: Mike Schmidt,
           K.R. Sloan,
	   James Painter
  Last Modified: 2 November 1988
  Purpose: Convert a WFF image file to RLE encoding
 */
#include <stdio.h>
#include <strings.h>
#include "wff.h"

static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s\n",
           RoutineName);
 }
static void
Pass(fdIn,fdOut)
 FILE *fdIn, *fdOut;
 {
  FrameBufferType *FBin = NULL, *FBout = NULL;
  int Bottom, Left, Top, Right;
  char Name[NameLength], Value[ValueLength];
  int x,y,n;
  unsigned short *Pixel;
  int passed = 0, width;
  int BandsPerPixel;

  if (FAILURE == OpenFB(&FBin))           {                        return; }
  if (FAILURE == PassImageIn(fdIn, FBin)) { (void)CloseFB(&FBin);  return; }
  if (FAILURE == OpenFB(&FBout))          { (void)CloseFB(&FBin);  return; }
 

  /*  Copy over existing NV pairs - watch for "X-PassedBy" */
  for (n=0;;n++)
   {
    GetDescriptorN(FBin, n, Name, Value);
    if (Name[0] == '\0') break;

    if      (0 == strcmp(Name,"Encoding"))
     {
      strcpy(Value,"RLE");
     }
    else if (0 == strcmp(Name,"X-PassedBy"))
     {
      if ( (strlen(Value)+strlen(RoutineName)+3) > ValueLength)
       strcpy(Value,"...");
      strcat(Value,", "); strcat(Value,RoutineName);
      passed = 1;
     }
    SetDescriptor(FBout, Name, Value);
   }

  /*  if necessary, add "X-PassedBy" */
  if (0 == passed)
   {
    strcpy(Name,"X-PassedBy");
    strcpy(Value,RoutineName);
    SetDescriptor(FBout, Name, Value);
   }

  /* Header operations over, now we can start the output stream */
  if (FAILURE == PassImageOut(fdOut, FBout))
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }

  /* Finally, pass the pixels */
  if (FAILURE == GetBounds(FBin, &Bottom, &Left, &Top, &Right)) 
   { (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; }
  width = Right-Left+1;
  BandsPerPixel = FBin->BandsPerPixel;
  Pixel = (unsigned short *) 
    malloc( sizeof(unsigned short) * (unsigned)(width * BandsPerPixel) );
  if ((unsigned short *)0 == Pixel)
    {
      fprintf( stderr, "No memory for scan line buffer!\n" );
      (void)CloseFB(&FBin); (void)CloseFB(&FBout); return;
    }
      
  for (y=Bottom;y<=Top;y++)
   {
    if (FAILURE == NextNPixelsIn(FBin, width, Pixel))
     {  
      fprintf(stderr,"%s: NextNPixelsIn failed\n", RoutineName);        
      (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; 
     }
    if (FAILURE == NextNPixelsOut(FBout, width, Pixel))
     {
      fprintf(stderr,"%s: NextNPixelsOut failed\n", RoutineName);        
      (void)CloseFB(&FBin); (void)CloseFB(&FBout); return; 
     }
    wffFlush(FBout);
   }       

  (void)CloseFB(&FBin);
  (void)CloseFB(&FBout);
 }

int
main(argc,argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed = 0;
 
  RoutineName = argv[ArgsParsed++];
  if (ArgsParsed < argc)  { usage(); exit (-1); }	

  Pass(stdin,stdout);

  fprintf(stderr,"\n                -30-\n");
  exit (0);
}

