/*
 File: WallChart.c
 Author: K.R. Sloan
 Last Modified: 22 December 1992
 Purpose: print WallChart
 */
#include <stdio.h>
#include <strings.h>
#include "Header.h"
#include "PairingCards.h"

extern VERBOSE;

static int Center(s,str,w)
 FILE *s;
 char *str;
 int w;
 {
  int l,pad,p;

  l = strlen(str);
  pad = (w-l)/2;
  for(p=0;p<pad;p++)fprintf(s," ");
  fprintf(s,"%s",str);
 }

int WallChart(s,PLAYERS,ROUNDS,PairingCards)
 FILE *s;
 int PLAYERS;
 int ROUNDS;
 PlayerType PairingCards[];
 {
  int p,r;
  double ThisScore, TotalScore;
  char N[NameLength], V[ValueLength];
  
  fprintf(s,"\n");
  strcpy(N,"TOURNAMENT");
  if (SUCCESS == GetDescriptor(N,V))
   { Center(s,V,72);   fprintf(s,"\n"); }
  strcpy(N,"DATE");
  if (SUCCESS == GetDescriptor(N,V))
   { Center(s,V,72);   fprintf(s,"\n"); }
  strcpy(N,"SECTION");
  if (SUCCESS == GetDescriptor(N,V))
   { Center(s,V,72);   fprintf(s,"\n"); }

  fprintf(s,"    Name/Rating/ID/Team   ");
  for(r=0;r<ROUNDS;r++)
   fprintf(s," R%02d ",r+1);
  fprintf(s, " Score\n");
  for(p=0;p<PLAYERS;p++)
   {
    PlayerType *PC;

    PC = &(PairingCards[p]);
    fprintf(s,"%3d %-20.20s ",p+1,PC->Name);
    for(r=0;r<ROUNDS;r++)
     {
      int opponent;

      if (-1 == (opponent = PC->Games[r].Opponent))
       fprintf(s," BYE ");
      else
       fprintf(s," %c%3d",PC->Games[r].Color,opponent+1);
     }
    fprintf(s,"\n");
    
    TotalScore = 0.0;
    fprintf(s,"    ");
    if (0 >= PC->Ro) fprintf(s," UNR"); 
    else             fprintf(s,"%4d",PC->Ro);
    if (0 >= PC->ID) fprintf(s,"      new  "); 
    else             fprintf(s,"   %8ld",PC->ID);
    fprintf(s," %3.3s  ",PC->Team);

    for(r=0;r<ROUNDS;r++)
     {
      switch (PC->Games[r].Result)
       {
        case 'W':
        case 'B': TotalScore += 1.0; break;

        case 'D':
        case 'H': TotalScore += 0.5; break;

        case 'L':
        case 'F':                    break;
       }
      
      fprintf(s," %4.1lf",TotalScore);      
     }
    fprintf(s,"  %4.1f\n",TotalScore);
   }

  return(0);
 }
