/*
 * XShogi
 * based on XBoard -- an Xt/Athena user interface for GNU Chess
 *
 * Original authors of XBoard:  Dan Sears and Chris Sears
 * Enhancements for XBoard (Version 2.0):  Tim Mann
 * Modifications to XShogi (Version 1.0): Matthias Mutz 
 * Enhancements to XShogi (Version 1.1): Matthias Mutz 
 *
 * XShogi borrows its piece bitmaps from CRANES Shogi.  
 *
 * Copyright 1991 (XBoard) by Digital Equipment Corporation, Massachusetts.
 * Enhancements for XBoard Copyright 1992 Free Software Foundation, Inc.
 * Enhancements for XShogi Copyright 1993 Matthias Mutz
 *
 * The following terms apply to Digital Equipment Corporation's copyright
 * interest in XBoard:
 * ------------------------------------------------------------------------
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Digital not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * ------------------------------------------------------------------------
 *
 * The following terms apply to the enhanced version of Xshogi distributed
 * by the Free Software Foundation:
 * ------------------------------------------------------------------------
 * This file is part of XSHOGI.
 *
 * XSHOGI is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY.  No author or distributor accepts responsibility to anyone for
 * the consequences of using it or for whether it serves any particular
 * purpose or works at all, unless he says so in writing.  Refer to the XSHOGI
 * General Public License for full details.
 *
 * Everyone is granted permission to copy, modify and redistribute XSHOGI, but
 * only under the conditions described in the XSHOGI General Public License. A
 * copy of this license is supposed to have been given to you along with
 * XSHOGI so you can know your rights and responsibilities.  It should be in a
 * file named COPYING.  Among other things, the copyright notice and this
 * notice must be preserved on all copies.
 * ------------------------------------------------------------------------
 */

#define BOARD_SIZE		9
#define DROP_LINES		3
#define DROP_COLS		3
#ifdef WESTERN_BITMAPS
#define LARGE_SQUARE_SIZE	32
#define MEDIUM_SQUARE_SIZE	32
#else
#define LARGE_SQUARE_SIZE	64
#define MEDIUM_SQUARE_SIZE	49
#endif
#define SMALL_SQUARE_SIZE       32
#define LINE_GAP		2
#define MAX_MOVES		512
#define MSG_SIZ			256
#define DIALOG_SIZE		256
#define MOVE_
#define MOVE_LEN		16      /* enough for "Black resigns\000"*/
#define TIME_CONTROL		"5"	/* in minutes */
#define TIME_DELAY		"1.0"	/* seconds between moves */
#define MOVES_PER_SESSION	40	/* moves per TIME_CONTROL */
#define BLACK_ON_MOVE		((int) ((currentMove % 2) == 0))
#define ATTENTION
#ifndef FIRST_CHESS_PROGRAM
#define FIRST_CHESS_PROGRAM	"gnushogix1"
#endif
#ifndef SECOND_CHESS_PROGRAM
#define SECOND_CHESS_PROGRAM	"gnushogix2"
#endif
#ifndef FIRST_HOST
#define FIRST_HOST		"localhost"
#endif
#ifndef SECOND_HOST
#define SECOND_HOST		"localhost"
#endif
#define MATCH_MODE		"False"
#define INIT_STRING		"beep\neasy\nrandom\n"
#define BLACK_STRING		"black\ngo\n"
#define WHITE_STRING		"white\ngo\n"
#define DEFAULT_SIZE            "Small"
#define BLACK_PIECE_COLOR	"#FFFFD7"
#define WHITE_PIECE_COLOR	"#FFFFD7"
#define LIGHT_SQUARE_COLOR	"#EBDFB0"
#define DARK_SQUARE_COLOR	"#EBDFB0"
#define MAIN_FONT    "-*-helvetica-medium-o-normal--*-*-*-*-*-*-*-*"
#define COORD_FONT   "-*-helvetica-bold-r-normal--*-*-*-*-*-*-*-*"
#define DEFAULT_FONT "*font: -*-helvetica-medium-r-normal--*-120-*-*-*-*-*-*"
#define BLINK_COUNT 3	/* number of machines to-square blinks */
#define NULLCHAR                '\000'



typedef enum {
	Large, Medium, Small
} BoardSize;

typedef enum {
	BeginningOfGame, MachinePlaysBlack, MachinePlaysWhite, TwoMachinesPlay,
	ForceMoves, PlayFromGameFile, SetupPosition, PauseGame, EndOfGame,
	EditPosition
} GameMode;

typedef enum {
	MatchFalse, MatchInit, MatchPosition, MatchOpening
} MatchMode;
          

typedef enum {
	BlackPawn, BlackLance, BlackKnight, BlackSilver, BlackGold, BlackBishop, BlackRook, 
        BlackPPawn, BlackPLance, BlackPKnight, BlackPSilver, BlackPBishop, BlackPRook, BlackKing,
	WhitePawn, WhiteLance, WhiteKnight, WhiteSilver, WhiteGold, WhiteBishop, WhiteRook, 
        WhitePPawn, WhitePLance, WhitePKnight, WhitePSilver, WhitePBishop, WhitePRook, WhiteKing,
	EmptySquare,
	ClearBoard, BlackPlay, WhitePlay /*for use on EditPosition menus*/
} ChessSquare;

typedef ChessSquare Board[BOARD_SIZE][BOARD_SIZE];
                   
typedef int Catched[2][8];

typedef enum {
	BlackPromotion = 1, WhitePromotion, BlackDrop, WhiteDrop,
        NormalMove,
	BlackWins, WhiteWins, GameIsDrawn, StartGame, BadMove, Comment,
	AmbiguousMove
} ChessMove;

typedef enum {
	ResetTimers, DecrementTimers, SwitchTimers, 
	ReDisplayTimers, StopTimers, StartTimers
} ClockMode;

/*
 * Various compatibility grunge
 */
#ifdef __STDC__
#define	P(args)		args
#define VOID_PROC	(void(*)(char*))
#else
#define P(args)		()
#define VOID_PROC
#endif
