/* ttyputc.c - ttyputc */

#include <conf.h>
#include <kernel.h>
#include <slu.h>			/* before tty.h */
#include <tty.h>
#include <io.h>

/*------------------------------------------------------------------------
 *  ttyputc - write one character to a tty device
 *------------------------------------------------------------------------
 */
ttyputc(devptr, ch )
struct	devsw	*devptr;
char	ch;
{
	struct	tty   *iptr;
	ps_t	ps;

	iptr = &tty[devptr->dvminor];
        if ( ch==NEWLINE && iptr->ocrlf )
                ttyputc(devptr,RETURN);
	wait(iptr->osem);		/* wait	for space in queue	*/
	disable(ps);
	iptr->obuff[iptr->ohead++] = ch;
	if (iptr->ohead	>= OBUFLEN)
		iptr->ohead = 0;
#ifdef DL11
	(iptr->ioaddr)->ctstat = SLUENABLE;
#endif
#ifdef DUART681
	DUART_ENABLE((struct csr *)iptr->ioaddr,iptr);
#endif
	restore(ps);
	return(OK);
}
