/* ttyinit.c - ttyinit */

#include <conf.h>
#include <kernel.h>
#include <slu.h>			/* before tty.h */
#include <tty.h>
#include <io.h>

/*------------------------------------------------------------------------
 *  ttyinit - initialize buffers and modes for a tty line
 *------------------------------------------------------------------------
 */
#ifdef DUART681
typedef int (*fptr)();
extern int duart0int(), duart1int(), duart2int(), duart3int();
fptr handlrs[] = { duart0int, duart1int, duart2int, duart3int };
extern fptr vectab[];
# endif

ttyinit(devptr)
	struct	devsw	*devptr;
{
	register struct	tty *iptr;
	volatile register struct csr *cptr;
	int	 junk, isconsole;
#ifdef DUART681
	register struct duart681 *dptr;
	int unit;
#endif

	kprintf("tty%d at %#x", devptr->dvminor, devptr->dvcsr );

	/* pointer to per-tty data */
	iptr = &tty[devptr->dvminor];

#ifdef PDP11
	/* set up interrupt vector and interrupt dispatch table */
	iosetvec(devptr->dvnum, iptr, iptr);
#endif

#ifdef RAWCONSOLE
	isconsole = FALSE;
#else
	isconsole = (devptr->dvnum == CONSOLE);	/* make console cooked	*/
#endif

	iptr->ioaddr = (struct csr *)devptr->dvcsr; /* copy in csr address */
	iptr->ihead = iptr->itail = 0;		/* empty input queue	*/
	iptr->isem = screaten(0,"ttyi"); 	/* chars. read so far=0	*/
	iptr->osem = screaten(OBUFLEN,"ttyo");	/* buffer available=all	*/
	iptr->odsend = 0;			/* sends delayed so far	*/
	iptr->ohead = iptr->otail = 0;		/* output queue empty	*/
	iptr->ehead = iptr->etail = 0;		/* echo queue empty	*/
	iptr->imode = (isconsole ? IMCOOKED : IMRAW);
	iptr->iecho = iptr->evis = isconsole;	/* echo console input	*/
	iptr->ierase = iptr->ieback = isconsole;/* console honors erase	*/
	iptr->ierasec = BACKSP;			/*  using ^h		*/
	iptr->ecrlf = iptr->icrlf = isconsole;	/* map RETURN on input	*/
#ifdef RAWCONSOLE
	iptr->ocrlf = iptr->oflow = TRUE;
#else
	iptr->ocrlf = iptr->oflow = isconsole;
#endif
	iptr->ikill = isconsole;		/* set line kill == @	*/
	iptr->ikillc = ATSIGN;
	iptr->oheld = FALSE;
	iptr->ostart = STRTCH;
	iptr->ostop = STOPCH;
	iptr->icursor = 0;
	iptr->ifullc = TFULLC;

	cptr = (struct csr *)devptr->dvcsr;

# ifdef DL11
	junk = cptr->crbuf;			/* clear receiver and	*/
	cptr->crstat = SLUENABLE;		/* enable in. interrupts*/
	cptr->ctstat = SLUDISABLE;		/* disable out.   "	*/
# endif DL11

# ifdef DUART681
	/* ACK!!! use a DELAY macro?? */
	for( junk = 5000; junk != 0; junk-- ) ;	/* wait a bit before */
						/* slamming duart */

	/* The next 2 lines establish the relationship between
	 * ttys and duarts
	 */
	unit = devptr->dvminor / 2;
	iptr->port = (devptr->dvminor & 1);	/* figure out if A or B port */
	dptr = &duart681[unit];

	vectab[ devptr->dvivec ] = handlrs[ unit ];
	kprintf(" on duart%d line %d vector %d",
		devptr->dvivec, iptr->port, unit );

	devptr->dvioblk = (char *)iptr;		/* fill tty control blk	*/
	/* point duart to tty(s) */
	dptr->duart_tty[ iptr->port ] = iptr;

	/* point tty to duart */
	iptr->dptr = dptr;

	/* only one ACR for both ports of DUART & timer */
	dptr->duart_acr |= DU_ACR_SET2;		/* baud set 2 */
	cptr->DU_ACR  = dptr->duart_acr;

	if( iptr->port == 0 ) {			/* A (first device) */
	    while( cptr->DU_SRA & DU_SR_RXREADY )
		junk = cptr->DU_RBA;		/* clear receiver */

	    cptr->DU_CRA  = DU_CR_MSC_RMR | DU_CR_XMT_DIS | DU_CR_RCV_DIS;
						/* reset mr pointer to mr1 */
						/* disable xmit and recv */

	    cptr->DU_CSRA = 0xbb;		/* rx, tx at 9600 baud */
	    cptr->DU_MR1A = 0x13;		/* no rx rts, no rx irq */
						/* char er, none, even, 8 */
	    cptr->DU_MR2A = 0x0f;		/* normal, no tx rts */
						/* no tx cts, 2 stop */
	    /* only one IMR for both halves & timer */
	    dptr->duart_imr &= ~DU_IN_TXA;	/* disable tx ints */
	    dptr->duart_imr |=  DU_IN_RXA;	/* enable rx ints */
	    dptr->duart_imr |=  DU_IN_BKA;	/* enable break */

	    cptr->DU_IMR = dptr->duart_imr;
	    cptr->DU_CRA = DU_CR_XMT_ENA | DU_CR_RCV_ENA;
	}
	else {					/* odd port */
	    while( cptr->DU_SRB & DU_SR_RXREADY )
		junk = cptr->DU_RBB;		/* clear receiver */

	    cptr->DU_CRB  = DU_CR_MSC_RMR | DU_CR_XMT_DIS | DU_CR_RCV_DIS;
						/* reset mr pointer to mr1 */
						/* disable xmit and recv */

	    cptr->DU_CSRB = 0xbb;		/* rx, tx at 9600 baud */
	    cptr->DU_MR1B = 0x13;		/* no rx rts, no rx irq */
						/* char er, none, even, 8 */
	    cptr->DU_MR2B = 0x0f;		/* normal, no tx rts */
						/* no tx cts, 2 stop */
	    /* only one IMR for both halves & timer */
	    dptr->duart_imr &= ~DU_IN_TXB;	/* disable tx ints */
	    dptr->duart_imr |=  DU_IN_RXB;	/* enable rx ints */
	    dptr->duart_imr |=  DU_IN_BKB;	/* enable break */
	    cptr->DU_IMR = dptr->duart_imr;

	    cptr->DU_CRB = DU_CR_XMT_ENA | DU_CR_RCV_ENA;
	} /* odd port */
	kprintf("\n");
#endif DUART681
}
