/* ttyiin.c ttyiin, erase1, eputc, echoch */

#include <conf.h>
#include <kernel.h>
#include <slu.h>			/* before tty.h */
#include <tty.h>
#include <io.h>

/*------------------------------------------------------------------------
 *  ttyiin  --  lower-half tty device driver for input interrupts
 *------------------------------------------------------------------------
 */
INTPROC	ttyiin(iptr)
	register struct	tty	*iptr;	/* pointer to tty block		*/
{
	register struct	csr *cptr;
	register int	ch;
	Bool	cerr;
	int	ct;

	cptr = (struct csr *) iptr->ioaddr;
	if (iptr->imode == IMRAW) {
		if (scount(iptr->isem) >= IBUFLEN){
#ifdef DL11
			ch = cptr->crbuf;
#endif DL11
#ifdef DUART681
			if( iptr->port == 0 )
			    ch = cptr->DU_RBA;	/* DEVICE A */
			else
			    ch = cptr->DU_RBB;	/* DEVICE B */
#endif DUART681
			return;
		}
#ifdef DL11
		if ((ch=cptr->crbuf)&SLUERMASK)	/* character error	*/
			iptr->ibuff[iptr->ihead++]=(ch&SLUCHMASK)|IOCHERR;
		else				/* normal read complete	*/
			iptr->ibuff[iptr->ihead++] = ch	& SLUCHMASK;
#endif DL11
#ifdef DUART681
		if( cptr->DU_SRA & DU_SR_ERRMASK ) /* ACK!! PORT A ONLY */
		    ch = ((cptr->DU_RBA)&SLUCHMASK)|IOCHERR; /* A only */
		else
		    ch = cptr->DU_RBA;		/* DEVICE A only */
		iptr->ibuff[iptr->ihead++] = ch;
#ifdef DEBUG
		kprintf("ttyiin read %d.\n", ch );
#endif DEBUG
#endif DUART681
		if (iptr->ihead	>= IBUFLEN)	/* wrap buffer pointer	*/
			iptr->ihead = 0;
	        signal(iptr->isem);
	}				/* ....raw */
	else {				/* cbreak | cooked mode	*/
#ifdef DL11
		cerr = ((ch=cptr->crbuf)&SLUERMASK) ? IOCHERR : 0;
		ch &= SLUCHMASK;
#endif DL11
#ifdef DUART681
		if( iptr->port == 0 ) {	/* port A... */
		    if( cptr->DU_SRA & DU_SR_ERRMASK )
			cerr = IOCHERR;
		    else
			cerr = 0;
		    ch = cptr->DU_RBA;
		}
		else {
		    if( cptr->DU_SRB & DU_SR_ERRMASK )
			cerr = IOCHERR;
		    else
			cerr = 0;
		    ch = cptr->DU_RBB;
		}
#endif DUART681
		if ( ch	== RETURN && iptr->icrlf )
			ch = NEWLINE;
		if (iptr->oflow) {
			if (ch == iptr->ostart)	{
			    iptr->oheld = FALSE;
#ifdef DL11
			    cptr->ctstat = SLUENABLE;
#endif DL11
#ifdef DUART681
			    DUART_ENABLE(cptr,iptr);
#endif DUART681
			    return;
			}
			if (ch == iptr->ostop) {
				iptr->oheld = TRUE;
				return;
			}
		} /* oflow */
		iptr->oheld = FALSE;
		if (iptr->imode	== IMCBREAK) {		/* cbreak mode	*/
			if (scount(iptr->isem) >= IBUFLEN) {
				eputc(iptr->ifullc,iptr,cptr);
				return;
			}
			iptr->ibuff[iptr->ihead++] = ch	| cerr;
			if (iptr->ihead	>= IBUFLEN)
				iptr->ihead = 0;
			if (iptr->iecho)
				echoch(ch,iptr,cptr);
			if (scount(iptr->isem) < IBUFLEN)
				signal(iptr->isem);
		} else {				/* cooked mode	*/
			if (ch == iptr->ikillc && iptr->ikill) {
				iptr->ihead -= iptr->icursor;
				if (iptr->ihead	< 0)
					iptr->ihead += IBUFLEN;
				iptr->icursor =	0;
				eputc(RETURN,iptr,cptr);
				eputc(NEWLINE,iptr,cptr);
				return;
			}
			if (ch == iptr->ierasec	&& iptr->ierase) {
				if (iptr->icursor > 0) {
					iptr->icursor--;
					erase1(iptr,cptr);
				}
				return;
			}
			if (ch == NEWLINE || ch == RETURN) {
				if (iptr->iecho)
					echoch(ch,iptr,cptr);
				iptr->ibuff[iptr->ihead++] = ch	| cerr;
				if (iptr->ihead	>= IBUFLEN)
					iptr->ihead = 0;
				ct = iptr->icursor+1; /* +1 for \n or \r*/
				iptr->icursor =	0;
				signaln(iptr->isem,ct);
				return;
			}
			ct = scount(iptr->isem);
			ct = ct	< 0 ? 0	: ct;
			if ((ct	+ iptr->icursor) >= IBUFLEN-1) {
				eputc(iptr->ifullc,iptr,cptr);
				return;
			}
			if (iptr->iecho)
				echoch(ch,iptr,cptr);
			iptr->icursor++;
			iptr->ibuff[iptr->ihead++] = ch	| cerr;
			if (iptr->ihead	>= IBUFLEN)
				iptr->ihead = 0;
		}
	}
}

/*------------------------------------------------------------------------
 *  erase1  --  erase one character honoring erasing backspace
 *------------------------------------------------------------------------
 */
LOCAL erase1(iptr,cptr)
	struct	tty   *iptr;
	struct	csr	*cptr;
{
	char	ch;

	if (--(iptr->ihead) < 0)
		iptr->ihead += IBUFLEN;
	ch = iptr->ibuff[iptr->ihead];
	if (iptr->iecho) {
		if (ch < BLANK || ch == 0177) {
			if (iptr->evis)	{
				eputc(BACKSP,iptr,cptr);
				if (iptr->ieback) {
					eputc(BLANK,iptr,cptr);
					eputc(BACKSP,iptr,cptr);
				}
			}
			eputc(BACKSP,iptr,cptr);
			if (iptr->ieback) {
				eputc(BLANK,iptr,cptr);
				eputc(BACKSP,iptr,cptr);
			}
		} else {
			eputc(BACKSP,iptr,cptr);
			if (iptr->ieback) {
				eputc(BLANK,iptr,cptr);
				eputc(BACKSP,iptr,cptr);
			}
		}
	} else {
#ifdef DL11
		cptr->ctstat = SLUENABLE;
#endif
#ifdef DUART681
		DUART_ENABLE(cptr,iptr);
#endif
	}
}

/*------------------------------------------------------------------------
 *  echoch  --  echo a character with visual and ocrlf options
 *------------------------------------------------------------------------
 */
LOCAL echoch(ch, iptr, cptr)
	char	ch;		/* character to	echo			*/
	struct	tty   *iptr;	/* pointer to I/O block for this devptr	*/
	struct	csr	*cptr;	/* csr address for this devptr		*/
{
	if ((ch==NEWLINE||ch==RETURN)&&iptr->ecrlf) {
		eputc(RETURN,iptr,cptr);
		eputc(NEWLINE,iptr,cptr);
	} else if ((ch<BLANK||ch==0177) && iptr->evis) {
		eputc(UPARROW,iptr,cptr);
		eputc(ch+0100,iptr,cptr);	/* make it printable	*/
	} else {
		eputc(ch,iptr,cptr);
	}
}

/*------------------------------------------------------------------------
 *  eputc - put one character in the echo queue
 *------------------------------------------------------------------------
 */
LOCAL eputc(ch,iptr,cptr)
	char	ch;
	struct	tty   *iptr;
	struct	csr	*cptr;
{
	iptr->ebuff[iptr->ehead++] = ch;
	if (iptr->ehead	>= EBUFLEN)
		iptr->ehead = 0;
#ifdef DL11
	cptr->ctstat = SLUENABLE;
#endif DL11
#ifdef DUART681
	DUART_ENABLE(cptr,iptr);
#endif DUART681
}
