; Xinu startup.s for PC532
;
; from resume532.s
; NSC 32000 ROM debugger.
; Bruce Culbertson  Bob Krause
; lifted from MONSTART by Dave Rand.

	.text
memlen: .equ	32*h'100000	;32 megabytes
;;;;;;;;;;;;;;;;
datasp:	.equ	h'0			; non-swapped data space
codesp:	.equ	h'10000000		; permenant code space
SCSI:	.equ	h'30000000		; polled SCSI address
;;;;;;;;;;;;;;;;
SECOND:	.equ	4000000			; ACB count for 1 second (rough)
;;;;;;;;;;;;;;;;
cfg_i:		.equ	h'001		; interrupt vectoring
cfg_f:		.equ	h'002		; floating point (32381)
cfg_m:		.equ	h'004		; memory mgmt

cfg_de:		.equ	h'100		; direct exception enable
cfg_dc:		.equ	h'200		; data cache enable
cfg_ic:		.equ	h'800		; insn cache enable
;;;;;;;;;;;;;;;;
psr_usp:        .equ    h'200
psr_ie:         .equ    h'800
;;;;;;;;;;;;;;;;

start::

; The code from start to reset1 starts up the refresh
; and swaps the rom to high memory.

	bicpsrw	psr_usp or psr_ie	; disable interrupts, usp
	lprw	cfg,cfg_i or cfg_f or cfg_m or cfg_dc or cfg_ic or cfg_de

	movd	(SECOND/1000000)*800,r1 ; get 800 microsecond delay
h1:	acbd	-1,r1,h1

	movd	h'fffffe00,r7		; point to ICU
	movb	h'15,22(r7)		; set up refresh
	movqb	0,16(r7)
	movb	13,24(r7)
	movqb	0,25(r7)
	movqb	-1,19(r7)		; set up a 1 in all outputs
	movqb	0,20(r7)		; set as all I/O
	movqb	-2,21(r7)		; g0 as output

;	br	reset1+codesp		; jump to regular ROM location
;reset1:	movqb	-2,19(r7)		; kill rom at zero, swap RAM

;the following code lights all of the LEDs connected to the SCSI

	movd	SCSI,r0			; point to scsi
	movb	h'8,0(r0)		; register 8
	movb	h'4,1(r0)		; no reset, 20 Mhz
	movqb	7,0(r0)			; register 7
	movb	h'10,1(r0)		; port A output
	movb	h'd,0(r0)		; register D
	movqb	-1,1(r0)		; LED status

;; This code wakes up the DRAM, according to the spec.
;; It also initializes (at txl1) the first 2K of ram by overwriting.
;	addr	@10,r2			; do it 10 times
;txl2:	movd	(SECOND/1000000)*8000,r1 ; get 8 millisecond delay
;h2:	acbd	-1,r1,h2
;	movd	datasp,r0		; point to data space
;	movqd	0,0(r0)			; write to page zero
;	movqd	0,h'2000000-4(r0)	; write to last page
;	movqd	0,0(r0)			; write to page zero
;	movqd	0,h'2000000-4(r0)	; write to last page
;	movqd	0,0(r0)			; write to page zero
;	movqd	0,h'2000000-4(r0)	; write to last page
;	movqd	0,0(r0)			; write to page zero
;	movqd	0,h'2000000-4(r0)	; write to last page
;	addr	@512,r1			; write first 512 doubles (2048 bytes)
;txl1:	movqd	0,0(r0)			; write data
;	addqd	4,r0			; next block
;	acbd	-1,r1,txl1		; and loop
;	acbd	-1,r2,txl2		; loop 10 times
;
; The following actually enables the NMI/parity error.
	movd	h'28000040,r0
	cmpqb	0,h'10(r0)		; clear NMI error

;;;;
	movd	@_etext,r0		; get end of text (start of a.out data)
	movd	@_bdata,r1		; get start of data
	movd	@_edata,r2
	cmpd	r1,r0			; same?
	beq	bsszero			; yes, linked for running in ram

datacopy:
	movb	0(r0),0(r1)
	addqd	1,r0
	addqd	1,r1
	cmpd	r1,r2			; end of data?
	bne	datacopy

bsszero:
	movqb	0,0(r2)
	addqd	1,r2
	cmpd	@_end,r2
	bne	bsszero

;
;;Initialize rest of memory (32M)
;	movd	datasp+2048,r0		; point to start of data space
;	movd	(memlen-2048)/32,r1	; number of chunks to write
;parin3:	movqd	0,0(r0)
;	movqd	0,4(r0)
;	movqd	0,8(r0)
;	movqd	0,12(r0)
;	movqd	0,16(r0)
;	movqd	0,20(r0)
;	movqd	0,24(r0)
;	movqd	0,28(r0)
;	addd	32,r0
;	acbd	-1,r1,parin3
;
;	movd	h'28000040,r0
;	cmpqb	0,h'10(r0)		; clear NMI error

;	lprd	sp,db_stack
;	lprd	intbase,inttab_adr
;	lprw	mod,modtab_adr
	lprd	sb,0
;--------------------------------------------------------------------------
; End of MONSTART
;--------------------------------------------------------------------------

	lprd	sp,kernstk		; get silly stack
	jsr	sizmem			; find how much memory we have

	lprd	sp,_maxaddr		; switch stack to high memory
	movqd	0,tos			; leave space for MAGIC word

	jsr	_loinit

	br	_nulluser
