/* getstk.c - getstk */

#include <conf.h>
#include <kernel.h>
#include <mem.h>

/*------------------------------------------------------------------------
 * getstk  --  allocate stack memory, returning address of topmost int
 *------------------------------------------------------------------------
 */
int	*getstk(nbytes)
	unsigned int nbytes;
{
	ps_t	ps;
	struct	mblock	*p, *q;	/* q follows p along memlist		*/
	struct	mblock	*fits, *fitsq;
	int	len;

	disable(ps);
	if (nbytes == 0) {
		restore(ps);
		return( (int *)SYSERR );
	}
	nbytes = (unsigned int)roundew(nbytes);
	fits = NULL;
	q = &memlist;
	for (p = q->mnext ; p != NULL ; q = p,p = p->mnext)
		if ( p->mlen >= nbytes) {
			fitsq = q;
			fits = p;
		}
	if (fits == NULL) {
		restore(ps);
		return( (int *)SYSERR );
	}
	if (nbytes == fits->mlen) {
		fitsq->mnext = fits->mnext;
		len = nbytes;
	} else {
		len = fits->mlen;
		fits->mlen -= nbytes;
	}
	fits = ((int)fits) + len - sizeof(int);
	*( (int *) fits ) = nbytes;
	restore(ps);
	return( (int *)fits );
}
