/* freemem.c - freemem */

#include <conf.h>
#include <kernel.h>
#include <mem.h>

/*------------------------------------------------------------------------
 *  freemem  --  free a memory block, returning it to memlist
 *------------------------------------------------------------------------
 */
SYSCALL	freemem(block, size)
	struct	mblock	*block;
	Word size;
{
	ps_t	ps;
	struct	mblock	*p, *q;
	Word top;

	if (size==0 || (Word)block>(Word)maxaddr
		    || ((Word)block)<((Word)&end))
		return(SYSERR);
	size = (Word)roundew(size);
	disable(ps);
	for( p=memlist.mnext,q= &memlist ; p!=NULL && p<block ;
		    q=p,p=p->mnext )
		;
	if ((top=q->mlen+(Word)q)>(Word)block && q!= &memlist ||
		    p!=NULL && (size+(Word)block) > (Word)p ) {
		restore(ps);
		return(SYSERR);
	}
	if ( q!= &memlist && top == (Word)block )
		q->mlen += size;
	else {
		block->mlen = size;
		block->mnext = p;
		q->mnext = block;
		q = block;
	}
	if ( (Word)( q->mlen + (Word)q ) == (Word)p) {
		q->mlen += p->mlen;
		q->mnext = p->mnext;
	}
	restore(ps);
	return(OK);
}
