# include <slu.h>
# ifdef DUART681
# include <kernel.h>
# include <tty.h>

/*#define DEBUG				/*  */

# ifdef DUART681_CLOCK
extern int defclk, clkdiff, slnempty, *sltop, preempt;
# endif

/* here from duartint.s */

INTPROC
duarthandlr(n)
    int n;				/* duart unit number */
{
    volatile register struct csr *cp;
    register unsigned char status;
    register struct duart681 *duart;
    struct tty *tp;

    duart = &duart681[n];
    tp = duart->duart_tty[0];		/* port A tty struct */
    cp = (struct csr *) tp->ioaddr;

    status = cp->DU_ISR;		/* get possible interrupt conditions */
#ifdef DEBUG
    kprintf("duarthandlr(%d) status %#x mask %#x\n",
	    n, status & 0xff, duart->duart_imr & 0xff );
#endif DEBUG

    status &= duart->duart_imr;		/* mask bits we care about */
    if( status == 0 )
	return;

    if( status & DU_IN_RXA ) {		/* recv A ready */
	while( cp->DU_SRA & DU_SR_RXREADY ) /* why not? */
	    ttyiin( tp );
    }

    if( status & DU_IN_BKA ) {		/* break A */
	kprintf("duart%d: break A\n", n);
	cp->DU_CRA = DU_CR_MSC_RBREAK;	/* MUST RESET!! */
    }

    if( status & DU_IN_TXA )		/* xmit A ready */
	ttyoin( tp );

    /****************/

    tp = duart->duart_tty[1];		/* port B tty struct */
    cp = (struct csr *) tp->ioaddr;	/* should not be needed! */

    if( status & DU_IN_TXB )		/* xmit B ready */
	ttyoin( tp );

    if( status & DU_IN_RXB ) {		/* recv B ready */
	while( cp->DU_SRB & DU_SR_RXREADY ) /* why not? */
	    ttyiin( tp );
    }

    if( status & DU_IN_BKB ) {		/* break B */
	kprintf("duart%d: break B\n", n);
	cp->DU_CRB = DU_CR_MSC_RBREAK;	/* MUST RESET!! */
    }

    /****************/

    if( status & DU_IN_INP ) {		/* input ports */
	kprintf("duart%d: input port change\n", n);
    }

    /****************/

# ifdef DUART681_CLOCK
    if( status & DU_IN_CTR ) {		/* counter/timer */
	dummy( cp->DU_STOPC );		/* reset timer */
	if( defclk )
	    clkdiff++;
	else {
	    if( slnempty &&  --(*sltop) <= 0 )
		wakeup();
	    if( --preempt <= 0 )
		resched();
	}
    }
# endif DUART681_CLOCK
}
#endif DUART681
