/* create.c - create, newpid */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <mem.h>
#include <magic.h>

/*------------------------------------------------------------------------
 *  create  -  create a process to start running a procedure
 *------------------------------------------------------------------------
 */
SYSCALL create(procaddr,ssize,priority,name,nargs,args)
	int	*procaddr;		/* procedure address		*/
	int	ssize;			/* stack size in words		*/
	int	priority;		/* process priority > 0		*/
	char	*name;			/* name (for debugging)		*/
	int	nargs;			/* number of args that follow	*/
	int	args;			/* arguments (treated like an	*/
					/* array in the code)		*/
{
	int	pid;			/* stores new process id	*/
	struct	pentry	*pptr;		/* pointer to proc. table entry */
	int	i;
	int	*a;			/* points to list of args	*/
	int	*saddr;			/* stack address		*/
	ps_t	ps;			/* saved processor status	*/
	int	INITRET();
	disable(ps);
	if( ssize < MINSTK )
	    ssize = MINSTK;		/* budd */
	ssize = (int) roundew(ssize);
	if ( ((saddr=(int *)getstk(ssize)) == (int *)SYSERR ) ||
	    (pid=newpid()) == SYSERR || isodd(procaddr) ||
		priority < 1 ) {
		restore(ps);
		return(SYSERR);
	}
	numproc++;
	kprintf("create(%x,%d.,%d.,%s,%d...)\n",
		procaddr, ssize, priority, name, nargs );
	pptr = &proctab[pid];
	pptr->pstate = PRSUSP;
	for (i=0 ; i<PNMLEN && (pptr->pname[i]=name[i])!=0 ; i++)
		;
	pptr->pprio = priority;
	pptr->pbase = (Word)saddr;
	pptr->pstklen = ssize;
	pptr->plimit = (Word) ( saddr - ssize + 1);
	*saddr-- = MAGIC;		/* budd: put in magic number */

#ifdef DEBUG				/* budd */
	kprintf("pid %d, base %x, limit %x\n",
		pid, pptr->pbase, pptr->plimit );
#endif

	pptr->pargs = nargs;
	for (i=0 ; i<PNREGS ; i++)
		pptr->pregs[i]=INITREG;

	pptr->pregs[PC] = pptr->paddr = (Word)procaddr;
	pptr->pregs[PS] = INITPS;
	a = (&args) + (nargs-1);	/* point to last argument	*/
	for ( ; nargs > 0 ; nargs--)	/* machine dependent; copy args	*/
		*saddr-- = *a--;	/* onto created process' stack	*/
	*saddr = (int)INITRET;		/* push on return address	*/
#ifdef PDP11
	pptr->pregs[SP] = (Word)saddr;
#endif
#ifdef MC68K
	pptr->pregs[USP] = (Word)saddr;
	pptr->pregs[SSP] = (Word)saddr;
#endif
	restore(ps);
	return(pid);
}

/*------------------------------------------------------------------------
 * newpid  --  obtain a new (free) process id
 *------------------------------------------------------------------------
 */
LOCAL	newpid()
{
	int	pid;			/* process id to return		*/
	int	i;

	for (i=0 ; i<NPROC ; i++) {	/* check all NPROC slots	*/
		if ( (pid=nextproc--) <= 0)
			nextproc = NPROC-1;
		if (proctab[pid].pstate == PRFREE)
			return(pid);
	}
	return(SYSERR);
}

stackcheck(l)
char *l;
{
    register int i;
    for( i = 0; i < NPROC; i++ ) {
	if (proctab[i].pstate != PRFREE)
	    if( *(int *)(proctab[i].pbase) != MAGIC ) {
		kprintf("%s: pid %d has corrupt stack\n", l, i );
		panic("you lose");
	    }
    }
}
