;* clkint.s -  clkint

;*------------------------------------------------------------------------
;* clkint  --  real-time clock interrupt service routine 
;*------------------------------------------------------------------------
	.text

_clkint::
	addqd	-1,_count6		; Is this the 6th interrupt?
	blt	clret			;  no => return
	movd	6,_count6		;  yes=> reset counter&continue
	cmpqd	0,_defclk		; Are clock ticks deferred?
	bne	isdef			;  no => skip down

	cmpqd	0,_slnempty		; Is sleep queue nonempty?
	beq     clpreem			;  yes=> skip down
	addqd	-1,_sltop		;  no => decrement delta key
	blt     clpreem			;        of first process,
	save	[r0,r1,r2]
	jsr	_wakeup
	restore	[r2,r1,r0]

clpreem:
	addqd	-1,_preempt		; Decrement preemption counter
	ble	doresched		;   and call resched if it
clret:	reti				; Return from interrupt

;; here to preempt current process
doresched:
	save	[r0,r1,r2]
	jsr	_resched
	restore	[r2,r1,r0]
	reti

;; here on deferred clock
isdef:	addqd	1,_clkdiff		;  yes=> count in clkdiff and
	reti				;        return quickly
