/* clkinit.c - clkinit */

#include <conf.h>
#include <kernel.h>
#include <sleep.h>
#include <quantum.h>

#ifdef MC68K				/* PB68010 used duart clock!! */

# define DUART0_ADDR 0xfc0000
# define DUART0_VECTOR 15		/* unassigned int. */

extern long vectab[];
#endif

#ifdef DUART681_CLOCK
extern int clkruns;
#include <slu.h>			/* duart defs */
extern struct duart681 duart681[];
#endif DUART681_CLOCK

#ifdef NS32K
#define CLOCKV 31			/* ICU @+16 + INT15 */
extern int clkruns;
typedef int (*fptr)();
extern fptr vectab[];
#endif

/*
 *------------------------------------------------------------------------
 * clkinit - initialize the clock and sleep queue (called at startup)
 *------------------------------------------------------------------------
 */
clkinit()
{
#ifdef PDP11
	int *vector;

	vector = (int *) CVECTOR;	/* set up interrupt vector	*/
	*vector++ = (int) clkint;
	*vector = DISABLE;
	setclkr();
#endif PDP11
#ifdef NS32K
	ps_t ps;
	int tick(), clkint();
	register junk;

	/* ICU set up in startup.s */
	disable(ps);
	/* unmask clock!!! */
	vectab[ CLOCKV ] = tick;
	enable();
	for( junk = 2000000; clkruns == 0 && junk != 0; junk-- )
	    ;
	restore(ps);
	vectab[ CLOCKV ] = clkint;
#endif
#ifdef DUART681_CLOCK
	ps_t ps;
	int junk;
	int duart0int(), tick();
	register struct duart681 *dp;
	volatile register struct csr *cptr;

	cptr = (struct csr *) DUART0_ADDR;		/* ACK */
# ifdef MC68K
	cptr->DU_IVR = DUART0_VECTOR;			/* ACK */
	vectab[ DUART0_VECTOR ] = (long) tick; 		/* ACK */
# endif

	dp = &duart681[0];
	dp->duart_imr = DU_IN_CTR;
	dp->duart_acr = DU_ACR_T_X_16;

	cptr->DU_ACR = dp->duart_acr;
	cptr->DU_CTUR = 90;		/* CT: 23040 -> 10Hz */
	cptr->DU_CTLR = 0;
	junk = ptr->DU_STARTC;		/* address trigger start */
	cptr->DU_IMR = dp->duart_imr;	/* set interrupt mast */

	disable(ps);
	enable();
	for( junk = 20000; clkruns == 0 && junk != 0; junk-- )
	    ;
	restore(ps);

#ifdef MC68K
	vectab[ DUART0_VECTOR ] = (long) duart0int;	/* ACK */
#endif MC68K
#endif DUART681_CLOCK

	preempt = QUANTUM;		/* initial time quantum		*/
	count6 = 6;			/* 60ths of a sec. counter	*/
	slnempty = FALSE;		/* initially, no process asleep	*/
	clkdiff = 0;			/* zero deferred ticks		*/
	defclk = 0;			/* clock is not deferred	*/
	clockq = newqueue();		/* allocate clock queue in q	*/
}

tick() {
    clkruns = 1;
}
