|* startup.s - start */

DISABLE	=	0x2700			| PS to disable interrupts

|*------------------------------------------------------------------------
|*  Xinu system entry point -- first location beyond interrupt vectors
|*------------------------------------------------------------------------
|*************************************************************************
|		THIS FILE MUST BE LOADED FIRST, USING ld -N
|*************************************************************************

	.data
	.globl	_bdata
	.globl	_etext,_edata,_end
_bdata:

	.text

RAMTOP= 0x20fffe

	.globl	start

	.word	0x4e71,0x4ef9		| ISP (nop,jmp)
	.long	start			| IPC

start:
	movw	#DISABLE,sr	 	| Disable interrupts
	movl	#0,a6			| Clear fp for trace
	reset				| reset bus

	movl	#_etext,a0		| get end of text (start of a.out data)
	movl	#_bdata,a1		| get start of data
	movl	#_edata,a2
	cmpl	a1,a0			| same?
	beq	bsszero			| yes, linked for running in ram

datacopy:
	movb	a0@+,a1@+
	cmpl	a1,a2			| end of data?
	bne	datacopy

bsszero:
	clrb	a2@+
	cmpl	#_end,a2
	bne	bsszero

|	movl	#kernstk,sp		| set up temporary stack pointer
|	jsr	_sizmem			| _maxaddr set to max address

	movl	#RAMTOP,_maxaddr	| DUMMY

	movl	_maxaddr,sp		| switch stack to high memory
	tstl	sp@-			| leave space for MAGIC word
	jsr	_loinit

	jmp	_nulluser		| Jump to C startup routine
