|* lowcore.s - loinit

|*------------------------------------------------------------------------
|* loinit  -  map of dispatch table and interrupt dispatcher 
|*------------------------------------------------------------------------
	.data
	.comm	regsave,64			| 16*4
	.comm	tregsave,64			| 16*4

	.text
	.globl	_loinit
_loinit:
	lea	_vectab,a1			| get vector table
	movc	a1,vbr				| set CPU vector base register

	movl	#255,d0
10$:	movl	#mytrap,a1@+
	dbra	d0,10$

	movl	#mytrace,_vectab+36

	rts

|****************************************************************

| 68010 frame:
| sp+0	sr
| sp+2	pc.h
| sp+4	pc.l
| sp+6	format/vector
| 	......

mytrap:	moveml	#0xffff,regsave
	movw	sp@(6),d0			| get format + vector

	andl	#0x0fff,d0			| isolate vector addrress
	lsrl	#2,d0				| make vector number

	btst	#15,sp@(6)			| test for long frame
	bne	20$
	
	movw	#0,sp@-				| make status look long
	movl	d0,sp@-				| push vector
	pea	mymsg
	jsr	_kprintf
	lea	sp@(12),sp
	bra	30$

| here on address exception...
20$:	movl	sp@(10),d1			| get address
	movw	#0,sp@-				| make status look long
	movl	d1,sp@-				| push address
	movl	d0,sp@-				| push vector
	pea	mymsg2
	jsr	_kprintf
	lea	sp@(14),sp

30$:	moveml	regsave,#0xffff
	jsr	_regdump
10$:	bra	10$

mymsg:	.asciz 	"Trap to %d. SR %#x PC %#x\12\15"

mymsg2:	.asciz 	"Trap to %d. Addr %#x SR %#x PC %#x\12\15"


|****************************************************************

	.even
mytrace:
	moveml	#0xffff,tregsave
	movl	sp@(2),a1			| get pc
	movw	#0,sp@-				| make status look long
	movl	tregsave+56,sp@-			| push a6
	movl	tregsave+60,sp@-			| push sp
	movl	a1,sp@-				| push pc
	movl	a1@,sp@-			| push insn (perhaps only word)
	pea	tracemsg
	jsr	_kprintf
	moveml	tregsave,#0xffff
	rte

tracemsg:
	.asciz	">>> insn %#x @ %#x sp %#x fp %#x sr %#x\12\15"
