/* mem.h - freestk, roundew, truncew */

/*----------------------------------------------------------------------
 * roundew, truncew - round or truncate address to next even word
 *----------------------------------------------------------------------
 */
#define	roundew(x)	(Word *)( (3 + (Word)(x)) & (~3) )
#define	truncew(x)	(Word *)( ((Word)(x)) & (~3) )

/*----------------------------------------------------------------------
 *  freestk  --  free stack memory allocated by getstk
 *----------------------------------------------------------------------
 */
#define freestk(p,len)	freemem((Word)(p)		\
				- (Word)(roundew(len))	\
				+ (Word)sizeof(Word),	\
				roundew(len) )

struct	mblock	{
	struct	mblock	*mnext;
	unsigned int	mlen;
	};
extern	struct	mblock	memlist;	/* head of free memory list	*/
extern	int	*maxaddr;		/* max memory address		*/
extern	int	end;			/* address beyond loaded memory	*/

