/* kernel.h - disable, enable, halt, restore, isodd */

/* Symbolic constants used throughout Xinu */

typedef	char		Bool;		/* Boolean type			*/
#define	FALSE		0		/* Boolean constants		*/
#define	TRUE		1
#define	NULL		(char *)0	/* Null pointer for linked lists*/
#define	SYSCALL		int		/* System call declaration	*/
#define	LOCAL		static		/* Local procedure declaration	*/
#define	INTPROC		int		/* Interrupt procedure  "	*/
#define	PROCESS		int		/* Process declaration		*/
#define	RESCHYES	1		/* tell	ready to reschedule	*/
#define	RESCHNO		0		/* tell	ready not to resch.	*/
#define	MININT		0100000		/* minimum integer (-32768)	*/
#define	MAXINT		0077777		/* maximum integer		*/
#define	SP		6		/* reg.	6 is stack pointer	*/
#define	PC		7		/* reg.	7 is program counter	*/
#define	PS		8		/* proc. status	in 8th reg. loc	*/
#define	MINSTK		40		/* minimum process stack size	*/
#define	NULLSTK		300		/* process 0 stack size		*/
#define	DISABLE		0340		/* PS to disable interrupts	*/
#define	OK		 1		/* returned when system	call ok	*/
#define	SYSERR		-1		/* returned when sys. call fails*/

/* initialization constants */

#define	INITARGC	1		/* initial process argc		*/
#define	INITSTK		200		/* initial process stack	*/
#define	INITPRIO	20		/* initial process priority	*/
#define	INITNAME	"main"		/* initial process name		*/
#define	INITRET		userret		/* processes return address	*/
#define	INITPS		0		/* initial process PS		*/
#define	INITREG		0		/* initial register contents	*/
#define	QUANTUM		10		/* clock ticks until preemption	*/

/* misc. utility inline	functions */

#define	isodd(x)	(01&(int)(x))
#define	disable(ps)	asm("mfps ~ps");asm("mtps $0340")
#define	restore(ps)	asm("mtps ~ps")	/* restore interrupt status	*/
#define	enable()	asm("mtps $000")/* enable interrupts		*/
#define	pause()		asm("wait")	/* machine "wait for interr."	*/
#define	halt()		asm("halt")	/* machine halt	instruction	*/

extern	int	rdyhead, rdytail;
extern	int	preempt;
