;;; Copyright (C) 1991 Christopher J. Love
;;;
;;; This file is for use with Epoch, a modified version of GNU Emacs.
;;; Requires Epoch 4.0 or later.
;;;
;;; This code is distributed in the hope that it will be useful,
;;; bute WITHOUT ANY WARRANTY. No author or distributor accepts
;;; responsibility to anyone for the consequences of using this code
;;; or for whether it serves any particular purpose or works at all,
;;; unless explicitly stated in a written agreement.
;;;
;;; Everyone is granted permission to copy, modify and redistribute
;;; this code, but only under the conditions described in the
;;; GNU Emacs General Public License, except the original author nor his
;;; agents are bound by the License in their use of this code.
;;; (These special rights for the author in no way restrict the rights of
;;;  others given in the License or this prologue)
;;; A copy of this license is supposed to have been given to you along
;;; with Epoch so you can know your rights and responsibilities. 
;;; It should be in a file named COPYING.  Among other things, the
;;; copyright notice and this notice must be preserved on all copies. 
;;;
;;; $Revision: 1.3 $
;;; $Source: /import/kaplan/stable/distrib/epoch-4.0p0/epoch-lisp/RCS/convert-buttons.el,v $
;;; $Date: 92/02/10 20:20:36 $
;;; $Author: love $
;;;
;;; convert-buttons.el - convert button references to zone references for
;;;			Epoch 4.0 Beta.  Performs action on current buffer;
;;;			buffer then needs to be saved and byte-compiled.
;;;
(require 'mini-cl)
(provide 'convert-buttons)

(defun convert-current-buffer ()
  "Convert button references to zones"
  (interactive)
  (save-excursion
    (dolist (repl-string cmd-list)
      (progn
	(goto-char (point-min))
	(replace-string (car repl-string) (cadr repl-string))
	(message "Doing %s" (car repl-string))
))))

(setq cmd-list
  (list
    (list "button-text" "zone-text")
    (list "clear-buttons" "clear-zones")
    (list "move-button" "move-zone")
    (list "make-button" "make-zone")
    (list "button-style" "zone-style")
    (list "button-data" "zone-data")
    (list "button-start" "zone-start")
    (list "button-end" "zone-end")
    (list "button-at" "zone-at")
    (list "buttons-at" "zones-at")
    (list "delete-button-at" "delete-zone-at")
    (list "delete-button" "delete-zone")
    (list "buttonp" "zonep")
    (list "button-list" "zone-list")
    (list "buttons-in-region" "zones-in-region")
    (list "button-buffer" "zone-buffer")
    (list "set-button-style" "set-zone-style")
    (list "button-style" "zone-style")    
    (list "set-button-data" "set-zone-data")
    (list "button-data" "set-zone-data")
    (list "set-button-read-only" "set-zone-read-only")
    (list "button-read-only-p" "zone-read-only-p")
    (list "set-button-transient" "set-zone-transient")
    (list "button-transient-p" "zone-transient-p")
    (list "add-button" "add-zone")
    (list "add-read-only-button" "add-read-only-zone")
    (list "add-graphic-button" "add-graphic-zone")
    (list "buttons-modify-buffer" "zones-modify-buffer") ; variable
))

      
  
  