;;; Copyright (C) 1991 Christopher J. Love
;;;
;;; This file is for use with Epoch, a modified version of GNU Emacs.
;;; Requires Epoch 4.0 or later.
;;;
;;; This code is distributed in the hope that it will be useful,
;;; bute WITHOUT ANY WARRANTY. No author or distributor accepts
;;; responsibility to anyone for the consequences of using this code
;;; or for whether it serves any particular purpose or works at all,
;;; unless explicitly stated in a written agreement.
;;;
;;; Everyone is granted permission to copy, modify and redistribute
;;; this code, but only under the conditions described in the
;;; GNU Emacs General Public License, except the original author nor his
;;; agents are bound by the License in their use of this code.
;;; (These special rights for the author in no way restrict the rights of
;;;  others given in the License or this prologue)
;;; A copy of this license is supposed to have been given to you along
;;; with Epoch so you can know your rights and responsibilities. 
;;; It should be in a file named COPYING.  Among other things, the
;;; copyright notice and this notice must be preserved on all copies. 
;;;
;;; mode-styles.el - Set default modeline format list to contain
;;;	       embedded styles.
;;;
(provide 'mode-styles)

;; mode:*hilight-style*  - style for modeline hilights
(defvar mode:*hilight-style*  (make-style)
  "Style for modeline hilights"
)
(let ((s1 mode:*hilight-style*))
  (set-style-foreground s1 "red")
  (set-style-background s1 "white")
  (set-style-font s1 "ncenb12")
)

;; mode:*normal-style* - style for normal modeline contents
(defvar mode:*normal-style* (make-style)
  "Normal modeline style"
)
(let ((s2 mode:*normal-style*))
  (set-style-foreground s2 "black")
  (set-style-background s2 "white")
  (set-style-font s2 "ncenr12")
)

;; define modeline format
;(setq mode-line-buffer-identification
;  (list mode:*hilight-style* "Epoch: %17b" mode:*normal-style*)
;)
(setq default-mode-line-format
  (list
    ""
    'mode:*normal-style*     
    'mode-line-modified
    'mode:*hilight-style*
    'mode-line-buffer-identification
    'mode:*normal-style*
    "   "
    'global-mode-string
    "   %[("
    'mode-name 'minor-mode-alist "%n" 'mode-line-process
    ")%]----"
    (cons -3 "%p")
    "-%-"
))
;(setq default-mode-line-format
;  (list
;    ""
;    mode:*normal-style*
;    mode-line-modified
;    mode:*hilight-style*
;    mode-line-buffer-identification
;    mode:*normal-style*
;    "   "
;    global-mode-string
;    "   %[("
;    mode-name
;    minor-mode-alist
;    "%n"
;    mode-line-process
;    ")%]----"
;    (cons -3 "%p")
;    "-%-"
;))

