--
-- This file is part of TALER
-- Copyright (C) 2025 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>

BEGIN;

SELECT _v.register_patch('libeufin-bank-0013', NULL, NULL);

SET search_path TO libeufin_bank;
-- Remove all existing functions
DO
$do$
BEGIN
  IF EXISTS (SELECT FROM config WHERE key LIKE 'cashin_%') THEN
    INSERT INTO config (key, value) VALUES ('conversion_rate', jsonb_build_object(
      'cashin', jsonb_build_object(
        'ratio', jsonb_build_object(
          'val', (SELECT value->'val' FROM config WHERE key='cashin_ratio'),
          'frac', (SELECT value->'frac' FROM config WHERE key='cashin_ratio')
        ),
        'fee', jsonb_build_object(
          'val', (SELECT value->'val' FROM config WHERE key='cashin_fee'),
          'frac', (SELECT value->'frac' FROM config WHERE key='cashin_fee')
        ),
        'tiny_amount', jsonb_build_object(
          'val', (SELECT value->'val' FROM config WHERE key='cashin_tiny_amount'),
          'frac', (SELECT value->'frac' FROM config WHERE key='cashin_tiny_amount')
        ),
        'min_amount', jsonb_build_object(
          'val', (SELECT value->'val' FROM config WHERE key='cashin_min_amount'),
          'frac', (SELECT value->'frac' FROM config WHERE key='cashin_min_amount')
        ),
        'rounding_mode', (SELECT value->'mode' FROM config WHERE key='cashin_rounding_mode')
      ),
      'cashout', jsonb_build_object(
        'ratio', jsonb_build_object(
          'val', (SELECT value->'val' FROM config WHERE key='cashout_ratio'),
          'frac', (SELECT value->'frac' FROM config WHERE key='cashout_ratio')
        ),
        'fee', jsonb_build_object(
          'val', (SELECT value->'val' FROM config WHERE key='cashout_fee'),
          'frac', (SELECT value->'frac' FROM config WHERE key='cashout_fee')
        ),
        'tiny_amount', jsonb_build_object(
          'val', (SELECT value->'val' FROM config WHERE key='cashout_tiny_amount'),
          'frac', (SELECT value->'frac' FROM config WHERE key='cashout_tiny_amount')
        ),
        'min_amount', jsonb_build_object(
          'val', (SELECT value->'val' FROM config WHERE key='cashout_min_amount'),
          'frac', (SELECT value->'frac' FROM config WHERE key='cashout_min_amount')
        ),
        'rounding_mode', (SELECT value->'mode' FROM config WHERE key='cashout_rounding_mode')
        )
      )
    );
    DELETE FROM config WHERE key LIKE 'cashin_%' OR key LIKE 'cashout_%';
  END IF;
END
$do$;

CREATE TABLE conversion_rate_classes
  ( conversion_rate_class_id INT8 GENERATED BY DEFAULT AS IDENTITY UNIQUE
   ,name TEXT NOT NULL UNIQUE
   ,description TEXT
   ,cashin_ratio taler_amount
   ,cashin_fee taler_amount
   ,cashin_min_amount taler_amount
   ,cashin_rounding_mode rounding_mode
   ,cashout_ratio taler_amount
   ,cashout_fee taler_amount
   ,cashout_min_amount taler_amount
   ,cashout_rounding_mode rounding_mode
  );
COMMENT ON TABLE conversion_rate_classes IS 'TODO';
ALTER TABLE bank_accounts ADD COLUMN conversion_rate_class_id INT4 REFERENCES conversion_rate_classes(conversion_rate_class_id);

-- Migrate existing user config
INSERT INTO conversion_rate_classes(name, cashout_min_amount)
SELECT format('migrated min_cashout=%s.%s', (min_cashout).val, TRIM(TRAILING '0' FROM LPAD((min_cashout).frac::text, 8, '0'))), min_cashout
FROM bank_accounts
WHERE min_cashout IS NOT NULL
GROUP BY min_cashout;
UPDATE bank_accounts SET conversion_rate_class_id=(
  SELECT conversion_rate_class_id FROM conversion_rate_classes WHERE cashout_min_amount=min_cashout
) WHERE min_cashout IS NOT NULL;
ALTER TABLE bank_accounts DROP COLUMN min_cashout;

CREATE INDEX accounts_conversion_rate_class_id ON bank_accounts (conversion_rate_class_id);
COMMENT ON INDEX accounts_conversion_rate_class_id
  IS 'link accounts to their conversion rate class';
COMMIT;
