/* a 32 (or more) bit integer (signed) */
typedef int i32;

/* macros to sign extend quantities that are less than 32 bits long */
/* Sun mishandles (int)(char)(constant) */
#ifndef sun
#define Sign8(n)	((int)(char)(n))
#else
#define Sign8(n)	(((n) << 24) >> 24)
#endif
#define Sign16(n)	((int)(short)(n))
#define Sign24(n)	((n) & (1<<23) ? ((n)|0xff000000) : (n))
/* #define Sign24(n)	(((n) << 8) >> 8) */

/* macros to truncate quantites that are signed but shouldn't be */
#define UnSign8(n)	((n) & 0xff)
#define UnSign16(n)	((n) & 0xffff)
#define UnSign24(n)	((n) & 0xffffff)

/* note that we never have unsigned 32 bit integers */
