/* This machine-generated file includes source code from GNU Jitter.

   Copyright (C) 2016-2021 Luca Saiu
   Written by Luca Saiu

   GNU Jitter is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License,
   or (at your option) any later version.

   GNU Jitter is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Jitter.  If not, see <http://www.gnu.org/licenses/>.


  Copyright (C) 2017, 2018, 2020, 2021  Luca Saiu
  Written by Luca Saiu

  This file is part of JitterLisp, distributed as an example along with
  GNU Jitter under the same license.

  JitterLisp is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  JitterLisp is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with JitterLisp.  If not, see <http://www.gnu.org/licenses/>.

*/

/* User-specified code, initial vm2 part: beginning. */

/* User-specified code, initial vm2 part: end */

/* These two macros are convenient for making VM-specific identifiers
   using VM-independent macros from a public header, without polluting
   the global namespace. */
#define JITTER_VM_PREFIX_LOWER_CASE jitterlispvm
#define JITTER_VM_PREFIX_UPPER_CASE JITTERLISPVM

//#include <config.h>

#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>

/* Early C code from the user. */

#   include <stdio.h>
  
  /* End of the early C code from the user. */

#include <jitter/jitter.h>
#include <jitter/jitter-instruction.h>

#define JITTER_THIS_CAN_INCLUDE_JITTER_EXECUTOR_H
#include <jitter/jitter-executor.h>

#ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-machine-common.h>
#include <jitter/machine/jitter-machine.h>
#endif // #ifdef JITTER_ENABLE_ASSEMBLY
#include <jitter/jitter-fatal.h>
#include <jitter/jitter-malloc.h>

#include "jitterlispvm-vm.h"
//#include "jitterlispvm-meta-instructions.h"
//#include "jitterlispvm-specialized-instructions.h"
//#include "jitterlispvm-state.h"

/* Include stack data structure support. */
#include <jitter/jitter-stack.h>

/* Include patch-in definitions, only if patch-in is enabled.  We know whether it is
   by checking JITTER_HAVE_PATCH_IN , defined in jitter/jitter-patch-in.h .
   The same for defects. */
#include <jitter/jitter-patch-in.h>
#include <jitter/jitter-fast-branch.h>
#include <jitter/jitter-defect.h>
#ifdef JITTER_HAVE_PATCH_IN
  JITTER_PATCH_IN_DESCRIPTOR_DECLARATIONS_(jitterlispvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
  static void jitter_useless_function (void) asm ("jitter_fake_target_asm");
  static void jitter_useless_function (void) {}
  JITTER_DEFECT_DESCRIPTOR_DECLARATIONS_(jitterlispvm);
  static const char * const jitterlispvm_fake_target_asm
    = (const char *) & jitter_useless_function;
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

/* Always include the non-user fast-branch definitions, which use patch-ins where possible
   or consist in fallback definitions otherwise. */
#include <jitter/jitter-fast-branch.h>

#define JITTER_FAST_BRANCH_PREFIX jitterlispvm_

/* Most of the needed macros are in jitter-executor.h .  This however
   needs to be here, as it relies on a prefix to be substituted. */
#define _JITTER_STATE_BACKING  \
  (jitter_original_state->jitterlispvm_state_backing)
/* Expand to an l-value evaluating to the pending_notification field for
   the current state. */
#define JITTER_PENDING_NOTIFICATIONS  \
  (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_notifications)
/* Expand to an l-value evaluating to the pending field of the struct
   jitter_signal_notification element for the given signal, for the
   current state. */
#define JITTER_PENDING_SIGNAL_NOTIFICATION(signal_id)  \
  ((JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA->pending_signal_notifications + (signal_id))->pending)

/* Expand to the i-th fast register as an lvalue.  This is used internally,
   always with a literal index . */
#define JITTER_FAST_REGISTER(class, index)                             \
  (JITTER_CONCATENATE_FOUR(jitter_state_runtime.jitter_fast_register_, \
                           class, _, index))

/* Expand to a slow register lvalue, given an offset in bytes from the base. */
#define JITTER_SLOW_REGISTER_FROM_OFFSET(c, offset)               \
  (* ((JITTER_CONCATENATE_TWO(jitterlispvm_register_, c) * restrict)  \
      (((char *) jitter_array_base) + offset)))

/* Expand to the i-th register, which must be a slow register, as an lvalue.
   The given index must be a register index counting from 0 and including fast
   regusters as well, if there are any.  For example if an r class had 3 fast
   registers then the first slow register would be %r3, to be accessed as
   JITTER_SLOW_REGISTER(r, 3).  It would be invalid to access %r0, %r1 and
   %r2 which this macro, as %r0, %r1 and %r2 would be fast. */
#define JITTER_SLOW_REGISTER(c, i)                                          \
  JITTER_SLOW_REGISTER_FROM_OFFSET(c, JITTERLISPVM_SLOW_REGISTER_OFFSET(c, i))

/* It's not possible to have a single macro JITTER_REGISTER taking an index and
   expanding to either a fast or a slow register lvalue, due to CPP conditional
   limitations.  This restriction is unfortunate, but we have to live with it
   as long as we don't switch to a different preprocessor.
   What we can have is a set of zero-argument macros each expanding to a register
   lvalue, for *a limited number* of registers.  Here we define access macros for
   every fast register plus a reasonable number (currently 32) of slow registers,
   per class. */
#define JITTER_REGISTER_r_0    JITTER_SLOW_REGISTER(r, 0)
#define JITTER_REGISTER_r_1    JITTER_SLOW_REGISTER(r, 1)
#define JITTER_REGISTER_r_2    JITTER_SLOW_REGISTER(r, 2)
#define JITTER_REGISTER_r_3    JITTER_SLOW_REGISTER(r, 3)
#define JITTER_REGISTER_r_4    JITTER_SLOW_REGISTER(r, 4)
#define JITTER_REGISTER_r_5    JITTER_SLOW_REGISTER(r, 5)
#define JITTER_REGISTER_r_6    JITTER_SLOW_REGISTER(r, 6)
#define JITTER_REGISTER_r_7    JITTER_SLOW_REGISTER(r, 7)
#define JITTER_REGISTER_r_8    JITTER_SLOW_REGISTER(r, 8)
#define JITTER_REGISTER_r_9    JITTER_SLOW_REGISTER(r, 9)
#define JITTER_REGISTER_r_10   JITTER_SLOW_REGISTER(r, 10)
#define JITTER_REGISTER_r_11   JITTER_SLOW_REGISTER(r, 11)
#define JITTER_REGISTER_r_12   JITTER_SLOW_REGISTER(r, 12)
#define JITTER_REGISTER_r_13   JITTER_SLOW_REGISTER(r, 13)
#define JITTER_REGISTER_r_14   JITTER_SLOW_REGISTER(r, 14)
#define JITTER_REGISTER_r_15   JITTER_SLOW_REGISTER(r, 15)
#define JITTER_REGISTER_r_16   JITTER_SLOW_REGISTER(r, 16)
#define JITTER_REGISTER_r_17   JITTER_SLOW_REGISTER(r, 17)
#define JITTER_REGISTER_r_18   JITTER_SLOW_REGISTER(r, 18)
#define JITTER_REGISTER_r_19   JITTER_SLOW_REGISTER(r, 19)
#define JITTER_REGISTER_r_20   JITTER_SLOW_REGISTER(r, 20)
#define JITTER_REGISTER_r_21   JITTER_SLOW_REGISTER(r, 21)
#define JITTER_REGISTER_r_22   JITTER_SLOW_REGISTER(r, 22)
#define JITTER_REGISTER_r_23   JITTER_SLOW_REGISTER(r, 23)
#define JITTER_REGISTER_r_24   JITTER_SLOW_REGISTER(r, 24)
#define JITTER_REGISTER_r_25   JITTER_SLOW_REGISTER(r, 25)
#define JITTER_REGISTER_r_26   JITTER_SLOW_REGISTER(r, 26)
#define JITTER_REGISTER_r_27   JITTER_SLOW_REGISTER(r, 27)
#define JITTER_REGISTER_r_28   JITTER_SLOW_REGISTER(r, 28)
#define JITTER_REGISTER_r_29   JITTER_SLOW_REGISTER(r, 29)
#define JITTER_REGISTER_r_30   JITTER_SLOW_REGISTER(r, 30)
#define JITTER_REGISTER_r_31   JITTER_SLOW_REGISTER(r, 31)


#ifdef JITTER_DISPATCH_NO_THREADING

/* Reserve the scratch register, if any. */
#ifdef JITTER_SCRATCH_REGISTER
  register union jitter_word
  jitter_residual_argument_scratch_register_variable asm (JITTER_STRINGIFY(JITTER_SCRATCH_REGISTER));
#endif // #ifdef JITTER_SCRATCH_REGISTER

/* Reserve The Array base register. */
#ifndef JITTER_BASE_REGISTER
# error "the machine does not define JITTER_BASE_REGISTER"
#else
register char * restrict
jitterlispvm_array_base_register_variable asm (JITTER_STRINGIFY(JITTER_BASE_REGISTER));
#endif // #ifndef JITTER_BASE_REGISTER

/* Reserve registers for our 4 residual arguments.  If this particular VM doesn't
   need all of those supported by the assembly machine then reserve only the first
   ones.  If, on the other hand, we need more residual arguments than we have
   available registers, use CPP macros to map the remaining residual arguments
   to memory locations relative to the base, with constant offsets. */

/* Define a macro for the 0-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_0_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_0));
# define JITTER_RESIDUAL_ARGUMENT_0               \
    jitter_residual_argument_0_register_variable
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_0_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_0  \
    (* (union jitter_word *)                 \
       (jitter_array_base + JITTERLISPVM_RESIDUAL_OFFSET(0)))
# define JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_0)
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 1-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_1_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_1));
# define JITTER_RESIDUAL_ARGUMENT_1               \
    jitter_residual_argument_1_register_variable
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_1_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_1  \
    (* (union jitter_word *)                 \
       (jitter_array_base + JITTERLISPVM_RESIDUAL_OFFSET(1)))
# define JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_1)
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 2-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_2_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_2));
# define JITTER_RESIDUAL_ARGUMENT_2               \
    jitter_residual_argument_2_register_variable
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_2_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_2  \
    (* (union jitter_word *)                 \
       (jitter_array_base + JITTERLISPVM_RESIDUAL_OFFSET(2)))
# define JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_2)
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)

/* Define a macro for the 3-th residual as a register, or as a residual
   memory slot.  Also define a macro expanding to inline asm code with
   output constraints on the appropriate register or memory, to let GCC
   know that its value has been changed by unknown code. */
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  register union jitter_word
  jitter_residual_argument_3_register_variable asm (JITTER_STRINGIFY(JITTER_RESIDUAL_REGISTER_3));
# define JITTER_RESIDUAL_ARGUMENT_3               \
    jitter_residual_argument_3_register_variable
# define JITTER_MARK_RESIDUAL_3_AS_SET_BY_ASSEMBLY                 \
    JITTER_MARK_REGISTER_AS_SET_BY_ASSEMBLY(jitter_residual_argument_3_register_variable)
#else
# define JITTER_RESIDUAL_ARGUMENT_3  \
    (* (union jitter_word *)                 \
       (jitter_array_base + JITTERLISPVM_RESIDUAL_OFFSET(3)))
# define JITTER_MARK_RESIDUAL_3_AS_SET_BY_ASSEMBLY                    \
    JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(JITTER_RESIDUAL_ARGUMENT_3)
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)

/* The global register values we reserve in this compilation unit are
   callee-save: the called function is supposed to save them before
   setting them, and restore them to their previous value before
   returning to the caller.  Of course this is not done automatically
   in this compilation unit, so we have to do it by hand.  Notice that
   every variable allocated to a register by GCC will not use the
   registers we reserved, so we can be sure that, if we save our
   global register variables before setting them for the first time,
   their values will be the ones we want to retain. */

/* The buffer where I keep the original register values needs to hold
   every residual register, plus possibly the scratch register and the
   residual base; those two registers are not always used, but allocating
   just two words more costs essentially nothing and lets me simplify
   the code a little.  The two words are not written or read unless
   needed. */
#define JITTERLISPVM_REGISTER_BUFFER_ELEMENT_NO (JITTER_RESIDUAL_REGISTER_NO + 2)
__attribute__ ((noinline, cold))

static void
jitterlispvm_save_registers (union jitter_word *buffer)
{
  buffer [0].pointer = (union jitter_word*) jitterlispvm_array_base_register_variable;
#ifdef JITTER_SCRATCH_REGISTER
  buffer [1] = jitter_residual_argument_scratch_register_variable;
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [0 + 2] = JITTER_RESIDUAL_ARGUMENT_0;
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [1 + 2] = JITTER_RESIDUAL_ARGUMENT_1;
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [2 + 2] = JITTER_RESIDUAL_ARGUMENT_2;
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  buffer [3 + 2] = JITTER_RESIDUAL_ARGUMENT_3;
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)
}

__attribute__ ((noinline, cold))
static void
jitterlispvm_restore_registers (const union jitter_word *buffer)
{
  jitterlispvm_array_base_register_variable = (char *) buffer [0].pointer;
#ifdef JITTER_SCRATCH_REGISTER
  jitter_residual_argument_scratch_register_variable = buffer [1];
#endif // #ifdef JITTER_SCRATCH_REGISTER
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_0 = buffer [0 + 2];
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_1 = buffer [1 + 2];
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_2 = buffer [2 + 2];
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_RESIDUAL_ARGUMENT_3 = buffer [3 + 2];
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)
}

#endif // #ifdef JITTER_DISPATCH_NO_THREADING


/* The following stack operations (without the initial state
   argument) can be used inside instruction code blocks.
   Notice that macros with the same "JITTERLISPVM_" names are
   defined in the generated header to be used out of VM code,
   but those alternative definitions have an additional first
   argument, a VM state pointer. */

/* Wrapper definition of the top operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_TOP_MAINSTACK
#undef JITTERLISPVM_TOP_MAINSTACK
#define JITTERLISPVM_TOP_MAINSTACK /* The preferred name. */ \
  JITTER_TOP_MAINSTACK
#define JITTER_TOP_MAINSTACK()  \
  JITTER_STACK_TOS_TOP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the under_top operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_UNDER_TOP_MAINSTACK
#undef JITTERLISPVM_UNDER_TOP_MAINSTACK
#define JITTERLISPVM_UNDER_TOP_MAINSTACK /* The preferred name. */ \
  JITTER_UNDER_TOP_MAINSTACK
#define JITTER_UNDER_TOP_MAINSTACK()  \
  JITTER_STACK_TOS_UNDER_TOP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the at_depth operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_AT_DEPTH_MAINSTACK
#undef JITTERLISPVM_AT_DEPTH_MAINSTACK
#define JITTERLISPVM_AT_DEPTH_MAINSTACK /* The preferred name. */ \
  JITTER_AT_DEPTH_MAINSTACK
#define JITTER_AT_DEPTH_MAINSTACK(x0)  \
  JITTER_STACK_TOS_AT_DEPTH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the at_nonzero_depth operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_AT_NONZERO_DEPTH_MAINSTACK
#undef JITTERLISPVM_AT_NONZERO_DEPTH_MAINSTACK
#define JITTERLISPVM_AT_NONZERO_DEPTH_MAINSTACK /* The preferred name. */ \
  JITTER_AT_NONZERO_DEPTH_MAINSTACK
#define JITTER_AT_NONZERO_DEPTH_MAINSTACK(x0)  \
  JITTER_STACK_TOS_AT_NONZERO_DEPTH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the set_at_depth operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_SET_AT_DEPTH_MAINSTACK
#undef JITTERLISPVM_SET_AT_DEPTH_MAINSTACK
#define JITTERLISPVM_SET_AT_DEPTH_MAINSTACK /* The preferred name. */ \
  JITTER_SET_AT_DEPTH_MAINSTACK
#define JITTER_SET_AT_DEPTH_MAINSTACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_DEPTH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0, x1)
/* Wrapper definition of the set_at_nonzero_depth operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_SET_AT_NONZERO_DEPTH_MAINSTACK
#undef JITTERLISPVM_SET_AT_NONZERO_DEPTH_MAINSTACK
#define JITTERLISPVM_SET_AT_NONZERO_DEPTH_MAINSTACK /* The preferred name. */ \
  JITTER_SET_AT_NONZERO_DEPTH_MAINSTACK
#define JITTER_SET_AT_NONZERO_DEPTH_MAINSTACK(x0, x1)  \
  JITTER_STACK_TOS_SET_AT_NONZERO_DEPTH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0, x1)
/* Wrapper definition of the push_unspecified operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_PUSH_UNSPECIFIED_MAINSTACK
#undef JITTERLISPVM_PUSH_UNSPECIFIED_MAINSTACK
#define JITTERLISPVM_PUSH_UNSPECIFIED_MAINSTACK /* The preferred name. */ \
  JITTER_PUSH_UNSPECIFIED_MAINSTACK
#define JITTER_PUSH_UNSPECIFIED_MAINSTACK()  \
  JITTER_STACK_TOS_PUSH_UNSPECIFIED (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the push operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_PUSH_MAINSTACK
#undef JITTERLISPVM_PUSH_MAINSTACK
#define JITTERLISPVM_PUSH_MAINSTACK /* The preferred name. */ \
  JITTER_PUSH_MAINSTACK
#define JITTER_PUSH_MAINSTACK(x0)  \
  JITTER_STACK_TOS_PUSH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the under_push_unspecified operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_UNDER_PUSH_UNSPECIFIED_MAINSTACK
#undef JITTERLISPVM_UNDER_PUSH_UNSPECIFIED_MAINSTACK
#define JITTERLISPVM_UNDER_PUSH_UNSPECIFIED_MAINSTACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_UNSPECIFIED_MAINSTACK
#define JITTER_UNDER_PUSH_UNSPECIFIED_MAINSTACK()  \
  JITTER_STACK_TOS_UNDER_PUSH_UNSPECIFIED (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the under_push operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_UNDER_PUSH_MAINSTACK
#undef JITTERLISPVM_UNDER_PUSH_MAINSTACK
#define JITTERLISPVM_UNDER_PUSH_MAINSTACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_MAINSTACK
#define JITTER_UNDER_PUSH_MAINSTACK(x0)  \
  JITTER_STACK_TOS_UNDER_PUSH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the drop operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_DROP_MAINSTACK
#undef JITTERLISPVM_DROP_MAINSTACK
#define JITTERLISPVM_DROP_MAINSTACK /* The preferred name. */ \
  JITTER_DROP_MAINSTACK
#define JITTER_DROP_MAINSTACK()  \
  JITTER_STACK_TOS_DROP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the dup operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_DUP_MAINSTACK
#undef JITTERLISPVM_DUP_MAINSTACK
#define JITTERLISPVM_DUP_MAINSTACK /* The preferred name. */ \
  JITTER_DUP_MAINSTACK
#define JITTER_DUP_MAINSTACK()  \
  JITTER_STACK_TOS_DUP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the swap operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_SWAP_MAINSTACK
#undef JITTERLISPVM_SWAP_MAINSTACK
#define JITTERLISPVM_SWAP_MAINSTACK /* The preferred name. */ \
  JITTER_SWAP_MAINSTACK
#define JITTER_SWAP_MAINSTACK()  \
  JITTER_STACK_TOS_SWAP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the quake operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_QUAKE_MAINSTACK
#undef JITTERLISPVM_QUAKE_MAINSTACK
#define JITTERLISPVM_QUAKE_MAINSTACK /* The preferred name. */ \
  JITTER_QUAKE_MAINSTACK
#define JITTER_QUAKE_MAINSTACK()  \
  JITTER_STACK_TOS_QUAKE (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the over operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_OVER_MAINSTACK
#undef JITTERLISPVM_OVER_MAINSTACK
#define JITTERLISPVM_OVER_MAINSTACK /* The preferred name. */ \
  JITTER_OVER_MAINSTACK
#define JITTER_OVER_MAINSTACK()  \
  JITTER_STACK_TOS_OVER (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the tuck operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_TUCK_MAINSTACK
#undef JITTERLISPVM_TUCK_MAINSTACK
#define JITTERLISPVM_TUCK_MAINSTACK /* The preferred name. */ \
  JITTER_TUCK_MAINSTACK
#define JITTER_TUCK_MAINSTACK()  \
  JITTER_STACK_TOS_TUCK (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the nip operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_NIP_MAINSTACK
#undef JITTERLISPVM_NIP_MAINSTACK
#define JITTERLISPVM_NIP_MAINSTACK /* The preferred name. */ \
  JITTER_NIP_MAINSTACK
#define JITTER_NIP_MAINSTACK()  \
  JITTER_STACK_TOS_NIP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the rot operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_ROT_MAINSTACK
#undef JITTERLISPVM_ROT_MAINSTACK
#define JITTERLISPVM_ROT_MAINSTACK /* The preferred name. */ \
  JITTER_ROT_MAINSTACK
#define JITTER_ROT_MAINSTACK()  \
  JITTER_STACK_TOS_ROT (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the mrot operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_MROT_MAINSTACK
#undef JITTERLISPVM_MROT_MAINSTACK
#define JITTERLISPVM_MROT_MAINSTACK /* The preferred name. */ \
  JITTER_MROT_MAINSTACK
#define JITTER_MROT_MAINSTACK()  \
  JITTER_STACK_TOS_MROT (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the roll operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_ROLL_MAINSTACK
#undef JITTERLISPVM_ROLL_MAINSTACK
#define JITTERLISPVM_ROLL_MAINSTACK /* The preferred name. */ \
  JITTER_ROLL_MAINSTACK
#define JITTER_ROLL_MAINSTACK(x0)  \
  JITTER_STACK_TOS_ROLL (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the mroll operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_MROLL_MAINSTACK
#undef JITTERLISPVM_MROLL_MAINSTACK
#define JITTERLISPVM_MROLL_MAINSTACK /* The preferred name. */ \
  JITTER_MROLL_MAINSTACK
#define JITTER_MROLL_MAINSTACK(x0)  \
  JITTER_STACK_TOS_MROLL (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the slide operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_SLIDE_MAINSTACK
#undef JITTERLISPVM_SLIDE_MAINSTACK
#define JITTERLISPVM_SLIDE_MAINSTACK /* The preferred name. */ \
  JITTER_SLIDE_MAINSTACK
#define JITTER_SLIDE_MAINSTACK(x0, x1)  \
  JITTER_STACK_TOS_SLIDE (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0, x1)
/* Wrapper definition of the whirl operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_WHIRL_MAINSTACK
#undef JITTERLISPVM_WHIRL_MAINSTACK
#define JITTERLISPVM_WHIRL_MAINSTACK /* The preferred name. */ \
  JITTER_WHIRL_MAINSTACK
#define JITTER_WHIRL_MAINSTACK(x0)  \
  JITTER_STACK_TOS_WHIRL (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the bulge operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_BULGE_MAINSTACK
#undef JITTERLISPVM_BULGE_MAINSTACK
#define JITTERLISPVM_BULGE_MAINSTACK /* The preferred name. */ \
  JITTER_BULGE_MAINSTACK
#define JITTER_BULGE_MAINSTACK(x0)  \
  JITTER_STACK_TOS_BULGE (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the height operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_HEIGHT_MAINSTACK
#undef JITTERLISPVM_HEIGHT_MAINSTACK
#define JITTERLISPVM_HEIGHT_MAINSTACK /* The preferred name. */ \
  JITTER_HEIGHT_MAINSTACK
#define JITTER_HEIGHT_MAINSTACK()  \
  JITTER_STACK_TOS_HEIGHT (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    )
/* Wrapper definition of the set_height operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_SET_HEIGHT_MAINSTACK
#undef JITTERLISPVM_SET_HEIGHT_MAINSTACK
#define JITTERLISPVM_SET_HEIGHT_MAINSTACK /* The preferred name. */ \
  JITTER_SET_HEIGHT_MAINSTACK
#define JITTER_SET_HEIGHT_MAINSTACK(x0)  \
  JITTER_STACK_TOS_SET_HEIGHT (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the reverse operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_REVERSE_MAINSTACK
#undef JITTERLISPVM_REVERSE_MAINSTACK
#define JITTERLISPVM_REVERSE_MAINSTACK /* The preferred name. */ \
  JITTER_REVERSE_MAINSTACK
#define JITTER_REVERSE_MAINSTACK(x0)  \
  JITTER_STACK_TOS_REVERSE (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the unary operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_UNARY_MAINSTACK
#undef JITTERLISPVM_UNARY_MAINSTACK
#define JITTERLISPVM_UNARY_MAINSTACK /* The preferred name. */ \
  JITTER_UNARY_MAINSTACK
#define JITTER_UNARY_MAINSTACK(x0)  \
  JITTER_STACK_TOS_UNARY (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the binary operation for the
   TOS-optimized stack "mainstack". */
#undef JITTER_BINARY_MAINSTACK
#undef JITTERLISPVM_BINARY_MAINSTACK
#define JITTERLISPVM_BINARY_MAINSTACK /* The preferred name. */ \
  JITTER_BINARY_MAINSTACK
#define JITTER_BINARY_MAINSTACK(x0)  \
  JITTER_STACK_TOS_BINARY (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    mainstack  \
    , x0)
/* Wrapper definition of the top operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_TOP_RETURNSTACK
#undef JITTERLISPVM_TOP_RETURNSTACK
#define JITTERLISPVM_TOP_RETURNSTACK /* The preferred name. */ \
  JITTER_TOP_RETURNSTACK
#define JITTER_TOP_RETURNSTACK()  \
  JITTER_STACK_NTOS_TOP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the under_top operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_UNDER_TOP_RETURNSTACK
#undef JITTERLISPVM_UNDER_TOP_RETURNSTACK
#define JITTERLISPVM_UNDER_TOP_RETURNSTACK /* The preferred name. */ \
  JITTER_UNDER_TOP_RETURNSTACK
#define JITTER_UNDER_TOP_RETURNSTACK()  \
  JITTER_STACK_NTOS_UNDER_TOP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the at_depth operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_AT_DEPTH_RETURNSTACK
#undef JITTERLISPVM_AT_DEPTH_RETURNSTACK
#define JITTERLISPVM_AT_DEPTH_RETURNSTACK /* The preferred name. */ \
  JITTER_AT_DEPTH_RETURNSTACK
#define JITTER_AT_DEPTH_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_AT_DEPTH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)
/* Wrapper definition of the at_nonzero_depth operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_AT_NONZERO_DEPTH_RETURNSTACK
#undef JITTERLISPVM_AT_NONZERO_DEPTH_RETURNSTACK
#define JITTERLISPVM_AT_NONZERO_DEPTH_RETURNSTACK /* The preferred name. */ \
  JITTER_AT_NONZERO_DEPTH_RETURNSTACK
#define JITTER_AT_NONZERO_DEPTH_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_AT_NONZERO_DEPTH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)
/* Wrapper definition of the set_at_depth operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_SET_AT_DEPTH_RETURNSTACK
#undef JITTERLISPVM_SET_AT_DEPTH_RETURNSTACK
#define JITTERLISPVM_SET_AT_DEPTH_RETURNSTACK /* The preferred name. */ \
  JITTER_SET_AT_DEPTH_RETURNSTACK
#define JITTER_SET_AT_DEPTH_RETURNSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_DEPTH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0, x1)
/* Wrapper definition of the set_at_nonzero_depth operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_SET_AT_NONZERO_DEPTH_RETURNSTACK
#undef JITTERLISPVM_SET_AT_NONZERO_DEPTH_RETURNSTACK
#define JITTERLISPVM_SET_AT_NONZERO_DEPTH_RETURNSTACK /* The preferred name. */ \
  JITTER_SET_AT_NONZERO_DEPTH_RETURNSTACK
#define JITTER_SET_AT_NONZERO_DEPTH_RETURNSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SET_AT_NONZERO_DEPTH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0, x1)
/* Wrapper definition of the push_unspecified operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_PUSH_UNSPECIFIED_RETURNSTACK
#undef JITTERLISPVM_PUSH_UNSPECIFIED_RETURNSTACK
#define JITTERLISPVM_PUSH_UNSPECIFIED_RETURNSTACK /* The preferred name. */ \
  JITTER_PUSH_UNSPECIFIED_RETURNSTACK
#define JITTER_PUSH_UNSPECIFIED_RETURNSTACK()  \
  JITTER_STACK_NTOS_PUSH_UNSPECIFIED (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the push operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_PUSH_RETURNSTACK
#undef JITTERLISPVM_PUSH_RETURNSTACK
#define JITTERLISPVM_PUSH_RETURNSTACK /* The preferred name. */ \
  JITTER_PUSH_RETURNSTACK
#define JITTER_PUSH_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_PUSH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)
/* Wrapper definition of the under_push_unspecified operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_UNDER_PUSH_UNSPECIFIED_RETURNSTACK
#undef JITTERLISPVM_UNDER_PUSH_UNSPECIFIED_RETURNSTACK
#define JITTERLISPVM_UNDER_PUSH_UNSPECIFIED_RETURNSTACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_UNSPECIFIED_RETURNSTACK
#define JITTER_UNDER_PUSH_UNSPECIFIED_RETURNSTACK()  \
  JITTER_STACK_NTOS_UNDER_PUSH_UNSPECIFIED (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the under_push operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_UNDER_PUSH_RETURNSTACK
#undef JITTERLISPVM_UNDER_PUSH_RETURNSTACK
#define JITTERLISPVM_UNDER_PUSH_RETURNSTACK /* The preferred name. */ \
  JITTER_UNDER_PUSH_RETURNSTACK
#define JITTER_UNDER_PUSH_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_UNDER_PUSH (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)
/* Wrapper definition of the drop operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_DROP_RETURNSTACK
#undef JITTERLISPVM_DROP_RETURNSTACK
#define JITTERLISPVM_DROP_RETURNSTACK /* The preferred name. */ \
  JITTER_DROP_RETURNSTACK
#define JITTER_DROP_RETURNSTACK()  \
  JITTER_STACK_NTOS_DROP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the dup operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_DUP_RETURNSTACK
#undef JITTERLISPVM_DUP_RETURNSTACK
#define JITTERLISPVM_DUP_RETURNSTACK /* The preferred name. */ \
  JITTER_DUP_RETURNSTACK
#define JITTER_DUP_RETURNSTACK()  \
  JITTER_STACK_NTOS_DUP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the swap operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_SWAP_RETURNSTACK
#undef JITTERLISPVM_SWAP_RETURNSTACK
#define JITTERLISPVM_SWAP_RETURNSTACK /* The preferred name. */ \
  JITTER_SWAP_RETURNSTACK
#define JITTER_SWAP_RETURNSTACK()  \
  JITTER_STACK_NTOS_SWAP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the quake operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_QUAKE_RETURNSTACK
#undef JITTERLISPVM_QUAKE_RETURNSTACK
#define JITTERLISPVM_QUAKE_RETURNSTACK /* The preferred name. */ \
  JITTER_QUAKE_RETURNSTACK
#define JITTER_QUAKE_RETURNSTACK()  \
  JITTER_STACK_NTOS_QUAKE (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the over operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_OVER_RETURNSTACK
#undef JITTERLISPVM_OVER_RETURNSTACK
#define JITTERLISPVM_OVER_RETURNSTACK /* The preferred name. */ \
  JITTER_OVER_RETURNSTACK
#define JITTER_OVER_RETURNSTACK()  \
  JITTER_STACK_NTOS_OVER (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the tuck operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_TUCK_RETURNSTACK
#undef JITTERLISPVM_TUCK_RETURNSTACK
#define JITTERLISPVM_TUCK_RETURNSTACK /* The preferred name. */ \
  JITTER_TUCK_RETURNSTACK
#define JITTER_TUCK_RETURNSTACK()  \
  JITTER_STACK_NTOS_TUCK (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the nip operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_NIP_RETURNSTACK
#undef JITTERLISPVM_NIP_RETURNSTACK
#define JITTERLISPVM_NIP_RETURNSTACK /* The preferred name. */ \
  JITTER_NIP_RETURNSTACK
#define JITTER_NIP_RETURNSTACK()  \
  JITTER_STACK_NTOS_NIP (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the rot operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_ROT_RETURNSTACK
#undef JITTERLISPVM_ROT_RETURNSTACK
#define JITTERLISPVM_ROT_RETURNSTACK /* The preferred name. */ \
  JITTER_ROT_RETURNSTACK
#define JITTER_ROT_RETURNSTACK()  \
  JITTER_STACK_NTOS_ROT (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the mrot operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_MROT_RETURNSTACK
#undef JITTERLISPVM_MROT_RETURNSTACK
#define JITTERLISPVM_MROT_RETURNSTACK /* The preferred name. */ \
  JITTER_MROT_RETURNSTACK
#define JITTER_MROT_RETURNSTACK()  \
  JITTER_STACK_NTOS_MROT (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the roll operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_ROLL_RETURNSTACK
#undef JITTERLISPVM_ROLL_RETURNSTACK
#define JITTERLISPVM_ROLL_RETURNSTACK /* The preferred name. */ \
  JITTER_ROLL_RETURNSTACK
#define JITTER_ROLL_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_ROLL (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)
/* Wrapper definition of the mroll operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_MROLL_RETURNSTACK
#undef JITTERLISPVM_MROLL_RETURNSTACK
#define JITTERLISPVM_MROLL_RETURNSTACK /* The preferred name. */ \
  JITTER_MROLL_RETURNSTACK
#define JITTER_MROLL_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_MROLL (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)
/* Wrapper definition of the slide operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_SLIDE_RETURNSTACK
#undef JITTERLISPVM_SLIDE_RETURNSTACK
#define JITTERLISPVM_SLIDE_RETURNSTACK /* The preferred name. */ \
  JITTER_SLIDE_RETURNSTACK
#define JITTER_SLIDE_RETURNSTACK(x0, x1)  \
  JITTER_STACK_NTOS_SLIDE (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0, x1)
/* Wrapper definition of the whirl operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_WHIRL_RETURNSTACK
#undef JITTERLISPVM_WHIRL_RETURNSTACK
#define JITTERLISPVM_WHIRL_RETURNSTACK /* The preferred name. */ \
  JITTER_WHIRL_RETURNSTACK
#define JITTER_WHIRL_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_WHIRL (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)
/* Wrapper definition of the bulge operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_BULGE_RETURNSTACK
#undef JITTERLISPVM_BULGE_RETURNSTACK
#define JITTERLISPVM_BULGE_RETURNSTACK /* The preferred name. */ \
  JITTER_BULGE_RETURNSTACK
#define JITTER_BULGE_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_BULGE (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)
/* Wrapper definition of the height operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_HEIGHT_RETURNSTACK
#undef JITTERLISPVM_HEIGHT_RETURNSTACK
#define JITTERLISPVM_HEIGHT_RETURNSTACK /* The preferred name. */ \
  JITTER_HEIGHT_RETURNSTACK
#define JITTER_HEIGHT_RETURNSTACK()  \
  JITTER_STACK_NTOS_HEIGHT (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    )
/* Wrapper definition of the set_height operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_SET_HEIGHT_RETURNSTACK
#undef JITTERLISPVM_SET_HEIGHT_RETURNSTACK
#define JITTERLISPVM_SET_HEIGHT_RETURNSTACK /* The preferred name. */ \
  JITTER_SET_HEIGHT_RETURNSTACK
#define JITTER_SET_HEIGHT_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_SET_HEIGHT (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)
/* Wrapper definition of the reverse operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_REVERSE_RETURNSTACK
#undef JITTERLISPVM_REVERSE_RETURNSTACK
#define JITTERLISPVM_REVERSE_RETURNSTACK /* The preferred name. */ \
  JITTER_REVERSE_RETURNSTACK
#define JITTER_REVERSE_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_REVERSE (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)
/* Wrapper definition of the unary operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_UNARY_RETURNSTACK
#undef JITTERLISPVM_UNARY_RETURNSTACK
#define JITTERLISPVM_UNARY_RETURNSTACK /* The preferred name. */ \
  JITTER_UNARY_RETURNSTACK
#define JITTER_UNARY_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_UNARY (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)
/* Wrapper definition of the binary operation for the
   non-TOS-optimized stack "returnstack". */
#undef JITTER_BINARY_RETURNSTACK
#undef JITTERLISPVM_BINARY_RETURNSTACK
#define JITTERLISPVM_BINARY_RETURNSTACK /* The preferred name. */ \
  JITTER_BINARY_RETURNSTACK
#define JITTER_BINARY_RETURNSTACK(x0)  \
  JITTER_STACK_NTOS_BINARY (jitterlisp_object,  \
    jitter_state_runtime. /* not an error */,  \
    returnstack  \
    , x0)

/* Late C code from the user. */

__attribute__ ((unused))
void
debug_pointer (jitter_int index, const void *pointer)
{
  return;
  printf ("[DEBUG: %lli %p]\n", (long long) index, pointer);
  fflush (stdout);
}

/* Open an argument-type-checking sequence, for the given number of arguments
   to be read from the main stack.  This is a helper macro for
   JITTERLISPVM_CHECK_TYPES_* . */
#define JITTERLISPVM_BEGIN_CHECK_TYPES_(_jitterlisp_vm_in_arity)  \
  JITTER_BEGIN_                                                   \
    int _jitterlispvm_arg_no = (_jitterlisp_vm_in_arity);         \
    int _jitterlispvm_arg_index __attribute__ ((unused)) = 0;     \
    int _jitterlispvm_arg_depth __attribute__ ((unused)) \
      = _jitterlispvm_arg_no - 1;

/* Check the next argument in the sequence, failing if its type doesn't match
   the given uppercase suffix.  Do nothing if compiling an unsafe JitterLisp. */
#ifdef JITTERLISP_UNSAFE
# define JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type,    \
                                       _jitterlisp_error_fast_label)  \
    { /* Do nothing. */ }
#else
# define JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type,     \
                                       _jitterlisp_error_fast_label)   \
    {                                                                  \
      /* Branch-fast to the given label if the next object type is     \
         not the required one. */                                      \
      JITTER_CONCATENATE_TWO (JITTERLISP_BRANCH_FAST_UNLESS_,          \
                              _jitterlisp_uppercase_type)              \
         (JITTER_AT_DEPTH_MAINSTACK(_jitterlispvm_arg_depth),          \
          _jitterlisp_error_fast_label);                               \
      _jitterlispvm_arg_depth --;                                      \
      _jitterlispvm_arg_index ++;                                      \
    }
#endif // #ifdef JITTERLISP_UNSAFE

/* Close an argument-type-checking sequence.  This is a helper macro for
   JITTERLISPVM_CHECK_TYPES_* . */
#define JITTERLISPVM_END_CHECK_TYPES_  \
  JITTER_END_

/* For in-arity N, check that the topmost N arguments have the given N types
   expressed as uppercase suffixes, respectively.  This functionality is
   provided for a few common values of N . */
#define JITTERLISPVM_CHECK_TYPES_1(_jitterlisp_uppercase_type_0,  \
                                   _jitterlisp_error_fast_label)  \
  JITTERLISPVM_BEGIN_CHECK_TYPES_(1)                              \
    JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type_0,   \
                                  _jitterlisp_error_fast_label);  \
  JITTERLISPVM_END_CHECK_TYPES_
#define JITTERLISPVM_CHECK_TYPES_2(_jitterlisp_uppercase_type_0,  \
                                   _jitterlisp_uppercase_type_1,  \
                                   _jitterlisp_error_fast_label)  \
  JITTERLISPVM_BEGIN_CHECK_TYPES_(2)                              \
    JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type_0,   \
                                  _jitterlisp_error_fast_label);  \
    JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type_1,   \
                                  _jitterlisp_error_fast_label);  \
  JITTERLISPVM_END_CHECK_TYPES_
#define JITTERLISPVM_CHECK_TYPES_3(_jitterlisp_uppercase_type_0,  \
                                   _jitterlisp_uppercase_type_1,  \
                                   _jitterlisp_uppercase_type_2,  \
                                   _jitterlisp_error_fast_label)  \
  JITTERLISPVM_BEGIN_CHECK_TYPES_(3)                              \
    JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type_0,   \
                                  _jitterlisp_error_fast_label);  \
    JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type_1,   \
                                  _jitterlisp_error_fast_label);  \
    JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type_2,   \
                                  _jitterlisp_error_fast_label);  \
  JITTERLISPVM_END_CHECK_TYPES_
#define JITTERLISPVM_CHECK_TYPES_4(_jitterlisp_uppercase_type_0,  \
                                   _jitterlisp_uppercase_type_1,  \
                                   _jitterlisp_uppercase_type_2,  \
                                   _jitterlisp_uppercase_type_3,  \
                                   _jitterlisp_error_fast_label)  \
  JITTERLISPVM_BEGIN_CHECK_TYPES_(4)                              \
    JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type_0,   \
                                  _jitterlisp_error_fast_label);  \
    JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type_1,   \
                                  _jitterlisp_error_fast_label);  \
    JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type_2,   \
                                  _jitterlisp_error_fast_label);  \
    JITTERLISPVM_CHECK_NEXT_TYPE_(_jitterlisp_uppercase_type_3,   \
                                  _jitterlisp_error_fast_label);  \
  JITTERLISPVM_END_CHECK_TYPES_

#if 0
# define JITTERLISPVM_ERROR_INVALID_PRIMITIVE_ARGUMENT_TYPE_          \
    jitterlispvm_error_invalid_primitive_argument_type_unfriendly ()
#else
# define JITTERLISPVM_ERROR_INVALID_PRIMITIVE_ARGUMENT_TYPE_     \
    jitterlispvm_error_invalid_primitive_argument_type_friendly  \
       (JITTER_SPECIALIZED_INSTRUCTION_OPCODE,                   \
        _jitterlispvm_arg_index,                                 \
        JITTER_AT_DEPTH_MAINSTACK(_jitterlispvm_arg_depth))
#endif


// Unfortunately the attribute is invisible across the wrapper.
// This is convenient for debugging, but I don't want to use it in production:
// passing parameters at every call makes the code much bigger, even if the
// call is not executed.
__attribute__ ((noreturn, unused))
static void
jitterlispvm_error_invalid_primitive_argument_type_friendly
   (int sins_opcode,
    int arg_index,
    jitterlisp_object o)
{
  /* Print information about the argument and its hex representation:
     don't dare yet to print it as a Lisp object, as the printer might
     crash if there is a bug and the object is invalid. */
#define SIZEOF_BUFFER 1000
  char buffer [SIZEOF_BUFFER];
  snprintf (buffer,
            SIZEOF_BUFFER,
            "%s: About the %i-th (0-based) primitive argument %p\n",
            jitterlispvm_specialized_instruction_names [sins_opcode],
            arg_index, (void *) o);
#undef SIZEOF_BUFFER
  jitterlisp_print_error_char_star (buffer);

  /* This shouldn't be needed on GNU, but flush the output so that we can be
     sure that the previous line is visible before we crash. */
  jitter_print_flush (jitterlisp_print_context);

  /* Okay, now we can print in in Lisp. */
  jitterlisp_print_error_char_star ("  (in Lisp ");
  jitterlisp_print_error (o);
  jitterlisp_print_error_char_star ("):\n");

  jitterlisp_error_cloned ("invalid primitive argument type");
}

__attribute__ ((noreturn, unused))
static void
jitterlispvm_error_invalid_primitive_argument_type_unfriendly (void)
{
  jitterlisp_error_cloned ("invalid primitive argument type");
}

static void
jitterlisp_fail_from_vm (void)
{
  jitterlisp_error_cloned ("unspecified error raised by VM code");
}

    static const char *stack_printf_format_string __attribute__ ((unused))
      = "%" JITTER_PRIi "\n";
  
  
  /* End of the late C code from the user. */

/* The definition of this is machine-generated in jitterlispvm-vm2.c , and the
   function is not intended for the user.  If initializing then set
   structuredvm_threads and structuredvm_thread_sizes and just return, ignoring
   the other fields and s.  If not initializing then actually enter VM code
   starting from the initial program point in the state. */
static enum jitterlispvm_exit_status
jitterlispvm_execute_or_initialize (bool jitter_initialize,
                                struct jitterlispvm_state * const jitter_original_state)
  __attribute__ ((noclone, noinline, no_reorder));

enum jitterlispvm_exit_status
jitterlispvm_execute_executable_routine (const struct jitter_executable_routine *er,
                                     struct jitterlispvm_state *s)
{
  jitterlispvm_make_place_for_slow_registers (s, er->slow_register_per_class_no);
  jitter_program_point initial_program_point
    = JITTERLISPVM_EXECUTABLE_ROUTINE_BEGINNING (er);
  return jitterlispvm_branch_to_program_point (initial_program_point,
                                           s);
}


/* Threads or pointers to native code blocks of course don't exist with
   switch-dispatching. */
#ifndef JITTER_DISPATCH_SWITCH
const jitter_thread *
jitterlispvm_threads;

const jitter_thread *
jitterlispvm_thread_ends;

const long *
jitterlispvm_thread_sizes;
#endif // #ifndef JITTER_DISPATCH_SWITCH

void
jitterlispvm_initialize_threads (void)
{
  jitterlispvm_execute_or_initialize (true, NULL);
}

enum jitterlispvm_exit_status
jitterlispvm_branch_to_program_point (jitterlispvm_program_point p, struct jitterlispvm_state *s)
{
  /* Change the state to set the initial program point. */
  s->jitterlispvm_state_backing.initial_program_point = p;

  /* Execute. */
  return jitterlispvm_execute_or_initialize (false, s);
}

__attribute__ ((noinline, noclone, no_reorder))
void
jitterlispvm_asm_headers (void)
{
#ifdef JITTER_HAVE_PATCH_IN
  /* Generate the single patch-in header for this executor as a
     global asm statement.  This expands into a global definition in
     assembly in a separate subsection, and relies on toplevel C
     definitions not being reordered: jitterlispvm_execute_or_initialize
     will add to the same global.  Do the same for defects. */
  JITTER_PATCH_IN_HEADER(jitterlispvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT

  /* The same for defects... */
  JITTER_DEFECT_HEADER(jitterlispvm);
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

#ifndef JITTER_DISPATCH_SWITCH
  JITTER_DATA_LOCATION_HEADER(jitterlispvm);
#endif // #ifndef JITTER_DISPATCH_SWITCH

}
static enum jitterlispvm_exit_status
jitterlispvm_execute_or_initialize (bool jitter_initialize,
                                struct jitterlispvm_state * const jitter_original_state)
{
/* Undefine the state field access macros which are meant to be
   used out of VM instructions. */
#undef JITTERLISPVM_STATE_RUNTIME_FIELD
#undef JITTERLISPVM_STATE_BACKING_FIELD

/* Replace the definitions by versions which will work (only!)
   inside instruction bodies.  These macros have one argument
   instead of two: the VM state being used is *the* current
   state. */
#define JITTERLISPVM_STATE_RUNTIME_FIELD  _JITTER_STATE_RUNTIME_FIELD
#define JITTERLISPVM_STATE_BACKING_FIELD  _JITTER_STATE_BACKING_FIELD

#ifdef JITTER_DISPATCH_NO_THREADING
  /* Save the values in the registers we reserved as global variables,
     since from the point of view of the other C compilation units such
     registers are callee-save.  FIXME: this is not really needed when
     initializing, if I've been careful; but for the time being I want
     to play it safe. */
  union jitter_word jitter_register_buffer [JITTERLISPVM_REGISTER_BUFFER_ELEMENT_NO];
  jitterlispvm_save_registers (jitter_register_buffer);
#endif // #ifdef JITTER_DISPATCH_NO_THREADING

  /* Initialization.  This is only called once at startup. */
  if (__builtin_expect (jitter_initialize, false))
    {
      /* Make sure that vm1 and vm2 were macroexpanded consistently
         with respect to instrumentation macros.  This relies on the
         enum values for each feature working as individual bits in a
         bitmask: see the comment in jitter/jitter-vm.h . */
      enum jitter_vm_instrumentation correct_instrumentation
        = jitter_vm_instrumentation_none;
#if defined (JITTERLISPVM_PROFILE_COUNT)
      correct_instrumentation |= jitter_vm_instrumentation_count;
#endif
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
      correct_instrumentation |= jitter_vm_instrumentation_sample;
#endif
      if (jitterlispvm_vm_configuration->instrumentation != correct_instrumentation)
        jitter_fatal ("vm1 and vm2 were compiled with different profiling "
                      "instrumentation macros.  Please recompile with coherent "
                      "CPPFLAGS");

#if defined (JITTERLISPVM_PROFILE_SAMPLE)
    /* Initialise the sample-profile subsystem, once and for all. */
    jitterlispvm_profile_sample_initialize ();
#endif // #if defined (JITTERLISPVM_PROFILE_SAMPLE)

#ifndef JITTER_DISPATCH_SWITCH
      /* FIXME: I can do this with only one relocation, by keeping
         a pointer to the first VM instruction beginning in a static
         variable, and then having a static vector of offsets with
         respect to the first pointer.  This will slightly complicate
         my initialization code, but should make startup faster.
         FIXME: that won't work on AVR, according to the GCC
         documentation.  Do I care?  Probably not, since AVRs can't
         address more than 2^16 bytes, which is too little to run my
         VMs. */
      static const jitter_thread jitterlispvm_the_threads []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_ePRETENDTOJUMPANYWHERE),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(at_mdepth_mto_mregister__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(at_mdepth_mto_mregister__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(at_mdepth_mto_mregister__n3___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(at_mdepth_mto_mregister__n4___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(at_mdepth_mto_mregister__n5___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(at_mdepth_mto_mregister__n6___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(at_mdepth_mto_mregister__n7___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(at_mdepth_mto_mregister__n8___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(at_mdepth_mto_mregister__n9___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(at_mdepth_mto_mregister__n10___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(at_mdepth_mto_mregister__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mfalse__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mnon_mpositive__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mnot_mless__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mnot_mnull__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mnull__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mpositive__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mregister_mnon_mpositive___rrR__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mregister_mnon_mzero___rrR__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mregister_mnot_mnull___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mregister_mnull___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mregister_mpositive___rrR__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(branch_mif_mtrue__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__n0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__n1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__n2__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__n3__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__n4__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__n5__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__n6__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__n7__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__n8__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__n9__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__n10__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__n0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__n1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__n2__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__n3__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__n4__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__n5__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__n6__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__n7__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__n8__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__n9__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__n10__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mcompiled__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(call_mfrom_mc__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(canonicalize_mboolean),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(cdr_mregister___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_mclosure__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_mglobal_mdefined__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__n4__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__n5__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__n6__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__n8__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__n9__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__n10__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__n4__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__n5__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__n6__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__n8__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__n9__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__n10__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(check_min_marity_m_malt__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mfrom_mliteral__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mfrom_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(copy_mto_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(drop_mnip),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(dup),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(fail__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(gc_mif_mneeded__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(heap_mallocate__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(heap_mallocate__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(heap_mallocate__n12),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(heap_mallocate__n16),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(heap_mallocate__n24),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(heap_mallocate__n32),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(heap_mallocate__n36),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(heap_mallocate__n48),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(heap_mallocate__n52),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(heap_mallocate__n64),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(heap_mallocate__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(literal_mto_mregister__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_mfive),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_mfive_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_mfour),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_mfour_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_mpush_mliteral__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_mpush_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_msix),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_msix_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_mthree),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_mthree_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_mtwo),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nip_mtwo_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(nop),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(one_mminus_mregister___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(one_mplus_mregister___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mto_mglobal__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mto_mglobal_mdefined__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(pop_mto_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive__nR__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive__nR__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive__nR__n4__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mboolean_mcanonicalize),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mbox),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mbox_mget__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mbox_msetb_mspecial__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mcar__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mcdr__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mcharacterp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mcons_mspecial),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mconsp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_meqp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mfixnum_meqp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mfixnum_mnot_meqp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mfixnump),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mgreaterp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mlessp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnegate__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnegativep__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnon_mconsp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnon_mnegativep__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnon_mnullp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnon_mpositivep__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnon_msymbolp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnon_mzerop__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnot),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnot_meqp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnot_mgreaterp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnot_mlessp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnothingp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mnullp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mone_mminus__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mone_mplus__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mpositivep__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mprimordial_mdivided__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mprimordial_mdivided_munsafe__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mprimordial_mminus__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mprimordial_mplus__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mprimordial_mtimes__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mquotient__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mquotient_munsafe__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mremainder__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mremainder_munsafe__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mset_mcarb_mspecial__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mset_mcdrb_mspecial__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_msymbolp),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mtwo_mdivided__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mtwo_mquotient__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mtwo_mremainder__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mtwo_mtimes__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_muniquep),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(primitive_mzerop__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(procedure_mprolog),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mfalse),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mglobal__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mliteral__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mnil),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mnothing),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mone),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_munspecified),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(push_mzero),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(register_mto_mregister___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(restore_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(return),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(save_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__n0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__n1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__n2__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__n3__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__n4__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__n5__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__n6__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__n7__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__n8__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__n9__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__n10__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__n0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__n1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__n2__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__n3__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__n4__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__n5__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__n6__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__n7__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__n8__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__n9__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__n10__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(tail_mcall_mcompiled__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(unreachable),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mfalse__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnon_mpositive__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnot_mless__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnot_mnull__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnull__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mpositive__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mpositive___rrR__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mzero___rrR__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnot_mnull___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnull___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mpositive___rrR__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mbranch_mif_mtrue__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__n3__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__n4__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__n5__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__n6__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__n7__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__n8__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__n9__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__n10__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n3__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n4__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n5__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n6__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n7__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n8__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n9__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n10__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcall_mfrom_mc__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcdr_mregister___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_mclosure__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_mglobal_mdefined__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n2__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n4__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n5__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n6__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n8__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n9__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n10__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n2__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n4__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n5__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n6__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n8__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n9__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n10__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mexitvm__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mgc_mif_mneeded__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mone_mminus_mregister___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mone_mplus_mregister___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mpop_mto_mglobal__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mpop_mto_mglobal_mdefined__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n2__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n4__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mbox_mget__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mbox_msetb_mspecial__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mcar__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mcdr__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mfixnum_meqp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mfixnum_mnot_meqp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mgreaterp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mlessp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mnegate__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mnegativep__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mnon_mnegativep__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mnon_mpositivep__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mnon_mzerop__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mnot_mgreaterp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mnot_mlessp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mone_mminus__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mone_mplus__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mpositivep__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided_munsafe__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mminus__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mplus__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mtimes__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mquotient__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mquotient_munsafe__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mremainder__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mremainder_munsafe__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mset_mcarb_mspecial__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mset_mcdrb_mspecial__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mdivided__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mquotient__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mremainder__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mtimes__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprimitive_mzerop__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mprocedure_mprolog__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mpush_mglobal__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mreturn__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__n3__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__n4__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__n5__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__n6__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__n7__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__n8__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__n9__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__n10__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n3__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n4__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n5__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n6__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n7__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n8__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n9__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n10__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_BEGIN_LABEL_OF(_eREPLACEMENT_munreachable__retR),
                0)
          };
      static const jitter_thread jitterlispvm_the_thread_ends []
        = {
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eINVALID),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eBEGINBASICBLOCK),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eEXITVM),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eDATALOCATIONS),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eNOP),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE0),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eUNREACHABLE1),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_ePRETENDTOJUMPANYWHERE),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(at_mdepth_mto_mregister__n1___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(at_mdepth_mto_mregister__n2___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(at_mdepth_mto_mregister__n3___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(at_mdepth_mto_mregister__n4___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(at_mdepth_mto_mregister__n5___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(at_mdepth_mto_mregister__n6___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(at_mdepth_mto_mregister__n7___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(at_mdepth_mto_mregister__n8___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(at_mdepth_mto_mregister__n9___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(at_mdepth_mto_mregister__n10___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(at_mdepth_mto_mregister__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mfalse__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mnon_mpositive__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mnot_mless__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mnot_mnull__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mnull__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mpositive__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mregister_mnon_mpositive___rrR__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mregister_mnon_mzero___rrR__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mregister_mnot_mnull___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mregister_mnull___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mregister_mpositive___rrR__fR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(branch_mif_mtrue__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__n0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__n1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__n2__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__n3__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__n4__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__n5__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__n6__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__n7__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__n8__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__n9__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__n10__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__n0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__n1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__n2__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__n3__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__n4__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__n5__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__n6__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__n7__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__n8__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__n9__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__n10__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mcompiled__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(call_mfrom_mc__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(canonicalize_mboolean),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(cdr_mregister___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_mclosure__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_mglobal_mdefined__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__n4__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__n5__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__n6__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__n8__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__n9__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__n10__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__n4__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__n5__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__n6__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__n7__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__n8__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__n9__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__n10__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(check_min_marity_m_malt__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mfrom_mliteral__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mfrom_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(copy_mto_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(drop_mnip),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(dup),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(exitvm),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(fail__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(gc_mif_mneeded__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(heap_mallocate__n4),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(heap_mallocate__n8),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(heap_mallocate__n12),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(heap_mallocate__n16),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(heap_mallocate__n24),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(heap_mallocate__n32),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(heap_mallocate__n36),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(heap_mallocate__n48),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(heap_mallocate__n52),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(heap_mallocate__n64),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(heap_mallocate__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(literal_mto_mregister__nR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_mfive),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_mfive_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_mfour),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_mfour_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_mpush_mliteral__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_mpush_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_msix),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_msix_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_mthree),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_mthree_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_mtwo),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nip_mtwo_mdrop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(nop),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(one_mminus_mregister___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(one_mplus_mregister___rrR___rrR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mto_mglobal__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mto_mglobal_mdefined__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(pop_mto_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive__nR__n0__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive__nR__n1__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive__nR__n2__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive__nR__n3__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive__nR__n4__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive__nR__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mboolean_mcanonicalize),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mbox),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mbox_mget__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mbox_msetb_mspecial__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mcar__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mcdr__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mcharacterp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mcons_mspecial),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mconsp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_meqp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mfixnum_meqp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mfixnum_mnot_meqp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mfixnump),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mgreaterp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mlessp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnegate__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnegativep__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnon_mconsp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnon_mnegativep__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnon_mnullp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnon_mpositivep__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnon_msymbolp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnon_mzerop__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnot),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnot_meqp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnot_mgreaterp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnot_mlessp__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnothingp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mnullp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mone_mminus__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mone_mplus__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mpositivep__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mprimordial_mdivided__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mprimordial_mdivided_munsafe__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mprimordial_mminus__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mprimordial_mplus__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mprimordial_mtimes__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mquotient__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mquotient_munsafe__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mremainder__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mremainder_munsafe__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mset_mcarb_mspecial__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mset_mcdrb_mspecial__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_msymbolp),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mtwo_mdivided__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mtwo_mquotient__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mtwo_mremainder__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mtwo_mtimes__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_muniquep),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(primitive_mzerop__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(procedure_mprolog),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mfalse),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mglobal__nR__fR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mliteral__nR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mnil),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mnothing),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mone),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_munspecified),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(push_mzero),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(register_mto_mregister___rrR___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(restore_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(return),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(save_mregister___rrR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__n0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__n1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__n2__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__n3__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__n4__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__n5__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__n6__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__n7__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__n8__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__n9__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__n10__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__n0__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__n1__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__n2__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__n3__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__n4__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__n5__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__n6__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__n7__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__n8__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__n9__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__n10__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(tail_mcall_mcompiled__nR__retR),
            && JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(unreachable),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mfalse__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnon_mpositive__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnot_mless__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnot_mnull__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnull__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mpositive__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mpositive___rrR__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mzero___rrR__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnot_mnull___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnull___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mpositive___rrR__fR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mbranch_mif_mtrue__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__n3__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__n4__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__n5__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__n6__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__n7__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__n8__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__n9__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__n10__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n3__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n4__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n5__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n6__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n7__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n8__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n9__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n10__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcall_mfrom_mc__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcdr_mregister___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_mclosure__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_mglobal_mdefined__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n2__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n4__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n5__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n6__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n8__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n9__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n10__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n2__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n4__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n5__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n6__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n7__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n8__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n9__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n10__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mexitvm__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mgc_mif_mneeded__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mone_mminus_mregister___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mone_mplus_mregister___rrR___rrR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mpop_mto_mglobal__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mpop_mto_mglobal_mdefined__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n0__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n1__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n2__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n3__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n4__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive__nR__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mbox_mget__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mbox_msetb_mspecial__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mcar__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mcdr__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mfixnum_meqp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mfixnum_mnot_meqp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mgreaterp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mlessp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mnegate__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mnegativep__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mnon_mnegativep__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mnon_mpositivep__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mnon_mzerop__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mnot_mgreaterp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mnot_mlessp__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mone_mminus__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mone_mplus__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mpositivep__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided_munsafe__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mminus__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mplus__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mtimes__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mquotient__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mquotient_munsafe__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mremainder__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mremainder_munsafe__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mset_mcarb_mspecial__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mset_mcdrb_mspecial__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mdivided__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mquotient__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mremainder__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mtimes__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprimitive_mzerop__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mprocedure_mprolog__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mpush_mglobal__nR__fR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mreturn__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__n3__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__n4__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__n5__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__n6__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__n7__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__n8__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__n9__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__n10__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n0__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n1__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n2__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n3__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n4__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n5__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n6__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n7__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n8__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n9__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n10__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__nR__retR),
                0),
            JITTER_IF2_DEFECT_
               (&& JITTER_SPECIALIZED_INSTRUCTION_END_LABEL_OF(_eREPLACEMENT_munreachable__retR),
                0)
          };
      /* A few non-GCC compilers such as TCC support GNU C's labels
         as values, but do not recognise their differences as
         *constant* expressions.  Compute the difference at
         initialisation then. */
      static long
      jitterlispvm_the_thread_sizes [JITTERLISPVM_SPECIALIZED_INSTRUCTION_NO];
      int i;
      for (i = 0; i < JITTERLISPVM_SPECIALIZED_INSTRUCTION_NO; i ++)
        jitterlispvm_the_thread_sizes [i]
          = jitterlispvm_the_thread_ends [i] - jitterlispvm_the_threads [i];
      jitterlispvm_thread_sizes
        = (const long *) jitterlispvm_the_thread_sizes;
      jitterlispvm_threads = jitterlispvm_the_threads;
      jitterlispvm_thread_ends = jitterlispvm_the_thread_ends;

#ifdef JITTER_HAVE_DEFECT_REPLACEMENT
      /* Define the correct distance between the fake target in C
         and in assembly, for this VM. */
      JITTER_DEFECT_CORRECT_DISPLACEMENT_NAME (jitterlispvm)
        = ((char *) && jitter_fake_target
           - (char *) jitterlispvm_fake_target_asm);
      //fprintf (stderr, "DEBUG: INITIALISE CORRECT DISPLACEMENT TO %li\n", (long) JITTER_DEFECT_CORRECT_DISPLACEMENT_NAME (jitterlispvm));
#endif // #ifdef JITTER_HAVE_DEFECT_REPLACEMENT

#endif // #ifndef JITTER_DISPATCH_SWITCH

      /* Back to regular C, without our reserved registers if any; I can share
         the end code with the non-initialization case. */
#ifdef JITTER_HAVE_PATCH_IN
      //JITTER_DUMP_PATCH_IN_DESCRIPTORS(jitterlispvm);
#endif // #ifdef JITTER_HAVE_PATCH_IN
      goto jitter_possibly_restore_registers_and_return_label;
    }


  /* Before setting up runtime structures and jumping to the first
     instruction check that the last exit status was correct, and
     update it for the present run. */
  switch (_JITTER_STATE_BACKING_FIELD (exit_status))
    {
    case jitterlispvm_exit_status_never_executed:
    case jitterlispvm_exit_status_exited:
    case jitterlispvm_exit_status_debug:
      /* This is normal and expected. */
      _JITTER_STATE_BACKING_FIELD (exit_status)
        = jitterlispvm_exit_status_being_executed;
      break;

    case jitterlispvm_exit_status_being_executed:
      jitter_fatal ("the exit status before execution is "
                    "jitterlispvm_exit_status_being_executed: "
                    "you may have exited the last evaluation "
                    "through longjmp, or reused the same VM "
                    "state for a new execution with a previous "
                    "execution still in progress.");

    default:
      jitter_fatal ("invalid exit state %i",
                    (int) _JITTER_STATE_BACKING_FIELD (exit_status));
    }

  /* Here is the actual *executor* initialization, to be run before
     actually running the code. */

/* Selectively suppress suprious -Wmaybe-uninitialized .
   The indirect jump hack I use in profiling mode in order to
   have a large gap inside a function introduced by assembler without
   being restricted by jump offset limits (intentionally) tricks GCC
   into believing that the indirect jump may reach any instruction label;
   GCC would then warn that some locals might be used uninitialized,
   by skipping over their initialization.  This however is not possible,
   and I want to selectively silence the warning for the variables in
   question. */
//#pragma GCC diagnostic push
//#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"

  /* Wrap functions and globals used within VM instructions, if needed.
     This is a trick to keep instructions readable while avoiding PC-relative
     addressing, which would mess up replicated code. */
#ifdef JITTER_REPLICATE

  /* Protect the C globals used in VM instructions so that they are always
     referred thru a pointer (from a register or the stack) set in the
     non-replicated part.  This is necessary on architectures where I can't
     force global references to pass thru a GOT.
     [FIXME: possibly don't do this on architectures that don't need it.] */

  typeof (jitterlispvm_states) * volatile _my_volatile_pointer_to_jitterlispvm_states = & jitterlispvm_states;
  typeof (jitterlispvm_states) * const restrict _my_pointer_to_jitterlispvm_states __attribute__ ((unused))
     = _my_volatile_pointer_to_jitterlispvm_states;
# undef jitterlispvm_states
# define jitterlispvm_states (* _my_pointer_to_jitterlispvm_states)

  typeof (stack_printf_format_string) * volatile _my_volatile_pointer_to_stack_printf_format_string = & stack_printf_format_string;
  typeof (stack_printf_format_string) * const restrict _my_pointer_to_stack_printf_format_string __attribute__ ((unused))
     = _my_volatile_pointer_to_stack_printf_format_string;
# undef stack_printf_format_string
# define stack_printf_format_string (* _my_pointer_to_stack_printf_format_string)

  /* Similarly, wrap the C functions used in VM instructions, so that they are
     always called thru a function pointer.  This is necessary on architectures
     where call instructions represent the callee as a PC-relative address.
     Unfortunately C has a special quirky syntax for function pointers, so I
     can't just use the code above.  [FIXME: don't do this on architectures
     that don't need it.] */
  typeof (jitterlispvm_error_invalid_primitive_argument_type_friendly) * volatile _jitter_my_volatile_pointer_to_jitterlispvm_error_invalid_primitive_argument_type_friendly = & jitterlispvm_error_invalid_primitive_argument_type_friendly;
  typeof (jitterlispvm_error_invalid_primitive_argument_type_friendly) * const _jitter_my_jitterlispvm_error_invalid_primitive_argument_type_friendly __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_jitterlispvm_error_invalid_primitive_argument_type_friendly;
# undef jitterlispvm_error_invalid_primitive_argument_type_friendly
# define jitterlispvm_error_invalid_primitive_argument_type_friendly(...)  \
  JITTER_CALL_C (_jitter_my_jitterlispvm_error_invalid_primitive_argument_type_friendly, __VA_ARGS__)
  typeof (jitterlispvm_error_invalid_primitive_argument_type_unfriendly) * volatile _jitter_my_volatile_pointer_to_jitterlispvm_error_invalid_primitive_argument_type_unfriendly = & jitterlispvm_error_invalid_primitive_argument_type_unfriendly;
  typeof (jitterlispvm_error_invalid_primitive_argument_type_unfriendly) * const _jitter_my_jitterlispvm_error_invalid_primitive_argument_type_unfriendly __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_jitterlispvm_error_invalid_primitive_argument_type_unfriendly;
# undef jitterlispvm_error_invalid_primitive_argument_type_unfriendly
# define jitterlispvm_error_invalid_primitive_argument_type_unfriendly(...)  \
  JITTER_CALL_C (_jitter_my_jitterlispvm_error_invalid_primitive_argument_type_unfriendly, __VA_ARGS__)
  typeof (jitterlisp_fail_from_vm) * volatile _jitter_my_volatile_pointer_to_jitterlisp_fail_from_vm = & jitterlisp_fail_from_vm;
  typeof (jitterlisp_fail_from_vm) * const _jitter_my_jitterlisp_fail_from_vm __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_jitterlisp_fail_from_vm;
# undef jitterlisp_fail_from_vm
# define jitterlisp_fail_from_vm(...)  \
  JITTER_CALL_C (_jitter_my_jitterlisp_fail_from_vm, __VA_ARGS__)
  typeof (jitterlisp_allocate) * volatile _jitter_my_volatile_pointer_to_jitterlisp_allocate = & jitterlisp_allocate;
  typeof (jitterlisp_allocate) * const _jitter_my_jitterlisp_allocate __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_jitterlisp_allocate;
# undef jitterlisp_allocate
# define jitterlisp_allocate(...)  \
  JITTER_CALL_C (_jitter_my_jitterlisp_allocate, __VA_ARGS__)
  typeof (jitterlisp_call_interpreted) * volatile _jitter_my_volatile_pointer_to_jitterlisp_call_interpreted = & jitterlisp_call_interpreted;
  typeof (jitterlisp_call_interpreted) * const _jitter_my_jitterlisp_call_interpreted __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_jitterlisp_call_interpreted;
# undef jitterlisp_call_interpreted
# define jitterlisp_call_interpreted(...)  \
  JITTER_CALL_C (_jitter_my_jitterlisp_call_interpreted, __VA_ARGS__)
  typeof (jitterlisp_print) * volatile _jitter_my_volatile_pointer_to_jitterlisp_print = & jitterlisp_print;
  typeof (jitterlisp_print) * const _jitter_my_jitterlisp_print __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_jitterlisp_print;
# undef jitterlisp_print
# define jitterlisp_print(...)  \
  JITTER_CALL_C (_jitter_my_jitterlisp_print, __VA_ARGS__)
  typeof (debug_pointer) * volatile _jitter_my_volatile_pointer_to_debug_pointer = & debug_pointer;
  typeof (debug_pointer) * const _jitter_my_debug_pointer __attribute__ ((unused))
     = * _jitter_my_volatile_pointer_to_debug_pointer;
# undef debug_pointer
# define debug_pointer(...)  \
  JITTER_CALL_C (_jitter_my_debug_pointer, __VA_ARGS__)
/* See the comment above about spurious -Wmaybe-uninitialized warnings. */
//#pragma GCC diagnostic pop
#endif // #ifdef JITTER_REPLICATE


  /* Make an automatic struct holding a copy of the state whose pointer was given.
     The idea is that the copy should be in registers, as far as possible. */
  struct jitterlispvm_state_runtime jitter_state_runtime
    = jitter_original_state->_jitterlispvm_1TbNcL3hel_state_runtime;

  /* Initialize a pointer to The Array base.  This pointer will be in a
     global register variable with no-threading dispatch, and with
     other dispatches in an automatic variable, still hopefully kept
     in a register. */
/* About the pragma, look for "-Wmaybe-uninitialized" in the comments above. FIXME: this is to avoid a GCC warning with profiling.  Check with profiling on. */
//#pragma GCC diagnostic push
//#pragma GCC diagnostic ignored "-Wmaybe-uninitialized"
#ifdef JITTER_DISPATCH_NO_THREADING
# define jitter_array_base jitterlispvm_array_base_register_variable
#else
  char * restrict jitter_array_base __attribute__ ((unused));
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
//#pragma GCC diagnostic pop
  jitter_array_base
    = (((char *) jitter_original_state->jitterlispvm_state_backing.jitter_array)
       + JITTER_ARRAY_BIAS);

  /* Declare the instruction pointer from the thread array, unless the dispatch
     is no-threading, in which case no thread array even exists. */
  jitterlispvm_program_point jitter_ip = NULL; /* Invalidate to catch errors. */
#ifdef JITTER_REPLICATE
  /* Save an instruction address within this function, to jump to at VM exit
     time; that way we can be sure that at exit time we are back to
     non-replicated code, and stuff like PC-relative addressing work again
     without special tricks.  This variable may safely (and actually should,
     for performance) be kept on the stack.  We need it to be volatile to
     prevent the compiler from being too clever and jump to it using a
     PC-relative displacement from replicated code.   It must not be static,
     since non-automatic variables are problematic to access from replicated
     code, which might use PC-relative addressing. */
  volatile typeof (&& jitter_exit_vm_label) restrict
  jitter_saved_exit_non_replicated_code_pointer = &&jitter_exit_vm_label;
  JITTER_MARK_MEMORY_AS_SET_BY_ASSEMBLY(jitter_saved_exit_non_replicated_code_pointer);
#endif // #ifdef JITTER_REPLICATE


#ifdef JITTER_REPLICATE
  /* FIXME: comment. */
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(fail__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(fail__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(fail__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(fail__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mfalse__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mfalse__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mfalse__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mfalse__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnon_mpositive__fR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnon_mpositive__fR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnon_mpositive__fR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnon_mpositive__fR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnot_mless__fR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnot_mless__fR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnot_mless__fR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnot_mless__fR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnot_mnull__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnot_mnull__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnot_mnull__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnot_mnull__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnull__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mnull__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnull__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mnull__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mpositive__fR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mpositive__fR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mpositive__fR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mpositive__fR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mpositive___rrR__fR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mpositive___rrR__fR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mpositive___rrR__fR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mpositive___rrR__fR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mzero___rrR__fR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mzero___rrR__fR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mzero___rrR__fR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnon_mzero___rrR__fR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnot_mnull___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnot_mnull___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnot_mnull___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnot_mnull___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnull___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mnull___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnull___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mnull___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mpositive___rrR__fR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mregister_mpositive___rrR__fR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mpositive___rrR__fR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mregister_mpositive___rrR__fR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mtrue__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mbranch_mif_mtrue__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mtrue__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mbranch_mif_mtrue__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__n0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__n1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n2__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__n2__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n2__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n2__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n3__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__n3__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n3__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n3__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n4__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__n4__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n4__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n4__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n5__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__n5__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n5__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n5__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n6__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__n6__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n6__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n6__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n7__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__n7__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n7__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n7__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n8__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__n8__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n8__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n8__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n9__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__n9__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n9__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n9__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n10__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__n10__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n10__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__n10__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n2__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n2__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n2__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n2__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n3__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n3__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n3__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n3__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n4__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n4__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n4__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n4__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n5__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n5__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n5__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n5__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n6__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n6__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n6__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n6__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n7__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n7__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n7__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n7__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n8__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n8__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n8__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n8__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n9__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n9__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n9__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n9__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n10__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__n10__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n10__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__n10__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mcompiled__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mcompiled__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mfrom_mc__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcall_mfrom_mc__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mfrom_mc__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcall_mfrom_mc__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcdr_mregister___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcdr_mregister___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcdr_mregister___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcdr_mregister___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_mclosure__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_mclosure__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_mclosure__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_mclosure__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_mglobal_mdefined__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_mglobal_mdefined__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_mglobal_mdefined__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_mglobal_mdefined__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n2__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n2__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n2__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n2__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n3__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n3__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n3__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n3__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n4__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n4__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n4__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n4__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n5__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n5__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n5__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n5__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n6__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n6__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n6__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n6__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n7__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n7__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n7__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n7__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n8__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n8__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n8__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n8__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n9__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n9__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n9__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n9__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n10__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__n10__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n10__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__n10__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n2__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n2__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n2__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n2__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n3__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n3__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n3__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n3__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n4__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n4__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n4__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n4__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n5__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n5__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n5__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n5__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n6__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n6__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n6__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n6__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n7__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n7__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n7__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n7__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n8__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n8__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n8__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n8__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n9__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n9__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n9__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n9__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n10__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n10__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n10__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__n10__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mcheck_min_marity_m_malt__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mexitvm__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mexitvm__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mgc_mif_mneeded__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mgc_mif_mneeded__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mgc_mif_mneeded__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mgc_mif_mneeded__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mone_mminus_mregister___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mone_mminus_mregister___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mone_mminus_mregister___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mone_mminus_mregister___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mone_mplus_mregister___rrR___rrR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mone_mplus_mregister___rrR___rrR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mone_mplus_mregister___rrR___rrR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mone_mplus_mregister___rrR___rrR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpop_mto_mglobal__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mpop_mto_mglobal__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpop_mto_mglobal__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpop_mto_mglobal__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpop_mto_mglobal_mdefined__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mpop_mto_mglobal_mdefined__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpop_mto_mglobal_mdefined__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpop_mto_mglobal_mdefined__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n0__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n0__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n0__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n0__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n1__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n1__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n1__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n1__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n2__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n2__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n2__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n2__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n3__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n3__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n3__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n3__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n4__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive__nR__n4__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n4__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__n4__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive__nR__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive__nR__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mbox_mget__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mbox_mget__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mbox_mget__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mbox_mget__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mbox_msetb_mspecial__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mbox_msetb_mspecial__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mbox_msetb_mspecial__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mbox_msetb_mspecial__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mcar__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mcar__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mcar__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mcar__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mcdr__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mcdr__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mcdr__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mcdr__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mfixnum_meqp__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mfixnum_meqp__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mfixnum_meqp__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mfixnum_meqp__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mfixnum_mnot_meqp__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mfixnum_mnot_meqp__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mfixnum_mnot_meqp__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mfixnum_mnot_meqp__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mgreaterp__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mgreaterp__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mgreaterp__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mgreaterp__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mlessp__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mlessp__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mlessp__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mlessp__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnegate__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mnegate__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnegate__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnegate__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnegativep__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mnegativep__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnegativep__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnegativep__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnon_mnegativep__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mnon_mnegativep__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnon_mnegativep__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnon_mnegativep__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnon_mpositivep__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mnon_mpositivep__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnon_mpositivep__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnon_mpositivep__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnon_mzerop__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mnon_mzerop__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnon_mzerop__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnon_mzerop__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnot_mgreaterp__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mnot_mgreaterp__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnot_mgreaterp__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnot_mgreaterp__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnot_mlessp__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mnot_mlessp__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnot_mlessp__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mnot_mlessp__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mone_mminus__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mone_mminus__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mone_mminus__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mone_mminus__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mone_mplus__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mone_mplus__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mone_mplus__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mone_mplus__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mpositivep__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mpositivep__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mpositivep__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mpositivep__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided_munsafe__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided_munsafe__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided_munsafe__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mdivided_munsafe__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mminus__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mminus__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mminus__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mminus__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mplus__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mplus__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mplus__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mplus__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mtimes__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mprimordial_mtimes__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mtimes__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mprimordial_mtimes__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mquotient__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mquotient__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mquotient__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mquotient__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mquotient_munsafe__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mquotient_munsafe__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mquotient_munsafe__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mquotient_munsafe__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mremainder__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mremainder__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mremainder__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mremainder__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mremainder_munsafe__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mremainder_munsafe__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mremainder_munsafe__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mremainder_munsafe__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mset_mcarb_mspecial__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mset_mcarb_mspecial__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mset_mcarb_mspecial__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mset_mcarb_mspecial__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mset_mcdrb_mspecial__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mset_mcdrb_mspecial__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mset_mcdrb_mspecial__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mset_mcdrb_mspecial__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mdivided__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mdivided__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mdivided__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mdivided__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mquotient__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mquotient__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mquotient__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mquotient__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mremainder__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mremainder__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mremainder__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mremainder__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mtimes__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mtwo_mtimes__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mtimes__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mtwo_mtimes__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mzerop__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprimitive_mzerop__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mzerop__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprimitive_mzerop__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedure_mprolog__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mprocedure_mprolog__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedure_mprolog__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mprocedure_mprolog__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpush_mglobal__nR__fR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mpush_mglobal__nR__fR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpush_mglobal__nR__fR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mpush_mglobal__nR__fR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreturn__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mreturn__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreturn__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mreturn__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__n0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__n1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n2__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__n2__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n2__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n2__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n3__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__n3__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n3__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n3__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n4__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__n4__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n4__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n4__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n5__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__n5__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n5__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n5__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n6__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__n6__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n6__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n6__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n7__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__n7__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n7__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n7__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n8__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__n8__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n8__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n8__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n9__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__n9__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n9__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n9__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n10__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__n10__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n10__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__n10__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n0__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n0__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n0__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n0__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n1__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n1__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n1__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n1__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n2__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n2__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n2__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n2__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n3__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n3__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n3__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n3__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n4__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n4__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n4__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n4__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n5__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n5__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n5__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n5__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n6__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n6__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n6__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n6__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n7__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n7__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n7__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n7__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n8__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n8__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n8__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n8__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n9__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n9__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n9__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n9__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n10__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n10__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n10__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__n10__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__nR__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_mtail_mcall_mcompiled__nR__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__nR__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_mtail_mcall_mcompiled__nR__retR)));
  volatile void *JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)
    = && JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_LABEL_OF(_eREPLACEMENT_munreachable__retR);
  asm volatile ("#pretend to affect " JITTER_STRINGIFY(JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)) "\n"
                : "+m" (JITTER_SPECIALIZED_INSTRUCTION_NON_RELOCATABLE_CODE_VARIABLE_OF(_eREPLACEMENT_munreachable__retR)));
#endif // #ifdef JITTER_REPLICATE

  /* Initialization C code from the user */

    /* End of the initialization C code from the user */


# if defined(JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined(JITTER_DISPATCH_NO_THREADING)
  /* Execute architecture-specific execution-beginning code, if any.
     Make sure it is safe to expand the macro without do..while
     (false), since the expansion may contain declarations of
     variables to be used later. */
  {}; JITTER_EXECUTION_BEGINNING_; {};
  /* Declare a variable used in asm constraints on some architectures:
     see the comment in jitter-executor.h . */
  volatile long _jitter_useless_variable __attribute__ ((unused))
    = 0;
# endif

#if defined (JITTERLISPVM_PROFILE_SAMPLE)
    /* Start sample-profiling: this starts the periodic timer signal,
       whose handler will look at the current instruction field within
       the special-purpose struct in the Array. */
    jitterlispvm_profile_sample_start (JITTERLISPVM_OWN_STATE);
#endif // #if defined (JITTERLISPVM_PROFILE_SAMPLE)

  /* Jump to the first instruction.  If replication is enabled this point
     marks the boundary between the ordinary world of C compiled code and
     the more fragile replicated code, where PC-relative address does
     not work as intended (which prevents the use of global and static
     variables, string literals and possibly large literal constants), and
     GDB gets easily confused. */
  jitter_ip
    = jitter_original_state->jitterlispvm_state_backing.initial_program_point;

  /* This is the actual jump to the first instruction: it's not an
     inline asm constraint lie like below. */

# if   defined(JITTER_DISPATCH_SWITCH)
    goto jitter_dispatching_switch_label;
# elif (defined(JITTER_DISPATCH_DIRECT_THREADING)  \
        || defined(JITTER_DISPATCH_MINIMAL_THREADING))
    goto * (jitter_ip->label);
# elif defined(JITTER_DISPATCH_NO_THREADING)
    /* On no-threading we only use jitter_ip for the first instruction.
       Make it an alias for the base, which will be enough to satisfy
       inline assembly code which pretends to alter the instruction
       pointer in ways invisible to the compiler.
       At least in my tests this trick frees up one hardware register,
       which is not surprising. */
    goto * jitter_ip;
#   define jitter_ip jitterlispvm_array_base_register_variable
# else
#   error "unknown dispatch"
# endif // if ... dispatch
#ifdef JITTER_REPLICATE
  JITTER_PRETEND_TO_UPDATE_IP_;
  JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE();
  goto jitter_fake_target;
#endif // #ifdef JITTER_REPLICATE

#ifdef JITTER_DISPATCH_SWITCH
  /* This is the dispatching switch.  At the beginning of the first VM
     VM instruction and at the end of each other, control jumps here. */
 jitter_dispatching_switch_label:
  switch (jitter_ip->fixnum)
    {
#endif // #ifdef JITTER_DISPATCH_SWITCH

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!INVALID, _eINVALID, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  0
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !INVALID
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eINVALID
{

jitter_fatal ("reached the !INVALID instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!INVALID, _eINVALID, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, hot)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  1
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !BEGINBASICBLOCK
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eBEGINBASICBLOCK
{

#ifdef JITTER_DISPATCH_MINIMAL_THREADING
  JITTER_SET_IP (jitter_ip + 1);
#endif // #ifdef JITTER_DISPATCH_MINIMAL_THREADING

}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!BEGINBASICBLOCK, _eBEGINBASICBLOCK, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!EXITVM, _eEXITVM, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  2
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !EXITVM
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eEXITVM
{

_JITTER_EXIT();
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!EXITVM, _eEXITVM, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

JITTER_INSTRUCTION_PROLOG_(!DATALOCATIONS, _eDATALOCATIONS, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  3
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !DATALOCATIONS
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eDATALOCATIONS
{
#ifndef JITTER_DISPATCH_SWITCH
#ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("instruction pointer", jitter_ip);
#endif // #ifndef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("base", jitter_array_base);
#ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_SCRATCH_REGISTER
  JITTER_DATA_LOCATION_DATUM ("scratch", jitter_residual_argument_scratch_register_variable);
#endif // #ifdef JITTER_SCRATCH_REGISTER

#endif // #ifdef JITTER_DISPATCH_NO_THREADING
#ifdef JITTER_DISPATCH_NO_THREADING
#if (0 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 0", jitter_residual_argument_0_register_variable);
#endif // #if (0 < JITTER_RESIDUAL_REGISTER_NO)
#if (1 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 1", jitter_residual_argument_1_register_variable);
#endif // #if (1 < JITTER_RESIDUAL_REGISTER_NO)
#if (2 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 2", jitter_residual_argument_2_register_variable);
#endif // #if (2 < JITTER_RESIDUAL_REGISTER_NO)
#if (3 < JITTER_RESIDUAL_REGISTER_NO)
  JITTER_DATA_LOCATION_DATUM ("residual 3", jitter_residual_argument_3_register_variable);
#endif // #if (3 < JITTER_RESIDUAL_REGISTER_NO)
#endif // #ifdef JITTER_DISPATCH_NO_THREADING
  JITTER_DATA_LOCATION_DATUM ("link register", jitter_state_runtime._jitter_link);
  JITTER_DATA_LOCATION_DATUM ("mainstack top", 
     JITTER_STACK_TOS_TOP_NAME (whatever, jitter_state_runtime., mainstack));
  JITTER_DATA_LOCATION_DATUM ("mainstack undertop ptr", 
     JITTER_STACK_TOS_UNDER_TOP_POINTER_NAME (whatever, jitter_state_runtime., mainstack));
  JITTER_DATA_LOCATION_DATUM ("returnstack top ptr", 
     JITTER_STACK_NTOS_TOP_POINTER_NAME (whatever, jitter_state_runtime., returnstack));
#endif // #ifndef JITTER_DISPATCH_SWITCH
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!DATALOCATIONS, _eDATALOCATIONS, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!NOP, _eNOP, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  4
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !NOP
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eNOP
{

  /* Do nothing. */;
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!NOP, _eNOP, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE0, _eUNREACHABLE0, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  5
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE0
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE0
{

jitter_fatal ("reached the !UNREACHABLE0 instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE0, _eUNREACHABLE0, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!UNREACHABLE1, _eUNREACHABLE1, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  6
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !UNREACHABLE1
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _eUNREACHABLE1
{

jitter_fatal ("reached the !UNREACHABLE1 instruction");
}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!UNREACHABLE1, _eUNREACHABLE1, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

#  undef JITTER_COMPUTED_GOTO
#  define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
JITTER_INSTRUCTION_PROLOG_(!PRETENDTOJUMPANYWHERE, _ePRETENDTOJUMPANYWHERE, cold)
#define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#define JITTER_SPECIALIZED_INSTRUCTION_OPCODE  7
#define JITTER_SPECIALIZED_INSTRUCTION_NAME  !PRETENDTOJUMPANYWHERE
#define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME  _ePRETENDTOJUMPANYWHERE
jitter_fake_target: __attribute__ ((unused));{

#if ! defined(JITTER_DISPATCH_SWITCH)
  JITTER_PRETEND_TO_UPDATE_IP_;
  goto * jitter_ip;
#endif

}
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
JITTER_INSTRUCTION_EPILOG_(!PRETENDTOJUMPANYWHERE, _ePRETENDTOJUMPANYWHERE, 0)
#undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME
#undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

  /* Ordinary specialized instructions. */
  /* Ordinary specialised instruction at-depth-to-register/n1/%rR */
  JITTER_INSTRUCTION_PROLOG_(at-depth-to-register/n1/%rR, at_mdepth_mto_mregister__n1___rrR, cold)
  { /* This block begins with definitions for at-depth-to-register/n1/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       8
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         at-depth-to-register/n1/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "at-depth-to-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "at-depth-to-register/n1/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME at_mdepth_mto_mregister__n1___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of at-depth-to-register/n1/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "at-depth-to-register/n1/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for at-depth-to-register/n1/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    // FIXME: replace with JITTER_AT_DEPTH_UNSAFE_MAINSTACK after I implement
    // unsafe at-depth operations.
    JITTER_ARG1 = JITTER_AT_DEPTH_MAINSTACK(JITTER_ARGN0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for at-depth-to-register/n1/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "at-depth-to-register/n1/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the at-depth-to-register/n1/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(at-depth-to-register/n1/%rR, at_mdepth_mto_mregister__n1___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for at-depth-to-register/n1/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction at-depth-to-register/n2/%rR */
  JITTER_INSTRUCTION_PROLOG_(at-depth-to-register/n2/%rR, at_mdepth_mto_mregister__n2___rrR, cold)
  { /* This block begins with definitions for at-depth-to-register/n2/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       9
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         at-depth-to-register/n2/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "at-depth-to-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "at-depth-to-register/n2/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME at_mdepth_mto_mregister__n2___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 2L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of at-depth-to-register/n2/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "at-depth-to-register/n2/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for at-depth-to-register/n2/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    // FIXME: replace with JITTER_AT_DEPTH_UNSAFE_MAINSTACK after I implement
    // unsafe at-depth operations.
    JITTER_ARG1 = JITTER_AT_DEPTH_MAINSTACK(JITTER_ARGN0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for at-depth-to-register/n2/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "at-depth-to-register/n2/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the at-depth-to-register/n2/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(at-depth-to-register/n2/%rR, at_mdepth_mto_mregister__n2___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for at-depth-to-register/n2/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction at-depth-to-register/n3/%rR */
  JITTER_INSTRUCTION_PROLOG_(at-depth-to-register/n3/%rR, at_mdepth_mto_mregister__n3___rrR, cold)
  { /* This block begins with definitions for at-depth-to-register/n3/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       10
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         at-depth-to-register/n3/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "at-depth-to-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "at-depth-to-register/n3/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME at_mdepth_mto_mregister__n3___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 3L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of at-depth-to-register/n3/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "at-depth-to-register/n3/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for at-depth-to-register/n3/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    // FIXME: replace with JITTER_AT_DEPTH_UNSAFE_MAINSTACK after I implement
    // unsafe at-depth operations.
    JITTER_ARG1 = JITTER_AT_DEPTH_MAINSTACK(JITTER_ARGN0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for at-depth-to-register/n3/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "at-depth-to-register/n3/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the at-depth-to-register/n3/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(at-depth-to-register/n3/%rR, at_mdepth_mto_mregister__n3___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for at-depth-to-register/n3/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction at-depth-to-register/n4/%rR */
  JITTER_INSTRUCTION_PROLOG_(at-depth-to-register/n4/%rR, at_mdepth_mto_mregister__n4___rrR, cold)
  { /* This block begins with definitions for at-depth-to-register/n4/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       11
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         at-depth-to-register/n4/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "at-depth-to-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "at-depth-to-register/n4/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME at_mdepth_mto_mregister__n4___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 4L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of at-depth-to-register/n4/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "at-depth-to-register/n4/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for at-depth-to-register/n4/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    // FIXME: replace with JITTER_AT_DEPTH_UNSAFE_MAINSTACK after I implement
    // unsafe at-depth operations.
    JITTER_ARG1 = JITTER_AT_DEPTH_MAINSTACK(JITTER_ARGN0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for at-depth-to-register/n4/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "at-depth-to-register/n4/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the at-depth-to-register/n4/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(at-depth-to-register/n4/%rR, at_mdepth_mto_mregister__n4___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for at-depth-to-register/n4/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction at-depth-to-register/n5/%rR */
  JITTER_INSTRUCTION_PROLOG_(at-depth-to-register/n5/%rR, at_mdepth_mto_mregister__n5___rrR, cold)
  { /* This block begins with definitions for at-depth-to-register/n5/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       12
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         at-depth-to-register/n5/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "at-depth-to-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "at-depth-to-register/n5/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME at_mdepth_mto_mregister__n5___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 5L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of at-depth-to-register/n5/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "at-depth-to-register/n5/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for at-depth-to-register/n5/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    // FIXME: replace with JITTER_AT_DEPTH_UNSAFE_MAINSTACK after I implement
    // unsafe at-depth operations.
    JITTER_ARG1 = JITTER_AT_DEPTH_MAINSTACK(JITTER_ARGN0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for at-depth-to-register/n5/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "at-depth-to-register/n5/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the at-depth-to-register/n5/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(at-depth-to-register/n5/%rR, at_mdepth_mto_mregister__n5___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for at-depth-to-register/n5/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction at-depth-to-register/n6/%rR */
  JITTER_INSTRUCTION_PROLOG_(at-depth-to-register/n6/%rR, at_mdepth_mto_mregister__n6___rrR, cold)
  { /* This block begins with definitions for at-depth-to-register/n6/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       13
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         at-depth-to-register/n6/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "at-depth-to-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "at-depth-to-register/n6/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME at_mdepth_mto_mregister__n6___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 6L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of at-depth-to-register/n6/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "at-depth-to-register/n6/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for at-depth-to-register/n6/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    // FIXME: replace with JITTER_AT_DEPTH_UNSAFE_MAINSTACK after I implement
    // unsafe at-depth operations.
    JITTER_ARG1 = JITTER_AT_DEPTH_MAINSTACK(JITTER_ARGN0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for at-depth-to-register/n6/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "at-depth-to-register/n6/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the at-depth-to-register/n6/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(at-depth-to-register/n6/%rR, at_mdepth_mto_mregister__n6___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for at-depth-to-register/n6/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction at-depth-to-register/n7/%rR */
  JITTER_INSTRUCTION_PROLOG_(at-depth-to-register/n7/%rR, at_mdepth_mto_mregister__n7___rrR, cold)
  { /* This block begins with definitions for at-depth-to-register/n7/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       14
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         at-depth-to-register/n7/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "at-depth-to-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "at-depth-to-register/n7/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME at_mdepth_mto_mregister__n7___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 7L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of at-depth-to-register/n7/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "at-depth-to-register/n7/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for at-depth-to-register/n7/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    // FIXME: replace with JITTER_AT_DEPTH_UNSAFE_MAINSTACK after I implement
    // unsafe at-depth operations.
    JITTER_ARG1 = JITTER_AT_DEPTH_MAINSTACK(JITTER_ARGN0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for at-depth-to-register/n7/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "at-depth-to-register/n7/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the at-depth-to-register/n7/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(at-depth-to-register/n7/%rR, at_mdepth_mto_mregister__n7___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for at-depth-to-register/n7/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction at-depth-to-register/n8/%rR */
  JITTER_INSTRUCTION_PROLOG_(at-depth-to-register/n8/%rR, at_mdepth_mto_mregister__n8___rrR, cold)
  { /* This block begins with definitions for at-depth-to-register/n8/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       15
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         at-depth-to-register/n8/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "at-depth-to-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "at-depth-to-register/n8/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME at_mdepth_mto_mregister__n8___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 8L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of at-depth-to-register/n8/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "at-depth-to-register/n8/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for at-depth-to-register/n8/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    // FIXME: replace with JITTER_AT_DEPTH_UNSAFE_MAINSTACK after I implement
    // unsafe at-depth operations.
    JITTER_ARG1 = JITTER_AT_DEPTH_MAINSTACK(JITTER_ARGN0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for at-depth-to-register/n8/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "at-depth-to-register/n8/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the at-depth-to-register/n8/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(at-depth-to-register/n8/%rR, at_mdepth_mto_mregister__n8___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for at-depth-to-register/n8/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction at-depth-to-register/n9/%rR */
  JITTER_INSTRUCTION_PROLOG_(at-depth-to-register/n9/%rR, at_mdepth_mto_mregister__n9___rrR, cold)
  { /* This block begins with definitions for at-depth-to-register/n9/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       16
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         at-depth-to-register/n9/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "at-depth-to-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "at-depth-to-register/n9/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME at_mdepth_mto_mregister__n9___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 9L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of at-depth-to-register/n9/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "at-depth-to-register/n9/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for at-depth-to-register/n9/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    // FIXME: replace with JITTER_AT_DEPTH_UNSAFE_MAINSTACK after I implement
    // unsafe at-depth operations.
    JITTER_ARG1 = JITTER_AT_DEPTH_MAINSTACK(JITTER_ARGN0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for at-depth-to-register/n9/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "at-depth-to-register/n9/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the at-depth-to-register/n9/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(at-depth-to-register/n9/%rR, at_mdepth_mto_mregister__n9___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for at-depth-to-register/n9/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction at-depth-to-register/n10/%rR */
  JITTER_INSTRUCTION_PROLOG_(at-depth-to-register/n10/%rR, at_mdepth_mto_mregister__n10___rrR, cold)
  { /* This block begins with definitions for at-depth-to-register/n10/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       17
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         at-depth-to-register/n10/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "at-depth-to-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "at-depth-to-register/n10/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME at_mdepth_mto_mregister__n10___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 10L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of at-depth-to-register/n10/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "at-depth-to-register/n10/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for at-depth-to-register/n10/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    // FIXME: replace with JITTER_AT_DEPTH_UNSAFE_MAINSTACK after I implement
    // unsafe at-depth operations.
    JITTER_ARG1 = JITTER_AT_DEPTH_MAINSTACK(JITTER_ARGN0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for at-depth-to-register/n10/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "at-depth-to-register/n10/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the at-depth-to-register/n10/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(at-depth-to-register/n10/%rR, at_mdepth_mto_mregister__n10___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for at-depth-to-register/n10/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction at-depth-to-register/nR/%rR */
  JITTER_INSTRUCTION_PROLOG_(at-depth-to-register/nR/%rR, at_mdepth_mto_mregister__nR___rrR, cold)
  { /* This block begins with definitions for at-depth-to-register/nR/%rR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       18
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         at-depth-to-register/nR/%rR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "at-depth-to-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "at-depth-to-register/nR/%rR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME at_mdepth_mto_mregister__nR___rrR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of at-depth-to-register/nR/%rR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "at-depth-to-register/nR/%rR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for at-depth-to-register/nR/%rR . */
  {
/* User-specified code, user code block part: beginning. */

    // FIXME: replace with JITTER_AT_DEPTH_UNSAFE_MAINSTACK after I implement
    // unsafe at-depth operations.
    JITTER_ARG1 = JITTER_AT_DEPTH_MAINSTACK(JITTER_ARGN0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for at-depth-to-register/nR/%rR . */

  //fprintf (stderr, "..Executed instruction %s\n", "at-depth-to-register/nR/%rR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the at-depth-to-register/nR/%rR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(at-depth-to-register/nR/%rR, at_mdepth_mto_mregister__nR___rrR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for at-depth-to-register/nR/%rR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch/fR */
  JITTER_INSTRUCTION_PROLOG_(branch/fR, branch__fR, hot)
  { /* This block begins with definitions for branch/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       19
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST(JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch/fR, branch__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-false/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-false/fR, branch_mif_mfalse__fR, hot)
  { /* This block begins with definitions for branch-if-false/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       20
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-false/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-false"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-false/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mfalse__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-false/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-false/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-false/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-false/fR . */
  {
/* User-specified code, user code block part: beginning. */

    jitterlisp_object top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTERLISP_FALSE, JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-false/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-false/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-false/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-false/fR, branch_mif_mfalse__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-false/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-non-positive/fR/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-non-positive/fR/fR, branch_mif_mnon_mpositive__fR__fR, hot)
  { /* This block begins with definitions for branch-if-non-positive/fR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       21
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-non-positive/fR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-non-positive"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-non-positive/fR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mnon_mpositive__fR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-non-positive/fR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 1
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-non-positive/fR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-non-positive/fR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-non-positive/fR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTERLISPVM_CHECK_TYPES_1(FIXNUM, JITTER_ARGF1);
    jitterlisp_object top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_NONPOSITIVE(top, JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-non-positive/fR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-non-positive/fR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-non-positive/fR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-non-positive/fR/fR, branch_mif_mnon_mpositive__fR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-non-positive/fR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-not-less/fR/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-not-less/fR/fR, branch_mif_mnot_mless__fR__fR, hot)
  { /* This block begins with definitions for branch-if-not-less/fR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       22
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-not-less/fR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-not-less"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-not-less/fR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mnot_mless__fR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-not-less/fR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 1
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-not-less/fR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-not-less/fR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-not-less/fR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTERLISPVM_CHECK_TYPES_2(FIXNUM, FIXNUM, JITTER_ARGF1);
    jitterlisp_object undertop = JITTER_UNDER_TOP_MAINSTACK();
    jitterlisp_object top = JITTER_TOP_MAINSTACK();
    JITTER_NIP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED(undertop, top, JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-not-less/fR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-not-less/fR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-not-less/fR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-not-less/fR/fR, branch_mif_mnot_mless__fR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-not-less/fR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-not-null/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-not-null/fR, branch_mif_mnot_mnull__fR, hot)
  { /* This block begins with definitions for branch-if-not-null/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       23
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-not-null/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-not-null"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-not-null/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mnot_mnull__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-not-null/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-not-null/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-not-null/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-not-null/fR . */
  {
/* User-specified code, user code block part: beginning. */

    jitterlisp_object top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_NOTEQUAL(top, JITTERLISP_EMPTY_LIST, JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-not-null/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-not-null/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-not-null/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-not-null/fR, branch_mif_mnot_mnull__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-not-null/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-null/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-null/fR, branch_mif_mnull__fR, hot)
  { /* This block begins with definitions for branch-if-null/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       24
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-null/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-null"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-null/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mnull__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-null/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-null/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-null/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-null/fR . */
  {
/* User-specified code, user code block part: beginning. */

    jitterlisp_object top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_EQUAL(top, JITTERLISP_EMPTY_LIST, JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-null/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-null/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-null/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-null/fR, branch_mif_mnull__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-null/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-positive/fR/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-positive/fR/fR, branch_mif_mpositive__fR__fR, hot)
  { /* This block begins with definitions for branch-if-positive/fR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       25
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-positive/fR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-positive"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-positive/fR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mpositive__fR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-positive/fR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 1
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-positive/fR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-positive/fR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-positive/fR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTERLISPVM_CHECK_TYPES_1(FIXNUM, JITTER_ARGF1);
    jitterlisp_object top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_POSITIVE(top, JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-positive/fR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-positive/fR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-positive/fR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-positive/fR/fR, branch_mif_mpositive__fR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-positive/fR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-register-non-positive/%rR/fR/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-register-non-positive/%rR/fR/fR, branch_mif_mregister_mnon_mpositive___rrR__fR__fR, cold)
  { /* This block begins with definitions for branch-if-register-non-positive/%rR/fR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       26
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-register-non-positive/%rR/fR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-register-non-positive"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-register-non-positive/%rR/fR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mregister_mnon_mpositive___rrR__fR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-register-non-positive/%rR/fR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 1
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-register-non-positive/%rR/fR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-register-non-positive/%rR/fR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-register-non-positive/%rR/fR/fR . */
  {
/* User-specified code, user code block part: beginning. */

#if ! defined (JITTERLISP_UNSAFE)
    JITTERLISP_BRANCH_FAST_UNLESS_FIXNUM (JITTER_ARG0, JITTER_ARGF2);
#endif
    JITTER_BRANCH_FAST_IF_NONPOSITIVE(JITTER_ARG0, JITTER_ARGF1);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-register-non-positive/%rR/fR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-register-non-positive/%rR/fR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-register-non-positive/%rR/fR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-register-non-positive/%rR/fR/fR, branch_mif_mregister_mnon_mpositive___rrR__fR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-register-non-positive/%rR/fR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-register-non-zero/%rR/fR/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-register-non-zero/%rR/fR/fR, branch_mif_mregister_mnon_mzero___rrR__fR__fR, cold)
  { /* This block begins with definitions for branch-if-register-non-zero/%rR/fR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       27
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-register-non-zero/%rR/fR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-register-non-zero"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-register-non-zero/%rR/fR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mregister_mnon_mzero___rrR__fR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-register-non-zero/%rR/fR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 1
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-register-non-zero/%rR/fR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-register-non-zero/%rR/fR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-register-non-zero/%rR/fR/fR . */
  {
/* User-specified code, user code block part: beginning. */

#if ! defined (JITTERLISP_UNSAFE)
    JITTERLISP_BRANCH_FAST_UNLESS_FIXNUM (JITTER_ARG0, JITTER_ARGF2);
#endif
    JITTER_BRANCH_FAST_IF_NOTEQUAL(JITTER_ARG0, JITTERLISP_FIXNUM_ENCODE(0),
                                   JITTER_ARGF1);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-register-non-zero/%rR/fR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-register-non-zero/%rR/fR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-register-non-zero/%rR/fR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-register-non-zero/%rR/fR/fR, branch_mif_mregister_mnon_mzero___rrR__fR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-register-non-zero/%rR/fR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-register-not-null/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-register-not-null/%rR/fR, branch_mif_mregister_mnot_mnull___rrR__fR, cold)
  { /* This block begins with definitions for branch-if-register-not-null/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       28
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-register-not-null/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-register-not-null"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-register-not-null/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mregister_mnot_mnull___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-register-not-null/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-register-not-null/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-register-not-null/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-register-not-null/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_NOTEQUAL(JITTER_ARG0,
                                   JITTERLISP_EMPTY_LIST,
                                   JITTER_ARGF1);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-register-not-null/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-register-not-null/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-register-not-null/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-register-not-null/%rR/fR, branch_mif_mregister_mnot_mnull___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-register-not-null/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-register-null/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-register-null/%rR/fR, branch_mif_mregister_mnull___rrR__fR, cold)
  { /* This block begins with definitions for branch-if-register-null/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       29
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-register-null/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-register-null"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-register-null/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mregister_mnull___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-register-null/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-register-null/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-register-null/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-register-null/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

    JITTER_BRANCH_FAST_IF_EQUAL(JITTER_ARG0,
                                JITTERLISP_EMPTY_LIST,
                                JITTER_ARGF1);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-register-null/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-register-null/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-register-null/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-register-null/%rR/fR, branch_mif_mregister_mnull___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-register-null/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-register-positive/%rR/fR/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-register-positive/%rR/fR/fR, branch_mif_mregister_mpositive___rrR__fR__fR, cold)
  { /* This block begins with definitions for branch-if-register-positive/%rR/fR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       30
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-register-positive/%rR/fR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-register-positive"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-register-positive/%rR/fR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mregister_mpositive___rrR__fR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-register-positive/%rR/fR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 1
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-register-positive/%rR/fR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-register-positive/%rR/fR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-register-positive/%rR/fR/fR . */
  {
/* User-specified code, user code block part: beginning. */

#if ! defined (JITTERLISP_UNSAFE)
    JITTERLISP_BRANCH_FAST_UNLESS_FIXNUM (JITTER_ARG0, JITTER_ARGF2);
#endif
    JITTER_BRANCH_FAST_IF_POSITIVE(JITTER_ARG0, JITTER_ARGF1);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-register-positive/%rR/fR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-register-positive/%rR/fR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-register-positive/%rR/fR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-register-positive/%rR/fR/fR, branch_mif_mregister_mpositive___rrR__fR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-register-positive/%rR/fR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction branch-if-true/fR */
  JITTER_INSTRUCTION_PROLOG_(branch-if-true/fR, branch_mif_mtrue__fR, hot)
  { /* This block begins with definitions for branch-if-true/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       31
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         branch-if-true/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "branch-if-true"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "branch-if-true/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME branch_mif_mtrue__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for branch-if-true/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of branch-if-true/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "branch-if-true/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for branch-if-true/fR . */
  {
/* User-specified code, user code block part: beginning. */

    jitterlisp_object top = JITTER_TOP_MAINSTACK();
    JITTER_DROP_MAINSTACK();
    JITTER_BRANCH_FAST_IF_NOTEQUAL(top, JITTERLISP_FALSE, JITTER_ARGF0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for branch-if-true/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "branch-if-true/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the branch-if-true/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(branch-if-true/fR, branch_mif_mtrue__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for branch-if-true/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/n0/retR */
  JITTER_INSTRUCTION_PROLOG_(call/n0/retR, call__n0__retR, cold)
  { /* This block begins with definitions for call/n0/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       32
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/n0/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/n0/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__n0__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/n0/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/n0/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/n0/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/n0/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/n0/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/n0/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/n0/retR, call__n0__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/n0/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/n1/retR */
  JITTER_INSTRUCTION_PROLOG_(call/n1/retR, call__n1__retR, cold)
  { /* This block begins with definitions for call/n1/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       33
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/n1/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/n1/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__n1__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/n1/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/n1/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/n1/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/n1/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/n1/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/n1/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/n1/retR, call__n1__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/n1/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/n2/retR */
  JITTER_INSTRUCTION_PROLOG_(call/n2/retR, call__n2__retR, cold)
  { /* This block begins with definitions for call/n2/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       34
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/n2/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/n2/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__n2__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 2L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/n2/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/n2/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/n2/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/n2/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/n2/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/n2/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/n2/retR, call__n2__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/n2/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/n3/retR */
  JITTER_INSTRUCTION_PROLOG_(call/n3/retR, call__n3__retR, cold)
  { /* This block begins with definitions for call/n3/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       35
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/n3/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/n3/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__n3__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 3L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/n3/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/n3/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/n3/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/n3/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/n3/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/n3/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/n3/retR, call__n3__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/n3/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/n4/retR */
  JITTER_INSTRUCTION_PROLOG_(call/n4/retR, call__n4__retR, cold)
  { /* This block begins with definitions for call/n4/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       36
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/n4/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/n4/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__n4__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 4L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/n4/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/n4/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/n4/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/n4/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/n4/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/n4/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/n4/retR, call__n4__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/n4/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/n5/retR */
  JITTER_INSTRUCTION_PROLOG_(call/n5/retR, call__n5__retR, cold)
  { /* This block begins with definitions for call/n5/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       37
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/n5/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/n5/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__n5__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 5L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/n5/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/n5/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/n5/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/n5/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/n5/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/n5/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/n5/retR, call__n5__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/n5/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/n6/retR */
  JITTER_INSTRUCTION_PROLOG_(call/n6/retR, call__n6__retR, cold)
  { /* This block begins with definitions for call/n6/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       38
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/n6/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/n6/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__n6__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 6L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/n6/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/n6/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/n6/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/n6/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/n6/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/n6/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/n6/retR, call__n6__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/n6/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/n7/retR */
  JITTER_INSTRUCTION_PROLOG_(call/n7/retR, call__n7__retR, cold)
  { /* This block begins with definitions for call/n7/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       39
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/n7/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/n7/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__n7__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 7L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/n7/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/n7/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/n7/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/n7/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/n7/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/n7/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/n7/retR, call__n7__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/n7/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/n8/retR */
  JITTER_INSTRUCTION_PROLOG_(call/n8/retR, call__n8__retR, cold)
  { /* This block begins with definitions for call/n8/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       40
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/n8/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/n8/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__n8__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 8L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/n8/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/n8/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/n8/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/n8/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/n8/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/n8/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/n8/retR, call__n8__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/n8/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/n9/retR */
  JITTER_INSTRUCTION_PROLOG_(call/n9/retR, call__n9__retR, cold)
  { /* This block begins with definitions for call/n9/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       41
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/n9/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/n9/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__n9__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 9L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/n9/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/n9/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/n9/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/n9/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/n9/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/n9/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/n9/retR, call__n9__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/n9/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/n10/retR */
  JITTER_INSTRUCTION_PROLOG_(call/n10/retR, call__n10__retR, cold)
  { /* This block begins with definitions for call/n10/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       42
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/n10/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/n10/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__n10__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 10L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/n10/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/n10/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/n10/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/n10/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/n10/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/n10/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/n10/retR, call__n10__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/n10/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call/nR/retR */
  JITTER_INSTRUCTION_PROLOG_(call/nR/retR, call__nR__retR, cold)
  { /* This block begins with definitions for call/nR/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       43
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call/nR/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call/nR/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call__nR__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call/nR/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call/nR/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call/nR/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    if (c->kind == jitterlisp_closure_type_compiled)
      {
        /* Make place for the return address in the return stack.  The
           actual value will be written by the callee. */
        JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

        /* Branch-and-link to the native code, whose first instruction
           will be a prolog. */
        struct jitterlisp_compiled_closure *cc = & c->compiled;
        JITTER_BRANCH_AND_LINK(cc->first_program_point);
      }
    else
      {
        const struct jitterlisp_interpreted_closure *ic = & c->interpreted;

        /* Push an element on the main stack.  This way we can ensure that
           every actual is accessible thru memory in a contiguous array,
           even if the main stack is TOS-optimized.  Compute the address
           (on the main stack backing) where the actuals begin.

           Notice that the interpreted function we are calling is allowed
           to call into compiled code in its turn.  This is not a problem,
           as we are not moving stack pointers down until the call ends:
           the unused part of the main and return stacks is available to
           the callee. */
        JITTER_PUSH_UNSPECIFIED_MAINSTACK();
        jitterlisp_object *actuals
          // FIXME: add a stack operator to compute this address.
          = (& JITTER_UNDER_TOP_MAINSTACK()) - in_arity + 1;

        /* Call the interpreter. */
        jitterlisp_object interpretation_result
          = jitterlisp_call_interpreted (ic, actuals, in_arity);

        /* Remove as many elements as the in-arity plus one (the callee) from
           the stack, without affecting the top.  Unless JITTER_ARGN0 is
           residual this whole loops compiles to one instruction when the main
           stack is TOS-optimized, and doesn't touch memory. */
        int i;
        for (i = 0; i < in_arity + 1; i ++)
          JITTER_NIP_MAINSTACK();

        /* Now the stack is one element higher than it was before the call,
           containing the unspecified element at the top.  Replace it with
           the result.  Again this doesn't touch memory. */
        JITTER_TOP_MAINSTACK() = interpretation_result;
      }
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call/nR/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call/nR/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call/nR/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call/nR/retR, call__nR__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call/nR/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/n0/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/n0/retR, call_mcompiled__n0__retR, cold)
  { /* This block begins with definitions for call-compiled/n0/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       44
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/n0/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/n0/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__n0__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/n0/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/n0/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/n0/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/n0/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/n0/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/n0/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/n0/retR, call_mcompiled__n0__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/n0/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/n1/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/n1/retR, call_mcompiled__n1__retR, cold)
  { /* This block begins with definitions for call-compiled/n1/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       45
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/n1/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/n1/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__n1__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/n1/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/n1/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/n1/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/n1/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/n1/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/n1/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/n1/retR, call_mcompiled__n1__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/n1/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/n2/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/n2/retR, call_mcompiled__n2__retR, cold)
  { /* This block begins with definitions for call-compiled/n2/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       46
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/n2/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/n2/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__n2__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 2L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/n2/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/n2/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/n2/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/n2/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/n2/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/n2/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/n2/retR, call_mcompiled__n2__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/n2/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/n3/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/n3/retR, call_mcompiled__n3__retR, cold)
  { /* This block begins with definitions for call-compiled/n3/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       47
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/n3/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/n3/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__n3__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 3L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/n3/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/n3/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/n3/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/n3/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/n3/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/n3/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/n3/retR, call_mcompiled__n3__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/n3/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/n4/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/n4/retR, call_mcompiled__n4__retR, cold)
  { /* This block begins with definitions for call-compiled/n4/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       48
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/n4/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/n4/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__n4__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 4L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/n4/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/n4/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/n4/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/n4/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/n4/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/n4/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/n4/retR, call_mcompiled__n4__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/n4/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/n5/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/n5/retR, call_mcompiled__n5__retR, cold)
  { /* This block begins with definitions for call-compiled/n5/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       49
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/n5/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/n5/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__n5__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 5L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/n5/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/n5/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/n5/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/n5/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/n5/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/n5/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/n5/retR, call_mcompiled__n5__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/n5/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/n6/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/n6/retR, call_mcompiled__n6__retR, cold)
  { /* This block begins with definitions for call-compiled/n6/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       50
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/n6/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/n6/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__n6__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 6L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/n6/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/n6/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/n6/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/n6/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/n6/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/n6/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/n6/retR, call_mcompiled__n6__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/n6/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/n7/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/n7/retR, call_mcompiled__n7__retR, cold)
  { /* This block begins with definitions for call-compiled/n7/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       51
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/n7/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/n7/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__n7__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 7L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/n7/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/n7/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/n7/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/n7/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/n7/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/n7/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/n7/retR, call_mcompiled__n7__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/n7/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/n8/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/n8/retR, call_mcompiled__n8__retR, cold)
  { /* This block begins with definitions for call-compiled/n8/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       52
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/n8/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/n8/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__n8__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 8L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/n8/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/n8/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/n8/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/n8/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/n8/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/n8/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/n8/retR, call_mcompiled__n8__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/n8/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/n9/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/n9/retR, call_mcompiled__n9__retR, cold)
  { /* This block begins with definitions for call-compiled/n9/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       53
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/n9/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/n9/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__n9__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 9L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/n9/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/n9/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/n9/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/n9/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/n9/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/n9/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/n9/retR, call_mcompiled__n9__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/n9/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/n10/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/n10/retR, call_mcompiled__n10__retR, cold)
  { /* This block begins with definitions for call-compiled/n10/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       54
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/n10/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/n10/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__n10__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 10L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/n10/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/n10/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/n10/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/n10/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/n10/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/n10/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/n10/retR, call_mcompiled__n10__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/n10/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-compiled/nR/retR */
  JITTER_INSTRUCTION_PROLOG_(call-compiled/nR/retR, call_mcompiled__nR__retR, cold)
  { /* This block begins with definitions for call-compiled/nR/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       55
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-compiled/nR/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-compiled"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-compiled/nR/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mcompiled__nR__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 1-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2

    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP1;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-compiled/nR/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-compiled/nR/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-compiled/nR/retR . */
  {
/* User-specified code, user code block part: beginning. */

    const jitter_uint in_arity = JITTER_ARGN0;
    jitterlisp_object callee = JITTER_AT_DEPTH_MAINSTACK(in_arity);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);

    /* Here we can assume that * c is a compiled closure without checking. */
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();
//    JITTER_TOP_RETURNSTACK() = 0x4242aaaa; // FIXME: just a test.  Remove.

    /* Branch-and-link to the native code, whose first instruction
       will be a prolog. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-compiled/nR/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-compiled/nR/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-compiled/nR/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-compiled/nR/retR, call_mcompiled__nR__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-compiled/nR/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction call-from-c/retR */
  JITTER_INSTRUCTION_PROLOG_(call-from-c/retR, call_mfrom_mc__retR, cold)
  { /* This block begins with definitions for call-from-c/retR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       56
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         call-from-c/retR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "call-from-c"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "call-from-c/retR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME call_mfrom_mc__retR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is a non-replacement and a caller.
       Its 0-th argument, a literal, is the return address where to jump
       back after the procedure returns.  Branch-and-link
       functionality is enabled for this instruction. */
/* This instruction is relocatable: use more efficient branches
   which can generate defects. */
#   undef JITTER_BRANCH_AND_LINK
#   define JITTER_BRANCH_AND_LINK      _JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   define JITTER_BRANCH_AND_LINK_WITH _JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK
#   define JITTER_BRANCH_FAST_AND_LINK _JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1

    /* The 0th argument is a residual label. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0


#if defined(JITTER_DISPATCH_NO_THREADING)             \
    && (! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)  \
        || /* is this a replacement? */ 0)
  /* We use the implicit argument at the end of the calling.
     instruction to discover the procedure return address. */
  const void * const _jitter_return_pointer
    __attribute__ ((unused)) = JITTER_ARGP0;
  /* And make it accessible to the user (who will usually call 
     JITTER_BRANCH_AND_LINK) thru a nice macro. */
# define _JITTER_RETURN_ADDRESS _jitter_return_pointer
#endif

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of call-from-c/retR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "call-from-c/retR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for call-from-c/retR . */
  {
/* User-specified code, user code block part: beginning. */

    /* Get a number (untagged) from the stack top, so that I know at which
       depth to find the closure.  The arity check must have been
       performed already on the interpreter side. */
    const jitter_uint in_arity_plus_one = JITTER_TOP_MAINSTACK();

    /* What follows is similar to the call instruction in the case of a compiled
       callee.  Shall I factor the common code with a macro? */

    /* Decode the closure. */
    jitterlisp_object callee
      = JITTER_AT_NONZERO_DEPTH_MAINSTACK(in_arity_plus_one);
    struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(callee);
    struct jitterlisp_compiled_closure *cc = & c->compiled;

    /* Drop the number of arguments. */
    JITTER_DROP_MAINSTACK();

    /* Make place for the return address in the return stack.  The
       actual value will be written by the callee. */
    JITTER_PUSH_UNSPECIFIED_RETURNSTACK();

    /* Branch-and-link.  This follows the ordinary calling convention,
       with the main stack containing the closure and its actuals, known
       to be in the correct number.  The next VM instruction will be a
       prolog saving the link; then execution will fall thru into the
       compiled closure body. */
    JITTER_BRANCH_AND_LINK(cc->first_program_point);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for call-from-c/retR . */

  //fprintf (stderr, "..Executed instruction %s\n", "call-from-c/retR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the call-from-c/retR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#if    defined(JITTER_DISPATCH_NO_THREADING)         \
    && ! defined(JITTER_MACHINE_SUPPORTS_PROCEDURE)
# undef _JITTER_RETURN_ADDRESS
#endif

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(call-from-c/retR, call_mfrom_mc__retR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for call-from-c/retR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction canonicalize-boolean */
  JITTER_INSTRUCTION_PROLOG_(canonicalize-boolean, canonicalize_mboolean, hot)
  { /* This block begins with definitions for canonicalize-boolean . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       57
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         canonicalize-boolean
#   define JITTER_INSTRUCTION_NAME_AS_STRING "canonicalize-boolean"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "canonicalize-boolean"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME canonicalize_mboolean

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is not branching. */
#   undef JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is not branching: undefine branch
       macros so that they cannot be used by mistake. */
/* Locally poison JITTER_COMPUTED_GOTO . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_COMPUTED_GOTO")
# undef JITTER_COMPUTED_GOTO
# define JITTER_COMPUTED_GOTO JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_COMPUTED_GOTO, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_COMPUTED_GOTO
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_COMPUTED_GOTO . */

/* Locally poison JITTER_BRANCH . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_BRANCH")
# undef JITTER_BRANCH
# define JITTER_BRANCH JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_BRANCH, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_BRANCH
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_BRANCH . */

/* Locally poison JITTER_EXIT . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("JITTER_EXIT")
# undef JITTER_EXIT
# define JITTER_EXIT JITTER_POISONED_WITHOUT_ATTRIBUTE (JITTER_EXIT, "branching")
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef JITTER_EXIT
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of JITTER_EXIT . */

  /* The residual arity for this instruction does not depend on fast labels. */
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0


#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of canonicalize-boolean ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "canonicalize-boolean"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for canonicalize-boolean . */
  {
/* User-specified code, user code block part: beginning. */

    JITTERLISP_BOOLEAN_CANONICALIZE_(JITTER_TOP_MAINSTACK(),
                                     JITTER_TOP_MAINSTACK());
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for canonicalize-boolean . */

  //fprintf (stderr, "..Executed instruction %s\n", "canonicalize-boolean");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the canonicalize-boolean argument macros so they can't be used
       by mistake in the instruction body coming next. */

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_EXIT")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_BRANCH")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("JITTER_COMPUTED_GOTO")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(canonicalize-boolean, canonicalize_mboolean, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for canonicalize-boolean, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction cdr-register/%rR/%rR/fR */
  JITTER_INSTRUCTION_PROLOG_(cdr-register/%rR/%rR/fR, cdr_mregister___rrR___rrR__fR, cold)
  { /* This block begins with definitions for cdr-register/%rR/%rR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       58
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         cdr-register/%rR/%rR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "cdr-register"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "cdr-register/%rR/%rR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME cdr_mregister___rrR___rrR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 3
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for cdr-register/%rR/%rR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

    /* The 2th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF2 0
    /* JITTER_ARG2 is intentionally not defined for a fast label. */

#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 (JITTER_RESIDUAL_ARGUMENT_0.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[0]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET0 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG0  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET0)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

    /* The 1th argument is a slow (therefore residual, passed as an offset)
        register. */
  /* Define a macro expanding to the slow register offset. */
#if defined(JITTER_DISPATCH_NO_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 (JITTER_RESIDUAL_ARGUMENT_1.fixnum)
#elif defined (JITTER_DISPATCH_MINIMAL_THREADING)
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[1]).fixnum)
#else
# define JITTER_SLOW_REGISTER_OFFSET1 ((((union jitter_word*)jitter_ip)[2]).fixnum)
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
  /* Define a macro expanding to an l-value for the VM register content. */
#   define JITTER_ARG1  JITTER_SLOW_REGISTER_FROM_OFFSET(r, JITTER_SLOW_REGISTER_OFFSET1)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG2  JITTER_RESIDUAL_ARGUMENT_2
    JITTER_MARK_RESIDUAL_2_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[2])
#else
#   define JITTER_ARG2  (((union jitter_word*)jitter_ip)[3])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN2 (JITTER_ARG2.fixnum)
#   define JITTER_ARGU2 (JITTER_ARG2.ufixnum)
#   define JITTER_ARGP2 (JITTER_ARG2.pointer)
#   define JITTER_ARGF2 JITTER_ARGP2

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of cdr-register/%rR/%rR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "cdr-register/%rR/%rR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for cdr-register/%rR/%rR/fR . */
  {
/* User-specified code, user code block part: beginning. */

#if ! defined (JITTERLISP_UNSAFE)
    JITTERLISP_BRANCH_FAST_UNLESS_CONS (JITTER_ARG0, JITTER_ARGF2);
#endif
    JITTERLISP_CDR_(JITTER_ARG1,
                    JITTER_ARG0);
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for cdr-register/%rR/%rR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "cdr-register/%rR/%rR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the cdr-register/%rR/%rR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1
#   undef JITTER_SLOW_REGISTER_OFFSET2
#   undef JITTER_ARG2
#   undef JITTER_ARGN2
#   undef JITTER_ARGU2
#   undef JITTER_ARGP2
#   undef JITTER_ARGF2

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(cdr-register/%rR/%rR/fR, cdr_mregister___rrR___rrR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for cdr-register/%rR/%rR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction check-closure/fR */
  JITTER_INSTRUCTION_PROLOG_(check-closure/fR, check_mclosure__fR, hot)
  { /* This block begins with definitions for check-closure/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       59
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         check-closure/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "check-closure"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "check-closure/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME check_mclosure__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for check-closure/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF0 0
    /* JITTER_ARG0 is intentionally not defined for a fast label. */

#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of check-closure/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "check-closure/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for check-closure/fR . */
  {
/* User-specified code, user code block part: beginning. */

#   ifndef JITTERLISP_UNSAFE
      jitterlisp_object top = JITTER_TOP_MAINSTACK();
      if (! JITTERLISP_IS_CLOSURE(top))
        JITTER_BRANCH_FAST(JITTER_ARGF0);
#   endif // #ifndef JITTERLISP_UNSAFE
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for check-closure/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "check-closure/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the check-closure/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(check-closure/fR, check_mclosure__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for check-closure/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction check-global-defined/nR/fR */
  JITTER_INSTRUCTION_PROLOG_(check-global-defined/nR/fR, check_mglobal_mdefined__nR__fR, cold)
  { /* This block begins with definitions for check-global-defined/nR/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       60
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         check-global-defined/nR/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "check-global-defined"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "check-global-defined/nR/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME check_mglobal_mdefined__nR__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 2
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for check-global-defined/nR/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a residual literal. */
#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG0  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG0  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_1
    JITTER_MARK_RESIDUAL_1_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[2])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of check-global-defined/nR/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "check-global-defined/nR/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for check-global-defined/nR/fR . */
  {
/* User-specified code, user code block part: beginning. */

#ifndef JITTERLISP_UNSAFE
    jitterlisp_object tagged_symbol = JITTER_ARGN0;
    struct jitterlisp_symbol * symbol = JITTERLISP_SYMBOL_DECODE(tagged_symbol);
    JITTER_BRANCH_FAST_IF_EQUAL (symbol->global_value, JITTERLISP_UNDEFINED,
                                 JITTER_ARGF1);
#endif // #ifndef JITTERLISP_UNSAFE
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for check-global-defined/nR/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "check-global-defined/nR/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the check-global-defined/nR/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(check-global-defined/nR/fR, check_mglobal_mdefined__nR__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for check-global-defined/nR/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction check-in-arity/n0/fR */
  JITTER_INSTRUCTION_PROLOG_(check-in-arity/n0/fR, check_min_marity__n0__fR, hot)
  { /* This block begins with definitions for check-in-arity/n0/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       61
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         check-in-arity/n0/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "check-in-arity"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "check-in-arity/n0/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME check_min_marity__n0__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for check-in-arity/n0/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 0L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of check-in-arity/n0/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "check-in-arity/n0/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for check-in-arity/n0/fR . */
  {
/* User-specified code, user code block part: beginning. */

#   ifndef JITTERLISP_UNSAFE
      /* Here we can assume that the top object is a closure, without checking:
         we either already performed a type check, or the compiler decided it
         wasn't necessary. */
      jitterlisp_object top = JITTER_TOP_MAINSTACK();
      struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(top);

      JITTER_BRANCH_FAST_IF_NOTEQUAL(c->in_arity, JITTER_ARGN0, JITTER_ARGF1);
#   endif // #ifndef JITTERLISP_UNSAFE
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for check-in-arity/n0/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "check-in-arity/n0/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the check-in-arity/n0/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(check-in-arity/n0/fR, check_min_marity__n0__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for check-in-arity/n0/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction check-in-arity/n1/fR */
  JITTER_INSTRUCTION_PROLOG_(check-in-arity/n1/fR, check_min_marity__n1__fR, hot)
  { /* This block begins with definitions for check-in-arity/n1/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       62
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         check-in-arity/n1/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "check-in-arity"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "check-in-arity/n1/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME check_min_marity__n1__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for check-in-arity/n1/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 1L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of check-in-arity/n1/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "check-in-arity/n1/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for check-in-arity/n1/fR . */
  {
/* User-specified code, user code block part: beginning. */

#   ifndef JITTERLISP_UNSAFE
      /* Here we can assume that the top object is a closure, without checking:
         we either already performed a type check, or the compiler decided it
         wasn't necessary. */
      jitterlisp_object top = JITTER_TOP_MAINSTACK();
      struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(top);

      JITTER_BRANCH_FAST_IF_NOTEQUAL(c->in_arity, JITTER_ARGN0, JITTER_ARGF1);
#   endif // #ifndef JITTERLISP_UNSAFE
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for check-in-arity/n1/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "check-in-arity/n1/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the check-in-arity/n1/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(check-in-arity/n1/fR, check_min_marity__n1__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for check-in-arity/n1/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction check-in-arity/n2/fR */
  JITTER_INSTRUCTION_PROLOG_(check-in-arity/n2/fR, check_min_marity__n2__fR, hot)
  { /* This block begins with definitions for check-in-arity/n2/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       63
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         check-in-arity/n2/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "check-in-arity"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "check-in-arity/n2/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME check_min_marity__n2__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for check-in-arity/n2/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 2L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 2L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of check-in-arity/n2/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "check-in-arity/n2/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for check-in-arity/n2/fR . */
  {
/* User-specified code, user code block part: beginning. */

#   ifndef JITTERLISP_UNSAFE
      /* Here we can assume that the top object is a closure, without checking:
         we either already performed a type check, or the compiler decided it
         wasn't necessary. */
      jitterlisp_object top = JITTER_TOP_MAINSTACK();
      struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(top);

      JITTER_BRANCH_FAST_IF_NOTEQUAL(c->in_arity, JITTER_ARGN0, JITTER_ARGF1);
#   endif // #ifndef JITTERLISP_UNSAFE
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for check-in-arity/n2/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "check-in-arity/n2/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the check-in-arity/n2/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(check-in-arity/n2/fR, check_min_marity__n2__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for check-in-arity/n2/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction check-in-arity/n3/fR */
  JITTER_INSTRUCTION_PROLOG_(check-in-arity/n3/fR, check_min_marity__n3__fR, hot)
  { /* This block begins with definitions for check-in-arity/n3/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       64
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         check-in-arity/n3/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "check-in-arity"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "check-in-arity/n3/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME check_min_marity__n3__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for check-in-arity/n3/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 3L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 3L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of check-in-arity/n3/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "check-in-arity/n3/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for check-in-arity/n3/fR . */
  {
/* User-specified code, user code block part: beginning. */

#   ifndef JITTERLISP_UNSAFE
      /* Here we can assume that the top object is a closure, without checking:
         we either already performed a type check, or the compiler decided it
         wasn't necessary. */
      jitterlisp_object top = JITTER_TOP_MAINSTACK();
      struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(top);

      JITTER_BRANCH_FAST_IF_NOTEQUAL(c->in_arity, JITTER_ARGN0, JITTER_ARGF1);
#   endif // #ifndef JITTERLISP_UNSAFE
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for check-in-arity/n3/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "check-in-arity/n3/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the check-in-arity/n3/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(check-in-arity/n3/fR, check_min_marity__n3__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for check-in-arity/n3/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction check-in-arity/n4/fR */
  JITTER_INSTRUCTION_PROLOG_(check-in-arity/n4/fR, check_min_marity__n4__fR, hot)
  { /* This block begins with definitions for check-in-arity/n4/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       65
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         check-in-arity/n4/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "check-in-arity"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "check-in-arity/n4/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME check_min_marity__n4__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for check-in-arity/n4/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 4L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 4L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of check-in-arity/n4/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "check-in-arity/n4/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for check-in-arity/n4/fR . */
  {
/* User-specified code, user code block part: beginning. */

#   ifndef JITTERLISP_UNSAFE
      /* Here we can assume that the top object is a closure, without checking:
         we either already performed a type check, or the compiler decided it
         wasn't necessary. */
      jitterlisp_object top = JITTER_TOP_MAINSTACK();
      struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(top);

      JITTER_BRANCH_FAST_IF_NOTEQUAL(c->in_arity, JITTER_ARGN0, JITTER_ARGF1);
#   endif // #ifndef JITTERLISP_UNSAFE
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for check-in-arity/n4/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "check-in-arity/n4/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the check-in-arity/n4/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(check-in-arity/n4/fR, check_min_marity__n4__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for check-in-arity/n4/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction check-in-arity/n5/fR */
  JITTER_INSTRUCTION_PROLOG_(check-in-arity/n5/fR, check_min_marity__n5__fR, hot)
  { /* This block begins with definitions for check-in-arity/n5/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       66
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         check-in-arity/n5/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "check-in-arity"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "check-in-arity/n5/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME check_min_marity__n5__fR

#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
  /* Local poisoning will be in effect.  Avoid warnings. */
# pragma GCC diagnostic push
# pragma GCC diagnostic ignored "-Wpragmas"
# pragma GCC diagnostic ignored "-Wunknown-warning-option"
# pragma GCC diagnostic ignored "-Wbuiltin-macro-redefined"
# pragma GCC diagnostic ignored "-Wbuiltin-declaration-mismatch"
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

/* Locally poison longjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("longjmp")
# undef longjmp
# define longjmp JITTER_POISONED_EVERYWHERE (longjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef longjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of longjmp . */

/* Locally poison setjmp . */
#if defined (JITTER_HAVE_LOCAL_POISONING)
# pragma push_macro ("setjmp")
# undef setjmp
# define setjmp JITTER_POISONED_EVERYWHERE (setjmp)
#else // ! defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# undef setjmp
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* End of the poisoning of setjmp . */

    /* This specialized instruction is not a replacement. */
    /* This specialized instruction is branching. */
#   undef JITTER_BRANCH_FAST
#   define JITTER_BRANCH_FAST _JITTER_BRANCH_FAST
#   undef JITTER_BRANCH_FAST_IF_ZERO
#   define JITTER_BRANCH_FAST_IF_ZERO _JITTER_BRANCH_FAST_IF_ZERO
#   undef JITTER_BRANCH_FAST_IF_NONZERO
#   define JITTER_BRANCH_FAST_IF_NONZERO _JITTER_BRANCH_FAST_IF_NONZERO
#   undef JITTER_BRANCH_FAST_IF_POSITIVE
#   define JITTER_BRANCH_FAST_IF_POSITIVE _JITTER_BRANCH_FAST_IF_POSITIVE
#   undef JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   define JITTER_BRANCH_FAST_IF_NONPOSITIVE _JITTER_BRANCH_FAST_IF_NONPOSITIVE
#   undef JITTER_BRANCH_FAST_IF_NEGATIVE
#   define JITTER_BRANCH_FAST_IF_NEGATIVE _JITTER_BRANCH_FAST_IF_NEGATIVE
#   undef JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   define JITTER_BRANCH_FAST_IF_NONNEGATIVE _JITTER_BRANCH_FAST_IF_NONNEGATIVE
#   undef JITTER_BRANCH_FAST_IF_EQUAL
#   define JITTER_BRANCH_FAST_IF_EQUAL _JITTER_BRANCH_FAST_IF_EQUAL
#   undef JITTER_BRANCH_FAST_IF_NOTEQUAL
#   define JITTER_BRANCH_FAST_IF_NOTEQUAL _JITTER_BRANCH_FAST_IF_NOTEQUAL
#   undef JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_SIGNED _JITTER_BRANCH_FAST_IF_LESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_LESS_UNSIGNED _JITTER_BRANCH_FAST_IF_LESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTLESS_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_SIGNED _JITTER_BRANCH_FAST_IF_GREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_GREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_SIGNED
#   undef JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   define JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED _JITTER_BRANCH_FAST_IF_NOTGREATER_UNSIGNED
#   undef JITTER_BRANCH_FAST_IF_AND
#   define JITTER_BRANCH_FAST_IF_AND _JITTER_BRANCH_FAST_IF_AND
#   undef JITTER_BRANCH_FAST_IF_NOTAND
#   define JITTER_BRANCH_FAST_IF_NOTAND _JITTER_BRANCH_FAST_IF_NOTAND
#   undef JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_PLUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS _JITTER_BRANCH_FAST_IF_MINUS_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS _JITTER_BRANCH_FAST_IF_TIMES_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS _JITTER_BRANCH_FAST_IF_DIVIDED_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS _JITTER_BRANCH_FAST_IF_REMAINDER_OVERFLOWS
#   undef JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   define JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS _JITTER_BRANCH_FAST_IF_NEGATE_OVERFLOWS
#   undef JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW _JITTER_PLUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW _JITTER_MINUS_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW _JITTER_TIMES_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW _JITTER_DIVIDED_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW _JITTER_REMAINDER_BRANCH_FAST_IF_OVERFLOW
#   undef JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
#   define JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW _JITTER_NEGATE_BRANCH_FAST_IF_OVERFLOW
    /* This specialized instruction is not a caller.  Undefine macros only
       visible in caller instructions. */
#   undef JITTER_BRANCH_AND_LINK
#   undef JITTER_BRANCH_AND_LINK_WITH
#   undef JITTER_BRANCH_FAST_AND_LINK

    /* This specialized instruction is not returning.  Undefine macros only
       visible in returning instructions. */
#   undef JITTER_RETURN

    /* This instructions is branching: define branch macros. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#   undef  JITTER_BRANCH
#   define JITTER_BRANCH         _JITTER_BRANCH
#   undef  JITTER_EXIT
#   define JITTER_EXIT           _JITTER_EXIT
  /* The residual arity varies depending on whether we have fast labels. */
#ifdef JITTER_HAVE_PATCH_IN
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 0
#else
  #define JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY 1
#endif // #ifdef JITTER_HAVE_PATCH_IN

  /* Define argument-access macros for check-in-arity/n5/fR . */
#ifdef JITTER_HAVE_PATCH_IN
  /* Define argument-access macros assuming that fast branches are enabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 5L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)

    /* The 1th argument is a "residual" fast label.  Define its
       _ARGF macro as the residual *index* (counting only fast labels, 0-based),
       so that at replication time we know what instruction address to patch in. */
#   define JITTER_ARGF1 0
    /* JITTER_ARG1 is intentionally not defined for a fast label. */

#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)

#else
  /* Define argument-access macros assuming that fast branches are disabled. */
    /* The 0th argument is a nonresidual literal. */
#   define JITTER_ARG0  ((const union jitter_word){.fixnum = 5L})
#   define JITTER_ARGN0 (JITTER_ARG0.fixnum)
#   define JITTER_ARGU0 (JITTER_ARG0.ufixnum)
#   define JITTER_ARGP0 (JITTER_ARG0.pointer)
#   define JITTER_ARGF0 JITTER_ARGP0

#if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARG1  JITTER_RESIDUAL_ARGUMENT_0
    JITTER_MARK_RESIDUAL_0_AS_SET_BY_ASSEMBLY;
#elif defined (JITTER_REPLICATE)
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[0])
#else
#   define JITTER_ARG1  (((union jitter_word*)jitter_ip)[1])
#endif // #if defined(JITTER_DISPATCH_NO_THREADING)
#   define JITTER_ARGN1 (JITTER_ARG1.fixnum)
#   define JITTER_ARGU1 (JITTER_ARG1.ufixnum)
#   define JITTER_ARGP1 (JITTER_ARG1.pointer)
#   define JITTER_ARGF1 JITTER_ARGP1

# endif // #ifdef JITTER_HAVE_PATCH_IN

#ifdef JITTER_REPLICATE
/* Define JITTER_COMPUTED_GOTO for the user code of check-in-arity/n5/fR ;
   This will be more efficient but potentially defective
   for relocatable instructions, or less efficient but safe for
   non-relocatable instruction.  Is this relocatable?  yes. */
#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#endif // #ifdef JITTER_REPLICATE
#if defined (JITTERLISPVM_PROFILE_SAMPLE)
  JITTER_PROFILE_SAMPLE_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
# if defined (JITTER_DISPATCH_MINIMAL_THREADING) \
     || defined (JITTER_DISPATCH_NO_THREADING)
   /* Force the compiler not to move sample-profiling instrumentation
      beyond this point; this way the actual user code is timed.
      This is still not perfect, as residuals are materialised before
      we arrive here, but should be adequate at least for slow VM
      instructions.  Unfortunately this is only possible with
      complex dispatches. */
   JITTER_PRETEND_TO_POSSIBLY_JUMP_ANYWHERE ();
# endif
#endif
#if defined (JITTERLISPVM_PROFILE_COUNT)
  /* Notice that, differently from the code above, this
     instrumentation code *can* be reordered freely: as long as a
     VM instruction is counted, the count increment can be placed
     anyehere.  Let GCC move this code and possibly achieve better
     throughput by exploiting instruction-level parallelism and
     therefore approximate more closely a non-profiled build. */
  JITTER_PROFILE_COUNT_UPDATE
     (JITTERLISPVM_OWN_SPECIAL_PURPOSE_STATE_DATA,
      JITTER_SPECIALIZED_INSTRUCTION_OPCODE);
#endif

  {
/* User-specified code, instruction-beginning-c part: beginning. */

  
/* User-specified code, instruction-beginning-c part: end */

  }
  //fprintf (stderr, "Executing instruction %s..\n", "check-in-arity/n5/fR"); fflush (stderr);
#undef JITTER_THIS_IS_A_REPLACEMENT
#undef JITTER_THIS_IS_NOT_A_REPLACEMENT
#define JITTER_THIS_IS_NOT_A_REPLACEMENT 1

    /* User code for check-in-arity/n5/fR . */
  {
/* User-specified code, user code block part: beginning. */

#   ifndef JITTERLISP_UNSAFE
      /* Here we can assume that the top object is a closure, without checking:
         we either already performed a type check, or the compiler decided it
         wasn't necessary. */
      jitterlisp_object top = JITTER_TOP_MAINSTACK();
      struct jitterlisp_closure *c = JITTERLISP_CLOSURE_DECODE(top);

      JITTER_BRANCH_FAST_IF_NOTEQUAL(c->in_arity, JITTER_ARGN0, JITTER_ARGF1);
#   endif // #ifndef JITTERLISP_UNSAFE
  
/* User-specified code, user code block part: end */

  }
    /* End of the user code for check-in-arity/n5/fR . */

  //fprintf (stderr, "..Executed instruction %s\n", "check-in-arity/n5/fR");
  {
/* User-specified code, instruction-end-c part: beginning. */

  
/* User-specified code, instruction-end-c part: end */

  }
    /* Undefine the check-in-arity/n5/fR argument macros so they can't be used
       by mistake in the instruction body coming next. */
#   undef JITTER_SLOW_REGISTER_OFFSET0
#   undef JITTER_ARG0
#   undef JITTER_ARGN0
#   undef JITTER_ARGU0
#   undef JITTER_ARGP0
#   undef JITTER_ARGF0
#   undef JITTER_SLOW_REGISTER_OFFSET1
#   undef JITTER_ARG1
#   undef JITTER_ARGN1
#   undef JITTER_ARGU1
#   undef JITTER_ARGP1
#   undef JITTER_ARGF1

#   undef JITTER_SPECIALIZED_INSTRUCTION_OPCODE
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME
#   undef JITTER_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING
#   undef JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME

#  undef JITTER_COMPUTED_GOTO
#  if defined (JITTER_COMPUTED_GOTO_IN_ASM)
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_IN_ASM
#  else /* JITTER_COMPUTED_GOTO_IN_ASM is not available. */
#    define JITTER_COMPUTED_GOTO JITTER_COMPUTED_GOTO_FALLBACK
#  endif /* if defined (JITTER_COMPUTED_GOTO_IN_ASM) */
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("setjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
# pragma pop_macro ("longjmp")
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
#if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)
/* Local poisoning is no longer in effect.  Revert to the previous
   state of warnings. */
# pragma GCC diagnostic pop
#endif // #if defined (JITTER_HAVE_LOCAL_POISONING_REQUIREMENTS)

 JITTER_INSTRUCTION_EPILOG_(check-in-arity/n5/fR, check_min_marity__n5__fR, JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY)
#   undef JITTER_SPECIALIZED_INSTRUCTION_RESIDUAL_ARITY

    /* Here ends the block for check-in-arity/n5/fR, which started with its
       definitions. */
  }

  /* Ordinary specialised instruction check-in-arity/n6/fR */
  JITTER_INSTRUCTION_PROLOG_(check-in-arity/n6/fR, check_min_marity__n6__fR, hot)
  { /* This block begins with definitions for check-in-arity/n6/fR . */
    /* This must be a literal and not the enum case, since
       it will be used in assembly as well. */
#   define JITTER_SPECIALIZED_INSTRUCTION_OPCODE       67
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME         check-in-arity/n6/fR
#   define JITTER_INSTRUCTION_NAME_AS_STRING "check-in-arity"
#   define JITTER_SPECIALIZED_INSTRUCTION_NAME_AS_STRING "check-in-arity/n6/fR"
#   define JITTER_SPECIALIZED_INSTRUCTION_MANGLED_NAME check_min_marity__n6__fR

#if 