package {

function ForBench()
local (imax,jmax,N,A,n,i,j)
{
	imax = 100;
	jmax = 100;
	N = 10;

	A = zeros(imax,jmax);

	for (n=0; n<N; n++)
		for (i=1; i<=imax; i++) for (j=1; j<=jmax; j++)
			A[i,j] = 1/(1+i+j);
};

function MipsBench()
local (nits,b,i)
{
	nits = 100000;
	b = 0;
	for (i=0; i<nits; i++) {
		nop(); nop(); nop(); nop(); nop();
		nop(); nop(); nop(); nop(); nop();
		nop(); nop(); nop(); nop(); nop();
		nop(); nop(); nop(); nop(); nop();
		nop(); nop(); nop(); nop(); nop();
		nop(); nop(); nop(); nop(); nop();
	}
};

function VCopyBench()
local (N,nits,a,i,b)
{
	N = 1000;
	nits = 15000;
	a = 1:N;
	for (i=0; i<nits; i++)
		b = a;
};

function VAddBench()
local (N,nits,a,i,b)
{
	N = 1000;
	nits = 15000;
	a = 1.0:N;
	for (i=0; i<nits; i++)
		b = a+11.0;
};

function VIAddBench()
local (N,nits,a,i,b)
{
	N = 1000;
	nits = 15000;
	a = 1:N;
	for (i=0; i<nits; i++)
		b = a+11;
};

function VMulBench()
local (N,nits,a,i,b)
{
	N = 1000;
	nits = 15000;
	a = 1.0:N;
	for (i=0; i<nits; i++)
		b = 11.0*a;
};

format("forbench:     scalar for-loops with 1/(i+j+1) as innermost computation ..\n");
t1=cputime();
ForBench();
for_time = cputime()-t1;

format("mipsbench:    30 NOP instructions inside for-loop ..\n");
t1=cputime();
MipsBench();
mips_time = cputime()-t1;

format("vcopybench:   vector copy ..\n");
t1=cputime();
VCopyBench();
vcopy_time = cputime()-t1;

format("vaddbench:    vector+scalar real addition ..\n");
t1=cputime();
VAddBench();
vadd_time = cputime()-t1;

format("viaddbench:   vector+scalar integer addition ..\n");
t1=cputime();
VIAddBench();
viadd_time = cputime()-t1;

format("vmulbench:    scalar*vector real multiplication ..\n");
t1=cputime();
VMulBench();
vmul_time = cputime()-t1;

fmt = "`20` `10.3` `10.3`\n";
format(fmt,"BENCHMARK",  "MIPS",            "MOPS");
format(fmt,"forbench",   "-",               1E-6*300000/for_time);
format(fmt,"mipsbench",  1E-6*3E6/mips_time,0);
format(fmt,"vcopybench", "-",               1E-6*15E6/vcopy_time);
format(fmt,"vaddbench",  "-",               1E-6*15E6/vadd_time);
format(fmt,"viaddbench", "-",               1E-6*15E6/viadd_time);
format(fmt,"vmulbench",  "-",               1E-6*15E6/vmul_time);

};
