;;; -*- Mode:Lisp; Package:Weyli; Base:10; Lowercase:T; Syntax:Common-Lisp -*-
;;; ===========================================================================
;;;			      Polynomial Domain Tools
;;; ===========================================================================
;;; (c) Copyright 1989, 1992 Cornell University

;;; $Id: poly-tools.lisp,v 2.18 1992/12/04 14:26:19 rz Exp $

(in-package "WEYLI")

;; Things conditionalized by GEHASH would require hash tables that
;; work with GE-EQUAL.

(defmethod print-object ((d polynomial-ring) stream)
  (with-slots (coefficient-domain) d
    (format stream "~A[" coefficient-domain)
    (display-list (ring-variables d) stream)
    (princ "]" stream)))

(defmethod initialize-instance :after
     ((domain variable-hash-table) &rest plist)
  (declare (ignore plist))
  (with-slots (variable-hash-table variable-table variables) domain
    #+GEHASH
    (setq variable-hash-table (make-hash-table :test #'equal))
    
    (setq variable-table (make-array (list (max (length variables) 1) 2)))
    (setq variable-hash-table 
	  (loop for var in variables
		for i upfrom 0
		collect (list var i)
		do (setf (aref variable-table i 0) var)))))

(defmethod variable-index ((domain variable-hash-table) (variable symbol))
  (setq variable (coerce variable *general*))
  (loop for (var index) in (variable-hash-table domain)
	do (when (ge-equal variable var)
	     (return index)))
  #+GEHASH
  (gethash variable (variable-hash-table domain)))

(defmethod variable-index
    ((domain variable-hash-table) (variable general-expression))  
  (loop for (var index) in (variable-hash-table domain)
	do (when (ge-equal variable var)
	     (return index)))
  #+GEHASH
  (gethash variable (variable-hash-table domain)))

(defmethod variable-symbol ((domain variable-hash-table) (order-number number))
  (aref (variable-index-table domain) order-number 0))

;;(defmethod variable-symbol ((domain variable-hash-table) (poly polynomial))
;;  (aref (variable-index-table domain) (poly-order-number (poly-form poly)) 0))

(defmethod get-variable-number-property
    ((domain variable-hash-table) order-number property)
  (%getf (aref (variable-index-table domain) order-number 1) property))

(defmethod set-variable-number-property
	   ((domain variable-hash-table) order-number property value)
  (setf (%getf (aref (variable-index-table domain) order-number 1) property)
	value))

(defsetf get-variable-number-property set-variable-number-property)

(defmethod get-variable-property
    ((domain variable-hash-table) variable property)
  (setq variable (coerce variable *general*))
  (get-variable-number-property domain (variable-index domain variable)
				property))

(defmethod set-variable-property
    ((domain variable-hash-table) variable property value)  
  (setq variable (coerce variable *general*))
  (set-variable-number-property domain (variable-index domain variable)
				property value))

;; Defined in general, which is loaded first.
;;(defsetf get-variable-property set-variable-property)

(defmethod add-new-variable ((ring variable-hash-table) variable)
  (setq variable (coerce variable *general*))
  (with-slots (variables variable-hash-table variable-table) ring
    (unless (member variable variables :test #'ge-equal)
      (let* ((count (length variables))
	     (array (make-array (list (1+ count) 2))))
	(setq variables (append variables (list variable)))
	(copy-array-contents variable-table array)
	(setq variable-table array)
	(setf (aref variable-table count 0) variable)
	(setq variable-hash-table (nconc variable-hash-table
					 (list (list variable count))))
	#+GEHASH
	(setf (gethash variable variable-hash-table) count)
	count))))

(defmethod zero ((domain caching-zero-and-one))
  (with-slots (zero) domain
    zero))

(defmethod one ((domain caching-zero-and-one))
  (with-slots (one) domain
    one))
