#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 1.1 $";
#endif
/*
$Header: /hdf/hdf/v3.2/test/RCS/thfile.c,v 1.1 1992/02/10 20:59:34 chouck beta $

$Log: thfile.c,v $
 * Revision 1.1  1992/02/10  20:59:34  chouck
 * Initial revision
 *
*/
/*

* Hopen
** Create a file.
** Open an existing file.
*** Normally.
*** Read-only file with DFACC_WRITE.
** Open non-existent file.
*** With DFACC_READ.
*** With DFACC_WRITE.
** Create an illegal file.
** Open the same file twice.
*** First with DFACC_WRITE then with DFACC_READ.
*** First with DFACC_WRITE then with DFACC_WRITE.
*** First with DFACC_READ and then with DFACC_WRITE.
*** First with DFACC_<any> and then with DFACC_CREATE.
** Open more files than there is slots.

* Hclose
** Close a proper file.
** Close with an illegal file id.
*** Random file id.
*** Correct tag but bad slot.

* Hstartread
** Normal.
** With illegal file id.
** With illegal tag/ref.
** With wildcard.
** Open more access elements than there is space.

*/

#include "hdf.h"
#define TESTFILE_NAME "t.hdf"
static int shell = 0;
char outbuf[4096], inbuf[4096];

void do_shell()
{
    if (shell) {
       puts("Spawning test shell.");
       if (fork() > 0) {
           execl("/bin/csh", "csh", (char*)0);
       } else {
           wait((int*)0);
       }
       puts("Returned from shell.");
    }
}

int main(argc, argv)
    int argc;
    char *argv[];
{
    int32 fid, fid1;
    int32 aid1, aid2;
    int32 fileid, length, offset, posn;
    uint16 tag, ref;
    int access, special, ret, i;

    if (argc > 1 && strcmp(argv[1], "-shell") == 0) {
       shell = 1;
    }
    for (i=0; i<4096; i++) outbuf[i] = (char) (i % 256);

    printf("Creating a file %s\n", TESTFILE_NAME);
    fid = Hopen(TESTFILE_NAME, DFACC_CREATE, 0);
    printf("fid from Hopen is %d\n", fid);

    puts("checking newref");
    ret = Hnewref(fid);
    printf("newref is %d\n", ret);

    puts("putting some data elements into the file.");
    puts("Data element 100 1");
    ret = Hputelement(fid, 100, 1, "testing 100 1", strlen("testing 100 1")+1);
    printf("ret from Hputelement is %d\n", ret);

    puts("Putting data element 100 4");
    ret = Hputelement(fid, 100, 4, outbuf, 2000);
    printf("ret from Hputelement is %d\n", ret);

    puts("checking newref");
    ret = Hnewref(fid);
    printf("newref is %d\n", ret);

    puts("putting data element 103 2");
    ret = Hputelement(fid, 103, 2, "element 103 2", strlen("element 103 2")+1);
    printf("ret from Hputelement is %d\n", ret);

    puts("getting data element 100 4");
    ret = Hgetelement(fid, 100, 4, inbuf);
    printf("ret from Hgetelement is %d\n", ret);
    for (i=0; i<ret; i++) {
       if (inbuf[i] != outbuf[i])
           printf("Wrong data at %d, out %d in %d\n", i, outbuf[i], inbuf[i]);
       inbuf[i] = '\0';
    }

    puts("putting data element 102 2");
    ret = Hputelement(fid, 102, 2, outbuf, 4096);
    printf("ret from Hputelement is %d\n", ret);

    puts("Closing the file.");
    ret = Hclose(fid);
    printf("ret from Hclose is %d\n", ret);

    do_shell();

    puts("Opening a file with DFACC_ALL");
    fid = Hopen(TESTFILE_NAME, DFACC_ALL, 0);
    printf("fid from Hopen is %d\n", fid);

    puts("checking newref");
    ret = Hnewref(fid);
    printf("newref is %d\n", ret);

    puts("starting read 100 1");
    aid1 = Hstartread(fid, 100, 1);
    printf("aid1 from Hstartread is %d\n", aid1);

    puts("inquiring about access element");
    ret = Hinquire(aid1, &fileid, &tag, &ref, &length, &offset, &posn,
                  &access, &special);
    printf("ret from Hinquire is %d\n", ret);
    printf("fileid %d tag %d ref %d length %d offset %d posn %d\n\
 access %d special %d\n",
          fileid, tag, ref, length, offset, posn, access, special);

    puts("Reading entire data element");
    ret = Hread(aid1, length, inbuf);
    printf("ret from Hread is %d\n", ret);
    printf("data is :%s:\n", inbuf);

    puts("checking newref");
    ret = Hnewref(fid);
    printf("newref is %d\n", ret);

    puts("searching nextread of 100 WILDCARD using DF_CURRENT");
    ret = Hnextread(aid1, 100, DFREF_WILDCARD, DF_CURRENT);
    printf("ret from Hnextread is %d\n", ret);

    puts("inquiring about access element");
    ret = Hinquire(aid1, &fileid, &tag, &ref, &length, &offset, &posn,
                  &access, &special);
    printf("ret from Hinquire is %d\n", ret);
    printf("fileid %d tag %d ref %d length %d offset %d posn %d\n\
 access %d special %d\n",
          fileid, tag, ref, length, offset, posn, access, special);

    puts("searching nextread of 100 WILDCARD using DF_CURRENT");
    puts("expect failure");
    ret = Hnextread(aid1, 100, DFREF_WILDCARD, DF_CURRENT);
    printf("ret from Hnextread is %d\n", ret);

    puts("searching nextread of WILDCARD WILDCARD using DF_START");
    ret = Hnextread(aid1, DFTAG_WILDCARD, DFREF_WILDCARD, DF_START);
    printf("ret from Hnextread is %d\n", ret);

    puts("inquiring about access element");
    ret = Hinquire(aid1, &fileid, &tag, &ref, &length, &offset, &posn,
                  &access, &special);
    printf("ret from Hinquire is %d\n", ret);
    printf("fileid %d tag %d ref %d length %d offset %d posn %d\n\
 access %d special %d\n",
          fileid, tag, ref, length, offset, posn, access, special);

    puts("searching nextread of WILDCARD 3 using DF_CURRENT");
    puts("expect a failure");
    ret = Hnextread(aid1, DFTAG_WILDCARD, 3, DF_CURRENT);
    printf("ret from Hnextread is %d\n", ret);

    puts("searching nextread of WILDCARD 2 using DF_CURRENT");
    ret = Hnextread(aid1, DFTAG_WILDCARD, 2, DF_CURRENT);
    printf("ret from Hnextread is %d\n", ret);

    puts("inquiring about access element");
    ret = Hinquire(aid1, &fileid, &tag, &ref, &length, &offset, &posn,
                  &access, &special);
    printf("ret from Hinquire is %d\n", ret);
    printf("fileid %d tag %d ref %d length %d offset %d posn %d\n\
 access %d special %d\n",
          fileid, tag, ref, length, offset, posn, access, special);

    puts("starting write on old data element 100 1");
    aid2 = Hstartwrite(fid, 100, 1, 4);
    printf("aid from Hstartwrite is %d\n", aid1);

    puts("writing ABCD into data element");
    ret = Hwrite(aid1, 4, "ABCD");
    printf("ret from Hwrite is %d\n");

    puts("ending read access element");
    ret = Hendaccess(aid1);
    printf("ret from Hendaccess is %d\n");

    puts("ending write access element");
    ret = Hendaccess(aid2);
    printf("ret from Hendaccess is %d\n");

    do_shell();

    puts("Opening a file.");
    fid1 = Hopen(TESTFILE_NAME, DFACC_READ, 0);
    printf("fid1 from Hopen is %d\n", fid1);

    puts("checking newref of fid1");
    ret = Hnewref(fid1);
    printf("newref is %d\n", ret);

    puts("Closing the file fid");
    ret = Hclose(fid);
    printf("ret from Hclose is %d\n", ret);

    puts("Closing the file fid1");
    ret = Hclose(fid1);
    printf("ret from Hclose is %d\n", ret);

    do_shell();
}
