#ifdef RCSID
static char RcsId[] = "@(#)$Revision: 1.2 $";
#endif
/*
$Header: /hdf/hdf/v3.2/test/RCS/tdfr8.c,v 1.1 1992/02/10 20:59:34 chouck beta mf
olk $

$Log: tdfr8.c,v $
 * Revision 1.2  1992/02/26  20:22:51  mfolk
 * Changed the way it reports results so that they are more obvious.
 * Added a routine to compare images and palettes.
 *
 * Revision 1.1  1992/02/10  20:59:34  chouck
 * Initial revision
 *
*/

#include "hdf.h"

#define XD1 100
#define YD1 100
#define XD2 321
#define YD2 111
#define FALSE 0

char im1[XD1][YD1], im2[XD2][YD2], ii1[XD1][YD1], ii2[XD2][YD2];
char pal1[768], pal2[768], ipal[768];

#define TESTFILE "tdfr8.hdf"
#define RESULT(a) printf("ret from %s is %d\n", a, ret)

main()
{
    int x,y;
    int ret, num_images=0;
    uint16 ref1, ref2, ref3;
    int32 xd, yd;
    int ispal;
    int error;

    for(x=0;x<XD1;x++)
       for (y=0;y<YD1;y++)
           im1[x][y] = (char)x+y;
    for(x=0;x<XD2;x++)
       for(y=0;y<YD2;y++)
           im2[x][y] = (char)x-y;
    for (x=0;x<256;x++) {
       pal1[3*x] = x;
       pal1[3*x + 1] = x;
       pal1[3*x + 2] = x;
       pal2[x] = x;
       pal2[x+256] = x;
       pal2[x+512] = x;
    }

    /* start here */
    puts("Setting palette 1");
    ret = DFR8setpalette(pal1);
    RESULT("DFR8setpalette");
    puts("Putting image 1 with pal 1, no compression in new file");
    ret = DFR8putimage(TESTFILE, (VOIDP)im1, XD1, YD1, 0);
    RESULT("DFR8putimage");
    num_images++;
    puts("Getting ref1");
    ref1 = DFR8lastref();
    printf("ref1 is %u\n\n", ref1);

    puts("Putting image 2 with pal 1, RLE compression");
    ret = DFR8addimage(TESTFILE, (VOIDP)im2, XD2, YD2, DFTAG_RLE);
    RESULT("DFR8addimage");
    num_images++;
    puts("Getting ref2");
    ref2 = DFR8lastref();
    printf("ref2 is %u\n\n", ref2);

    puts("Setting palette 2");
    ret = DFR8setpalette(pal2);
    RESULT("DFR8setpalette");
    puts("Putting image 2 with pal 2, imcomp");
    ret = DFR8addimage(TESTFILE, (VOIDP)im2, XD2, YD2, DFTAG_IMCOMP);
    RESULT("DFR8addimage");
    num_images++;
    puts("Getting ref3");
    ref3 = DFR8lastref();
    printf("ref3 is %u\n\n", ref3);

    puts("Getting number of images");
    ret = DFR8nimages(TESTFILE);
    RESULT("DFR8nimages");
    if (ret != num_images)
        printf("        >>> WRONG NUMBER OF IMAGES <<<\n");
    printf("\n");

    puts("Restarting file");
    ret = DFR8restart();
    RESULT("DFR8restart");
    printf("\n");

    puts("Getting dimensions of first image");
    ret = DFR8getdims(TESTFILE, &xd, &yd, &ispal);
    RESULT("DFR8getdims");
    puts("Getting image 1");
    ret = DFR8getimage(TESTFILE, (VOIDP)ii1, XD1, YD1, ipal);
    RESULT("DFR8getimage");
    error = FALSE;
    check_im_pal(XD1, YD1, xd, yd, (char **)im1, (char **)ii1, pal1, ipal);

    puts("Getting dimensions of image2");
    ret = DFR8getdims(TESTFILE, &xd, &yd, &ispal);
    RESULT("DFR8getdims");
    printf("xdim %d ydim %d ispal %d\n\n", xd, yd, ispal);

    puts("Getting dimensions of image3");
    ret = DFR8getdims(TESTFILE, &xd, &yd, &ispal);
    RESULT("DFR8getdims");
    printf("xdim %d ydim %d ispal %d\n", xd, yd, ispal);
    puts("Getting image 3");
    ret = DFR8getimage(TESTFILE, (VOIDP)ii2, XD2, YD2, ipal);
    RESULT("DFR8getimage");
    printf("\n");

    puts("Setting read ref2");
    ret = DFR8readref(TESTFILE, ref2);
    RESULT("DFR8readref");
    puts("Getting image 2");
    ret = DFR8getimage(TESTFILE, (VOIDP)ii2, XD2, YD2, ipal);
    RESULT("DFR8getimage");
    check_im_pal(XD2, YD2, XD2, YD2, (char **)im2, (char **)ii2, pal1, ipal);

    puts("Setting write ref3");
    ret = DFR8writeref(TESTFILE, ref3);
    RESULT("DFR8writeref");
    puts("Setting palette 2");
    ret = DFR8setpalette(pal2);
    RESULT("DFR8setpalette");
    puts("Putting image 1 with pal 2, RLE");
    ret = DFR8addimage(TESTFILE, (VOIDP)im1, XD1, YD1, DFTAG_RLE);
    RESULT("DFR8addimage");
    printf("\n");

    puts("Setting read ref3");
    ret = DFR8readref(TESTFILE, ref3);
    RESULT("DFR8readref");
    puts("Getting dimensions of first image");
    ret = DFR8getdims(TESTFILE, &xd, &yd, &ispal);
    RESULT("DFR8getdims");
    printf("xdim %d ydim %d ispal %d\n", xd, yd, ispal);
    puts("Getting image 1");
    ret = DFR8getimage(TESTFILE, (VOIDP)ii1, XD1, YD1, ipal);
    RESULT("DFR8getimage");
    check_im_pal(XD1, YD1, xd, yd, (char **)im1, (char **)ii1, pal2, ipal);

}

int check_im_pal(oldx, oldy, newx, newy, oldim, newim, oldpal, newpal)
    int oldx, oldy, newx, newy;
    char **oldim, **newim, *oldpal, *newpal;    
{
    int error;
    int x, y;
    uint8 *op, *np;

    printf("\nChecking image and palette.\n");

    op = (uint8 *)oldim;
    np = (uint8 *)newim;
    if ( newx!=oldx || newy != oldy)
        printf("        >>> DIMENSIONS WRONG <<<\n\n");
    error = FALSE;
    for (x=0;x<oldx;x++)
       for (y=0;y<oldy;y++) {
           if ( *op != *np) { 
               printf("\t>>>Error at %d %d, orig image=%d; new image=%d<<<\n",
                                                               x, y, *op, *np);
               error = TRUE;
           }
           op++;
           np++;
    }
    if (!error)
        printf("Image is correct.\n");

    error = FALSE;
    for (x=0;x<768;x++)
       if (oldpal[x] != newpal[x]) {
           printf("\t>>>Pal error at %d, orig pal %u new pal %u<<<\n",
                                                 x, oldpal[x], newpal[x]);
               error = TRUE;
       }
    if (!error)
        printf("Palette is correct.\n");
    printf("\n");
}
