      subroutine add_line
c
      logical line_dis
      common/lines/line_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            next_line,idash(40),iwid(40)
c
      call notify('Click and draw the rubber-banded line. ')
      call gen_line(x1(next_line),y1(next_line),
     &              x2(next_line),y2(next_line))
      call plot(x1(next_line),y1(next_line),3)
      call plot(x2(next_line),y2(next_line),2)
      line_dis(next_line) = .true.
      next_line = next_line + 1
      call notify('Line drawn. ')
      return
      end

c
c
      subroutine init_lines
c
      logical line_dis,arrow_dis
      common/lines/line_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            next_line,idash(40),iwid(40)
      common/heads/arrow_dis(40),xb(40),yb(40),xe(40),ye(40),
     &            next_head
c
      do i = 1, 40
         line_dis(i) = .false.
         arrow_dis(i) = .false.
         idash(i) = 0
         iwid(i) = 1
         x1(i) = 0.0
         y1(i) = 0.0
         x2(i) = 0.0
         y2(i) = 0.0
      enddo
      next_line = 1
      next_head = 1
      return
      end
c
c
      subroutine draw_lines
c
      logical line_dis
      common/lines/line_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            next_line,idash(40),iwid(40)
c
      do i = 1, next_line - 1
         if(line_dis(i)) then
            if(idash(i) .ne. 0) call setdash(idash(i))
            if(iwid(i) .ne. 1) call line_width(iwid(i))
            call plot(x1(i),y1(i),3)
            call plot(x2(i),y2(i),2)
            if(idash(i) .ne. 0) call setdash(0)
            call draw_heads(x1(i),y1(i))
            call draw_heads(x2(i),y2(i))
            if(iwid(i) .ne. 1) call line_width(1)
         endif
      enddo 
      return
      end
c
c
      subroutine delete_line(x,y,more)
c
      logical line_dis,more,vert
      common/lines/line_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            next_line,idash(40),iwid(40)
c
      do i = 1, next_line - 1
         call line_eq(x1(i),y1(i),x2(i),y2(i),slope,yint,vert)
         if(vert) then
            d = abs(x1(i) - x)
         else
            d = abs(slope*x - y + yint)/sqrt(slope**2 + 1.0)
         endif
         if(d .le. 0.25) then
            call delete_arrow(x1(i),y1(i))
            call delete_arrow(x2(i),y2(i))
            x1(i) = 0.0
            y1(i) = 0.0
            x2(i) = 0.0
            y2(i) = 0.0
            line_dis(i) = .false.
            idash(i) = 0
            iwid(i) = 1
            more = .false.
            call notify('Line deleted. ')
            return
         endif
      enddo
      more = .true.
      return
      end
c
      subroutine line_style(istyle)
c
      logical line_dis,vert
      common/lines/line_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            next_line,idash(40),iwid(40)
c
      call notify('Click on the line or arc to change the style. ')
      call getpoint(x,y,ibut)
      do i = 1, next_line - 1
         call line_eq(x1(i),y1(i),x2(i),y2(i),slope,yint,vert)
         if(vert) then
            d = abs(x1(i) - x)
         else
            d = abs(slope*x - y + yint)/sqrt(slope**2 + 1.0)
         endif
         if(d .le. 0.25) then
            if(istyle .ge. 10) then
               iwid(i) = istyle - 10
               call notify('Line width changed. ')
            else
               idash(i) = istyle
               call notify('Line style changed. ')
            endif
            return
         endif
      enddo
      call arc_style(x,y,istyle)
      return
      end
c
c
      subroutine add_arrow
      logical line_dis,inbox,arrow_dis
      common/lines/line_dis(40),x1(40),y1(40),x2(40),y2(40),
     &            next_line,idash(40),iwid(40)
      common/heads/arrow_dis(40),xb(40),yb(40),xe(40),ye(40),
     &            next_head
c
      call notify('Click on an endpoint to add an arrowhead. ')
      call getpoint(x,y,ibutton)
      do i = 1, next_line - 1
         xmin = x1(i) - 0.125
         ymin = y1(i) - 0.125
         xmax = x1(i) + 0.125
         ymax = y1(i) + 0.125
         if(inbox(x,y,xmin,ymin,xmax,ymax)) then
            call arrow_head(x2(i),y2(i),x1(i),y1(i))
            xb(next_head) = x2(i)
            yb(next_head) = y2(i)
            xe(next_head) = x1(i)
            ye(next_head) = y1(i)
            arrow_dis(next_head) = .true.
            next_head = next_head + 1
            call notify('Added arrowhead to line. ')
            return
         else
            xmin = x2(i) - 0.125
            ymin = y2(i) - 0.125
            xmax = x2(i) + 0.125
            ymax = y2(i) + 0.125
            if(inbox(x,y,xmin,ymin,xmax,ymax)) then
               call arrow_head(x1(i),y1(i),x2(i),y2(i))
               xb(next_head) = x1(i)
               yb(next_head) = y1(i)
               xe(next_head) = x2(i)
               ye(next_head) = y2(i)
               arrow_dis(next_head) = .true.
               next_head = next_head + 1
               call notify('Added arrowhead to line. ')
               return
            endif
         endif
      enddo
      call arc_arrow(x,y)
      return
      end
c
c
      subroutine draw_heads(x,y)
      logical arrow_dis
      common/heads/arrow_dis(40),xb(40),yb(40),xe(40),ye(40),
     &            next_head
c
c
      do i = 1, next_head - 1
         xmin = xe(i) - 0.125
         ymin = ye(i) - 0.125
         xmax = xe(i) + 0.125
         ymax = ye(i) + 0.125
         if(inbox(x,y,xmin,ymin,xmax,ymax)) then
            if(arrow_dis(i)) then
               call arrow_head(xb(i),yb(i),xe(i),ye(i))
            endif
         endif
      enddo 
      return
      end
c
c
      subroutine delete_arrow(x,y)
      logical inbox,arrow_dis
      common/heads/arrow_dis(40),xb(40),yb(40),xe(40),ye(40),
     &            next_head
c
      do i = 1, next_head - 1
         xmin = xe(i) - 0.125
         ymin = ye(i) - 0.125
         xmax = xe(i) + 0.125
         ymax = ye(i) + 0.125
         if(inbox(x,y,xmin,ymin,xmax,ymax)) then
            arrow_dis(i) = .false.
            return
         endif
      enddo
      return
      end
c
c
      subroutine arrow_head(x1,y1,x2,y2)
c
      real lx
      aw = 0.075
      ah = 0.05
      dx = x2 - x1
      dy = y1 - y2
      lx = sqrt(dx**2 + dy**2)
      sina = dy / lx
      cosa = dx / lx
      xb = x2*cosa - y2*sina
      yb = x2*sina + y2*cosa
      x = xb - aw
      y = yb - ah 
      xc = x*cosa + y*sina
      yc = -x*sina + y*cosa
      y = yb + ah
      xd = x*cosa + y*sina
      yd = -x*sina + y*cosa
      call plot(xc,yc,3)
      call plot(x2,y2,2)
      call plot(xd,yd,2)
      return
      end
