      subroutine symbol(x,y,h,string,theta,n)
      implicit real (a-h,o-z)
c
c Draw the specified symbol using hardware generated characters.
c
c James Blake
c @(#)symbol.f	1.1  4/3/89 
c

      character*(*) string
      include 'device_type.h'
      common /tscale/ sfactt
      common /cqpbnf/ xold, yold, fac, ires
      common/local_color/gray_level
c
c Courier font fudge factor to get proper heigh
c
      save  cfudge
      data  cfudge /1.66666666/
C
C
C   Bad input check
C
      if (n .lt. -2 .or. h .le. 0.0) return
c
c Check for calcomp style on-center symbols.
c
      if(ichar(string(1:1)).ge.0 .and. ichar(string(1:1)).le.28) then
         call oncenter(x,y,h,string,theta,n)
         return
      endif
      if (color_ws .or. mono_ws) then
         call set_char(h,theta)
         ih = screenx(x)
         iy = screeny(y)
c
c Output the string.
c
         call cftext(ih,iy,string(1:n)//char(0))
      elseif (PostScript) then
C
C   Initialize lots of stuff
C
         nch = n
         call plot (x, y, 3)
C
C Set the color
C
         call plfout (gray_level)
         call plcout (char(32))
         call plsout ("setgray\n")
C
C   Round angle to integer - good to 1 degree
C
         intang = nint(theta)
         cosang = cosd(float(intang))
         sinang = sind(float(intang))
C
C   Plot a string of characters
C
         if (nch .gt. 0) then
C
C     Set char angle
C
             if (intang .ne. 0) then
               call pliout (intang)
               call plsout (" RS ")
             end if
C
C     Output "(string) S ", escape ( ) characters. 
C
             call spec_str(h,string,nch)
C
C       Update our idea of where the pen is.
C
             xold = x + (nch * h * fac * cosang)
             yold = y + (nch * h * fac * sinang)
C
C     Undo character angle
C
             if (intang .ne. 0) then
               call plsout ("RE\n")
             else
               call plcout (char(10))
             endif
         end if
         gray_level = 0.0
      endif
      return
      end
