      subroutine polygon(vertx,verty,n)
c
c This routine will draw a filled polygon  
c using the current fill color.
c
c James Blake
c @(#)polygon.f	1.1  4/3/89 
c
      include 'device_type.h'
      common/local_color/gray_level
      common /cqpbnf/ xold, yold, fac, ires
      dimension ixc(100), iyc(100), vertx(n), verty(n)
c
      if (color_ws .or. mono_ws) then
         if (n .gt. 100) return
         do i = 1, n
            ixc(i) = screenx(vertx(i))
            iyc(i) = screeny(verty(i))
         enddo
         call cfpolygon(ixc,iyc,n)
      elseif (PostScript) then
c
         call plsout ("newpath\n")
         call plfout (gray_level)
         call plcout (char(32))
         call plsout ("setgray\n")
c
c Move to the first vertex.
c
         do j = 1, 2
            call pliout (nint (vertx(1)*fac*ires))
            call plcout (char(32))
            call pliout (nint (verty(1)*fac*ires))
            call plcout (char(32))
            call plsout ("M\n")
c
c Draw lines to each of the following verticies.
c
            do i = 2, n
               call pliout (nint (vertx(i)*fac*ires))
               call plcout (char(32))
               call pliout (nint (verty(i)*fac*ires))
               call plcout (char(32))
               call plsout ("L\n")
            enddo
            call plsout ("closepath\n")
            if (j .eq. 1) then
               call plsout ("fill\n")
            else
               call plsout ("0.0 setgray stroke\n")
            endif
         enddo
C
         gray_level = 0.0
      endif
      return
      end
