      subroutine polycolor(ipen)
c
c Change the fill color of a polygon as defined by the colors in newpen.
c The colors are:
c 		1	black
c		2	red
c		3	yellow
c		4	green
c		5	cyan
c		6	blue
c		7	magenta
c		8	white
c
c James Blake
c @(#)polycolor.f	1.1  4/3/89 
c
      include 'device_type.h'
      common/local_color/gray_level
C
      if (color_ws .or. mono_ws) then
         npen = ipen - 1
         if (color_ws) then
            if( npen .lt. 0 .or. npen .gt. 7 ) npen = 0
            call cfintstyle(1,1)
            call cfflcolor(npen)
         else
            if( npen .lt. 0 .or. npen .gt. 7 ) npen = 0
            if(npen .eq. 1) then
               call cfintstyle(3,1)
               call cfhatchix(3)
            elseif(npen .eq. 4 .or. npen .eq. 6) then
               call cfintstyle(3,1)
               call cfhatchix(1)
            elseif(npen .eq. 5) then
               call cfintstyle(1,1)
               call cfflcolor(1)
            else
               call cfintstyle(1,1)
               call cfflcolor(0)
            endif
         endif
      elseif (PostScript) then
c
c Simulate the range of colors used by the SunCGI library.
c
c Black = 0
c White = 1
c
         npen = ipen
         if (npen .lt. 1) npen = 1 
         gray_level = (npen - 1.0) / 7.0
       endif
      return
      end
