/* Simulator instruction semantics for arm.

THIS FILE IS MACHINE GENERATED WITH CGEN.

Copyright (C) 2000, 2001, 2002, 2003 Red Hat, Inc.

This file is part of the Red Hat simulators.


*/


#include "arm7f.h"

using namespace arm7f; // FIXME: namespace organization still wip

#define GET_ATTR(name) GET_ATTR_##name ()


namespace arm7f {

/* Enum declaration for semantic fragments in cpu family arm.  */
typedef enum arm_frag_type {
  ARM_FRAG_LIST_END, ARM_FRAG_MVN_REG_REG_SHIFT_HDR, ARM_FRAG_CMP_REG_REG_SHIFT_HDR, ARM_FRAG_TST_REG_REG_SHIFT_HDR
 , ARM_FRAG_ORR_REG_REG_SHIFT_HDR, ARM_FRAG_MVN_REG_IMM_SHIFT_HDR, ARM_FRAG_CMP_REG_IMM_SHIFT_HDR, ARM_FRAG_TST_REG_IMM_SHIFT_HDR
 , ARM_FRAG_ORR_REG_IMM_SHIFT_HDR, ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR, ARM_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_HDR
 , ARM_FRAG_STR_POST_DEC_REG_OFFSET_HDR, ARM_FRAG_LDR_POST_DEC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_STMDA_WB_HDR, ARM_FRAG_STMIA_WB_HDR
 , ARM_FRAG_STMIB_WB_HDR, ARM_FRAG_STMDB_WB_HDR, ARM_FRAG_LDMIA_WB_HDR, ARM_FRAG_LDMIB_WB_HDR
 , ARM_FRAG_STRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR, ARM_FRAG_LDRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR, ARM_FRAG_LDR_POST_DEC_NONPRIV_IMM_OFFSET_HDR, ARM_FRAG_X_HEADER
 , ARM_FRAG_TST_REG_REG_SHIFT_TRLR, ARM_FRAG_TEQ_REG_IMM_SHIFT_TRLR, ARM_FRAG_AND_IMM_TRLR, ARM_FRAG_AND_REG_REG_SHIFT_TRLR
 , ARM_FRAG_ORR_REG_IMM_SHIFT_TRLR, ARM_FRAG_UMULL_TRLR, ARM_FRAG_LDR_PRE_INC_IMM_OFFSET_TRLR, ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_TRLR
 , ARM_FRAG_STR_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_STR_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_STRH_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_TRLR
 , ARM_FRAG_LDR_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LDR_PRE_INC_REG_OFFSET_TRLR, ARM_FRAG_LDR_PRE_INC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_TRLR
 , ARM_FRAG_STR_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_STR_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_STRH_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_TRLR
 , ARM_FRAG_LDR_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LDR_PRE_INC_WB_REG_OFFSET_TRLR, ARM_FRAG_STRB_POST_INC_REG_OFFSET_TRLR, ARM_FRAG_STR_POST_INC_REG_OFFSET_TRLR
 , ARM_FRAG_STR_POST_INC_IMM_OFFSET_TRLR, ARM_FRAG_LDRB_POST_INC_REG_OFFSET_TRLR, ARM_FRAG_STRB_POST_DEC_REG_OFFSET_TRLR, ARM_FRAG_STR_POST_DEC_REG_OFFSET_TRLR
 , ARM_FRAG_STR_POST_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LDRB_POST_DEC_REG_OFFSET_TRLR, ARM_FRAG_X_TRAILER, ARM_FRAG_X_COND_MID
 , ARM_FRAG_X_AFTER_MID, ARM_FRAG_X_BEFORE_MID, ARM_FRAG_X_CTI_CHAIN_MID, ARM_FRAG_X_CHAIN_MID
 , ARM_FRAG_X_BEGIN_MID, ARM_FRAG_X_INVALID_MID, ARM_FRAG_B_MID, ARM_FRAG_BL_MID
 , ARM_FRAG_BX_MID, ARM_FRAG_LDR_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LDR_POST_DEC_REG_OFFSET_MID, ARM_FRAG_LDR_POST_INC_IMM_OFFSET_MID
 , ARM_FRAG_LDR_POST_INC_REG_OFFSET_MID, ARM_FRAG_LDR_POST_DEC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_LDR_POST_DEC_NONPRIV_REG_OFFSET_MID, ARM_FRAG_LDR_POST_INC_NONPRIV_IMM_OFFSET_MID
 , ARM_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_MID, ARM_FRAG_LDR_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_LDR_PRE_DEC_REG_OFFSET_MID, ARM_FRAG_LDR_PRE_INC_IMM_OFFSET_MID
 , ARM_FRAG_LDR_PRE_INC_REG_OFFSET_MID, ARM_FRAG_LDR_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_MID, ARM_FRAG_LDR_PRE_INC_WB_IMM_OFFSET_MID
 , ARM_FRAG_LDR_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_LDRB_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LDRB_POST_INC_IMM_OFFSET_MID, ARM_FRAG_LDRB_POST_DEC_NONPRIV_IMM_OFFSET_MID
 , ARM_FRAG_LDRB_POST_INC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_INC_IMM_OFFSET_MID
 , ARM_FRAG_LDRB_PRE_INC_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_INC_WB_IMM_OFFSET_MID
 , ARM_FRAG_LDRB_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_STR_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_STR_POST_INC_IMM_OFFSET_MID, ARM_FRAG_STR_POST_DEC_NONPRIV_IMM_OFFSET_MID
 , ARM_FRAG_STR_POST_INC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_REG_OFFSET_MID, ARM_FRAG_STR_PRE_INC_IMM_OFFSET_MID
 , ARM_FRAG_STR_PRE_INC_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_REG_OFFSET_MID, ARM_FRAG_STR_PRE_INC_WB_IMM_OFFSET_MID
 , ARM_FRAG_STR_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_STRB_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_STRB_POST_INC_IMM_OFFSET_MID, ARM_FRAG_STRB_POST_DEC_NONPRIV_IMM_OFFSET_MID
 , ARM_FRAG_STRB_POST_INC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_MID, ARM_FRAG_STRB_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_STRB_PRE_DEC_REG_OFFSET_MID
 , ARM_FRAG_STRB_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_STRB_PRE_INC_REG_OFFSET_MID, ARM_FRAG_STRB_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_STRB_PRE_DEC_WB_REG_OFFSET_MID
 , ARM_FRAG_STRB_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_STRB_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_STRH_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_STRH_PRE_DEC_REG_OFFSET_MID
 , ARM_FRAG_STRH_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_STRH_PRE_INC_REG_OFFSET_MID, ARM_FRAG_STRH_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_STRH_PRE_DEC_WB_REG_OFFSET_MID
 , ARM_FRAG_STRH_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_STRH_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_STRH_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_STRH_POST_DEC_REG_OFFSET_MID
 , ARM_FRAG_STRH_POST_INC_IMM_OFFSET_MID, ARM_FRAG_STRH_POST_INC_REG_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_REG_OFFSET_MID
 , ARM_FRAG_LDRSB_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_INC_REG_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_WB_REG_OFFSET_MID
 , ARM_FRAG_LDRSB_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_LDRSB_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LDRSB_POST_DEC_REG_OFFSET_MID
 , ARM_FRAG_LDRSB_POST_INC_IMM_OFFSET_MID, ARM_FRAG_LDRSB_POST_INC_REG_OFFSET_MID, ARM_FRAG_LDRH_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_LDRH_PRE_DEC_REG_OFFSET_MID
 , ARM_FRAG_LDRH_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_LDRH_PRE_INC_REG_OFFSET_MID, ARM_FRAG_LDRH_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRH_PRE_DEC_WB_REG_OFFSET_MID
 , ARM_FRAG_LDRH_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRH_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_LDRH_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LDRH_POST_DEC_REG_OFFSET_MID
 , ARM_FRAG_LDRH_POST_INC_IMM_OFFSET_MID, ARM_FRAG_LDRH_POST_INC_REG_OFFSET_MID, ARM_FRAG_LDRSH_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_LDRSH_PRE_DEC_REG_OFFSET_MID
 , ARM_FRAG_LDRSH_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_LDRSH_PRE_INC_REG_OFFSET_MID, ARM_FRAG_LDRSH_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRSH_PRE_DEC_WB_REG_OFFSET_MID
 , ARM_FRAG_LDRSH_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRSH_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_LDRSH_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LDRSH_POST_DEC_REG_OFFSET_MID
 , ARM_FRAG_LDRSH_POST_INC_IMM_OFFSET_MID, ARM_FRAG_LDRSH_POST_INC_REG_OFFSET_MID, ARM_FRAG_MUL_MID, ARM_FRAG_MLA_MID
 , ARM_FRAG_UMULL_MID, ARM_FRAG_UMLAL_MID, ARM_FRAG_SMULL_MID, ARM_FRAG_SMLAL_MID
 , ARM_FRAG_SWP_MID, ARM_FRAG_SWPB_MID, ARM_FRAG_SWI_MID, ARM_FRAG_AND_REG_IMM_SHIFT_MID
 , ARM_FRAG_AND_REG_REG_SHIFT_MID, ARM_FRAG_AND_IMM_MID, ARM_FRAG_ORR_REG_IMM_SHIFT_MID, ARM_FRAG_ORR_REG_REG_SHIFT_MID
 , ARM_FRAG_ORR_IMM_MID, ARM_FRAG_EOR_REG_IMM_SHIFT_MID, ARM_FRAG_EOR_REG_REG_SHIFT_MID, ARM_FRAG_EOR_IMM_MID
 , ARM_FRAG_MOV_REG_IMM_SHIFT_MID, ARM_FRAG_MOV_REG_REG_SHIFT_MID, ARM_FRAG_MOV_IMM_MID, ARM_FRAG_BIC_REG_IMM_SHIFT_MID
 , ARM_FRAG_BIC_REG_REG_SHIFT_MID, ARM_FRAG_BIC_IMM_MID, ARM_FRAG_MVN_REG_IMM_SHIFT_MID, ARM_FRAG_MVN_REG_REG_SHIFT_MID
 , ARM_FRAG_MVN_IMM_MID, ARM_FRAG_ADD_REG_IMM_SHIFT_MID, ARM_FRAG_ADD_REG_REG_SHIFT_MID, ARM_FRAG_ADD_IMM_MID
 , ARM_FRAG_ADC_REG_IMM_SHIFT_MID, ARM_FRAG_ADC_REG_REG_SHIFT_MID, ARM_FRAG_ADC_IMM_MID, ARM_FRAG_SUB_REG_IMM_SHIFT_MID
 , ARM_FRAG_SUB_REG_REG_SHIFT_MID, ARM_FRAG_SUB_IMM_MID, ARM_FRAG_SBC_REG_IMM_SHIFT_MID, ARM_FRAG_SBC_REG_REG_SHIFT_MID
 , ARM_FRAG_SBC_IMM_MID, ARM_FRAG_RSB_REG_IMM_SHIFT_MID, ARM_FRAG_RSB_REG_REG_SHIFT_MID, ARM_FRAG_RSB_IMM_MID
 , ARM_FRAG_RSC_REG_IMM_SHIFT_MID, ARM_FRAG_RSC_REG_REG_SHIFT_MID, ARM_FRAG_RSC_IMM_MID, ARM_FRAG_TST_REG_IMM_SHIFT_MID
 , ARM_FRAG_TST_REG_REG_SHIFT_MID, ARM_FRAG_TST_IMM_MID, ARM_FRAG_TEQ_REG_IMM_SHIFT_MID, ARM_FRAG_TEQ_REG_REG_SHIFT_MID
 , ARM_FRAG_TEQ_IMM_MID, ARM_FRAG_CMP_REG_IMM_SHIFT_MID, ARM_FRAG_CMP_REG_REG_SHIFT_MID, ARM_FRAG_CMP_IMM_MID
 , ARM_FRAG_CMN_REG_IMM_SHIFT_MID, ARM_FRAG_CMN_REG_REG_SHIFT_MID, ARM_FRAG_CMN_IMM_MID, ARM_FRAG_LDMDA_MID
 , ARM_FRAG_LDMDA_SW_MID, ARM_FRAG_LDMDA_WB_MID, ARM_FRAG_LDMDA_SW_WB_MID, ARM_FRAG_LDMIB_MID
 , ARM_FRAG_LDMIB_SW_MID, ARM_FRAG_LDMIB_WB_MID, ARM_FRAG_LDMIB_SW_WB_MID, ARM_FRAG_LDMIA_MID
 , ARM_FRAG_LDMIA_SW_MID, ARM_FRAG_LDMIA_WB_MID, ARM_FRAG_LDMIA_SW_WB_MID, ARM_FRAG_LDMDB_MID
 , ARM_FRAG_LDMDB_SW_MID, ARM_FRAG_LDMDB_WB_MID, ARM_FRAG_LDMDB_SW_WB_MID, ARM_FRAG_STMDB_MID
 , ARM_FRAG_STMDB_SW_MID, ARM_FRAG_STMDB_WB_MID, ARM_FRAG_STMDB_SW_WB_MID, ARM_FRAG_STMIB_MID
 , ARM_FRAG_STMIB_SW_MID, ARM_FRAG_STMIB_WB_MID, ARM_FRAG_STMIB_SW_WB_MID, ARM_FRAG_STMIA_MID
 , ARM_FRAG_STMIA_SW_MID, ARM_FRAG_STMIA_WB_MID, ARM_FRAG_STMIA_SW_WB_MID, ARM_FRAG_STMDA_MID
 , ARM_FRAG_STMDA_SW_MID, ARM_FRAG_STMDA_WB_MID, ARM_FRAG_STMDA_SW_WB_MID, ARM_FRAG_MRS_C_MID
 , ARM_FRAG_MRS_S_MID, ARM_FRAG_MSR_C_MID, ARM_FRAG_MSR_S_MID, ARM_FRAG_MAX
} ARM_FRAG_TYPE;

struct arm_insn_frag {
  ARM_INSN_TYPE itype;
  // 4: header+middle+trailer+delimiter
  ARM_FRAG_TYPE ftype[4];
};

struct arm_pbb_label {
  ARM_FRAG_TYPE frag;
  void *label;
};

} // end arm7f namespace

// Table of frags used by each insn.

extern const arm_insn_frag arm_frag_usage[] = {
  { ARM_INSN_X_COND, ARM_FRAG_X_COND_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_X_AFTER, ARM_FRAG_X_AFTER_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_X_BEFORE, ARM_FRAG_X_BEFORE_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_X_CTI_CHAIN, ARM_FRAG_X_CTI_CHAIN_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_X_CHAIN, ARM_FRAG_X_CHAIN_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_X_BEGIN, ARM_FRAG_X_BEGIN_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_X_INVALID, ARM_FRAG_X_INVALID_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_B, ARM_FRAG_B_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_BL, ARM_FRAG_BL_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_BX, ARM_FRAG_BX_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_POST_DEC_IMM_OFFSET, ARM_FRAG_LDR_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_POST_DEC_REG_OFFSET, ARM_FRAG_LDR_POST_DEC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_POST_INC_IMM_OFFSET, ARM_FRAG_LDR_POST_DEC_NONPRIV_IMM_OFFSET_HDR, ARM_FRAG_LDR_POST_INC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_POST_INC_REG_OFFSET, ARM_FRAG_LDR_POST_DEC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_LDR_POST_INC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_POST_DEC_NONPRIV_IMM_OFFSET, ARM_FRAG_LDR_POST_DEC_NONPRIV_IMM_OFFSET_HDR, ARM_FRAG_LDR_POST_DEC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_POST_DEC_NONPRIV_REG_OFFSET, ARM_FRAG_LDR_POST_DEC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_LDR_POST_DEC_NONPRIV_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_POST_INC_NONPRIV_IMM_OFFSET, ARM_FRAG_LDR_POST_INC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_POST_INC_NONPRIV_REG_OFFSET, ARM_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_PRE_DEC_IMM_OFFSET, ARM_FRAG_LDR_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_LDR_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_PRE_DEC_REG_OFFSET, ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR, ARM_FRAG_LDR_PRE_DEC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_PRE_INC_IMM_OFFSET, ARM_FRAG_LDR_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_LDR_PRE_INC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_PRE_INC_REG_OFFSET, ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR, ARM_FRAG_LDR_PRE_INC_REG_OFFSET_MID, ARM_FRAG_LDR_PRE_INC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_PRE_DEC_WB_IMM_OFFSET, ARM_FRAG_LDR_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_LDR_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_PRE_DEC_WB_REG_OFFSET, ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR, ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_PRE_INC_WB_IMM_OFFSET, ARM_FRAG_LDR_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_LDR_PRE_INC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDR_PRE_INC_WB_REG_OFFSET, ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR, ARM_FRAG_LDR_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_LDR_PRE_INC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_POST_DEC_IMM_OFFSET, ARM_FRAG_LDRB_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_POST_DEC_REG_OFFSET, ARM_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_LDRB_POST_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_POST_INC_IMM_OFFSET, ARM_FRAG_LDRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR, ARM_FRAG_LDRB_POST_INC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_POST_INC_REG_OFFSET, ARM_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_LDRB_POST_INC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_POST_DEC_NONPRIV_IMM_OFFSET, ARM_FRAG_LDRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR, ARM_FRAG_LDRB_POST_DEC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_POST_DEC_NONPRIV_REG_OFFSET, ARM_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_LDRB_POST_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_POST_INC_NONPRIV_IMM_OFFSET, ARM_FRAG_LDRB_POST_INC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_POST_INC_NONPRIV_REG_OFFSET, ARM_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_LDRB_POST_INC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_PRE_DEC_IMM_OFFSET, ARM_FRAG_LDRB_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_LDR_PRE_INC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_PRE_DEC_REG_OFFSET, ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR, ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_PRE_INC_IMM_OFFSET, ARM_FRAG_LDRB_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_LDR_PRE_INC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_PRE_INC_REG_OFFSET, ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR, ARM_FRAG_LDRB_PRE_INC_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_PRE_DEC_WB_IMM_OFFSET, ARM_FRAG_LDRB_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_LDR_PRE_INC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_PRE_DEC_WB_REG_OFFSET, ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR, ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_PRE_INC_WB_IMM_OFFSET, ARM_FRAG_LDRB_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_LDR_PRE_INC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRB_PRE_INC_WB_REG_OFFSET, ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR, ARM_FRAG_LDRB_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_POST_DEC_IMM_OFFSET, ARM_FRAG_STR_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_STR_POST_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_POST_DEC_REG_OFFSET, ARM_FRAG_STR_POST_DEC_REG_OFFSET_HDR, ARM_FRAG_STR_POST_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_POST_INC_IMM_OFFSET, ARM_FRAG_STR_POST_INC_IMM_OFFSET_MID, ARM_FRAG_STR_POST_INC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_POST_INC_REG_OFFSET, ARM_FRAG_STR_POST_DEC_REG_OFFSET_HDR, ARM_FRAG_STR_POST_INC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_POST_DEC_NONPRIV_IMM_OFFSET, ARM_FRAG_STR_POST_DEC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_POST_DEC_NONPRIV_REG_OFFSET, ARM_FRAG_STR_POST_DEC_REG_OFFSET_HDR, ARM_FRAG_STR_POST_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_POST_INC_NONPRIV_IMM_OFFSET, ARM_FRAG_STR_POST_INC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_POST_INC_NONPRIV_REG_OFFSET, ARM_FRAG_STR_POST_DEC_REG_OFFSET_HDR, ARM_FRAG_STR_POST_INC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_PRE_DEC_IMM_OFFSET, ARM_FRAG_STR_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_PRE_DEC_REG_OFFSET, ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_STR_PRE_DEC_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_PRE_INC_IMM_OFFSET, ARM_FRAG_STR_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_PRE_INC_REG_OFFSET, ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_STR_PRE_INC_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_PRE_DEC_WB_IMM_OFFSET, ARM_FRAG_STR_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_PRE_DEC_WB_REG_OFFSET, ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_STR_PRE_DEC_WB_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_PRE_INC_WB_IMM_OFFSET, ARM_FRAG_STR_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STR_PRE_INC_WB_REG_OFFSET, ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_STR_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_POST_DEC_IMM_OFFSET, ARM_FRAG_STRB_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_POST_DEC_REG_OFFSET, ARM_FRAG_STR_POST_DEC_REG_OFFSET_HDR, ARM_FRAG_STRB_POST_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_POST_INC_IMM_OFFSET, ARM_FRAG_STRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR, ARM_FRAG_STRB_POST_INC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_POST_INC_REG_OFFSET, ARM_FRAG_STR_POST_DEC_REG_OFFSET_HDR, ARM_FRAG_STRB_POST_INC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_POST_DEC_NONPRIV_IMM_OFFSET, ARM_FRAG_STRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR, ARM_FRAG_STRB_POST_DEC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_POST_DEC_NONPRIV_REG_OFFSET, ARM_FRAG_STR_POST_DEC_REG_OFFSET_HDR, ARM_FRAG_STRB_POST_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_POST_INC_NONPRIV_IMM_OFFSET, ARM_FRAG_STRB_POST_INC_NONPRIV_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_POST_INC_NONPRIV_REG_OFFSET, ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_MID, ARM_FRAG_STRB_POST_INC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_PRE_DEC_IMM_OFFSET, ARM_FRAG_STRB_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_PRE_DEC_REG_OFFSET, ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_STRB_PRE_DEC_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_PRE_INC_IMM_OFFSET, ARM_FRAG_STRB_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_PRE_INC_REG_OFFSET, ARM_FRAG_STRB_PRE_INC_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_PRE_DEC_WB_IMM_OFFSET, ARM_FRAG_STRB_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_PRE_DEC_WB_REG_OFFSET, ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_STRB_PRE_DEC_WB_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_PRE_INC_WB_IMM_OFFSET, ARM_FRAG_STRB_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRB_PRE_INC_WB_REG_OFFSET, ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR, ARM_FRAG_STRB_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_PRE_DEC_IMM_OFFSET, ARM_FRAG_STRH_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_STRH_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_PRE_DEC_REG_OFFSET, ARM_FRAG_STRH_PRE_DEC_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_PRE_INC_IMM_OFFSET, ARM_FRAG_STRH_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_STRH_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_PRE_INC_REG_OFFSET, ARM_FRAG_STRH_PRE_INC_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_PRE_DEC_WB_IMM_OFFSET, ARM_FRAG_STRH_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_STRH_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_PRE_DEC_WB_REG_OFFSET, ARM_FRAG_STRH_PRE_DEC_WB_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_PRE_INC_WB_IMM_OFFSET, ARM_FRAG_STRH_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_STRH_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_PRE_INC_WB_REG_OFFSET, ARM_FRAG_STRH_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_STR_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_POST_DEC_IMM_OFFSET, ARM_FRAG_STRH_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_POST_DEC_REG_OFFSET, ARM_FRAG_STRH_POST_DEC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_POST_INC_IMM_OFFSET, ARM_FRAG_STRH_POST_INC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STRH_POST_INC_REG_OFFSET, ARM_FRAG_STRH_POST_INC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_PRE_DEC_IMM_OFFSET, ARM_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_PRE_DEC_REG_OFFSET, ARM_FRAG_LDRSB_PRE_DEC_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_PRE_INC_IMM_OFFSET, ARM_FRAG_LDRSB_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_PRE_INC_REG_OFFSET, ARM_FRAG_LDRSB_PRE_INC_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_PRE_DEC_WB_IMM_OFFSET, ARM_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_PRE_DEC_WB_REG_OFFSET, ARM_FRAG_LDRSB_PRE_DEC_WB_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_PRE_INC_WB_IMM_OFFSET, ARM_FRAG_LDRSB_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_PRE_INC_WB_REG_OFFSET, ARM_FRAG_LDRSB_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_POST_DEC_IMM_OFFSET, ARM_FRAG_LDRSB_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_POST_DEC_REG_OFFSET, ARM_FRAG_LDRSB_POST_DEC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_POST_INC_IMM_OFFSET, ARM_FRAG_LDRSB_POST_INC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSB_POST_INC_REG_OFFSET, ARM_FRAG_LDRSB_POST_INC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_PRE_DEC_IMM_OFFSET, ARM_FRAG_LDRH_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_PRE_DEC_REG_OFFSET, ARM_FRAG_LDRH_PRE_DEC_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_PRE_INC_IMM_OFFSET, ARM_FRAG_LDRH_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_PRE_INC_REG_OFFSET, ARM_FRAG_LDRH_PRE_INC_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_PRE_DEC_WB_IMM_OFFSET, ARM_FRAG_LDRH_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_PRE_DEC_WB_REG_OFFSET, ARM_FRAG_LDRH_PRE_DEC_WB_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_PRE_INC_WB_IMM_OFFSET, ARM_FRAG_LDRH_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_PRE_INC_WB_REG_OFFSET, ARM_FRAG_LDRH_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_POST_DEC_IMM_OFFSET, ARM_FRAG_LDRH_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_POST_DEC_REG_OFFSET, ARM_FRAG_LDRH_POST_DEC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_POST_INC_IMM_OFFSET, ARM_FRAG_LDRH_POST_INC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRH_POST_INC_REG_OFFSET, ARM_FRAG_LDRH_POST_INC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_PRE_DEC_IMM_OFFSET, ARM_FRAG_LDRSH_PRE_DEC_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_PRE_DEC_REG_OFFSET, ARM_FRAG_LDRSH_PRE_DEC_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_PRE_INC_IMM_OFFSET, ARM_FRAG_LDRSH_PRE_INC_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_PRE_INC_REG_OFFSET, ARM_FRAG_LDRSH_PRE_INC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_PRE_DEC_WB_IMM_OFFSET, ARM_FRAG_LDRSH_PRE_DEC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_PRE_DEC_WB_REG_OFFSET, ARM_FRAG_LDRSH_PRE_DEC_WB_REG_OFFSET_MID, ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_PRE_INC_WB_IMM_OFFSET, ARM_FRAG_LDRSH_PRE_INC_WB_IMM_OFFSET_MID, ARM_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_PRE_INC_WB_REG_OFFSET, ARM_FRAG_LDRSH_PRE_INC_WB_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_POST_DEC_IMM_OFFSET, ARM_FRAG_LDRSH_POST_DEC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_POST_DEC_REG_OFFSET, ARM_FRAG_LDRSH_POST_DEC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_POST_INC_IMM_OFFSET, ARM_FRAG_LDRSH_POST_INC_IMM_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDRSH_POST_INC_REG_OFFSET, ARM_FRAG_LDRSH_POST_INC_REG_OFFSET_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_MUL, ARM_FRAG_MUL_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_MLA, ARM_FRAG_MLA_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_UMULL, ARM_FRAG_UMULL_MID, ARM_FRAG_UMULL_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_UMLAL, ARM_FRAG_UMLAL_MID, ARM_FRAG_UMULL_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_SMULL, ARM_FRAG_SMULL_MID, ARM_FRAG_UMULL_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_SMLAL, ARM_FRAG_SMLAL_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_SWP, ARM_FRAG_SWP_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_SWPB, ARM_FRAG_SWPB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_SWI, ARM_FRAG_SWI_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_AND_REG_IMM_SHIFT, ARM_FRAG_AND_REG_IMM_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_AND_REG_REG_SHIFT, ARM_FRAG_AND_REG_REG_SHIFT_MID, ARM_FRAG_AND_REG_REG_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_AND_IMM, ARM_FRAG_AND_IMM_MID, ARM_FRAG_AND_IMM_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_ORR_REG_IMM_SHIFT, ARM_FRAG_ORR_REG_IMM_SHIFT_HDR, ARM_FRAG_ORR_REG_IMM_SHIFT_MID, ARM_FRAG_ORR_REG_IMM_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_ORR_REG_REG_SHIFT, ARM_FRAG_ORR_REG_REG_SHIFT_HDR, ARM_FRAG_ORR_REG_REG_SHIFT_MID, ARM_FRAG_AND_REG_REG_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_ORR_IMM, ARM_FRAG_ORR_IMM_MID, ARM_FRAG_AND_IMM_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_EOR_REG_IMM_SHIFT, ARM_FRAG_ORR_REG_IMM_SHIFT_HDR, ARM_FRAG_EOR_REG_IMM_SHIFT_MID, ARM_FRAG_ORR_REG_IMM_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_EOR_REG_REG_SHIFT, ARM_FRAG_ORR_REG_REG_SHIFT_HDR, ARM_FRAG_EOR_REG_REG_SHIFT_MID, ARM_FRAG_AND_REG_REG_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_EOR_IMM, ARM_FRAG_EOR_IMM_MID, ARM_FRAG_AND_IMM_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_MOV_REG_IMM_SHIFT, ARM_FRAG_ORR_REG_IMM_SHIFT_HDR, ARM_FRAG_MOV_REG_IMM_SHIFT_MID, ARM_FRAG_ORR_REG_IMM_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_MOV_REG_REG_SHIFT, ARM_FRAG_ORR_REG_REG_SHIFT_HDR, ARM_FRAG_MOV_REG_REG_SHIFT_MID, ARM_FRAG_AND_REG_REG_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_MOV_IMM, ARM_FRAG_MOV_IMM_MID, ARM_FRAG_AND_IMM_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_BIC_REG_IMM_SHIFT, ARM_FRAG_ORR_REG_IMM_SHIFT_HDR, ARM_FRAG_BIC_REG_IMM_SHIFT_MID, ARM_FRAG_ORR_REG_IMM_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_BIC_REG_REG_SHIFT, ARM_FRAG_ORR_REG_REG_SHIFT_HDR, ARM_FRAG_BIC_REG_REG_SHIFT_MID, ARM_FRAG_AND_REG_REG_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_BIC_IMM, ARM_FRAG_BIC_IMM_MID, ARM_FRAG_AND_IMM_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_MVN_REG_IMM_SHIFT, ARM_FRAG_MVN_REG_IMM_SHIFT_HDR, ARM_FRAG_MVN_REG_IMM_SHIFT_MID, ARM_FRAG_ORR_REG_IMM_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_MVN_REG_REG_SHIFT, ARM_FRAG_MVN_REG_REG_SHIFT_HDR, ARM_FRAG_MVN_REG_REG_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_MVN_IMM, ARM_FRAG_MVN_IMM_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_ADD_REG_IMM_SHIFT, ARM_FRAG_MVN_REG_IMM_SHIFT_HDR, ARM_FRAG_ADD_REG_IMM_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_ADD_REG_REG_SHIFT, ARM_FRAG_MVN_REG_REG_SHIFT_HDR, ARM_FRAG_ADD_REG_REG_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_ADD_IMM, ARM_FRAG_ADD_IMM_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_ADC_REG_IMM_SHIFT, ARM_FRAG_MVN_REG_IMM_SHIFT_HDR, ARM_FRAG_ADC_REG_IMM_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_ADC_REG_REG_SHIFT, ARM_FRAG_MVN_REG_REG_SHIFT_HDR, ARM_FRAG_ADC_REG_REG_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_ADC_IMM, ARM_FRAG_ADC_IMM_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_SUB_REG_IMM_SHIFT, ARM_FRAG_MVN_REG_IMM_SHIFT_HDR, ARM_FRAG_SUB_REG_IMM_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_SUB_REG_REG_SHIFT, ARM_FRAG_MVN_REG_REG_SHIFT_HDR, ARM_FRAG_SUB_REG_REG_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_SUB_IMM, ARM_FRAG_SUB_IMM_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_SBC_REG_IMM_SHIFT, ARM_FRAG_MVN_REG_IMM_SHIFT_HDR, ARM_FRAG_SBC_REG_IMM_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_SBC_REG_REG_SHIFT, ARM_FRAG_MVN_REG_REG_SHIFT_HDR, ARM_FRAG_SBC_REG_REG_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_SBC_IMM, ARM_FRAG_SBC_IMM_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_RSB_REG_IMM_SHIFT, ARM_FRAG_MVN_REG_IMM_SHIFT_HDR, ARM_FRAG_RSB_REG_IMM_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_RSB_REG_REG_SHIFT, ARM_FRAG_MVN_REG_REG_SHIFT_HDR, ARM_FRAG_RSB_REG_REG_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_RSB_IMM, ARM_FRAG_RSB_IMM_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_RSC_REG_IMM_SHIFT, ARM_FRAG_MVN_REG_IMM_SHIFT_HDR, ARM_FRAG_RSC_REG_IMM_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_RSC_REG_REG_SHIFT, ARM_FRAG_MVN_REG_REG_SHIFT_HDR, ARM_FRAG_RSC_REG_REG_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_RSC_IMM, ARM_FRAG_RSC_IMM_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_TST_REG_IMM_SHIFT, ARM_FRAG_TST_REG_IMM_SHIFT_HDR, ARM_FRAG_TST_REG_IMM_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_TST_REG_REG_SHIFT, ARM_FRAG_TST_REG_REG_SHIFT_HDR, ARM_FRAG_TST_REG_REG_SHIFT_MID, ARM_FRAG_TST_REG_REG_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_TST_IMM, ARM_FRAG_TST_IMM_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_TEQ_REG_IMM_SHIFT, ARM_FRAG_TST_REG_IMM_SHIFT_HDR, ARM_FRAG_TEQ_REG_IMM_SHIFT_MID, ARM_FRAG_TEQ_REG_IMM_SHIFT_TRLR, ARM_FRAG_LIST_END },
  { ARM_INSN_TEQ_REG_REG_SHIFT, ARM_FRAG_TST_REG_REG_SHIFT_HDR, ARM_FRAG_TEQ_REG_REG_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_TEQ_IMM, ARM_FRAG_TEQ_IMM_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_CMP_REG_IMM_SHIFT, ARM_FRAG_CMP_REG_IMM_SHIFT_HDR, ARM_FRAG_CMP_REG_IMM_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_CMP_REG_REG_SHIFT, ARM_FRAG_CMP_REG_REG_SHIFT_HDR, ARM_FRAG_CMP_REG_REG_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_CMP_IMM, ARM_FRAG_CMP_IMM_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_CMN_REG_IMM_SHIFT, ARM_FRAG_CMN_REG_IMM_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_CMN_REG_REG_SHIFT, ARM_FRAG_CMN_REG_REG_SHIFT_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_CMN_IMM, ARM_FRAG_CMN_IMM_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMDA, ARM_FRAG_LDMDA_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMDA_SW, ARM_FRAG_LDMDA_SW_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMDA_WB, ARM_FRAG_LDMDA_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMDA_SW_WB, ARM_FRAG_LDMDA_SW_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMIB, ARM_FRAG_LDMIB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMIB_SW, ARM_FRAG_LDMIB_WB_HDR, ARM_FRAG_LDMIB_SW_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMIB_WB, ARM_FRAG_LDMIB_WB_HDR, ARM_FRAG_LDMIB_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMIB_SW_WB, ARM_FRAG_LDMIB_SW_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMIA, ARM_FRAG_LDMIA_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMIA_SW, ARM_FRAG_LDMIA_WB_HDR, ARM_FRAG_LDMIA_SW_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMIA_WB, ARM_FRAG_LDMIA_WB_HDR, ARM_FRAG_LDMIA_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMIA_SW_WB, ARM_FRAG_LDMIA_SW_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMDB, ARM_FRAG_LDMDB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMDB_SW, ARM_FRAG_LDMDB_SW_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMDB_WB, ARM_FRAG_LDMDB_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_LDMDB_SW_WB, ARM_FRAG_LDMDB_SW_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMDB, ARM_FRAG_STMDB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMDB_SW, ARM_FRAG_STMDB_WB_HDR, ARM_FRAG_STMDB_SW_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMDB_WB, ARM_FRAG_STMDB_WB_HDR, ARM_FRAG_STMDB_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMDB_SW_WB, ARM_FRAG_STMDB_SW_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMIB, ARM_FRAG_STMIB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMIB_SW, ARM_FRAG_STMIB_WB_HDR, ARM_FRAG_STMIB_SW_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMIB_WB, ARM_FRAG_STMIB_WB_HDR, ARM_FRAG_STMIB_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMIB_SW_WB, ARM_FRAG_STMIB_SW_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMIA, ARM_FRAG_STMIA_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMIA_SW, ARM_FRAG_STMIA_WB_HDR, ARM_FRAG_STMIA_SW_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMIA_WB, ARM_FRAG_STMIA_WB_HDR, ARM_FRAG_STMIA_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMIA_SW_WB, ARM_FRAG_STMIA_SW_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMDA, ARM_FRAG_STMDA_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMDA_SW, ARM_FRAG_STMDA_WB_HDR, ARM_FRAG_STMDA_SW_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMDA_WB, ARM_FRAG_STMDA_WB_HDR, ARM_FRAG_STMDA_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_STMDA_SW_WB, ARM_FRAG_STMDA_SW_WB_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_MRS_C, ARM_FRAG_MRS_C_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_MRS_S, ARM_FRAG_MRS_S_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_MSR_C, ARM_FRAG_MSR_C_MID, ARM_FRAG_LIST_END },
  { ARM_INSN_MSR_S, ARM_FRAG_MSR_S_MID, ARM_FRAG_LIST_END },
};

void
arm7f_cpu::arm_pbb_run ()
{
  arm7f_cpu* current_cpu = this;
  arm_scache* vpc;
  arm_scache* abuf;
#ifdef __GNUC__
  void** fragpc;
#else
  ARM_FRAG_TYPE* fragpc;
#endif

#ifdef __GNUC__
{
  static const arm_pbb_label labels[] =
    {
      { ARM_FRAG_LIST_END, 0 },
      { ARM_FRAG_MVN_REG_REG_SHIFT_HDR, && case_FRAG_MVN_REG_REG_SHIFT_HDR },
      { ARM_FRAG_CMP_REG_REG_SHIFT_HDR, && case_FRAG_CMP_REG_REG_SHIFT_HDR },
      { ARM_FRAG_TST_REG_REG_SHIFT_HDR, && case_FRAG_TST_REG_REG_SHIFT_HDR },
      { ARM_FRAG_ORR_REG_REG_SHIFT_HDR, && case_FRAG_ORR_REG_REG_SHIFT_HDR },
      { ARM_FRAG_MVN_REG_IMM_SHIFT_HDR, && case_FRAG_MVN_REG_IMM_SHIFT_HDR },
      { ARM_FRAG_CMP_REG_IMM_SHIFT_HDR, && case_FRAG_CMP_REG_IMM_SHIFT_HDR },
      { ARM_FRAG_TST_REG_IMM_SHIFT_HDR, && case_FRAG_TST_REG_IMM_SHIFT_HDR },
      { ARM_FRAG_ORR_REG_IMM_SHIFT_HDR, && case_FRAG_ORR_REG_IMM_SHIFT_HDR },
      { ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR, && case_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR },
      { ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR, && case_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR },
      { ARM_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_HDR, && case_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_HDR },
      { ARM_FRAG_STR_POST_DEC_REG_OFFSET_HDR, && case_FRAG_STR_POST_DEC_REG_OFFSET_HDR },
      { ARM_FRAG_LDR_POST_DEC_NONPRIV_REG_OFFSET_HDR, && case_FRAG_LDR_POST_DEC_NONPRIV_REG_OFFSET_HDR },
      { ARM_FRAG_STMDA_WB_HDR, && case_FRAG_STMDA_WB_HDR },
      { ARM_FRAG_STMIA_WB_HDR, && case_FRAG_STMIA_WB_HDR },
      { ARM_FRAG_STMIB_WB_HDR, && case_FRAG_STMIB_WB_HDR },
      { ARM_FRAG_STMDB_WB_HDR, && case_FRAG_STMDB_WB_HDR },
      { ARM_FRAG_LDMIA_WB_HDR, && case_FRAG_LDMIA_WB_HDR },
      { ARM_FRAG_LDMIB_WB_HDR, && case_FRAG_LDMIB_WB_HDR },
      { ARM_FRAG_STRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR, && case_FRAG_STRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR },
      { ARM_FRAG_LDRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR, && case_FRAG_LDRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR },
      { ARM_FRAG_LDR_POST_DEC_NONPRIV_IMM_OFFSET_HDR, && case_FRAG_LDR_POST_DEC_NONPRIV_IMM_OFFSET_HDR },
      { ARM_FRAG_X_HEADER, && case_FRAG_X_HEADER },
      { ARM_FRAG_TST_REG_REG_SHIFT_TRLR, && case_FRAG_TST_REG_REG_SHIFT_TRLR },
      { ARM_FRAG_TEQ_REG_IMM_SHIFT_TRLR, && case_FRAG_TEQ_REG_IMM_SHIFT_TRLR },
      { ARM_FRAG_AND_IMM_TRLR, && case_FRAG_AND_IMM_TRLR },
      { ARM_FRAG_AND_REG_REG_SHIFT_TRLR, && case_FRAG_AND_REG_REG_SHIFT_TRLR },
      { ARM_FRAG_ORR_REG_IMM_SHIFT_TRLR, && case_FRAG_ORR_REG_IMM_SHIFT_TRLR },
      { ARM_FRAG_UMULL_TRLR, && case_FRAG_UMULL_TRLR },
      { ARM_FRAG_LDR_PRE_INC_IMM_OFFSET_TRLR, && case_FRAG_LDR_PRE_INC_IMM_OFFSET_TRLR },
      { ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_TRLR, && case_FRAG_LDRB_PRE_DEC_REG_OFFSET_TRLR },
      { ARM_FRAG_STR_PRE_DEC_REG_OFFSET_TRLR, && case_FRAG_STR_PRE_DEC_REG_OFFSET_TRLR },
      { ARM_FRAG_STR_PRE_DEC_IMM_OFFSET_TRLR, && case_FRAG_STR_PRE_DEC_IMM_OFFSET_TRLR },
      { ARM_FRAG_STRH_PRE_DEC_IMM_OFFSET_TRLR, && case_FRAG_STRH_PRE_DEC_IMM_OFFSET_TRLR },
      { ARM_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_TRLR, && case_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_TRLR },
      { ARM_FRAG_LDR_PRE_DEC_IMM_OFFSET_TRLR, && case_FRAG_LDR_PRE_DEC_IMM_OFFSET_TRLR },
      { ARM_FRAG_LDR_PRE_INC_REG_OFFSET_TRLR, && case_FRAG_LDR_PRE_INC_REG_OFFSET_TRLR },
      { ARM_FRAG_LDR_PRE_INC_WB_IMM_OFFSET_TRLR, && case_FRAG_LDR_PRE_INC_WB_IMM_OFFSET_TRLR },
      { ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_TRLR, && case_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_TRLR },
      { ARM_FRAG_STR_PRE_DEC_WB_REG_OFFSET_TRLR, && case_FRAG_STR_PRE_DEC_WB_REG_OFFSET_TRLR },
      { ARM_FRAG_STR_PRE_DEC_WB_IMM_OFFSET_TRLR, && case_FRAG_STR_PRE_DEC_WB_IMM_OFFSET_TRLR },
      { ARM_FRAG_STRH_PRE_DEC_WB_IMM_OFFSET_TRLR, && case_FRAG_STRH_PRE_DEC_WB_IMM_OFFSET_TRLR },
      { ARM_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_TRLR, && case_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_TRLR },
      { ARM_FRAG_LDR_PRE_DEC_WB_IMM_OFFSET_TRLR, && case_FRAG_LDR_PRE_DEC_WB_IMM_OFFSET_TRLR },
      { ARM_FRAG_LDR_PRE_INC_WB_REG_OFFSET_TRLR, && case_FRAG_LDR_PRE_INC_WB_REG_OFFSET_TRLR },
      { ARM_FRAG_STRB_POST_INC_REG_OFFSET_TRLR, && case_FRAG_STRB_POST_INC_REG_OFFSET_TRLR },
      { ARM_FRAG_STR_POST_INC_REG_OFFSET_TRLR, && case_FRAG_STR_POST_INC_REG_OFFSET_TRLR },
      { ARM_FRAG_STR_POST_INC_IMM_OFFSET_TRLR, && case_FRAG_STR_POST_INC_IMM_OFFSET_TRLR },
      { ARM_FRAG_LDRB_POST_INC_REG_OFFSET_TRLR, && case_FRAG_LDRB_POST_INC_REG_OFFSET_TRLR },
      { ARM_FRAG_STRB_POST_DEC_REG_OFFSET_TRLR, && case_FRAG_STRB_POST_DEC_REG_OFFSET_TRLR },
      { ARM_FRAG_STR_POST_DEC_REG_OFFSET_TRLR, && case_FRAG_STR_POST_DEC_REG_OFFSET_TRLR },
      { ARM_FRAG_STR_POST_DEC_IMM_OFFSET_TRLR, && case_FRAG_STR_POST_DEC_IMM_OFFSET_TRLR },
      { ARM_FRAG_LDRB_POST_DEC_REG_OFFSET_TRLR, && case_FRAG_LDRB_POST_DEC_REG_OFFSET_TRLR },
      { ARM_FRAG_X_TRAILER, && case_FRAG_X_TRAILER },
      { ARM_FRAG_X_COND_MID, && case_FRAG_X_COND_MID },
      { ARM_FRAG_X_AFTER_MID, && case_FRAG_X_AFTER_MID },
      { ARM_FRAG_X_BEFORE_MID, && case_FRAG_X_BEFORE_MID },
      { ARM_FRAG_X_CTI_CHAIN_MID, && case_FRAG_X_CTI_CHAIN_MID },
      { ARM_FRAG_X_CHAIN_MID, && case_FRAG_X_CHAIN_MID },
      { ARM_FRAG_X_BEGIN_MID, && case_FRAG_X_BEGIN_MID },
      { ARM_FRAG_X_INVALID_MID, && case_FRAG_X_INVALID_MID },
      { ARM_FRAG_B_MID, && case_FRAG_B_MID },
      { ARM_FRAG_BL_MID, && case_FRAG_BL_MID },
      { ARM_FRAG_BX_MID, && case_FRAG_BX_MID },
      { ARM_FRAG_LDR_POST_DEC_IMM_OFFSET_MID, && case_FRAG_LDR_POST_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_LDR_POST_DEC_REG_OFFSET_MID, && case_FRAG_LDR_POST_DEC_REG_OFFSET_MID },
      { ARM_FRAG_LDR_POST_INC_IMM_OFFSET_MID, && case_FRAG_LDR_POST_INC_IMM_OFFSET_MID },
      { ARM_FRAG_LDR_POST_INC_REG_OFFSET_MID, && case_FRAG_LDR_POST_INC_REG_OFFSET_MID },
      { ARM_FRAG_LDR_POST_DEC_NONPRIV_IMM_OFFSET_MID, && case_FRAG_LDR_POST_DEC_NONPRIV_IMM_OFFSET_MID },
      { ARM_FRAG_LDR_POST_DEC_NONPRIV_REG_OFFSET_MID, && case_FRAG_LDR_POST_DEC_NONPRIV_REG_OFFSET_MID },
      { ARM_FRAG_LDR_POST_INC_NONPRIV_IMM_OFFSET_MID, && case_FRAG_LDR_POST_INC_NONPRIV_IMM_OFFSET_MID },
      { ARM_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_MID, && case_FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_MID },
      { ARM_FRAG_LDR_PRE_DEC_IMM_OFFSET_MID, && case_FRAG_LDR_PRE_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_LDR_PRE_DEC_REG_OFFSET_MID, && case_FRAG_LDR_PRE_DEC_REG_OFFSET_MID },
      { ARM_FRAG_LDR_PRE_INC_IMM_OFFSET_MID, && case_FRAG_LDR_PRE_INC_IMM_OFFSET_MID },
      { ARM_FRAG_LDR_PRE_INC_REG_OFFSET_MID, && case_FRAG_LDR_PRE_INC_REG_OFFSET_MID },
      { ARM_FRAG_LDR_PRE_DEC_WB_IMM_OFFSET_MID, && case_FRAG_LDR_PRE_DEC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_MID, && case_FRAG_LDR_PRE_DEC_WB_REG_OFFSET_MID },
      { ARM_FRAG_LDR_PRE_INC_WB_IMM_OFFSET_MID, && case_FRAG_LDR_PRE_INC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_LDR_PRE_INC_WB_REG_OFFSET_MID, && case_FRAG_LDR_PRE_INC_WB_REG_OFFSET_MID },
      { ARM_FRAG_LDRB_POST_DEC_IMM_OFFSET_MID, && case_FRAG_LDRB_POST_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRB_POST_INC_IMM_OFFSET_MID, && case_FRAG_LDRB_POST_INC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRB_POST_DEC_NONPRIV_IMM_OFFSET_MID, && case_FRAG_LDRB_POST_DEC_NONPRIV_IMM_OFFSET_MID },
      { ARM_FRAG_LDRB_POST_INC_NONPRIV_IMM_OFFSET_MID, && case_FRAG_LDRB_POST_INC_NONPRIV_IMM_OFFSET_MID },
      { ARM_FRAG_LDRB_PRE_DEC_IMM_OFFSET_MID, && case_FRAG_LDRB_PRE_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRB_PRE_DEC_REG_OFFSET_MID, && case_FRAG_LDRB_PRE_DEC_REG_OFFSET_MID },
      { ARM_FRAG_LDRB_PRE_INC_IMM_OFFSET_MID, && case_FRAG_LDRB_PRE_INC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRB_PRE_INC_REG_OFFSET_MID, && case_FRAG_LDRB_PRE_INC_REG_OFFSET_MID },
      { ARM_FRAG_LDRB_PRE_DEC_WB_IMM_OFFSET_MID, && case_FRAG_LDRB_PRE_DEC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_MID, && case_FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_MID },
      { ARM_FRAG_LDRB_PRE_INC_WB_IMM_OFFSET_MID, && case_FRAG_LDRB_PRE_INC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_LDRB_PRE_INC_WB_REG_OFFSET_MID, && case_FRAG_LDRB_PRE_INC_WB_REG_OFFSET_MID },
      { ARM_FRAG_STR_POST_DEC_IMM_OFFSET_MID, && case_FRAG_STR_POST_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_STR_POST_INC_IMM_OFFSET_MID, && case_FRAG_STR_POST_INC_IMM_OFFSET_MID },
      { ARM_FRAG_STR_POST_DEC_NONPRIV_IMM_OFFSET_MID, && case_FRAG_STR_POST_DEC_NONPRIV_IMM_OFFSET_MID },
      { ARM_FRAG_STR_POST_INC_NONPRIV_IMM_OFFSET_MID, && case_FRAG_STR_POST_INC_NONPRIV_IMM_OFFSET_MID },
      { ARM_FRAG_STR_PRE_DEC_IMM_OFFSET_MID, && case_FRAG_STR_PRE_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_STR_PRE_DEC_REG_OFFSET_MID, && case_FRAG_STR_PRE_DEC_REG_OFFSET_MID },
      { ARM_FRAG_STR_PRE_INC_IMM_OFFSET_MID, && case_FRAG_STR_PRE_INC_IMM_OFFSET_MID },
      { ARM_FRAG_STR_PRE_INC_REG_OFFSET_MID, && case_FRAG_STR_PRE_INC_REG_OFFSET_MID },
      { ARM_FRAG_STR_PRE_DEC_WB_IMM_OFFSET_MID, && case_FRAG_STR_PRE_DEC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_STR_PRE_DEC_WB_REG_OFFSET_MID, && case_FRAG_STR_PRE_DEC_WB_REG_OFFSET_MID },
      { ARM_FRAG_STR_PRE_INC_WB_IMM_OFFSET_MID, && case_FRAG_STR_PRE_INC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_STR_PRE_INC_WB_REG_OFFSET_MID, && case_FRAG_STR_PRE_INC_WB_REG_OFFSET_MID },
      { ARM_FRAG_STRB_POST_DEC_IMM_OFFSET_MID, && case_FRAG_STRB_POST_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_STRB_POST_INC_IMM_OFFSET_MID, && case_FRAG_STRB_POST_INC_IMM_OFFSET_MID },
      { ARM_FRAG_STRB_POST_DEC_NONPRIV_IMM_OFFSET_MID, && case_FRAG_STRB_POST_DEC_NONPRIV_IMM_OFFSET_MID },
      { ARM_FRAG_STRB_POST_INC_NONPRIV_IMM_OFFSET_MID, && case_FRAG_STRB_POST_INC_NONPRIV_IMM_OFFSET_MID },
      { ARM_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_MID, && case_FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_MID },
      { ARM_FRAG_STRB_PRE_DEC_IMM_OFFSET_MID, && case_FRAG_STRB_PRE_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_STRB_PRE_DEC_REG_OFFSET_MID, && case_FRAG_STRB_PRE_DEC_REG_OFFSET_MID },
      { ARM_FRAG_STRB_PRE_INC_IMM_OFFSET_MID, && case_FRAG_STRB_PRE_INC_IMM_OFFSET_MID },
      { ARM_FRAG_STRB_PRE_INC_REG_OFFSET_MID, && case_FRAG_STRB_PRE_INC_REG_OFFSET_MID },
      { ARM_FRAG_STRB_PRE_DEC_WB_IMM_OFFSET_MID, && case_FRAG_STRB_PRE_DEC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_STRB_PRE_DEC_WB_REG_OFFSET_MID, && case_FRAG_STRB_PRE_DEC_WB_REG_OFFSET_MID },
      { ARM_FRAG_STRB_PRE_INC_WB_IMM_OFFSET_MID, && case_FRAG_STRB_PRE_INC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_STRB_PRE_INC_WB_REG_OFFSET_MID, && case_FRAG_STRB_PRE_INC_WB_REG_OFFSET_MID },
      { ARM_FRAG_STRH_PRE_DEC_IMM_OFFSET_MID, && case_FRAG_STRH_PRE_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_STRH_PRE_DEC_REG_OFFSET_MID, && case_FRAG_STRH_PRE_DEC_REG_OFFSET_MID },
      { ARM_FRAG_STRH_PRE_INC_IMM_OFFSET_MID, && case_FRAG_STRH_PRE_INC_IMM_OFFSET_MID },
      { ARM_FRAG_STRH_PRE_INC_REG_OFFSET_MID, && case_FRAG_STRH_PRE_INC_REG_OFFSET_MID },
      { ARM_FRAG_STRH_PRE_DEC_WB_IMM_OFFSET_MID, && case_FRAG_STRH_PRE_DEC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_STRH_PRE_DEC_WB_REG_OFFSET_MID, && case_FRAG_STRH_PRE_DEC_WB_REG_OFFSET_MID },
      { ARM_FRAG_STRH_PRE_INC_WB_IMM_OFFSET_MID, && case_FRAG_STRH_PRE_INC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_STRH_PRE_INC_WB_REG_OFFSET_MID, && case_FRAG_STRH_PRE_INC_WB_REG_OFFSET_MID },
      { ARM_FRAG_STRH_POST_DEC_IMM_OFFSET_MID, && case_FRAG_STRH_POST_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_STRH_POST_DEC_REG_OFFSET_MID, && case_FRAG_STRH_POST_DEC_REG_OFFSET_MID },
      { ARM_FRAG_STRH_POST_INC_IMM_OFFSET_MID, && case_FRAG_STRH_POST_INC_IMM_OFFSET_MID },
      { ARM_FRAG_STRH_POST_INC_REG_OFFSET_MID, && case_FRAG_STRH_POST_INC_REG_OFFSET_MID },
      { ARM_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_MID, && case_FRAG_LDRSB_PRE_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSB_PRE_DEC_REG_OFFSET_MID, && case_FRAG_LDRSB_PRE_DEC_REG_OFFSET_MID },
      { ARM_FRAG_LDRSB_PRE_INC_IMM_OFFSET_MID, && case_FRAG_LDRSB_PRE_INC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSB_PRE_INC_REG_OFFSET_MID, && case_FRAG_LDRSB_PRE_INC_REG_OFFSET_MID },
      { ARM_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_MID, && case_FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSB_PRE_DEC_WB_REG_OFFSET_MID, && case_FRAG_LDRSB_PRE_DEC_WB_REG_OFFSET_MID },
      { ARM_FRAG_LDRSB_PRE_INC_WB_IMM_OFFSET_MID, && case_FRAG_LDRSB_PRE_INC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSB_PRE_INC_WB_REG_OFFSET_MID, && case_FRAG_LDRSB_PRE_INC_WB_REG_OFFSET_MID },
      { ARM_FRAG_LDRSB_POST_DEC_IMM_OFFSET_MID, && case_FRAG_LDRSB_POST_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSB_POST_DEC_REG_OFFSET_MID, && case_FRAG_LDRSB_POST_DEC_REG_OFFSET_MID },
      { ARM_FRAG_LDRSB_POST_INC_IMM_OFFSET_MID, && case_FRAG_LDRSB_POST_INC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSB_POST_INC_REG_OFFSET_MID, && case_FRAG_LDRSB_POST_INC_REG_OFFSET_MID },
      { ARM_FRAG_LDRH_PRE_DEC_IMM_OFFSET_MID, && case_FRAG_LDRH_PRE_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRH_PRE_DEC_REG_OFFSET_MID, && case_FRAG_LDRH_PRE_DEC_REG_OFFSET_MID },
      { ARM_FRAG_LDRH_PRE_INC_IMM_OFFSET_MID, && case_FRAG_LDRH_PRE_INC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRH_PRE_INC_REG_OFFSET_MID, && case_FRAG_LDRH_PRE_INC_REG_OFFSET_MID },
      { ARM_FRAG_LDRH_PRE_DEC_WB_IMM_OFFSET_MID, && case_FRAG_LDRH_PRE_DEC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_LDRH_PRE_DEC_WB_REG_OFFSET_MID, && case_FRAG_LDRH_PRE_DEC_WB_REG_OFFSET_MID },
      { ARM_FRAG_LDRH_PRE_INC_WB_IMM_OFFSET_MID, && case_FRAG_LDRH_PRE_INC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_LDRH_PRE_INC_WB_REG_OFFSET_MID, && case_FRAG_LDRH_PRE_INC_WB_REG_OFFSET_MID },
      { ARM_FRAG_LDRH_POST_DEC_IMM_OFFSET_MID, && case_FRAG_LDRH_POST_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRH_POST_DEC_REG_OFFSET_MID, && case_FRAG_LDRH_POST_DEC_REG_OFFSET_MID },
      { ARM_FRAG_LDRH_POST_INC_IMM_OFFSET_MID, && case_FRAG_LDRH_POST_INC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRH_POST_INC_REG_OFFSET_MID, && case_FRAG_LDRH_POST_INC_REG_OFFSET_MID },
      { ARM_FRAG_LDRSH_PRE_DEC_IMM_OFFSET_MID, && case_FRAG_LDRSH_PRE_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSH_PRE_DEC_REG_OFFSET_MID, && case_FRAG_LDRSH_PRE_DEC_REG_OFFSET_MID },
      { ARM_FRAG_LDRSH_PRE_INC_IMM_OFFSET_MID, && case_FRAG_LDRSH_PRE_INC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSH_PRE_INC_REG_OFFSET_MID, && case_FRAG_LDRSH_PRE_INC_REG_OFFSET_MID },
      { ARM_FRAG_LDRSH_PRE_DEC_WB_IMM_OFFSET_MID, && case_FRAG_LDRSH_PRE_DEC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSH_PRE_DEC_WB_REG_OFFSET_MID, && case_FRAG_LDRSH_PRE_DEC_WB_REG_OFFSET_MID },
      { ARM_FRAG_LDRSH_PRE_INC_WB_IMM_OFFSET_MID, && case_FRAG_LDRSH_PRE_INC_WB_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSH_PRE_INC_WB_REG_OFFSET_MID, && case_FRAG_LDRSH_PRE_INC_WB_REG_OFFSET_MID },
      { ARM_FRAG_LDRSH_POST_DEC_IMM_OFFSET_MID, && case_FRAG_LDRSH_POST_DEC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSH_POST_DEC_REG_OFFSET_MID, && case_FRAG_LDRSH_POST_DEC_REG_OFFSET_MID },
      { ARM_FRAG_LDRSH_POST_INC_IMM_OFFSET_MID, && case_FRAG_LDRSH_POST_INC_IMM_OFFSET_MID },
      { ARM_FRAG_LDRSH_POST_INC_REG_OFFSET_MID, && case_FRAG_LDRSH_POST_INC_REG_OFFSET_MID },
      { ARM_FRAG_MUL_MID, && case_FRAG_MUL_MID },
      { ARM_FRAG_MLA_MID, && case_FRAG_MLA_MID },
      { ARM_FRAG_UMULL_MID, && case_FRAG_UMULL_MID },
      { ARM_FRAG_UMLAL_MID, && case_FRAG_UMLAL_MID },
      { ARM_FRAG_SMULL_MID, && case_FRAG_SMULL_MID },
      { ARM_FRAG_SMLAL_MID, && case_FRAG_SMLAL_MID },
      { ARM_FRAG_SWP_MID, && case_FRAG_SWP_MID },
      { ARM_FRAG_SWPB_MID, && case_FRAG_SWPB_MID },
      { ARM_FRAG_SWI_MID, && case_FRAG_SWI_MID },
      { ARM_FRAG_AND_REG_IMM_SHIFT_MID, && case_FRAG_AND_REG_IMM_SHIFT_MID },
      { ARM_FRAG_AND_REG_REG_SHIFT_MID, && case_FRAG_AND_REG_REG_SHIFT_MID },
      { ARM_FRAG_AND_IMM_MID, && case_FRAG_AND_IMM_MID },
      { ARM_FRAG_ORR_REG_IMM_SHIFT_MID, && case_FRAG_ORR_REG_IMM_SHIFT_MID },
      { ARM_FRAG_ORR_REG_REG_SHIFT_MID, && case_FRAG_ORR_REG_REG_SHIFT_MID },
      { ARM_FRAG_ORR_IMM_MID, && case_FRAG_ORR_IMM_MID },
      { ARM_FRAG_EOR_REG_IMM_SHIFT_MID, && case_FRAG_EOR_REG_IMM_SHIFT_MID },
      { ARM_FRAG_EOR_REG_REG_SHIFT_MID, && case_FRAG_EOR_REG_REG_SHIFT_MID },
      { ARM_FRAG_EOR_IMM_MID, && case_FRAG_EOR_IMM_MID },
      { ARM_FRAG_MOV_REG_IMM_SHIFT_MID, && case_FRAG_MOV_REG_IMM_SHIFT_MID },
      { ARM_FRAG_MOV_REG_REG_SHIFT_MID, && case_FRAG_MOV_REG_REG_SHIFT_MID },
      { ARM_FRAG_MOV_IMM_MID, && case_FRAG_MOV_IMM_MID },
      { ARM_FRAG_BIC_REG_IMM_SHIFT_MID, && case_FRAG_BIC_REG_IMM_SHIFT_MID },
      { ARM_FRAG_BIC_REG_REG_SHIFT_MID, && case_FRAG_BIC_REG_REG_SHIFT_MID },
      { ARM_FRAG_BIC_IMM_MID, && case_FRAG_BIC_IMM_MID },
      { ARM_FRAG_MVN_REG_IMM_SHIFT_MID, && case_FRAG_MVN_REG_IMM_SHIFT_MID },
      { ARM_FRAG_MVN_REG_REG_SHIFT_MID, && case_FRAG_MVN_REG_REG_SHIFT_MID },
      { ARM_FRAG_MVN_IMM_MID, && case_FRAG_MVN_IMM_MID },
      { ARM_FRAG_ADD_REG_IMM_SHIFT_MID, && case_FRAG_ADD_REG_IMM_SHIFT_MID },
      { ARM_FRAG_ADD_REG_REG_SHIFT_MID, && case_FRAG_ADD_REG_REG_SHIFT_MID },
      { ARM_FRAG_ADD_IMM_MID, && case_FRAG_ADD_IMM_MID },
      { ARM_FRAG_ADC_REG_IMM_SHIFT_MID, && case_FRAG_ADC_REG_IMM_SHIFT_MID },
      { ARM_FRAG_ADC_REG_REG_SHIFT_MID, && case_FRAG_ADC_REG_REG_SHIFT_MID },
      { ARM_FRAG_ADC_IMM_MID, && case_FRAG_ADC_IMM_MID },
      { ARM_FRAG_SUB_REG_IMM_SHIFT_MID, && case_FRAG_SUB_REG_IMM_SHIFT_MID },
      { ARM_FRAG_SUB_REG_REG_SHIFT_MID, && case_FRAG_SUB_REG_REG_SHIFT_MID },
      { ARM_FRAG_SUB_IMM_MID, && case_FRAG_SUB_IMM_MID },
      { ARM_FRAG_SBC_REG_IMM_SHIFT_MID, && case_FRAG_SBC_REG_IMM_SHIFT_MID },
      { ARM_FRAG_SBC_REG_REG_SHIFT_MID, && case_FRAG_SBC_REG_REG_SHIFT_MID },
      { ARM_FRAG_SBC_IMM_MID, && case_FRAG_SBC_IMM_MID },
      { ARM_FRAG_RSB_REG_IMM_SHIFT_MID, && case_FRAG_RSB_REG_IMM_SHIFT_MID },
      { ARM_FRAG_RSB_REG_REG_SHIFT_MID, && case_FRAG_RSB_REG_REG_SHIFT_MID },
      { ARM_FRAG_RSB_IMM_MID, && case_FRAG_RSB_IMM_MID },
      { ARM_FRAG_RSC_REG_IMM_SHIFT_MID, && case_FRAG_RSC_REG_IMM_SHIFT_MID },
      { ARM_FRAG_RSC_REG_REG_SHIFT_MID, && case_FRAG_RSC_REG_REG_SHIFT_MID },
      { ARM_FRAG_RSC_IMM_MID, && case_FRAG_RSC_IMM_MID },
      { ARM_FRAG_TST_REG_IMM_SHIFT_MID, && case_FRAG_TST_REG_IMM_SHIFT_MID },
      { ARM_FRAG_TST_REG_REG_SHIFT_MID, && case_FRAG_TST_REG_REG_SHIFT_MID },
      { ARM_FRAG_TST_IMM_MID, && case_FRAG_TST_IMM_MID },
      { ARM_FRAG_TEQ_REG_IMM_SHIFT_MID, && case_FRAG_TEQ_REG_IMM_SHIFT_MID },
      { ARM_FRAG_TEQ_REG_REG_SHIFT_MID, && case_FRAG_TEQ_REG_REG_SHIFT_MID },
      { ARM_FRAG_TEQ_IMM_MID, && case_FRAG_TEQ_IMM_MID },
      { ARM_FRAG_CMP_REG_IMM_SHIFT_MID, && case_FRAG_CMP_REG_IMM_SHIFT_MID },
      { ARM_FRAG_CMP_REG_REG_SHIFT_MID, && case_FRAG_CMP_REG_REG_SHIFT_MID },
      { ARM_FRAG_CMP_IMM_MID, && case_FRAG_CMP_IMM_MID },
      { ARM_FRAG_CMN_REG_IMM_SHIFT_MID, && case_FRAG_CMN_REG_IMM_SHIFT_MID },
      { ARM_FRAG_CMN_REG_REG_SHIFT_MID, && case_FRAG_CMN_REG_REG_SHIFT_MID },
      { ARM_FRAG_CMN_IMM_MID, && case_FRAG_CMN_IMM_MID },
      { ARM_FRAG_LDMDA_MID, && case_FRAG_LDMDA_MID },
      { ARM_FRAG_LDMDA_SW_MID, && case_FRAG_LDMDA_SW_MID },
      { ARM_FRAG_LDMDA_WB_MID, && case_FRAG_LDMDA_WB_MID },
      { ARM_FRAG_LDMDA_SW_WB_MID, && case_FRAG_LDMDA_SW_WB_MID },
      { ARM_FRAG_LDMIB_MID, && case_FRAG_LDMIB_MID },
      { ARM_FRAG_LDMIB_SW_MID, && case_FRAG_LDMIB_SW_MID },
      { ARM_FRAG_LDMIB_WB_MID, && case_FRAG_LDMIB_WB_MID },
      { ARM_FRAG_LDMIB_SW_WB_MID, && case_FRAG_LDMIB_SW_WB_MID },
      { ARM_FRAG_LDMIA_MID, && case_FRAG_LDMIA_MID },
      { ARM_FRAG_LDMIA_SW_MID, && case_FRAG_LDMIA_SW_MID },
      { ARM_FRAG_LDMIA_WB_MID, && case_FRAG_LDMIA_WB_MID },
      { ARM_FRAG_LDMIA_SW_WB_MID, && case_FRAG_LDMIA_SW_WB_MID },
      { ARM_FRAG_LDMDB_MID, && case_FRAG_LDMDB_MID },
      { ARM_FRAG_LDMDB_SW_MID, && case_FRAG_LDMDB_SW_MID },
      { ARM_FRAG_LDMDB_WB_MID, && case_FRAG_LDMDB_WB_MID },
      { ARM_FRAG_LDMDB_SW_WB_MID, && case_FRAG_LDMDB_SW_WB_MID },
      { ARM_FRAG_STMDB_MID, && case_FRAG_STMDB_MID },
      { ARM_FRAG_STMDB_SW_MID, && case_FRAG_STMDB_SW_MID },
      { ARM_FRAG_STMDB_WB_MID, && case_FRAG_STMDB_WB_MID },
      { ARM_FRAG_STMDB_SW_WB_MID, && case_FRAG_STMDB_SW_WB_MID },
      { ARM_FRAG_STMIB_MID, && case_FRAG_STMIB_MID },
      { ARM_FRAG_STMIB_SW_MID, && case_FRAG_STMIB_SW_MID },
      { ARM_FRAG_STMIB_WB_MID, && case_FRAG_STMIB_WB_MID },
      { ARM_FRAG_STMIB_SW_WB_MID, && case_FRAG_STMIB_SW_WB_MID },
      { ARM_FRAG_STMIA_MID, && case_FRAG_STMIA_MID },
      { ARM_FRAG_STMIA_SW_MID, && case_FRAG_STMIA_SW_MID },
      { ARM_FRAG_STMIA_WB_MID, && case_FRAG_STMIA_WB_MID },
      { ARM_FRAG_STMIA_SW_WB_MID, && case_FRAG_STMIA_SW_WB_MID },
      { ARM_FRAG_STMDA_MID, && case_FRAG_STMDA_MID },
      { ARM_FRAG_STMDA_SW_MID, && case_FRAG_STMDA_SW_MID },
      { ARM_FRAG_STMDA_WB_MID, && case_FRAG_STMDA_WB_MID },
      { ARM_FRAG_STMDA_SW_WB_MID, && case_FRAG_STMDA_SW_WB_MID },
      { ARM_FRAG_MRS_C_MID, && case_FRAG_MRS_C_MID },
      { ARM_FRAG_MRS_S_MID, && case_FRAG_MRS_S_MID },
      { ARM_FRAG_MSR_C_MID, && case_FRAG_MSR_C_MID },
      { ARM_FRAG_MSR_S_MID, && case_FRAG_MSR_S_MID },
      { ARM_FRAG_MAX, 0 }
    };

  if (! arm_idesc::idesc_table_initialized_p)
    {
      // Several tables are in play here:
      // idesc table: const table of misc things for each insn
      // frag usage table: const set of frags used by each insn
      // frag label table: same as frag usage table, but contains labels
      // selected insn frag table: table of pointers to either the frag usage
      // table (if !gnuc) or frag label table (if gnuc) for the currently
      // selected ISA.  Insns not in the ISA are redirected to the `invalid'
      // insn handler.  FIXME: This one isn't implemented yet.

      // Allocate frag label table and point idesc table entries at it.
      // FIXME: Temporary hack, to be redone.
      static void** frag_label_table;
      int max_insns = ARM_INSN_MSR_S + 1;
      int tabsize = max_insns * 4;
      frag_label_table = new void* [tabsize];
      memset (frag_label_table, 0, sizeof (void*) * tabsize);
      int i;
      void** v;
      for (i = 0, v = frag_label_table; i < max_insns; ++i)
	{
	  arm_idesc::idesc_table[arm_frag_usage[i].itype].cgoto.frags = v;
	  for (int j = 0; arm_frag_usage[i].ftype[j] != ARM_FRAG_LIST_END; ++j)
	    *v++ = labels[arm_frag_usage[i].ftype[j]].label;
	}

      // Initialize the compiler virtual insn.
      // FIXME: Also needed if !gnuc.
      current_cpu->arm_engine.compile_begin_insn (current_cpu);

      arm_idesc::idesc_table_initialized_p = true;
    }
}
#endif

#ifdef __GNUC__
#define CASE(X) case_##X
// Branch to next handler without going around main loop.
#define NEXT_INSN(vpc, fragpc) fragpc = vpc->execute.cgoto.frags; goto * *fragpc
#define NEXT_FRAG(fragpc) ++fragpc; goto * *fragpc
// Break out of threaded interpreter and return to "main loop".
#define BREAK(vpc) goto end_switch
#else
#define CASE(X) case ARM_##X
#define NEXT_INSN(vpc, fragpc) fragpc = vpc->idesc->frags; goto restart
#define NEXT_FRAG(fragpc) ++fragpc; goto restart
#define BREAK(vpc) break
#endif

  // Get next insn to execute.
  vpc = current_cpu->arm_engine.get_next_vpc (current_cpu->h_pc_get ());

  {
    // These two are used to pass data from cti insns to the cti-chain insn.
    PCADDR pbb_br_npc;
    branch_status pbb_br_status;
    // These two are used to build up values of the previous two.
    PCADDR npc;
    branch_status br_status;
    // Top level locals moved here so they're usable by multiple fragments.
    SI temp_op2;
    SI temp_op1;
    BI carry_out;
    SI operand2;
    SI temp;
    SI lo;
    SI hi;
    DI mul_result;
    SI result;
    SI offset;
    SI addr;

restart:
#ifdef __GNUC__
  fragpc = vpc->execute.cgoto.frags;
  goto * *fragpc;
#else
  fragpc = vpc->idesc->frags;
  switch (*fragpc)
#endif

    {

// ********** used by: mvn-reg/reg-shift, add-reg/reg-shift, adc-reg/reg-shift, sub-reg/reg-shift, sbc-reg/reg-shift, rsb-reg/reg-shift, rsc-reg/reg-shift

  CASE (FRAG_MVN_REG_REG_SHIFT_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_regshift (* FLD (i_rm), FLD (f_operand2_shifttype), * FLD (i_operand2_shiftreg));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: cmp-reg/reg-shift

  CASE (FRAG_CMP_REG_REG_SHIFT_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_regshift (* FLD (i_rm), FLD (f_operand2_shifttype), * FLD (i_operand2_shiftreg));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: tst-reg/reg-shift, teq-reg/reg-shift

  CASE (FRAG_TST_REG_REG_SHIFT_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_regshift (* FLD (i_rm), FLD (f_operand2_shifttype), * FLD (i_operand2_shiftreg));
  carry_out = current_cpu->compute_carry_out_regshift (* FLD (i_rm), FLD (f_operand2_shifttype), * FLD (i_operand2_shiftreg), current_cpu->hardware.h_cbit);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: orr-reg/reg-shift, eor-reg/reg-shift, mov-reg/reg-shift, bic-reg/reg-shift

  CASE (FRAG_ORR_REG_REG_SHIFT_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_regshift (* FLD (i_rm), FLD (f_operand2_shifttype), * FLD (i_operand2_shiftreg));
  carry_out = current_cpu->compute_carry_out_regshift (* FLD (i_rm), FLD (f_operand2_shifttype), * FLD (i_operand2_shiftreg), current_cpu->hardware.h_cbit);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: mvn-reg/imm-shift, add-reg/imm-shift, adc-reg/imm-shift, sub-reg/imm-shift, sbc-reg/imm-shift, rsb-reg/imm-shift, rsc-reg/imm-shift

  CASE (FRAG_MVN_REG_IMM_SHIFT_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: cmp-reg/imm-shift

  CASE (FRAG_CMP_REG_IMM_SHIFT_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: tst-reg/imm-shift, teq-reg/imm-shift

  CASE (FRAG_TST_REG_IMM_SHIFT_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
  carry_out = current_cpu->compute_carry_out_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm), current_cpu->hardware.h_cbit);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: orr-reg/imm-shift, eor-reg/imm-shift, mov-reg/imm-shift, bic-reg/imm-shift

  CASE (FRAG_ORR_REG_IMM_SHIFT_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
  carry_out = current_cpu->compute_carry_out_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm), current_cpu->hardware.h_cbit);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: strb-post-inc-nonpriv-reg-offset, str-pre-dec-wb-reg-offset, str-pre-dec-reg-offset, strb-pre-dec-wb-reg-offset, strb-pre-dec-reg-offset, str-pre-inc-wb-reg-offset, str-pre-inc-reg-offset, strb-pre-inc-wb-reg-offset

  CASE (FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: ldr-pre-dec-wb-reg-offset, ldr-pre-dec-reg-offset, ldrb-pre-dec-wb-reg-offset, ldrb-pre-dec-reg-offset, ldr-pre-inc-wb-reg-offset, ldr-pre-inc-reg-offset, ldrb-pre-inc-wb-reg-offset, ldrb-pre-inc-reg-offset

  CASE (FRAG_LDR_PRE_DEC_WB_REG_OFFSET_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: ldr-post-inc-nonpriv-reg-offset, ldrb-post-dec-reg-offset, ldrb-post-dec-nonpriv-reg-offset, ldrb-post-inc-reg-offset, ldrb-post-inc-nonpriv-reg-offset

  CASE (FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
  addr = * FLD (i_rn);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: str-post-dec-reg-offset, str-post-dec-nonpriv-reg-offset, str-post-inc-reg-offset, str-post-inc-nonpriv-reg-offset, strb-post-dec-reg-offset, strb-post-dec-nonpriv-reg-offset, strb-post-inc-reg-offset

  CASE (FRAG_STR_POST_DEC_REG_OFFSET_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
  addr = * FLD (i_rn);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: ldr-post-dec-nonpriv-reg-offset, ldr-post-inc-reg-offset

  CASE (FRAG_LDR_POST_DEC_NONPRIV_REG_OFFSET_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
  addr = * FLD (i_rn);
if (((FLD (f_rd)) == (15))) {
npc = current_cpu->GETMEMSI (pc, addr); br_status = BRANCH_UNCACHEABLE;
} else {
* FLD (i_rd) = current_cpu->GETMEMSI (pc, addr);
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: stmda-wb, stmda-sw

  CASE (FRAG_STMDA_WB_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (((FLD (f_reg_list)) & (((1) << (15))))) {
{
current_cpu->SETMEMSI (pc, addr, ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4));
  addr = SUBSI (addr, 4);
}
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: stmia-wb, stmia-sw

  CASE (FRAG_STMIA_WB_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (((FLD (f_reg_list)) & (((1) << (0))))) {
{
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 0)]);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (1))))) {
{
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 1)]);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (2))))) {
{
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 2)]);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (3))))) {
{
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 3)]);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (4))))) {
{
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 4)]);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (5))))) {
{
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 5)]);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (6))))) {
{
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 6)]);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (7))))) {
{
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 7)]);
  addr = ADDSI (addr, 4);
}
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: stmib-wb, stmib-sw

  CASE (FRAG_STMIB_WB_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (((FLD (f_reg_list)) & (((1) << (0))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 0)]);
}
}
if (((FLD (f_reg_list)) & (((1) << (1))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 1)]);
}
}
if (((FLD (f_reg_list)) & (((1) << (2))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 2)]);
}
}
if (((FLD (f_reg_list)) & (((1) << (3))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 3)]);
}
}
if (((FLD (f_reg_list)) & (((1) << (4))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 4)]);
}
}
if (((FLD (f_reg_list)) & (((1) << (5))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 5)]);
}
}
if (((FLD (f_reg_list)) & (((1) << (6))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 6)]);
}
}
if (((FLD (f_reg_list)) & (((1) << (7))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->SETMEMSI (pc, addr, current_cpu->hardware.h_gr[((UINT) 7)]);
}
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: stmdb-wb, stmdb-sw

  CASE (FRAG_STMDB_WB_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (((FLD (f_reg_list)) & (((1) << (15))))) {
{
  addr = SUBSI (addr, 4);
current_cpu->SETMEMSI (pc, addr, ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4));
}
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: ldmia-wb, ldmia-sw

  CASE (FRAG_LDMIA_WB_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (((FLD (f_reg_list)) & (((1) << (0))))) {
{
current_cpu->hardware.h_gr[((UINT) 0)] = current_cpu->GETMEMSI (pc, addr);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (1))))) {
{
current_cpu->hardware.h_gr[((UINT) 1)] = current_cpu->GETMEMSI (pc, addr);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (2))))) {
{
current_cpu->hardware.h_gr[((UINT) 2)] = current_cpu->GETMEMSI (pc, addr);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (3))))) {
{
current_cpu->hardware.h_gr[((UINT) 3)] = current_cpu->GETMEMSI (pc, addr);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (4))))) {
{
current_cpu->hardware.h_gr[((UINT) 4)] = current_cpu->GETMEMSI (pc, addr);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (5))))) {
{
current_cpu->hardware.h_gr[((UINT) 5)] = current_cpu->GETMEMSI (pc, addr);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (6))))) {
{
current_cpu->hardware.h_gr[((UINT) 6)] = current_cpu->GETMEMSI (pc, addr);
  addr = ADDSI (addr, 4);
}
}
if (((FLD (f_reg_list)) & (((1) << (7))))) {
{
current_cpu->hardware.h_gr[((UINT) 7)] = current_cpu->GETMEMSI (pc, addr);
  addr = ADDSI (addr, 4);
}
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: ldmib-wb, ldmib-sw

  CASE (FRAG_LDMIB_WB_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (((FLD (f_reg_list)) & (((1) << (0))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->hardware.h_gr[((UINT) 0)] = current_cpu->GETMEMSI (pc, addr);
}
}
if (((FLD (f_reg_list)) & (((1) << (1))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->hardware.h_gr[((UINT) 1)] = current_cpu->GETMEMSI (pc, addr);
}
}
if (((FLD (f_reg_list)) & (((1) << (2))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->hardware.h_gr[((UINT) 2)] = current_cpu->GETMEMSI (pc, addr);
}
}
if (((FLD (f_reg_list)) & (((1) << (3))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->hardware.h_gr[((UINT) 3)] = current_cpu->GETMEMSI (pc, addr);
}
}
if (((FLD (f_reg_list)) & (((1) << (4))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->hardware.h_gr[((UINT) 4)] = current_cpu->GETMEMSI (pc, addr);
}
}
if (((FLD (f_reg_list)) & (((1) << (5))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->hardware.h_gr[((UINT) 5)] = current_cpu->GETMEMSI (pc, addr);
}
}
if (((FLD (f_reg_list)) & (((1) << (6))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->hardware.h_gr[((UINT) 6)] = current_cpu->GETMEMSI (pc, addr);
}
}
if (((FLD (f_reg_list)) & (((1) << (7))))) {
{
  addr = ADDSI (addr, 4);
current_cpu->hardware.h_gr[((UINT) 7)] = current_cpu->GETMEMSI (pc, addr);
}
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: strb-post-dec-nonpriv-imm-offset, strb-post-inc-imm-offset

  CASE (FRAG_STRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
current_cpu->SETMEMQI (pc, addr, TRUNCSIQI (* FLD (i_rd)));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: ldrb-post-dec-nonpriv-imm-offset, ldrb-post-inc-imm-offset

  CASE (FRAG_LDRB_POST_DEC_NONPRIV_IMM_OFFSET_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
if (((FLD (f_rd)) == (15))) {
npc = ZEXTQISI (current_cpu->GETMEMQI (pc, addr)); br_status = BRANCH_UNCACHEABLE;
} else {
* FLD (i_rd) = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by: ldr-post-dec-nonpriv-imm-offset, ldr-post-inc-imm-offset

  CASE (FRAG_LDR_POST_DEC_NONPRIV_IMM_OFFSET_HDR):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
if (((FLD (f_rd)) == (15))) {
npc = current_cpu->GETMEMSI (pc, addr); br_status = BRANCH_UNCACHEABLE;
} else {
* FLD (i_rd) = current_cpu->GETMEMSI (pc, addr);
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used by:

  CASE (FRAG_X_HEADER):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.fmt_empty.f
      PCADDR pc = abuf->addr;

((void) 0); /*nop*/

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: tst-reg/reg-shift

  CASE (FRAG_TST_REG_REG_SHIFT_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
if (EQSI (FLD (f_rd), 15)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
} else {
{
{
  {
    BI opval = EQSI (result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = carry_out;
    current_cpu->hardware.h_cbit = opval;
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: teq-reg/imm-shift

  CASE (FRAG_TEQ_REG_IMM_SHIFT_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
if (EQSI (FLD (f_rd), 15)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
} else {
{
{
  {
    BI opval = EQSI (result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = carry_out;
    current_cpu->hardware.h_cbit = opval;
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: and-imm, orr-imm, eor-imm, mov-imm, bic-imm

  CASE (FRAG_AND_IMM_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;

{
if (((FLD (f_rd)) == (15))) {
{
npc = result; br_status = BRANCH_UNCACHEABLE;
if (FLD (f_set_cc_)) {
current_cpu->h_cpsr_set (current_cpu->h_spsr_get ());
}
}
} else {
{
* FLD (i_rd) = result;
if (FLD (f_set_cc_)) {
{
current_cpu->hardware.h_zbit = EQSI (result, 0);
current_cpu->hardware.h_nbit = LTSI (result, 0);
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: and-reg/reg-shift, orr-reg/reg-shift, eor-reg/reg-shift, mov-reg/reg-shift, bic-reg/reg-shift

  CASE (FRAG_AND_REG_REG_SHIFT_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
if (((FLD (f_rd)) == (15))) {
{
npc = result; br_status = BRANCH_UNCACHEABLE;
if (FLD (f_set_cc_)) {
current_cpu->h_cpsr_set (current_cpu->h_spsr_get ());
}
}
} else {
{
* FLD (i_rd) = result;
if (FLD (f_set_cc_)) {
{
{
current_cpu->hardware.h_zbit = EQSI (result, 0);
current_cpu->hardware.h_nbit = LTSI (result, 0);
}
current_cpu->hardware.h_cbit = carry_out;
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: orr-reg/imm-shift, eor-reg/imm-shift, mov-reg/imm-shift, bic-reg/imm-shift, mvn-reg/imm-shift

  CASE (FRAG_ORR_REG_IMM_SHIFT_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
if (((FLD (f_rd)) == (15))) {
{
npc = result; br_status = BRANCH_UNCACHEABLE;
if (FLD (f_set_cc_)) {
current_cpu->h_cpsr_set (current_cpu->h_spsr_get ());
}
}
} else {
{
* FLD (i_rd) = result;
if (FLD (f_set_cc_)) {
{
{
current_cpu->hardware.h_zbit = EQSI (result, 0);
current_cpu->hardware.h_nbit = LTSI (result, 0);
}
current_cpu->hardware.h_cbit = carry_out;
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: umull, umlal, smull

  CASE (FRAG_UMULL_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_umull.f
      PCADDR pc = abuf->addr;

{
* FLD (i_rdhi) = SUBWORDDISI (mul_result, 0);
* FLD (i_rdlo) = SUBWORDDISI (mul_result, 1);
if (FLD (f_set_cc_)) {
{
current_cpu->hardware.h_zbit = EQDI (mul_result, 0);
current_cpu->hardware.h_nbit = LTDI (mul_result, 0);
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: ldr-pre-inc-imm-offset, ldrb-pre-dec-imm-offset, ldrb-pre-inc-imm-offset

  CASE (FRAG_LDR_PRE_INC_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
((void) 0); /*nop*/
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: ldrb-pre-dec-reg-offset, ldrb-pre-inc-reg-offset, ldrsb-pre-dec-reg-offset, ldrsb-pre-inc-reg-offset, ldrh-pre-dec-reg-offset, ldrh-pre-inc-reg-offset, ldrsh-pre-dec-reg-offset

  CASE (FRAG_LDRB_PRE_DEC_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
((void) 0); /*nop*/
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: str-pre-dec-reg-offset, str-pre-inc-reg-offset, strb-pre-dec-reg-offset, strb-pre-inc-reg-offset, strh-pre-dec-reg-offset, strh-pre-inc-reg-offset

  CASE (FRAG_STR_PRE_DEC_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
((void) 0); /*nop*/
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: str-pre-dec-imm-offset, str-pre-inc-imm-offset, strb-pre-dec-imm-offset, strb-pre-inc-imm-offset

  CASE (FRAG_STR_PRE_DEC_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
((void) 0); /*nop*/
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: strh-pre-dec-imm-offset, strh-pre-inc-imm-offset

  CASE (FRAG_STRH_PRE_DEC_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
((void) 0); /*nop*/
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: ldrsb-pre-dec-imm-offset, ldrsb-pre-inc-imm-offset, ldrh-pre-dec-imm-offset, ldrh-pre-inc-imm-offset, ldrsh-pre-dec-imm-offset, ldrsh-pre-inc-imm-offset

  CASE (FRAG_LDRSB_PRE_DEC_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
((void) 0); /*nop*/
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-pre-dec-imm-offset

  CASE (FRAG_LDR_PRE_DEC_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
((void) 0); /*nop*/
((void) 0); /*nop*/
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-pre-inc-reg-offset

  CASE (FRAG_LDR_PRE_INC_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
((void) 0); /*nop*/
((void) 0); /*nop*/
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: ldr-pre-inc-wb-imm-offset, ldrb-pre-dec-wb-imm-offset, ldrb-pre-inc-wb-imm-offset

  CASE (FRAG_LDR_PRE_INC_WB_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
* FLD (i_rn) = addr;
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: ldrb-pre-dec-wb-reg-offset, ldrb-pre-inc-wb-reg-offset, ldrsb-pre-dec-wb-reg-offset, ldrsb-pre-inc-wb-reg-offset, ldrh-pre-dec-wb-reg-offset, ldrh-pre-inc-wb-reg-offset, ldrsh-pre-dec-wb-reg-offset

  CASE (FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
* FLD (i_rn) = addr;
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: str-pre-dec-wb-reg-offset, str-pre-inc-wb-reg-offset, strb-pre-dec-wb-reg-offset, strb-pre-inc-wb-reg-offset, strh-pre-dec-wb-reg-offset, strh-pre-inc-wb-reg-offset

  CASE (FRAG_STR_PRE_DEC_WB_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
* FLD (i_rn) = addr;
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: str-pre-dec-wb-imm-offset, str-pre-inc-wb-imm-offset, strb-pre-dec-wb-imm-offset, strb-pre-inc-wb-imm-offset

  CASE (FRAG_STR_PRE_DEC_WB_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
* FLD (i_rn) = addr;
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: strh-pre-dec-wb-imm-offset, strh-pre-inc-wb-imm-offset

  CASE (FRAG_STRH_PRE_DEC_WB_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
* FLD (i_rn) = addr;
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: ldrsb-pre-dec-wb-imm-offset, ldrsb-pre-inc-wb-imm-offset, ldrh-pre-dec-wb-imm-offset, ldrh-pre-inc-wb-imm-offset, ldrsh-pre-dec-wb-imm-offset, ldrsh-pre-inc-wb-imm-offset

  CASE (FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
((void) 0); /*nop*/
* FLD (i_rn) = addr;
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-pre-dec-wb-imm-offset

  CASE (FRAG_LDR_PRE_DEC_WB_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
((void) 0); /*nop*/
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-pre-inc-wb-reg-offset

  CASE (FRAG_LDR_PRE_INC_WB_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
((void) 0); /*nop*/
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: strb-post-inc-reg-offset, strb-post-inc-nonpriv-reg-offset

  CASE (FRAG_STRB_POST_INC_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
current_cpu->SETMEMQI (pc, addr, TRUNCSIQI (* FLD (i_rd)));
  addr = ADDSI (* FLD (i_rn), offset);
* FLD (i_rn) = addr;
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: str-post-inc-reg-offset, str-post-inc-nonpriv-reg-offset

  CASE (FRAG_STR_POST_INC_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
current_cpu->SETMEMSI (pc, addr, * FLD (i_rd));
  addr = ADDSI (* FLD (i_rn), offset);
* FLD (i_rn) = addr;
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: str-post-inc-imm-offset

  CASE (FRAG_STR_POST_INC_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: ldrb-post-inc-reg-offset, ldrb-post-inc-nonpriv-reg-offset

  CASE (FRAG_LDRB_POST_INC_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
if (((FLD (f_rd)) == (15))) {
npc = ZEXTQISI (current_cpu->GETMEMQI (pc, addr)); br_status = BRANCH_UNCACHEABLE;
} else {
* FLD (i_rd) = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
}
  addr = ADDSI (* FLD (i_rn), offset);
* FLD (i_rn) = addr;
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: strb-post-dec-reg-offset, strb-post-dec-nonpriv-reg-offset

  CASE (FRAG_STRB_POST_DEC_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
current_cpu->SETMEMQI (pc, addr, TRUNCSIQI (* FLD (i_rd)));
  addr = SUBSI (* FLD (i_rn), offset);
* FLD (i_rn) = addr;
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: str-post-dec-reg-offset, str-post-dec-nonpriv-reg-offset

  CASE (FRAG_STR_POST_DEC_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
current_cpu->SETMEMSI (pc, addr, * FLD (i_rd));
  addr = SUBSI (* FLD (i_rn), offset);
* FLD (i_rn) = addr;
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: str-post-dec-imm-offset

  CASE (FRAG_STR_POST_DEC_IMM_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by: ldrb-post-dec-reg-offset, ldrb-post-dec-nonpriv-reg-offset

  CASE (FRAG_LDRB_POST_DEC_REG_OFFSET_TRLR):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
if (((FLD (f_rd)) == (15))) {
npc = ZEXTQISI (current_cpu->GETMEMQI (pc, addr)); br_status = BRANCH_UNCACHEABLE;
} else {
* FLD (i_rd) = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
}
  addr = SUBSI (* FLD (i_rn), offset);
* FLD (i_rn) = addr;
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used by:

  CASE (FRAG_X_TRAILER):
    {
#define FLD(f) abuf->fields.fmt_empty.f
      PCADDR pc = abuf->addr;

((void) 0); /*nop*/

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: x-cond

  CASE (FRAG_X_COND_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.fmt_empty.f
      PCADDR pc = abuf->addr;

{
  {
    // Assume branch not taken.
    pbb_br_status = BRANCH_UNTAKEN;
    UINT cond_code = abuf->cond;
    BI exec_p = current_cpu->eval_cond (cond_code, pc);
    if (! exec_p)
      ++vpc;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: x-after

  CASE (FRAG_X_AFTER_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.fmt_empty.f
      PCADDR pc = abuf->addr;

{
  {
    current_cpu->arm_engine.pbb_after (current_cpu, abuf);
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: x-before

  CASE (FRAG_X_BEFORE_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.fmt_empty.f
      PCADDR pc = abuf->addr;

{
  {
    current_cpu->arm_engine.pbb_before (current_cpu, abuf);
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: x-cti-chain

  CASE (FRAG_X_CTI_CHAIN_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.fmt_empty.f
      PCADDR pc = abuf->addr;

{
  {
    vpc = current_cpu->arm_engine.pbb_cti_chain (current_cpu, abuf, pbb_br_status, pbb_br_npc);
    // If we don't have to give up control, don't.
    // Note that we may overrun step_insn_count since we do the test at the
    // end of the block.  This is defined to be ok.
    if (UNLIKELY(current_cpu->stop_after_insns_p (abuf->fields.chain.insn_count)))
      BREAK (vpc);
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: x-chain

  CASE (FRAG_X_CHAIN_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.fmt_empty.f
      PCADDR pc = abuf->addr;

{
  {
    vpc = current_cpu->arm_engine.pbb_chain (current_cpu, abuf);
    // If we don't have to give up control, don't.
    // Note that we may overrun step_insn_count since we do the test at the
    // end of the block.  This is defined to be ok.
    if (UNLIKELY(current_cpu->stop_after_insns_p (abuf->fields.chain.insn_count)))
      BREAK (vpc);
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: x-begin

  CASE (FRAG_X_BEGIN_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.fmt_empty.f
      PCADDR pc = abuf->addr;

{
  {
    vpc = current_cpu->arm_pbb_begin (current_cpu->h_pc_get ());
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: x-invalid

  CASE (FRAG_X_INVALID_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.fmt_empty.f
      PCADDR pc = abuf->addr;

{
  {
    current_cpu->invalid_insn (pc);
    assert (0);
    /* NOTREACHED */
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: b

  CASE (FRAG_B_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_b.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  {
    USI opval = FLD (i_offset24);
    npc = opval; br_status = BRANCH_CACHEABLE;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: bl

  CASE (FRAG_BL_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_b.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  {
    SI opval = ANDSI (ADDSI (pc, 4), -4);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
  {
    USI opval = FLD (i_offset24);
    npc = opval; br_status = BRANCH_CACHEABLE;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: bx

  CASE (FRAG_BX_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_bx.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  {
    USI opval = ANDSI (* FLD (i_bx_rn), 0xfffffffe);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (ANDSI (* FLD (i_bx_rn), 1)) {
  {
    BI opval = 1;
    current_cpu->h_tbit_set (opval);
  }
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-post-dec-imm-offset

  CASE (FRAG_LDR_POST_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-post-dec-reg-offset

  CASE (FRAG_LDR_POST_DEC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-post-inc-imm-offset

  CASE (FRAG_LDR_POST_INC_IMM_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-post-inc-reg-offset

  CASE (FRAG_LDR_POST_INC_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-post-dec-nonpriv-imm-offset

  CASE (FRAG_LDR_POST_DEC_NONPRIV_IMM_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-post-dec-nonpriv-reg-offset

  CASE (FRAG_LDR_POST_DEC_NONPRIV_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-post-inc-nonpriv-imm-offset

  CASE (FRAG_LDR_POST_INC_NONPRIV_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-post-inc-nonpriv-reg-offset

  CASE (FRAG_LDR_POST_INC_NONPRIV_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-pre-dec-imm-offset

  CASE (FRAG_LDR_PRE_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = SUBSI (* FLD (i_rn), offset);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldr-pre-dec-reg-offset

  CASE (FRAG_LDR_PRE_DEC_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
((void) 0); /*nop*/
((void) 0); /*nop*/
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-pre-inc-imm-offset

  CASE (FRAG_LDR_PRE_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldr-pre-inc-reg-offset

  CASE (FRAG_LDR_PRE_INC_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = ADDSI (* FLD (i_rn), offset);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldr-pre-dec-wb-imm-offset

  CASE (FRAG_LDR_PRE_DEC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = SUBSI (* FLD (i_rn), offset);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldr-pre-dec-wb-reg-offset

  CASE (FRAG_LDR_PRE_DEC_WB_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
((void) 0); /*nop*/
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldr-pre-inc-wb-imm-offset

  CASE (FRAG_LDR_PRE_INC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldr-pre-inc-wb-reg-offset

  CASE (FRAG_LDR_PRE_INC_WB_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = ADDSI (* FLD (i_rn), offset);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrb-post-dec-imm-offset

  CASE (FRAG_LDRB_POST_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrb-post-inc-imm-offset

  CASE (FRAG_LDRB_POST_INC_IMM_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrb-post-dec-nonpriv-imm-offset

  CASE (FRAG_LDRB_POST_DEC_NONPRIV_IMM_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrb-post-inc-nonpriv-imm-offset

  CASE (FRAG_LDRB_POST_INC_NONPRIV_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrb-pre-dec-imm-offset

  CASE (FRAG_LDRB_PRE_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrb-pre-dec-reg-offset

  CASE (FRAG_LDRB_PRE_DEC_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrb-pre-inc-imm-offset

  CASE (FRAG_LDRB_PRE_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrb-pre-inc-reg-offset

  CASE (FRAG_LDRB_PRE_INC_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrb-pre-dec-wb-imm-offset

  CASE (FRAG_LDRB_PRE_DEC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrb-pre-dec-wb-reg-offset

  CASE (FRAG_LDRB_PRE_DEC_WB_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrb-pre-inc-wb-imm-offset

  CASE (FRAG_LDRB_PRE_INC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrb-pre-inc-wb-reg-offset

  CASE (FRAG_LDRB_PRE_INC_WB_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: str-post-dec-imm-offset

  CASE (FRAG_STR_POST_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: str-post-inc-imm-offset

  CASE (FRAG_STR_POST_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: str-post-dec-nonpriv-imm-offset

  CASE (FRAG_STR_POST_DEC_NONPRIV_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: str-post-inc-nonpriv-imm-offset

  CASE (FRAG_STR_POST_INC_NONPRIV_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: str-pre-dec-imm-offset

  CASE (FRAG_STR_PRE_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: str-pre-dec-reg-offset

  CASE (FRAG_STR_PRE_DEC_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: str-pre-inc-imm-offset

  CASE (FRAG_STR_PRE_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: str-pre-inc-reg-offset

  CASE (FRAG_STR_PRE_INC_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: str-pre-dec-wb-imm-offset

  CASE (FRAG_STR_PRE_DEC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: str-pre-dec-wb-reg-offset

  CASE (FRAG_STR_PRE_DEC_WB_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: str-pre-inc-wb-imm-offset

  CASE (FRAG_STR_PRE_INC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: str-pre-inc-wb-reg-offset

  CASE (FRAG_STR_PRE_INC_WB_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = * FLD (i_rd);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strb-post-dec-imm-offset

  CASE (FRAG_STRB_POST_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
  {
    QI opval = TRUNCSIQI (* FLD (i_rd));
    current_cpu->SETMEMQI (pc, addr, opval);
  }
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: strb-post-inc-imm-offset

  CASE (FRAG_STRB_POST_INC_IMM_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: strb-post-dec-nonpriv-imm-offset

  CASE (FRAG_STRB_POST_DEC_NONPRIV_IMM_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: strb-post-inc-nonpriv-imm-offset

  CASE (FRAG_STRB_POST_INC_NONPRIV_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = * FLD (i_rn);
  {
    QI opval = TRUNCSIQI (* FLD (i_rd));
    current_cpu->SETMEMQI (pc, addr, opval);
  }
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: strb-post-inc-nonpriv-reg-offset

  CASE (FRAG_STRB_POST_INC_NONPRIV_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = * FLD (i_rn);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strb-pre-dec-imm-offset

  CASE (FRAG_STRB_PRE_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = SUBSI (* FLD (i_rn), offset);
  {
    QI opval = TRUNCSIQI (* FLD (i_rd));
    current_cpu->SETMEMQI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strb-pre-dec-reg-offset

  CASE (FRAG_STRB_PRE_DEC_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
  {
    QI opval = TRUNCSIQI (* FLD (i_rd));
    current_cpu->SETMEMQI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strb-pre-inc-imm-offset

  CASE (FRAG_STRB_PRE_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = ADDSI (* FLD (i_rn), offset);
  {
    QI opval = TRUNCSIQI (* FLD (i_rd));
    current_cpu->SETMEMQI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strb-pre-inc-reg-offset

  CASE (FRAG_STRB_PRE_INC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
  addr = ADDSI (* FLD (i_rn), offset);
  {
    QI opval = TRUNCSIQI (* FLD (i_rd));
    current_cpu->SETMEMQI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strb-pre-dec-wb-imm-offset

  CASE (FRAG_STRB_PRE_DEC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = SUBSI (* FLD (i_rn), offset);
  {
    QI opval = TRUNCSIQI (* FLD (i_rd));
    current_cpu->SETMEMQI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strb-pre-dec-wb-reg-offset

  CASE (FRAG_STRB_PRE_DEC_WB_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = SUBSI (* FLD (i_rn), offset);
  {
    QI opval = TRUNCSIQI (* FLD (i_rd));
    current_cpu->SETMEMQI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strb-pre-inc-wb-imm-offset

  CASE (FRAG_STRB_PRE_INC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldr_post_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (f_uimm12);
  addr = ADDSI (* FLD (i_rn), offset);
  {
    QI opval = TRUNCSIQI (* FLD (i_rd));
    current_cpu->SETMEMQI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strb-pre-inc-wb-reg-offset

  CASE (FRAG_STRB_PRE_INC_WB_REG_OFFSET_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  addr = ADDSI (* FLD (i_rn), offset);
  {
    QI opval = TRUNCSIQI (* FLD (i_rd));
    current_cpu->SETMEMQI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strh-pre-dec-imm-offset

  CASE (FRAG_STRH_PRE_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = SUBSI (* FLD (i_rn), offset);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strh-pre-dec-reg-offset

  CASE (FRAG_STRH_PRE_DEC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = SUBSI (* FLD (i_rn), offset);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strh-pre-inc-imm-offset

  CASE (FRAG_STRH_PRE_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = ADDSI (* FLD (i_rn), offset);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strh-pre-inc-reg-offset

  CASE (FRAG_STRH_PRE_INC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = ADDSI (* FLD (i_rn), offset);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strh-pre-dec-wb-imm-offset

  CASE (FRAG_STRH_PRE_DEC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = SUBSI (* FLD (i_rn), offset);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strh-pre-dec-wb-reg-offset

  CASE (FRAG_STRH_PRE_DEC_WB_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = SUBSI (* FLD (i_rn), offset);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strh-pre-inc-wb-imm-offset

  CASE (FRAG_STRH_PRE_INC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = ADDSI (* FLD (i_rn), offset);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strh-pre-inc-wb-reg-offset

  CASE (FRAG_STRH_PRE_INC_WB_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = ADDSI (* FLD (i_rn), offset);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: strh-post-dec-imm-offset

  CASE (FRAG_STRH_POST_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = * FLD (i_rn);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: strh-post-dec-reg-offset

  CASE (FRAG_STRH_POST_DEC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = * FLD (i_rn);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: strh-post-inc-imm-offset

  CASE (FRAG_STRH_POST_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = * FLD (i_rn);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: strh-post-inc-reg-offset

  CASE (FRAG_STRH_POST_INC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = * FLD (i_rn);
  {
    HI opval = TRUNCSIHI (* FLD (i_rd));
    current_cpu->SETMEMHI (pc, addr, opval);
  }
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrsb-pre-dec-imm-offset

  CASE (FRAG_LDRSB_PRE_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsb-pre-dec-reg-offset

  CASE (FRAG_LDRSB_PRE_DEC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsb-pre-inc-imm-offset

  CASE (FRAG_LDRSB_PRE_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsb-pre-inc-reg-offset

  CASE (FRAG_LDRSB_PRE_INC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsb-pre-dec-wb-imm-offset

  CASE (FRAG_LDRSB_PRE_DEC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsb-pre-dec-wb-reg-offset

  CASE (FRAG_LDRSB_PRE_DEC_WB_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsb-pre-inc-wb-imm-offset

  CASE (FRAG_LDRSB_PRE_INC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsb-pre-inc-wb-reg-offset

  CASE (FRAG_LDRSB_PRE_INC_WB_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsb-post-dec-imm-offset

  CASE (FRAG_LDRSB_POST_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrsb-post-dec-reg-offset

  CASE (FRAG_LDRSB_POST_DEC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrsb-post-inc-imm-offset

  CASE (FRAG_LDRSB_POST_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrsb-post-inc-reg-offset

  CASE (FRAG_LDRSB_POST_INC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTQISI (current_cpu->GETMEMQI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrh-pre-dec-imm-offset

  CASE (FRAG_LDRH_PRE_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrh-pre-dec-reg-offset

  CASE (FRAG_LDRH_PRE_DEC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrh-pre-inc-imm-offset

  CASE (FRAG_LDRH_PRE_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrh-pre-inc-reg-offset

  CASE (FRAG_LDRH_PRE_INC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrh-pre-dec-wb-imm-offset

  CASE (FRAG_LDRH_PRE_DEC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrh-pre-dec-wb-reg-offset

  CASE (FRAG_LDRH_PRE_DEC_WB_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrh-pre-inc-wb-imm-offset

  CASE (FRAG_LDRH_PRE_INC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrh-pre-inc-wb-reg-offset

  CASE (FRAG_LDRH_PRE_INC_WB_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrh-post-dec-imm-offset

  CASE (FRAG_LDRH_POST_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrh-post-dec-reg-offset

  CASE (FRAG_LDRH_POST_DEC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrh-post-inc-imm-offset

  CASE (FRAG_LDRH_POST_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrh-post-inc-reg-offset

  CASE (FRAG_LDRH_POST_INC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = ZEXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrsh-pre-dec-imm-offset

  CASE (FRAG_LDRSH_PRE_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsh-pre-dec-reg-offset

  CASE (FRAG_LDRSH_PRE_DEC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsh-pre-inc-imm-offset

  CASE (FRAG_LDRSH_PRE_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsh-pre-inc-reg-offset

  CASE (FRAG_LDRSH_PRE_INC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
((void) 0); /*nop*/
((void) 0); /*nop*/
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrsh-pre-dec-wb-imm-offset

  CASE (FRAG_LDRSH_PRE_DEC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsh-pre-dec-wb-reg-offset

  CASE (FRAG_LDRSH_PRE_DEC_WB_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = SUBSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsh-pre-inc-wb-imm-offset

  CASE (FRAG_LDRSH_PRE_INC_WB_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: ldrsh-pre-inc-wb-reg-offset

  CASE (FRAG_LDRSH_PRE_INC_WB_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = ADDSI (* FLD (i_rn), offset);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
((void) 0); /*nop*/
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrsh-post-dec-imm-offset

  CASE (FRAG_LDRSH_POST_DEC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrsh-post-dec-reg-offset

  CASE (FRAG_LDRSH_POST_DEC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = SUBSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrsh-post-inc-imm-offset

  CASE (FRAG_LDRSH_POST_INC_IMM_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = FLD (i_hdt_offset8);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldrsh-post-inc-reg-offset

  CASE (FRAG_LDRSH_POST_INC_REG_OFFSET_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  offset = * FLD (i_rm);
  addr = * FLD (i_rn);
if (EQSI (FLD (f_rd), 15)) {
  {
    USI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
} else {
  {
    SI opval = EXTHISI (current_cpu->GETMEMHI (pc, addr));
    * FLD (i_rd) = opval;
  }
}
  addr = ADDSI (* FLD (i_rn), offset);
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: mul

  CASE (FRAG_MUL_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_mla.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = MULSI (* FLD (i_rm), * FLD (i_rs));
  {
    SI opval = result;
    * FLD (i_mul_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  {
    BI opval = EQSI (result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: mla

  CASE (FRAG_MLA_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_mla.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  {
    SI opval = ADDSI (MULSI (* FLD (i_rm), * FLD (i_rs)), * FLD (i_mul_rn));
    * FLD (i_mul_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  {
    BI opval = EQSI (result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: umull

  CASE (FRAG_UMULL_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_umull.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  mul_result = MULDI (ZEXTSIDI (* FLD (i_rs)), ZEXTSIDI (* FLD (i_rm)));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: umlal

  CASE (FRAG_UMLAL_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_umull.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  mul_result = JOINSIDI (* FLD (i_rdhi), * FLD (i_rdlo));
  mul_result = ADDDI (MULDI (ZEXTSIDI (* FLD (i_rs)), ZEXTSIDI (* FLD (i_rm))), mul_result);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: smull

  CASE (FRAG_SMULL_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_umull.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  mul_result = MULDI (EXTSIDI (* FLD (i_rs)), EXTSIDI (* FLD (i_rm)));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: smlal

  CASE (FRAG_SMLAL_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_umull.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  mul_result = JOINSIDI (* FLD (i_rdhi), * FLD (i_rdlo));
  mul_result = ADDDI (MULDI (EXTSIDI (* FLD (i_rs)), EXTSIDI (* FLD (i_rm))), mul_result);
  {
    SI opval = SUBWORDDISI (mul_result, 0);
    * FLD (i_rdhi) = opval;
  }
  {
    SI opval = SUBWORDDISI (mul_result, 1);
    * FLD (i_rdlo) = opval;
  }
if (FLD (f_set_cc_)) {
{
  {
    BI opval = EQDI (mul_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTDI (mul_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: swp

  CASE (FRAG_SWP_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  temp = current_cpu->GETMEMSI (pc, * FLD (i_rn));
  {
    SI opval = * FLD (i_rm);
    current_cpu->SETMEMSI (pc, * FLD (i_rn), opval);
  }
  {
    SI opval = temp;
    * FLD (i_rd) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: swpb

  CASE (FRAG_SWPB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  temp = current_cpu->GETMEMQI (pc, * FLD (i_rn));
  {
    QI opval = * FLD (i_rm);
    current_cpu->SETMEMQI (pc, * FLD (i_rn), opval);
  }
  {
    SI opval = temp;
    * FLD (i_rd) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: swi

  CASE (FRAG_SWI_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_swi.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  {
    USI opval = current_cpu->arm_swi (pc, FLD (f_swi_comment));
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: and-reg/imm-shift

  CASE (FRAG_AND_REG_IMM_SHIFT_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
  carry_out = current_cpu->compute_carry_out_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm), current_cpu->hardware.h_cbit);
  result = ANDSI (* FLD (i_rn), operand2);
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
{
  {
    BI opval = EQSI (result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = carry_out;
    current_cpu->hardware.h_cbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: and-reg/reg-shift

  CASE (FRAG_AND_REG_REG_SHIFT_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_regshift (* FLD (i_rm), FLD (f_operand2_shifttype), * FLD (i_operand2_shiftreg));
  carry_out = current_cpu->compute_carry_out_regshift (* FLD (i_rm), FLD (f_operand2_shifttype), * FLD (i_operand2_shiftreg), current_cpu->hardware.h_cbit);
  result = ANDSI (* FLD (i_rn), operand2);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: and-imm

  CASE (FRAG_AND_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = ANDSI (* FLD (i_rn), FLD (f_imm12));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: orr-reg/imm-shift

  CASE (FRAG_ORR_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  result = ORSI (* FLD (i_rn), operand2);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: orr-reg/reg-shift

  CASE (FRAG_ORR_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  result = ORSI (* FLD (i_rn), operand2);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: orr-imm

  CASE (FRAG_ORR_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = ORSI (* FLD (i_rn), FLD (f_imm12));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: eor-reg/imm-shift

  CASE (FRAG_EOR_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  result = XORSI (* FLD (i_rn), operand2);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: eor-reg/reg-shift

  CASE (FRAG_EOR_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  result = XORSI (* FLD (i_rn), operand2);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: eor-imm

  CASE (FRAG_EOR_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = XORSI (* FLD (i_rn), FLD (f_imm12));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: mov-reg/imm-shift

  CASE (FRAG_MOV_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  result = operand2;
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: mov-reg/reg-shift

  CASE (FRAG_MOV_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  result = operand2;
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: mov-imm

  CASE (FRAG_MOV_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = FLD (f_imm12);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: bic-reg/imm-shift

  CASE (FRAG_BIC_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  result = ANDSI (* FLD (i_rn), INVSI (operand2));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: bic-reg/reg-shift

  CASE (FRAG_BIC_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  result = ANDSI (* FLD (i_rn), INVSI (operand2));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: bic-imm

  CASE (FRAG_BIC_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = ANDSI (* FLD (i_rn), INVSI (FLD (f_imm12)));
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: mvn-reg/imm-shift

  CASE (FRAG_MVN_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  carry_out = current_cpu->compute_carry_out_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm), current_cpu->hardware.h_cbit);
  result = INVSI (operand2);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: mvn-reg/reg-shift

  CASE (FRAG_MVN_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  carry_out = current_cpu->compute_carry_out_regshift (* FLD (i_rm), FLD (f_operand2_shifttype), * FLD (i_operand2_shiftreg), current_cpu->hardware.h_cbit);
  result = INVSI (operand2);
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
{
  {
    BI opval = EQSI (result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = carry_out;
    current_cpu->hardware.h_cbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: mvn-imm

  CASE (FRAG_MVN_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = INVSI (FLD (f_imm12));
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  {
    BI opval = EQSI (result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: add-reg/imm-shift

  CASE (FRAG_ADD_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = ADDSI (* FLD (i_rn), operand2);
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = ADDCSI (temp_op1, temp_op2, 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = ADDCFSI (temp_op1, temp_op2, 0);
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = ADDOFSI (temp_op1, temp_op2, 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: add-reg/reg-shift

  CASE (FRAG_ADD_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = ADDSI (* FLD (i_rn), operand2);
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = ADDCSI (temp_op1, temp_op2, 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = ADDCFSI (temp_op1, temp_op2, 0);
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = ADDOFSI (temp_op1, temp_op2, 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: add-imm

  CASE (FRAG_ADD_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = ADDSI (* FLD (i_rn), FLD (f_imm12));
if (EQSI (FLD (f_rd), 15)) {
{
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
}
} else {
{
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = ADDCSI (* FLD (i_rn), FLD (f_imm12), 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = ADDCFSI (* FLD (i_rn), FLD (f_imm12), 0);
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = ADDOFSI (* FLD (i_rn), FLD (f_imm12), 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: adc-reg/imm-shift

  CASE (FRAG_ADC_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = ADDCSI (* FLD (i_rn), operand2, current_cpu->hardware.h_cbit);
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = ADDCSI (temp_op1, temp_op2, current_cpu->hardware.h_cbit);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = ADDCFSI (temp_op1, temp_op2, current_cpu->hardware.h_cbit);
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = ADDOFSI (temp_op1, temp_op2, current_cpu->hardware.h_cbit);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: adc-reg/reg-shift

  CASE (FRAG_ADC_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = ADDCSI (* FLD (i_rn), operand2, current_cpu->hardware.h_cbit);
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = ADDCSI (temp_op1, temp_op2, current_cpu->hardware.h_cbit);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = ADDCFSI (temp_op1, temp_op2, current_cpu->hardware.h_cbit);
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = ADDOFSI (temp_op1, temp_op2, current_cpu->hardware.h_cbit);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: adc-imm

  CASE (FRAG_ADC_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = ADDCSI (* FLD (i_rn), FLD (f_imm12), current_cpu->hardware.h_cbit);
if (EQSI (FLD (f_rd), 15)) {
{
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
}
} else {
{
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = ADDCSI (* FLD (i_rn), FLD (f_imm12), current_cpu->hardware.h_cbit);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = ADDCFSI (* FLD (i_rn), FLD (f_imm12), current_cpu->hardware.h_cbit);
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = ADDOFSI (* FLD (i_rn), FLD (f_imm12), current_cpu->hardware.h_cbit);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: sub-reg/imm-shift

  CASE (FRAG_SUB_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = SUBSI (* FLD (i_rn), operand2);
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (temp_op1, temp_op2, 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (temp_op1, temp_op2, 0));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (temp_op1, temp_op2, 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: sub-reg/reg-shift

  CASE (FRAG_SUB_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = SUBSI (* FLD (i_rn), operand2);
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (temp_op1, temp_op2, 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (temp_op1, temp_op2, 0));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (temp_op1, temp_op2, 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: sub-imm

  CASE (FRAG_SUB_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = SUBSI (* FLD (i_rn), FLD (f_imm12));
if (EQSI (FLD (f_rd), 15)) {
{
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
}
} else {
{
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (* FLD (i_rn), FLD (f_imm12), 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (* FLD (i_rn), FLD (f_imm12), 0));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (* FLD (i_rn), FLD (f_imm12), 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: sbc-reg/imm-shift

  CASE (FRAG_SBC_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = SUBCSI (* FLD (i_rn), operand2, NOTBI (current_cpu->hardware.h_cbit));
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (temp_op1, temp_op2, NOTBI (current_cpu->hardware.h_cbit));
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (temp_op1, temp_op2, NOTBI (current_cpu->hardware.h_cbit)));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (temp_op1, temp_op2, NOTBI (current_cpu->hardware.h_cbit));
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: sbc-reg/reg-shift

  CASE (FRAG_SBC_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = SUBCSI (* FLD (i_rn), operand2, NOTBI (current_cpu->hardware.h_cbit));
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (temp_op1, temp_op2, NOTBI (current_cpu->hardware.h_cbit));
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (temp_op1, temp_op2, NOTBI (current_cpu->hardware.h_cbit)));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (temp_op1, temp_op2, NOTBI (current_cpu->hardware.h_cbit));
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: sbc-imm

  CASE (FRAG_SBC_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = SUBCSI (* FLD (i_rn), FLD (f_imm12), NOTBI (current_cpu->hardware.h_cbit));
if (EQSI (FLD (f_rd), 15)) {
{
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
}
} else {
{
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (* FLD (i_rn), FLD (f_imm12), NOTBI (current_cpu->hardware.h_cbit));
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (* FLD (i_rn), FLD (f_imm12), NOTBI (current_cpu->hardware.h_cbit)));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (* FLD (i_rn), FLD (f_imm12), NOTBI (current_cpu->hardware.h_cbit));
    current_cpu->hardware.h_vbit = opval;
  }
}
}
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: rsb-reg/imm-shift

  CASE (FRAG_RSB_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = SUBSI (operand2, * FLD (i_rn));
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (temp_op2, temp_op1, 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (temp_op2, temp_op1, 0));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (temp_op2, temp_op1, 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: rsb-reg/reg-shift

  CASE (FRAG_RSB_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = SUBSI (operand2, * FLD (i_rn));
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (temp_op2, temp_op1, 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (temp_op2, temp_op1, 0));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (temp_op2, temp_op1, 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: rsb-imm

  CASE (FRAG_RSB_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = SUBSI (FLD (f_imm12), * FLD (i_rn));
if (EQSI (FLD (f_rd), 15)) {
{
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
}
} else {
{
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (FLD (f_imm12), * FLD (i_rn), 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (FLD (f_imm12), * FLD (i_rn), 0));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (FLD (f_imm12), * FLD (i_rn), 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: rsc-reg/imm-shift

  CASE (FRAG_RSC_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = SUBCSI (operand2, * FLD (i_rn), NOTBI (current_cpu->hardware.h_cbit));
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (temp_op2, temp_op1, NOTBI (current_cpu->hardware.h_cbit));
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (temp_op2, temp_op1, NOTBI (current_cpu->hardware.h_cbit)));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (temp_op2, temp_op1, NOTBI (current_cpu->hardware.h_cbit));
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: rsc-reg/reg-shift

  CASE (FRAG_RSC_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  temp_op1 = * FLD (i_rn);
  temp_op2 = operand2;
  result = SUBCSI (operand2, * FLD (i_rn), NOTBI (current_cpu->hardware.h_cbit));
if (EQSI (FLD (f_rd), 15)) {
{
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
} else {
{
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (temp_op2, temp_op1, NOTBI (current_cpu->hardware.h_cbit));
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (temp_op2, temp_op1, NOTBI (current_cpu->hardware.h_cbit)));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (temp_op2, temp_op1, NOTBI (current_cpu->hardware.h_cbit));
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: rsc-imm

  CASE (FRAG_RSC_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = SUBCSI (FLD (f_imm12), * FLD (i_rn), NOTBI (current_cpu->hardware.h_cbit));
if (EQSI (FLD (f_rd), 15)) {
{
if (FLD (f_set_cc_)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
  {
    USI opval = result;
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
}
} else {
{
if (FLD (f_set_cc_)) {
{
  SI tmp_result;
  tmp_result = SUBCSI (FLD (f_imm12), * FLD (i_rn), NOTBI (current_cpu->hardware.h_cbit));
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (FLD (f_imm12), * FLD (i_rn), NOTBI (current_cpu->hardware.h_cbit)));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (FLD (f_imm12), * FLD (i_rn), NOTBI (current_cpu->hardware.h_cbit));
    current_cpu->hardware.h_vbit = opval;
  }
}
}
  {
    SI opval = result;
    * FLD (i_rd) = opval;
  }
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: tst-reg/imm-shift

  CASE (FRAG_TST_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  result = ANDSI (* FLD (i_rn), operand2);
if (EQSI (FLD (f_rd), 15)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
} else {
{
{
  {
    BI opval = EQSI (result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = carry_out;
    current_cpu->hardware.h_cbit = opval;
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: tst-reg/reg-shift

  CASE (FRAG_TST_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  result = ANDSI (* FLD (i_rn), operand2);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: tst-imm

  CASE (FRAG_TST_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_tst_imm.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
if (EQSI (FLD (f_ror_imm8_rotate), 0)) {
  carry_out = current_cpu->hardware.h_cbit;
} else {
  carry_out = LTBI (FLD (f_ror_imm8), 0);
}
{
{
  {
    BI opval = EQSI (ANDSI (* FLD (i_rn), FLD (f_ror_imm8)), 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (ANDSI (* FLD (i_rn), FLD (f_ror_imm8)), 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = carry_out;
    current_cpu->hardware.h_cbit = opval;
  }
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: teq-reg/imm-shift

  CASE (FRAG_TEQ_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
  result = XORSI (* FLD (i_rn), operand2);
}

#undef FLD
    }
    NEXT_FRAG (fragpc);

// ********** used only by: teq-reg/reg-shift

  CASE (FRAG_TEQ_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
  result = XORSI (* FLD (i_rn), operand2);
if (EQSI (FLD (f_rd), 15)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
} else {
{
{
  {
    BI opval = EQSI (result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = carry_out;
    current_cpu->hardware.h_cbit = opval;
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: teq-imm

  CASE (FRAG_TEQ_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_tst_imm.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
if (EQSI (FLD (f_ror_imm8_rotate), 0)) {
  carry_out = current_cpu->hardware.h_cbit;
} else {
  carry_out = LTBI (FLD (f_ror_imm8), 0);
}
{
{
  {
    BI opval = EQSI (XORSI (* FLD (i_rn), FLD (f_ror_imm8)), 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (XORSI (* FLD (i_rn), FLD (f_ror_imm8)), 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = carry_out;
    current_cpu->hardware.h_cbit = opval;
  }
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: cmp-reg/imm-shift

  CASE (FRAG_CMP_REG_IMM_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;

{
if (EQSI (FLD (f_rd), 15)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
} else {
{
  SI tmp_result;
  tmp_result = SUBCSI (* FLD (i_rn), operand2, 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (* FLD (i_rn), operand2, 0));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (* FLD (i_rn), operand2, 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: cmp-reg/reg-shift

  CASE (FRAG_CMP_REG_REG_SHIFT_MID):
    {
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;

{
if (EQSI (FLD (f_rd), 15)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
} else {
{
  SI tmp_result;
  tmp_result = SUBCSI (* FLD (i_rn), operand2, 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (* FLD (i_rn), operand2, 0));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (* FLD (i_rn), operand2, 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: cmp-imm

  CASE (FRAG_CMP_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = SUBCSI (* FLD (i_rn), FLD (f_imm12), 0);
{
  {
    BI opval = EQSI (result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = NOTSI (SUBCFSI (* FLD (i_rn), FLD (f_imm12), 0));
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = SUBOFSI (* FLD (i_rn), FLD (f_imm12), 0);
    current_cpu->hardware.h_vbit = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: cmn-reg/imm-shift

  CASE (FRAG_CMN_REG_IMM_SHIFT_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_immshift (* FLD (i_rm), FLD (f_operand2_shifttype), FLD (f_operand2_shiftimm));
if (EQSI (FLD (f_rd), 15)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
} else {
{
  SI tmp_result;
  tmp_result = ADDCSI (* FLD (i_rn), operand2, 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = ADDCFSI (* FLD (i_rn), operand2, 0);
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = ADDOFSI (* FLD (i_rn), operand2, 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: cmn-reg/reg-shift

  CASE (FRAG_CMN_REG_REG_SHIFT_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_reg_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  operand2 = current_cpu->compute_operand2_regshift (* FLD (i_rm), FLD (f_operand2_shifttype), * FLD (i_operand2_shiftreg));
if (EQSI (FLD (f_rd), 15)) {
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
} else {
{
  SI tmp_result;
  tmp_result = ADDCSI (* FLD (i_rn), operand2, 0);
{
  {
    BI opval = EQSI (tmp_result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (tmp_result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = ADDCFSI (* FLD (i_rn), operand2, 0);
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = ADDOFSI (* FLD (i_rn), operand2, 0);
    current_cpu->hardware.h_vbit = opval;
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: cmn-imm

  CASE (FRAG_CMN_IMM_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_imm.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  result = ADDCSI (* FLD (i_rn), FLD (f_imm12), 0);
{
  {
    BI opval = EQSI (result, 0);
    current_cpu->hardware.h_zbit = opval;
  }
  {
    BI opval = LTSI (result, 0);
    current_cpu->hardware.h_nbit = opval;
  }
}
  {
    BI opval = ADDCFSI (* FLD (i_rn), FLD (f_imm12), 0);
    current_cpu->hardware.h_cbit = opval;
  }
  {
    BI opval = ADDOFSI (* FLD (i_rn), FLD (f_imm12), 0);
    current_cpu->hardware.h_vbit = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmda

  CASE (FRAG_LDMDA_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmda-sw

  CASE (FRAG_LDMDA_SW_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (14, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (13, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (12, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (11, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (10, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (9, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (8, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmda-wb

  CASE (FRAG_LDMDA_WB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmda-sw-wb

  CASE (FRAG_LDMDA_SW_WB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (14, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (13, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (12, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (11, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (10, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (9, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (8, 8)] = opval;
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
  addr = SUBSI (addr, 4);
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmib

  CASE (FRAG_LDMIB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = ADDSI (addr, 4);
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmib-sw

  CASE (FRAG_LDMIB_SW_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (8, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (9, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (10, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (11, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (12, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (13, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (14, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = ADDSI (addr, 4);
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmib-wb

  CASE (FRAG_LDMIB_WB_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = ADDSI (addr, 4);
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmib-sw-wb

  CASE (FRAG_LDMIB_SW_WB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (8, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (9, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (10, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (11, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (12, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (13, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (14, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = ADDSI (addr, 4);
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmia

  CASE (FRAG_LDMIA_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  addr = ADDSI (addr, 4);
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmia-sw

  CASE (FRAG_LDMIA_SW_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (8, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (9, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (10, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (11, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (12, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (13, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (14, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmia-wb

  CASE (FRAG_LDMIA_WB_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  addr = ADDSI (addr, 4);
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmia-sw-wb

  CASE (FRAG_LDMIA_SW_WB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (8, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (9, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (10, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (11, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (12, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (13, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (14, 8)] = opval;
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmdb

  CASE (FRAG_LDMDB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = SUBSI (addr, 4);
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmdb-sw

  CASE (FRAG_LDMDB_SW_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = SUBSI (addr, 4);
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (14, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (13, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (12, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (11, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (10, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (9, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (8, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
}
}
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmdb-wb

  CASE (FRAG_LDMDB_WB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = SUBSI (addr, 4);
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: ldmdb-sw-wb

  CASE (FRAG_LDMDB_SW_WB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      br_status = BRANCH_UNTAKEN;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = SUBSI (addr, 4);
  {
    USI opval = current_cpu->GETMEMSI (pc, addr);
    npc = opval; br_status = BRANCH_UNCACHEABLE;
  }
  {
    SI opval = current_cpu->h_spsr_get ();
    current_cpu->h_cpsr_set (opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 14)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (14, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 13)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (13, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 12)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (12, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 11)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (11, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 10)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (10, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 9)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (9, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 8)] = opval;
  }
} else {
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr_usr[SUBSI (8, 8)] = opval;
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 7)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 6)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 5)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 4)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 3)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 2)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 1)] = opval;
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->GETMEMSI (pc, addr);
    current_cpu->hardware.h_gr[((UINT) 0)] = opval;
  }
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

      pbb_br_npc = npc;
      pbb_br_status = br_status;
#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmdb

  CASE (FRAG_STMDB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmdb-sw

  CASE (FRAG_STMDB_SW_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (14, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (13, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (12, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (11, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (10, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (9, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (8, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmdb-wb

  CASE (FRAG_STMDB_WB_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmdb-sw-wb

  CASE (FRAG_STMDB_SW_WB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (14, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (13, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (12, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (11, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (10, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (9, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = SUBSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (8, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = SUBSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmib

  CASE (FRAG_STMIB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmib-sw

  CASE (FRAG_STMIB_SW_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (8, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (9, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (10, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (11, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (12, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (13, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (14, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmib-wb

  CASE (FRAG_STMIB_WB_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmib-sw-wb

  CASE (FRAG_STMIB_SW_WB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (8, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (9, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (10, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (11, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (12, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (13, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  addr = ADDSI (addr, 4);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (14, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  addr = ADDSI (addr, 4);
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmia

  CASE (FRAG_STMIA_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmia-sw

  CASE (FRAG_STMIA_SW_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (8, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (9, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (10, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (11, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (12, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (13, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (14, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmia-wb

  CASE (FRAG_STMIA_WB_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmia-sw-wb

  CASE (FRAG_STMIA_SW_WB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (8, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (9, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (10, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (11, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (12, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (13, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (14, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = ADDSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = ADDSI (addr, 4);
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmda

  CASE (FRAG_STMDA_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmda-sw

  CASE (FRAG_STMDA_SW_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (14, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (13, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (12, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (11, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (10, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (9, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (8, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmda-wb

  CASE (FRAG_STMDA_WB_MID):
    {
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;

{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: stmda-sw-wb

  CASE (FRAG_STMDA_SW_WB_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_ldmda.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  addr = * FLD (i_rn);
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
{
  {
    SI opval = ADDSI (current_cpu->hardware.h_gr[((UINT) 15)], 4);
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 14))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 14)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (14, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 13))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 13)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (13, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 12))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 12)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (12, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 11))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 11)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (11, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 10))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 10)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (10, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 9))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 9)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (9, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 8))) {
{
if (ANDSI (FLD (f_reg_list), SLLSI (1, 15))) {
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
} else {
  {
    SI opval = current_cpu->hardware.h_gr_usr[SUBSI (8, 8)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
}
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 7))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 7)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 6))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 6)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 5))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 5)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 4))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 4)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 3))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 3)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 2))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 2)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 1))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 1)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
if (ANDSI (FLD (f_reg_list), SLLSI (1, 0))) {
{
  {
    SI opval = current_cpu->hardware.h_gr[((UINT) 0)];
    current_cpu->SETMEMSI (pc, addr, opval);
  }
  addr = SUBSI (addr, 4);
}
}
  {
    SI opval = addr;
    * FLD (i_rn) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: mrs-c

  CASE (FRAG_MRS_C_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  {
    SI opval = current_cpu->h_cpsr_get ();
    * FLD (i_rd) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: mrs-s

  CASE (FRAG_MRS_S_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_strh_pre_dec_imm_offset.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  {
    SI opval = current_cpu->h_spsr_get ();
    * FLD (i_rd) = opval;
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: msr-c

  CASE (FRAG_MSR_C_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  {
    SI opval = * FLD (i_rm);
    current_cpu->h_cpsr_set (opval);
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);

// ********** used only by: msr-s

  CASE (FRAG_MSR_S_MID):
    {
      abuf = vpc;
      vpc = vpc + 1;
#define FLD(f) abuf->fields.sfmt_and_reg_imm_shift.f
      PCADDR pc = abuf->addr;
      current_cpu->hardware.h_gr[((UINT) 15)] = ADDSI (pc, GET_ATTR (R15_OFFSET));

{
  {
    SI opval = * FLD (i_rm);
    current_cpu->h_spsr_set (opval);
  }
}

#undef FLD
    }
    NEXT_INSN (vpc, fragpc);


#ifdef __GNUC__
    end_switch: ;
#else
    default: abort ();
#endif
    }
  }

  // Save vpc for next time.
  current_cpu->arm_engine.set_next_vpc (vpc);
}

