/*  *********************************************************************
    *  BCM1280/BCM1480 Board Support Package
    *
    *  High-Speed Port Block constants           File: bcm1480_hsp.h
    *
    *  This module contains constants and macros useful for
    *  programming the high-speed (HT/SPI-4) ports.
    *
    *  BCM1400 specification level:  1X55_1X80-UM100-R (12/18/03)
    *
    *********************************************************************
    *
    *  Copyright 2000,2001,2002,2003,2004
    *  Broadcom Corporation. All rights reserved.
    *
    *  This software is furnished under license and may be used and
    *  copied only in accordance with the following terms and
    *  conditions.  Subject to these conditions, you may download,
    *  copy, install, use, modify and distribute modified or unmodified
    *  copies of this software in source and/or binary form.  No title
    *  or ownership is transferred hereby.
    *
    *  1) Any source code used, modified or distributed must reproduce
    *     and retain this copyright notice and list of conditions
    *     as they appear in the source file.
    *
    *  2) No right is granted to use any trade name, trademark, or
    *     logo of Broadcom Corporation.  The "Broadcom Corporation"
    *     name may not be used to endorse or promote products derived
    *     from this software without the prior written permission of
    *     Broadcom Corporation.
    *
    *  3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR
    *     IMPLIED WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED
    *     WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
    *     PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
    *     SHALL BROADCOM BE LIABLE FOR ANY DAMAGES WHATSOEVER, AND IN
    *     PARTICULAR, BROADCOM SHALL NOT BE LIABLE FOR DIRECT, INDIRECT,
    *     INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
    *     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
    *     GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
    *     BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
    *     OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
    *     TORT (INCLUDING NEGLIGENCE OR OTHERWISE), EVEN IF ADVISED OF
    *     THE POSSIBILITY OF SUCH DAMAGE.
    ********************************************************************* */

#ifndef _BCM1480_HSP_H
#define _BCM1480_HSP_H

#include "sb1250_defs.h"


#define BCM1480_HSP_NUM_PORTS                3


/*
 * RX SPI-4 Configuration 0 Register (Table 334)
 */

#define M_BCM1480_HSP_RX_PORT_RESET         _SB_MAKEMASK1(0)
#define M_BCM1480_HSP_RX_PLL_DIV_4          _SB_MAKEMASK1(2)

#define S_BCM1480_HSP_RX_PLL_MULTIPLIER     3
#define M_BCM1480_HSP_RX_PLL_MULTIPLIER     _SB_MAKEMASK(5,S_BCM1480_HSP_RX_PLL_MULTIPLIER)
#define V_BCM1480_HSP_RX_PLL_MULTIPLIER(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PLL_MULTIPLIER)
#define G_BCM1480_HSP_RX_PLL_MULTIPLIER(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_PLL_MULTIPLIER,M_BCM1480_HSP_RX_PLL_MULTIPLIER)

#define S_BCM1480_HSP_TRAIN_CYCLE_COUNT     8
#define M_BCM1480_HSP_TRAIN_CYCLE_COUNT     _SB_MAKEMASK(8,S_BCM1480_HSP_TRAIN_CYCLE_COUNT)
#define V_BCM1480_HSP_TRAIN_CYCLE_COUNT(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_TRAIN_CYCLE_COUNT)
#define G_BCM1480_HSP_TRAIN_CYCLE_COUNT(x)  _SB_GETVALUE(x,S_BCM1480_HSP_TRAIN_CYCLE_COUNT,M_BCM1480_HSP_TRAIN_CYCLE_COUNT)

#define S_BCM1480_HSP_DIP4_ERR_CLEAR        16
#define M_BCM1480_HSP_DIP4_ERR_CLEAR        _SB_MAKEMASK(4,S_BCM1480_HSP_DIP4_ERR_CLEAR)
#define V_BCM1480_HSP_DIP4_ERR_CLEAR(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_DIP4_ERR_CLEAR)
#define G_BCM1480_HSP_DIP4_ERR_CLEAR(x)     _SB_GETVALUE(x,S_BCM1480_HSP_DIP4_ERR_CLEAR,M_BCM1480_HSP_DIP4_ERR_CLEAR)

#define S_BCM1480_DIP4_ERR_LIMIT            20
#define M_BCM1480_DIP4_ERR_LIMIT            _SB_MAKEMASK(4,S_BCM1480_DIP4_ERR_LIMIT)
#define V_BCM1480_DIP4_ERR_LIMIT(x)         _SB_MAKEVALUE(x,S_BCM1480_DIP4_ERR_LIMIT)
#define G_BCM1480_DIP4_ERR_LIMIT(x)         _SB_GETVALUE(x,S_BCM1480_DIP4_ERR_LIMIT,M_BCM1480_DIP4_ERR_LIMIT)

#define M_BCM1480_HSP_RSTAT_POLARITY        _SB_MAKEMASK1(24)

#define S_BCM1480_HSP_LINK_MODE             62
#define M_BCM1480_HSP_LINK_MODE             _SB_MAKEMASK(2,S_BCM1480_HSP_LINK_MODE)
#define V_BCM1480_HSP_LINK_MODE(x)          _SB_MAKEVALUE(x,S_BCM1480_HSP_LINK_MODE)
#define G_BCM1480_HSP_LINK_MODE(x)          _SB_GETVALUE(x,S_BCM1480_HSP_LINK_MODE,M_BCM1480_HSP_LINK_MODE)


#define K_BCM1480_HSP_LINK_MODE_HT	0
#define K_BCM1480_HSP_LINK_MODE_NOTCONN	1
#define K_BCM1480_HSP_LINK_MODE_SPI4	3

/*
 * RX SPI-4 De-Skew Override Configuration Register (Table 335)
 */

/*
 * Note: these macros don't follow the usual convention, since the entire
 * thing is basically an array of 4-bit fields, we add the "bit" parameter to each.
 */
#define M_BCM1480_HSP_RX_DESKEW_BIT(b)          _SB_MAKEMASK(2,S_BCM1480_HSP_RX_DESKEW_BIT(b))
#define V_BCM1480_HSP_RX_DESKEW_BIT(b,x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_DESKEW_BIT(b))
#define G_BCM1480_HSP_RX_DESKEW_BIT(b,x)        _SB_GETVALUE(x,S_BCM1480_HSP_RX_DESKEW_BIT(b),M_BCM1480_HSP_RX_DESKEW_BIT(b))


/*
 * RX SPI-4 Data Path and Deskew Configuration Register (Table 336)
 */

#define S_BCM1480_HSP_RX_DESKEW_PER_BIT     0
#define M_BCM1480_HSP_RX_DESKEW_PER_BIT     _SB_MAKEMASK(4,S_BCM1480_HSP_RX_DESKEW_PER_BIT)
#define V_BCM1480_HSP_RX_DESKEW_PER_BIT(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_DESKEW_PER_BIT)
#define G_BCM1480_HSP_RX_DESKEW_PER_BIT(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_DESKEW_PER_BIT,M_BCM1480_HSP_RX_DESKEW_PER_BIT)

#define M_BCM1480_HSP_RX_STATIC_DESKEW_EN _SB_MAKEMASK1(4)
#define M_BCM1480_HSP_RX_DESKEW_DISA      _SB_MAKEMASK1(5)
#define M_BCM1480_HSP_RX_RETRAIN_EN       _SB_MAKEMASK1(8)


/*
 * TX SPI-4 Configuration 0 Register (Table 337)
 */

#define M_BCM1480_HSP_TX_PORT_RESET         _SB_MAKEMASK1(0)

#define S_BCM1480_HSP_TX_PLL_MULTIPLIER     1
#define M_BCM1480_HSP_TX_PLL_MULTIPLIER     _SB_MAKEMASK(5,S_BCM1480_HSP_TX_PLL_MULTIPLIER)
#define V_BCM1480_HSP_TX_PLL_MULTIPLIER(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_PLL_MULTIPLIER)
#define G_BCM1480_HSP_TX_PLL_MULTIPLIER(x)  _SB_GETVALUE(x,S_BCM1480_HSP_TX_PLL_MULTIPLIER,M_BCM1480_HSP_TX_PLL_MULTIPLIER)

#define S_BCM1480_HSP_TX_RST_TRAINCNT       8
#define M_BCM1480_HSP_TX_RST_TRAINCNT       _SB_MAKEMASK(16,S_BCM1480_HSP_TX_RST_TRAINCNT)
#define V_BCM1480_HSP_TX_RST_TRAINCNT(x)    _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_RST_TRAINCNT)
#define G_BCM1480_HSP_TX_RST_TRAINCNT(x)    _SB_GETVALUE(x,S_BCM1480_HSP_TX_RST_TRAINCNT,M_BCM1480_HSP_TX_RST_TRAINCNT)

#define S_BCM1480_HSP_TX_RST_STATCNT        24
#define M_BCM1480_HSP_TX_RST_STATCNT        _SB_MAKEMASK(4,S_BCM1480_HSP_TX_RST_STATCNT)
#define V_BCM1480_HSP_TX_RST_STATCNT(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_RST_STATCNT)
#define G_BCM1480_HSP_TX_RST_STATCNT(x)     _SB_GETVALUE(x,S_BCM1480_HSP_TX_RST_STATCNT,M_BCM1480_HSP_TX_RST_STATCNT)

#define M_BCM1480_HSP_TX_FORCE_ERR          _SB_MAKEMASK1(32)
#define M_BCM1480_HSP_TX_TSTAT_SLOW_MODE    _SB_MAKEMASK1(33)
#define M_BCM1480_HSP_TX_TX_PLL_DIV_4       _SB_MAKEMASK1(34)

#define S_BCM1480_HSP_TX_DIP2_ERRLIMIT      36
#define M_BCM1480_HSP_TX_DIP2_ERRLIMIT      _SB_MAKEMASK(4,S_BCM1480_HSP_TX_DIP2_ERRLIMIT)
#define V_BCM1480_HSP_TX_DIP2_ERRLIMIT(x)   _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_DIP2_ERRLIMIT)
#define G_BCM1480_HSP_TX_DIP2_ERRLIMIT(x)   _SB_GETVALUE(x,S_BCM1480_HSP_TX_DIP2_ERRLIMIT,M_BCM1480_HSP_TX_DIP2_ERRLIMIT)

#define M_BCM1480_HSP_TX_TSTAT_POLARITY     _SB_MAKEMASK1(40)
#define M_BCM1480_HSP_TX_TX_OFF             _SB_MAKEMASK1(41)


/*
 * TX SPI-4 Training and Packet Configuration Register (Table 338)
 */

#define S_BCM1480_HSP_TX_DATA_MAX_T     0
#define M_BCM1480_HSP_TX_DATA_MAX_T     _SB_MAKEMASK(16,S_BCM1480_HSP_TX_DATA_MAX_T)
#define V_BCM1480_HSP_TX_DATA_MAX_T(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_DATA_MAX_T)
#define G_BCM1480_HSP_TX_DATA_MAX_T(x)  _SB_GETVALUE(x,S_BCM1480_HSP_TX_DATA_MAX_T,M_BCM1480_HSP_TX_DATA_MAX_T)

#define S_BCM1480_HSP_TX_TXPREFBURSTSZ     32
#define M_BCM1480_HSP_TX_TXPREFBURSTSZ     _SB_MAKEMASK(8,S_BCM1480_HSP_TX_TXPREFBURSTSZ)
#define V_BCM1480_HSP_TX_TXPREFBURSTSZ(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_TXPREFBURSTSZ)
#define G_BCM1480_HSP_TX_TXPREFBURSTSZ(x)  _SB_GETVALUE(x,S_BCM1480_HSP_TX_TXPREFBURSTSZ,M_BCM1480_HSP_TX_TXPREFBURSTSZ)

#define S_BCM1480_HSP_TX_TXMAXBURSTSZ     40
#define M_BCM1480_HSP_TX_TXMAXBURSTSZ     _SB_MAKEMASK(8,S_BCM1480_HSP_TX_TXMAXBURSTSZ)
#define V_BCM1480_HSP_TX_TXMAXBURSTSZ(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_TXMAXBURSTSZ)
#define G_BCM1480_HSP_TX_TXMAXBURSTSZ(x)  _SB_GETVALUE(x,S_BCM1480_HSP_TX_TXMAXBURSTSZ,M_BCM1480_HSP_TX_TXMAXBURSTSZ)

#define M_BCM1480_HSP_TX_NO_INTERLEAVE_MODE _SB_MAKEMASK1(48)


/*  *********************************************************************
    *  Interrupts and Diagnostics
    ********************************************************************* */

/*
 * RX SPI4 Interrupt enable and Interrupt Status (tables 339, 340)
 */

#define M_BCM1480_HSP_RX_INT_PERVCERR		_SB_MAKEMASK1(0)
#define M_BCM1480_HSP_RX_INT_EOPABORT		_SB_MAKEMASK1(1)
#define M_BCM1480_HSP_RX_INT_SPI4PROTOERR	_SB_MAKEMASK1(2)
#define M_BCM1480_HSP_RX_INT_ESTOREOVERFLOW	_SB_MAKEMASK1(3)
#define M_BCM1480_HSP_RX_INT_ALPHATRAINERR	_SB_MAKEMASK1(4)
#define M_BCM1480_HSP_RX_INT_DIP4ERROR		_SB_MAKEMASK1(5)
#define M_BCM1480_HSP_RX_INT_HRERROR		_SB_MAKEMASK1(6)
#define M_BCM1480_HSP_RX_INT_INTOVERFLOW	_SB_MAKEMASK1(7)



/*
 * RX HT Diagnostic CRC Error (tables 341, 342)
 */


#define S_BCM1480_HSP_RX_BAD_CRC_LANE     0
#define M_BCM1480_HSP_RX_BAD_CRC_LANE     _SB_MAKEMASK(32,S_BCM1480_HSP_RX_BAD_CRC_LANE)
#define V_BCM1480_HSP_RX_BAD_CRC_LANE(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_BAD_CRC_LANE)
#define G_BCM1480_HSP_RX_BAD_CRC_LANE(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_BAD_CRC_LANE,M_BCM1480_HSP_RX_BAD_CRC_LANE)

#define S_BCM1480_HSP_RX_EXPECTED_CRC_LANE     32
#define M_BCM1480_HSP_RX_EXPECTED_CRC_LANE     _SB_MAKEMASK(32,S_BCM1480_HSP_RX_EXPECTED_CRC_LANE)
#define V_BCM1480_HSP_RX_EXPECTED_CRC_LANE(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_EXPECTED_CRC_LANE)
#define G_BCM1480_HSP_RX_EXPECTED_CRC_LANE(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_EXPECTED_CRC_LANE,M_BCM1480_HSP_RX_EXPECTED_CRC_LANE)

/*
 * RX Diagnostic HT Command (Table 343)
 */

/* No fields */

/*
 * RX Diagnostic Packet Protocol (Table 344)
 */

#define S_BCM1480_HSP_RX_DIAG_VC     0
#define M_BCM1480_HSP_RX_DIAG_VC     _SB_MAKEMASK(8,S_BCM1480_HSP_RX_DIAG_VC)
#define V_BCM1480_HSP_RX_DIAG_VC(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_DIAG_VC)
#define G_BCM1480_HSP_RX_DIAG_VC(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_DIAG_VC,M_BCM1480_HSP_RX_DIAG_VC)

#define M_BCM1480_HSP_RX_DIAG_EOP	_SB_MAKEMASK1(8)
#define M_BCM1480_HSP_RX_DIAG_SOP	_SB_MAKEMASK1(9)

#define S_BCM1480_HSP_RX_DIAG_CONTROL     10
#define M_BCM1480_HSP_RX_DIAG_CONTROL     _SB_MAKEMASK(4,S_BCM1480_HSP_RX_DIAG_CONTROL)
#define V_BCM1480_HSP_RX_DIAG_CONTROL(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_DIAG_CONTROL)
#define G_BCM1480_HSP_RX_DIAG_CONTROL(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_DIAG_CONTROL,M_BCM1480_HSP_RX_DIAG_CONTROL)

#define M_BCM1480_HSP_RX_STRADDLING_CMD	_SB_MAKEMASK1(14)

#define S_BCM1480_HSP_RX_DIAG_ERR_CODE_1     16
#define M_BCM1480_HSP_RX_DIAG_ERR_CODE_1     _SB_MAKEMASK(4,S_BCM1480_HSP_RX_DIAG_ERR_CODE_1)
#define V_BCM1480_HSP_RX_DIAG_ERR_CODE_1(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_DIAG_ERR_CODE_1)
#define G_BCM1480_HSP_RX_DIAG_ERR_CODE_1(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_DIAG_ERR_CODE_1,M_BCM1480_HSP_RX_DIAG_ERR_CODE_1)

#define S_BCM1480_HSP_RX_DIAG_ERR_CODE_2     20
#define M_BCM1480_HSP_RX_DIAG_ERR_CODE_2     _SB_MAKEMASK(4,S_BCM1480_HSP_RX_DIAG_ERR_CODE_2)
#define V_BCM1480_HSP_RX_DIAG_ERR_CODE_2(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_DIAG_ERR_CODE_2)
#define G_BCM1480_HSP_RX_DIAG_ERR_CODE_2(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_DIAG_ERR_CODE_2,M_BCM1480_HSP_RX_DIAG_ERR_CODE_2)


/*
 * RX Diagnostic Detail (Table 345)
 */

#define M_BCM1480_HSP_RX_DIAGDET_PERVCERR	_SB_MAKEMASK1(0)
#define M_BCM1480_HSP_RX_DIAGDET_ALPHATRAINERR	_SB_MAKEMASK1(2)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4PROTOERR	_SB_MAKEMASK1(4)
#define M_BCM1480_HSP_RX_DIAGDET_DIP4ERROR	_SB_MAKEMASK1(6)
#define M_BCM1480_HSP_RX_DIAGDET_ESTOREOVERFLOW	_SB_MAKEMASK1(7)


#define M_BCM1480_HSP_RX_DIAGDET_SPI4_DATANOSOP		_SB_MAKEMASK1(32)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_SOPAFTERSOP	_SB_MAKEMASK1(33)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_EOPNOSOP		_SB_MAKEMASK1(34)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_EOPABORT		_SB_MAKEMASK1(35)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_BADDATA		_SB_MAKEMASK1(36)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_RESCMD		_SB_MAKEMASK1(37)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_BADSOP		_SB_MAKEMASK1(38)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_BADEOP		_SB_MAKEMASK1(39)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_BADCTL		_SB_MAKEMASK1(40)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_BADIDLE		_SB_MAKEMASK1(41)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_BADTRAINING	_SB_MAKEMASK1(42)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_ALPHATRAINING	_SB_MAKEMASK1(43)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_DIP4IDLE		_SB_MAKEMASK1(44)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_DIP4EOP		_SB_MAKEMASK1(45)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_DIP4DEAD		_SB_MAKEMASK1(46)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_HRNOMATCH		_SB_MAKEMASK1(47)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_HRMULTMATCH	_SB_MAKEMASK1(48)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_ESTOREOVR		_SB_MAKEMASK1(49)
#define M_BCM1480_HSP_RX_DIAGDET_SPI4_INTOVR		_SB_MAKEMASK1(51)


#define S_BCM1480_HSP_RX_DIAGDET_STATUS     32
#define M_BCM1480_HSP_RX_DIAGDET_STATUS     _SB_MAKEMASK(20,S_BCM1480_HSP_RX_DIAGDET_STATUS)
#define V_BCM1480_HSP_RX_DIAGDET_STATUS(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_DIAGDET_STATUS)
#define G_BCM1480_HSP_RX_DIAGDET_STATUS(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_DIAGDET_STATUS,M_BCM1480_HSP_RX_DIAGDET_STATUS)

#define S_BCM1480_HSP_RX_DIAGDET_PUSHPOP_DISTANCE     56
#define M_BCM1480_HSP_RX_DIAGDET_PUSHPOP_DISTANCE     _SB_MAKEMASK(4,S_BCM1480_HSP_RX_DIAGDET_PUSHPOP_DISTANCE)
#define V_BCM1480_HSP_RX_DIAGDET_PUSHPOP_DISTANCE(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_DIAGDET_PUSHPOP_DISTANCE)
#define G_BCM1480_HSP_RX_DIAGDET_PUSHPOP_DISTANCE(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_DIAGDET_PUSHPOP_DISTANCE,M_BCM1480_HSP_RX_DIAGDET_PUSHPOP_DISTANCE)

#define S_BCM1480_HSP_RX_DIAGDET_ESTORE_DISTANCE     60
#define M_BCM1480_HSP_RX_DIAGDET_ESTORE_DISTANCE     _SB_MAKEMASK(4,S_BCM1480_HSP_RX_DIAGDET_ESTORE_DISTANCE)
#define V_BCM1480_HSP_RX_DIAGDET_ESTORE_DISTANCE(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_DIAGDET_ESTORE_DISTANCE)
#define G_BCM1480_HSP_RX_DIAGDET_ESTORE_DISTANCE(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_DIAGDET_ESTORE_DISTANCE,M_BCM1480_HSP_RX_DIAGDET_ESTORE_DISTANCE)

/*
 * TX SPI4 Interrupt Enable and Interrupt Status (Table 346, 347)
 */

#define M_BCM1480_HSP_TX_INT_TSTATTIMEOUT	_SB_MAKEMASK1(0)
#define M_BCM1480_HSP_TX_INT_DIP2RXERR		_SB_MAKEMASK1(1)
#define M_BCM1480_HSP_TX_INT_SPI4RESET		_SB_MAKEMASK1(2)

/*
 * RX Packet Buffer Allocation Registers (Table 349)
 */

/*
 * XXX Depending on the revision of the manual, the fields may look
 *     incorrect here.  Check the errata for the correct layout
 *     of this register.
 */

#define S_BCM1480_HSP_RX_RAMCEILING_0       0
#define M_BCM1480_HSP_RX_RAMCEILING_0       _SB_MAKEMASK(10,S_BCM1480_HSP_RX_RAMCEILING_0)
#define V_BCM1480_HSP_RX_RAMCEILING_0(x)    _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_RAMCEILING_0)
#define G_BCM1480_HSP_RX_RAMCEILING_0(x)    _SB_GETVALUE(x,S_BCM1480_HSP_RX_RAMCEILING_0,M_BCM1480_HSP_RX_RAMCEILING_0)

#define S_BCM1480_HSP_RX_RAMFLOOR_0         16
#define M_BCM1480_HSP_RX_RAMFLOOR_0         _SB_MAKEMASK(10,S_BCM1480_HSP_RX_RAMFLOOR_0)
#define V_BCM1480_HSP_RX_RAMFLOOR_0(x)      _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_RAMFLOOR_0)
#define G_BCM1480_HSP_RX_RAMFLOOR_0(x)      _SB_GETVALUE(x,S_BCM1480_HSP_RX_RAMFLOOR_0,M_BCM1480_HSP_RX_RAMFLOOR_0)

#define S_BCM1480_HSP_RX_RAMCEILING_1       32
#define M_BCM1480_HSP_RX_RAMCEILING_1       _SB_MAKEMASK(10,S_BCM1480_HSP_RX_RAMCEILING_1)
#define V_BCM1480_HSP_RX_RAMCEILING_1(x)    _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_RAMCEILING_1)
#define G_BCM1480_HSP_RX_RAMCEILING_1(x)    _SB_GETVALUE(x,S_BCM1480_HSP_RX_RAMCEILING_1,M_BCM1480_HSP_RX_RAMCEILING_1)

#define S_BCM1480_HSP_RX_RAMFLOOR_1         48
#define M_BCM1480_HSP_RX_RAMFLOOR_1         _SB_MAKEMASK(10,S_BCM1480_HSP_RX_RAMFLOOR_1)
#define V_BCM1480_HSP_RX_RAMFLOOR_1(x)      _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_RAMFLOOR_1)
#define G_BCM1480_HSP_RX_RAMFLOOR_1(x)      _SB_GETVALUE(x,S_BCM1480_HSP_RX_RAMFLOOR_1,M_BCM1480_HSP_RX_RAMFLOOR_1)

/*
 * RX HT RAM Allocation Register 0 (Table 350 + Errata)
 */

#define S_BCM1480_HSP_RX_NPC_CMD_CEILING    0
#define M_BCM1480_HSP_RX_NPC_CMD_CEILING    _SB_MAKEMASK(10,S_BCM1480_HSP_RX_NPC_CMD_CEILING)
#define V_BCM1480_HSP_RX_NPC_CMD_CEILING(x) _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_NPC_CMD_CEILING)
#define G_BCM1480_HSP_RX_NPC_CMD_CEILING(x) _SB_GETVALUE(x,S_BCM1480_HSP_RX_NPC_CMD_CEILING,M_BCM1480_HSP_RX_NPC_CMD_CEILING)

#define S_BCM1480_HSP_RX_NPC_CMD_FLOOR      16
#define M_BCM1480_HSP_RX_NPC_CMD_FLOOR      _SB_MAKEMASK(10,S_BCM1480_HSP_RX_NPC_CMD_FLOOR)
#define V_BCM1480_HSP_RX_NPC_CMD_FLOOR(x)   _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_NPC_CMD_FLOOR)
#define G_BCM1480_HSP_RX_NPC_CMD_FLOOR(x)   _SB_GETVALUE(x,S_BCM1480_HSP_RX_NPC_CMD_FLOOR,M_BCM1480_HSP_RX_NPC_CMD_FLOOR)

/*
 * RX HT RAM Allocation Register 1 (Table 351 + Errata)
 */

#define S_BCM1480_HSP_RX_PC_CMD_CEILING     0
#define M_BCM1480_HSP_RX_PC_CMD_CEILING     _SB_MAKEMASK(10,S_BCM1480_HSP_RX_PC_CMD_CEILING)
#define V_BCM1480_HSP_RX_PC_CMD_CEILING(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PC_CMD_CEILING)
#define G_BCM1480_HSP_RX_PC_CMD_CEILING(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_PC_CMD_CEILING,M_BCM1480_HSP_RX_PC_CMD_CEILING)

#define S_BCM1480_HSP_RX_PC_CMD_FLOOR       16
#define M_BCM1480_HSP_RX_PC_CMD_FLOOR       _SB_MAKEMASK(10,S_BCM1480_HSP_RX_PC_CMD_FLOOR)
#define V_BCM1480_HSP_RX_PC_CMD_FLOOR(x)    _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PC_CMD_FLOOR)
#define G_BCM1480_HSP_RX_PC_CMD_FLOOR(x)    _SB_GETVALUE(x,S_BCM1480_HSP_RX_PC_CMD_FLOOR,M_BCM1480_HSP_RX_PC_CMD_FLOOR)

#define S_BCM1480_HSP_RX_PRB_CEILING        32
#define M_BCM1480_HSP_RX_PRB_CEILING        _SB_MAKEMASK(10,S_BCM1480_HSP_RX_PRB_CEILING)
#define V_BCM1480_HSP_RX_PRB_CEILING(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PRB_CEILING)
#define G_BCM1480_HSP_RX_PRB_CEILING(x)     _SB_GETVALUE(x,S_BCM1480_HSP_RX_PRB_CEILING,M_BCM1480_HSP_RX_PRB_CEILING)

#define S_BCM1480_HSP_RX_PRB_FLOOR          48
#define M_BCM1480_HSP_RX_PRB_FLOOR          _SB_MAKEMASK(10,S_BCM1480_HSP_RX_PRB_FLOOR)
#define V_BCM1480_HSP_RX_PRB_FLOOR(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PRB_FLOOR)
#define G_BCM1480_HSP_RX_PRB_FLOOR(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RX_PRB_FLOOR,M_BCM1480_HSP_RX_PRB_FLOOR)

/*
 * RX HT RAM Allocation Register 2 (Table 352 + Errata)
 */

#define S_BCM1480_HSP_RX_ACK_CEILING        0
#define M_BCM1480_HSP_RX_ACK_CEILING        _SB_MAKEMASK(10,S_BCM1480_HSP_RX_ACK_CEILING)
#define V_BCM1480_HSP_RX_ACK_CEILING(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_ACK_CEILING)
#define G_BCM1480_HSP_RX_ACK_CEILING(x)     _SB_GETVALUE(x,S_BCM1480_HSP_RX_ACK_CEILING,M_BCM1480_HSP_RX_ACK_CEILING)

#define S_BCM1480_HSP_RX_ACK_FLOOR          16
#define M_BCM1480_HSP_RX_ACK_FLOOR          _SB_MAKEMASK(10,S_BCM1480_HSP_RX_ACK_FLOOR)
#define V_BCM1480_HSP_RX_ACK_FLOOR(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_ACK_FLOOR)
#define G_BCM1480_HSP_RX_ACK_FLOOR(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RX_ACK_FLOOR,M_BCM1480_HSP_RX_ACK_FLOOR)

#define S_BCM1480_HSP_RX_WB_CEILING         32
#define M_BCM1480_HSP_RX_WB_CEILING         _SB_MAKEMASK(10,S_BCM1480_HSP_RX_WB_CEILING)
#define V_BCM1480_HSP_RX_WB_CEILING(x)      _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_WB_CEILING)
#define G_BCM1480_HSP_RX_WB_CEILING(x)      _SB_GETVALUE(x,S_BCM1480_HSP_RX_WB_CEILING,M_BCM1480_HSP_RX_WB_CEILING)

#define S_BCM1480_HSP_RX_WB_FLOOR           48
#define M_BCM1480_HSP_RX_WB_FLOOR           _SB_MAKEMASK(10,S_BCM1480_HSP_RX_WB_FLOOR)
#define V_BCM1480_HSP_RX_WB_FLOOR(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_WB_FLOOR)
#define G_BCM1480_HSP_RX_WB_FLOOR(x)        _SB_GETVALUE(x,S_BCM1480_HSP_RX_WB_FLOOR,M_BCM1480_HSP_RX_WB_FLOOR)

/*
 * RX HT RAM Allocation Register 3 (Table 353 + Errata)
 */

#define S_BCM1480_HSP_RX_CFILL_CEILING      0
#define M_BCM1480_HSP_RX_CFILL_CEILING      _SB_MAKEMASK(10,S_BCM1480_HSP_RX_CFILL_CEILING)
#define V_BCM1480_HSP_RX_CFILL_CEILING(x)   _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_CFILL_CEILING)
#define G_BCM1480_HSP_RX_CFILL_CEILING(x)   _SB_GETVALUE(x,S_BCM1480_HSP_RX_CFILL_CEILING,M_BCM1480_HSP_RX_CFILL_CEILING)

#define S_BCM1480_HSP_RX_CFILL_FLOOR        16
#define M_BCM1480_HSP_RX_CFILL_FLOOR        _SB_MAKEMASK(10,S_BCM1480_HSP_RX_CFILL_FLOOR)
#define V_BCM1480_HSP_RX_CFILL_FLOOR(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_CFILL_FLOOR)
#define G_BCM1480_HSP_RX_CFILL_FLOOR(x)     _SB_GETVALUE(x,S_BCM1480_HSP_RX_CFILL_FLOOR,M_BCM1480_HSP_RX_CFILL_FLOOR)

#define S_BCM1480_HSP_RX_CRD_CEILING        32
#define M_BCM1480_HSP_RX_CRD_CEILING        _SB_MAKEMASK(10,S_BCM1480_HSP_RX_CRD_CEILING)
#define V_BCM1480_HSP_RX_CRD_CEILING(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_CRD_CEILING)
#define G_BCM1480_HSP_RX_CRD_CEILING(x)     _SB_GETVALUE(x,S_BCM1480_HSP_RX_CRD_CEILING,M_BCM1480_HSP_RX_CRD_CEILING)

#define S_BCM1480_HSP_RX_CRD_FLOOR          48
#define M_BCM1480_HSP_RX_CRD_FLOOR          _SB_MAKEMASK(10,S_BCM1480_HSP_RX_CRD_FLOOR)
#define V_BCM1480_HSP_RX_CRD_FLOOR(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_CRD_FLOOR)
#define G_BCM1480_HSP_RX_CRD_FLOOR(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RX_CRD_FLOOR,M_BCM1480_HSP_RX_CRD_FLOOR)

/*
 * RX HT RAM Allocation Register 4 (Table 354 + Errata)
 */

#define S_BCM1480_HSP_RX_NPC_DAT_CEILING    0
#define M_BCM1480_HSP_RX_NPC_DAT_CEILING    _SB_MAKEMASK(10,S_BCM1480_HSP_RX_NPC_DAT_CEILING)
#define V_BCM1480_HSP_RX_NPC_DAT_CEILING(x) _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_NPC_DAT_CEILING)
#define G_BCM1480_HSP_RX_NPC_DAT_CEILING(x) _SB_GETVALUE(x,S_BCM1480_HSP_RX_NPC_DAT_CEILING,M_BCM1480_HSP_RX_NPC_DAT_CEILING)

#define S_BCM1480_HSP_RX_NPC_DAT_FLOOR      16
#define M_BCM1480_HSP_RX_NPC_DAT_FLOOR      _SB_MAKEMASK(10,S_BCM1480_HSP_RX_NPC_DAT_FLOOR)
#define V_BCM1480_HSP_RX_NPC_DAT_FLOOR(x)   _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_NPC_DAT_FLOOR)
#define G_BCM1480_HSP_RX_NPC_DAT_FLOOR(x)   _SB_GETVALUE(x,S_BCM1480_HSP_RX_NPC_DAT_FLOOR,M_BCM1480_HSP_RX_NPC_DAT_FLOOR)

#define S_BCM1480_HSP_RX_RSP_DAT_CEILING    32
#define M_BCM1480_HSP_RX_RSP_DAT_CEILING    _SB_MAKEMASK(10,S_BCM1480_HSP_RX_RSP_DAT_CEILING)
#define V_BCM1480_HSP_RX_RSP_DAT_CEILING(x) _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_RSP_DAT_CEILING)
#define G_BCM1480_HSP_RX_RSP_DAT_CEILING(x) _SB_GETVALUE(x,S_BCM1480_HSP_RX_RSP_DAT_CEILING,M_BCM1480_HSP_RX_RSP_DAT_CEILING)

#define S_BCM1480_HSP_RX_RSP_DAT_FLOOR      48
#define M_BCM1480_HSP_RX_RSP_DAT_FLOOR      _SB_MAKEMASK(10,S_BCM1480_HSP_RX_RSP_DAT_FLOOR)
#define V_BCM1480_HSP_RX_RSP_DAT_FLOOR(x)   _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_RSP_DAT_FLOOR)
#define G_BCM1480_HSP_RX_RSP_DAT_FLOOR(x)   _SB_GETVALUE(x,S_BCM1480_HSP_RX_RSP_DAT_FLOOR,M_BCM1480_HSP_RX_RSP_DAT_FLOOR)

/*
 * RX HT RAM Allocation Register 5 (Table 355 + Errata)
 */

#define S_BCM1480_HSP_RX_PC_DAT_CEILING     0
#define M_BCM1480_HSP_RX_PC_DAT_CEILING     _SB_MAKEMASK(10,S_BCM1480_HSP_RX_PC_DAT_CEILING)
#define V_BCM1480_HSP_RX_PC_DAT_CEILING(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PC_DAT_CEILING)
#define G_BCM1480_HSP_RX_PC_DAT_CEILING(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_PC_DAT_CEILING,M_BCM1480_HSP_RX_PC_DAT_CEILING)

#define S_BCM1480_HSP_RX_PC_DAT_FLOOR       16
#define M_BCM1480_HSP_RX_PC_DAT_FLOOR       _SB_MAKEMASK(10,S_BCM1480_HSP_RX_PC_DAT_FLOOR)
#define V_BCM1480_HSP_RX_PC_DAT_FLOOR(x)    _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PC_DAT_FLOOR)
#define G_BCM1480_HSP_RX_PC_DAT_FLOOR(x)    _SB_GETVALUE(x,S_BCM1480_HSP_RX_PC_DAT_FLOOR,M_BCM1480_HSP_RX_PC_DAT_FLOOR)

/* ... */

/*
 * TX Packet Buffer Allocation Registers (Table 356)
 */

#define S_BCM1480_HSP_TX_RAMCEILING_0       0
#define M_BCM1480_HSP_TX_RAMCEILING_0       _SB_MAKEMASK(8,S_BCM1480_HSP_TX_RAMCEILING_0)
#define V_BCM1480_HSP_TX_RAMCEILING_0(x)    _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_RAMCEILING_0)
#define G_BCM1480_HSP_TX_RAMCEILING_0(x)    _SB_GETVALUE(x,S_BCM1480_HSP_TX_RAMCEILING_0,M_BCM1480_HSP_TX_RAMCEILING_0)

#define S_BCM1480_HSP_TX_RAMFLOOR_0         16
#define M_BCM1480_HSP_TX_RAMFLOOR_0         _SB_MAKEMASK(8,S_BCM1480_HSP_TX_RAMFLOOR_0)
#define V_BCM1480_HSP_TX_RAMFLOOR_0(x)      _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_RAMFLOOR_0)
#define G_BCM1480_HSP_TX_RAMFLOOR_0(x)      _SB_GETVALUE(x,S_BCM1480_HSP_TX_RAMFLOOR_0,M_BCM1480_HSP_TX_RAMFLOOR_0)

#define S_BCM1480_HSP_TX_RAMCEILING_1       32
#define M_BCM1480_HSP_TX_RAMCEILING_1       _SB_MAKEMASK(8,S_BCM1480_HSP_TX_RAMCEILING_1)
#define V_BCM1480_HSP_TX_RAMCEILING_1(x)    _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_RAMCEILING_1)
#define G_BCM1480_HSP_TX_RAMCEILING_1(x)    _SB_GETVALUE(x,S_BCM1480_HSP_TX_RAMCEILING_1,M_BCM1480_HSP_TX_RAMCEILING_1)

#define S_BCM1480_HSP_TX_RAMFLOOR_1         48
#define M_BCM1480_HSP_TX_RAMFLOOR_1         _SB_MAKEMASK(8,S_BCM1480_HSP_TX_RAMFLOOR_1)
#define V_BCM1480_HSP_TX_RAMFLOOR_1(x)      _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_RAMFLOOR_1)
#define G_BCM1480_HSP_TX_RAMFLOOR_1(x)      _SB_GETVALUE(x,S_BCM1480_HSP_TX_RAMFLOOR_1,M_BCM1480_HSP_TX_RAMFLOOR_1)

/*
 * TX Non-Posted Command (NPC) Allocation Register (Table 357)
 */

#define S_BCM1480_HSP_TX_NPC_CEILING        0
#define M_BCM1480_HSP_TX_NPC_CEILING        _SB_MAKEMASK(8,S_BCM1480_HSP_TX_NPC_CEILING)
#define V_BCM1480_HSP_TX_NPC_CEILING(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_NPC_CEILING)
#define G_BCM1480_HSP_TX_NPC_CEILING(x)     _SB_GETVALUE(x,S_BCM1480_HSP_TX_NPC_CEILING,M_BCM1480_HSP_TX_NPC_CEILING)

#define S_BCM1480_HSP_TX_NPC_FLOOR          16
#define M_BCM1480_HSP_TX_NPC_FLOOR          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_NPC_FLOOR)
#define V_BCM1480_HSP_TX_NPC_FLOOR(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_NPC_FLOOR)
#define G_BCM1480_HSP_TX_NPC_FLOOR(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_NPC_FLOOR,M_BCM1480_HSP_TX_NPC_FLOOR)

/*
 * TX Response (RSP) Allocation Register (Table 358)
 */

#define S_BCM1480_HSP_TX_RSP_CEILING        0
#define M_BCM1480_HSP_TX_RSP_CEILING        _SB_MAKEMASK(8,S_BCM1480_HSP_TX_RSP_CEILING)
#define V_BCM1480_HSP_TX_RSP_CEILING(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_RSP_CEILING)
#define G_BCM1480_HSP_TX_RSP_CEILING(x)     _SB_GETVALUE(x,S_BCM1480_HSP_TX_RSP_CEILING,M_BCM1480_HSP_TX_RSP_CEILING)

#define S_BCM1480_HSP_TX_RSP_FLOOR          16
#define M_BCM1480_HSP_TX_RSP_FLOOR          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_RSP_FLOOR)
#define V_BCM1480_HSP_TX_RSP_FLOOR(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_RSP_FLOOR)
#define G_BCM1480_HSP_TX_RSP_FLOOR(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_RSP_FLOOR,M_BCM1480_HSP_TX_RSP_FLOOR)

/*
 * TX Posted Command (PC) Allocation Register (Table 359)
 */

#define S_BCM1480_HSP_TX_PC_CEILING         0
#define M_BCM1480_HSP_TX_PC_CEILING         _SB_MAKEMASK(8,S_BCM1480_HSP_TX_PC_CEILING)
#define V_BCM1480_HSP_TX_PC_CEILING(x)      _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_PC_CEILING)
#define G_BCM1480_HSP_TX_PC_CEILING(x)      _SB_GETVALUE(x,S_BCM1480_HSP_TX_PC_CEILING,M_BCM1480_HSP_TX_PC_CEILING)

#define S_BCM1480_HSP_TX_PC_FLOOR           16
#define M_BCM1480_HSP_TX_PC_FLOOR           _SB_MAKEMASK(8,S_BCM1480_HSP_TX_PC_FLOOR)
#define V_BCM1480_HSP_TX_PC_FLOOR(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_PC_FLOOR)
#define G_BCM1480_HSP_TX_PC_FLOOR(x)        _SB_GETVALUE(x,S_BCM1480_HSP_TX_PC_FLOOR,M_BCM1480_HSP_TX_PC_FLOOR)

/*
 * TX Probe (PC) and Acknowledgement (ACK) Allocation Register (Table 360)
 */

#define S_BCM1480_HSP_TX_PRB_CEILING        0
#define M_BCM1480_HSP_TX_PRB_CEILING        _SB_MAKEMASK(8,S_BCM1480_HSP_TX_PRB_CEILING)
#define V_BCM1480_HSP_TX_PRB_CEILING(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_PRB_CEILING)
#define G_BCM1480_HSP_TX_PRB_CEILING(x)     _SB_GETVALUE(x,S_BCM1480_HSP_TX_PRB_CEILING,M_BCM1480_HSP_TX_PRB_CEILING)

#define S_BCM1480_HSP_TX_PRB_FLOOR          16
#define M_BCM1480_HSP_TX_PRB_FLOOR          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_PRB_FLOOR)
#define V_BCM1480_HSP_TX_PRB_FLOOR(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_PRB_FLOOR)
#define G_BCM1480_HSP_TX_PRB_FLOOR(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_PRB_FLOOR,M_BCM1480_HSP_TX_PRB_FLOOR)

#define S_BCM1480_HSP_TX_ACK_CEILING        32
#define M_BCM1480_HSP_TX_ACK_CEILING        _SB_MAKEMASK(8,S_BCM1480_HSP_TX_ACK_CEILING)
#define V_BCM1480_HSP_TX_ACK_CEILING(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_ACK_CEILING)
#define G_BCM1480_HSP_TX_ACK_CEILING(x)     _SB_GETVALUE(x,S_BCM1480_HSP_TX_ACK_CEILING,M_BCM1480_HSP_TX_ACK_CEILING)

#define S_BCM1480_HSP_TX_ACK_FLOOR          48
#define M_BCM1480_HSP_TX_ACK_FLOOR          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_ACK_FLOOR)
#define V_BCM1480_HSP_TX_ACK_FLOOR(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_ACK_FLOOR)
#define G_BCM1480_HSP_TX_ACK_FLOOR(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_ACK_FLOOR,M_BCM1480_HSP_TX_ACK_FLOOR)

/*
 * TX Writeback (WB) and Coherent Fill (CFILL) Allocation Register (Table 361)
 */

#define S_BCM1480_HSP_TX_WB_CEILING         0
#define M_BCM1480_HSP_TX_WB_CEILING         _SB_MAKEMASK(8,S_BCM1480_HSP_TX_WB_CEILING)
#define V_BCM1480_HSP_TX_WB_CEILING(x)      _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_WB_CEILING)
#define G_BCM1480_HSP_TX_WB_CEILING(x)      _SB_GETVALUE(x,S_BCM1480_HSP_TX_WB_CEILING,M_BCM1480_HSP_TX_WB_CEILING)

#define S_BCM1480_HSP_TX_WB_FLOOR           16
#define M_BCM1480_HSP_TX_WB_FLOOR           _SB_MAKEMASK(8,S_BCM1480_HSP_TX_WB_FLOOR)
#define V_BCM1480_HSP_TX_WB_FLOOR(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_WB_FLOOR)
#define G_BCM1480_HSP_TX_WB_FLOOR(x)        _SB_GETVALUE(x,S_BCM1480_HSP_TX_WB_FLOOR,M_BCM1480_HSP_TX_WB_FLOOR)

#define S_BCM1480_HSP_TX_CFILL_CEILING      32
#define M_BCM1480_HSP_TX_CFILL_CEILING      _SB_MAKEMASK(8,S_BCM1480_HSP_TX_CFILL_CEILING)
#define V_BCM1480_HSP_TX_CFILL_CEILING(x)   _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_CFILL_CEILING)
#define G_BCM1480_HSP_TX_CFILL_CEILING(x)   _SB_GETVALUE(x,S_BCM1480_HSP_TX_CFILL_CEILING,M_BCM1480_HSP_TX_CFILL_CEILING)

#define S_BCM1480_HSP_TX_CFILL_FLOOR        48
#define M_BCM1480_HSP_TX_CFILL_FLOOR        _SB_MAKEMASK(8,S_BCM1480_HSP_TX_CFILL_FLOOR)
#define V_BCM1480_HSP_TX_CFILL_FLOOR(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_CFILL_FLOOR)
#define G_BCM1480_HSP_TX_CFILL_FLOOR(x)     _SB_GETVALUE(x,S_BCM1480_HSP_TX_CFILL_FLOOR,M_BCM1480_HSP_TX_CFILL_FLOOR)

/*
 * TX Coherent Read (CRD) Allocation Register (Table 362)
 */

#define S_BCM1480_HSP_TX_CRD_CEILING        0
#define M_BCM1480_HSP_TX_CRD_CEILING        _SB_MAKEMASK(8,S_BCM1480_HSP_TX_CRD_CEILING)
#define V_BCM1480_HSP_TX_CRD_CEILING(x)     _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_CRD_CEILING)
#define G_BCM1480_HSP_TX_CRD_CEILING(x)     _SB_GETVALUE(x,S_BCM1480_HSP_TX_CRD_CEILING,M_BCM1480_HSP_TX_CRD_CEILING)

#define S_BCM1480_HSP_TX_CRD_FLOOR          16
#define M_BCM1480_HSP_TX_CRD_FLOOR          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_CRD_FLOOR)
#define V_BCM1480_HSP_TX_CRD_FLOOR(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_CRD_FLOOR)
#define G_BCM1480_HSP_TX_CRD_FLOOR(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_CRD_FLOOR,M_BCM1480_HSP_TX_CRD_FLOOR)

/*
 * RX SPI4 Config Register 1 (Table 363)
 */

#define S_BCM1480_HSP_RX_CALENDAR_LEN           0
#define M_BCM1480_HSP_RX_CALENDAR_LEN           _SB_MAKEMASK(8,S_BCM1480_HSP_RX_CALENDAR_LEN)
#define V_BCM1480_HSP_RX_CALENDAR_LEN(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_CALENDAR_LEN)
#define G_BCM1480_HSP_RX_CALENDAR_LEN(x)        _SB_GETVALUE(x,S_BCM1480_HSP_RX_CALENDAR_LEN,M_BCM1480_HSP_RX_CALENDAR_LEN)

#define S_BCM1480_HSP_RX_CALENDAR_M           16
#define M_BCM1480_HSP_RX_CALENDAR_M           _SB_MAKEMASK(8,S_BCM1480_HSP_RX_CALENDAR_M)
#define V_BCM1480_HSP_RX_CALENDAR_M(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_CALENDAR_M)
#define G_BCM1480_HSP_RX_CALENDAR_M(x)        _SB_GETVALUE(x,S_BCM1480_HSP_RX_CALENDAR_M,M_BCM1480_HSP_RX_CALENDAR_M)

#define S_BCM1480_HSP_RX_ALPHA           40
#define M_BCM1480_HSP_RX_ALPHA           _SB_MAKEMASK(12,S_BCM1480_HSP_RX_ALPHA)
#define V_BCM1480_HSP_RX_ALPHA(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_ALPHA)
#define G_BCM1480_HSP_RX_ALPHA(x)        _SB_GETVALUE(x,S_BCM1480_HSP_RX_ALPHA,M_BCM1480_HSP_RX_ALPHA)

/*
 * RX SPI4 Calendar registers (Table 364)
 * Use these macros for both the _0 and _1 registers.  The arg 'c' is the calendar location
 */

#define S_BCM1480_HSP_RX_CALENDAR_X(c)	(((c)&7)*8)
#define M_BCM1480_HSP_RX_CALENDAR_X(c)      _SB_MAKEMASK(12,S_BCM1480_HSP_RX_CALENDAR_X(c))
#define V_BCM1480_HSP_RX_CALENDAR_X(c,x)    _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_CALENDAR_X(c))
#define G_BCM1480_HSP_RX_CALENDAR_X(c,x)    _SB_GETVALUE(x,S_BCM1480_HSP_RX_CALENDAR_X(c),M_BCM1480_HSP_RX_CALENDAR_X(c))

/*
 * RX SPI4 Watermark registers (Table 365)
 */

#define S_BCM1480_HSP_RX_ALMOSTEMPTY_EVEN          0
#define M_BCM1480_HSP_RX_ALMOSTEMPTY_EVEN          _SB_MAKEMASK(10,S_BCM1480_HSP_RX_ALMOSTEMPTY_EVEN)
#define V_BCM1480_HSP_RX_ALMOSTEMPTY_EVEN(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_ALMOSTEMPTY_EVEN)
#define G_BCM1480_HSP_RX_ALMOSTEMPTY_EVEN(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RX_ALMOSTEMPTY_EVEN,M_BCM1480_HSP_RX_ALMOSTEMPTY_EVEN)

#define S_BCM1480_HSP_RX_ALMOSTFULL_EVEN          16
#define M_BCM1480_HSP_RX_ALMOSTFULL_EVEN          _SB_MAKEMASK(10,S_BCM1480_HSP_RX_ALMOSTFULL_EVEN)
#define V_BCM1480_HSP_RX_ALMOSTFULL_EVEN(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_ALMOSTFULL_EVEN)
#define G_BCM1480_HSP_RX_ALMOSTFULL_EVEN(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RX_ALMOSTFULL_EVEN,M_BCM1480_HSP_RX_ALMOSTFULL_EVEN)

#define S_BCM1480_HSP_RX_ALMOSTEMPTY_ODD          32
#define M_BCM1480_HSP_RX_ALMOSTEMPTY_ODD          _SB_MAKEMASK(10,S_BCM1480_HSP_RX_ALMOSTEMPTY_ODD)
#define V_BCM1480_HSP_RX_ALMOSTEMPTY_ODD(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_ALMOSTEMPTY_ODD)
#define G_BCM1480_HSP_RX_ALMOSTEMPTY_ODD(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RX_ALMOSTEMPTY_ODD,M_BCM1480_HSP_RX_ALMOSTEMPTY_ODD)

#define S_BCM1480_HSP_RX_ALMOSTFULL_ODD          48
#define M_BCM1480_HSP_RX_ALMOSTFULL_ODD          _SB_MAKEMASK(10,S_BCM1480_HSP_RX_ALMOSTFULL_ODD)
#define V_BCM1480_HSP_RX_ALMOSTFULL_ODD(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_ALMOSTFULL_ODD)
#define G_BCM1480_HSP_RX_ALMOSTFULL_ODD(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RX_ALMOSTFULL_ODD,M_BCM1480_HSP_RX_ALMOSTFULL_ODD)

/*
 * TX SPI4 Configuration Register 1 (Table 366)
 */


#define S_BCM1480_HSP_TX_CALENDAR_LEN           0
#define M_BCM1480_HSP_TX_CALENDAR_LEN           _SB_MAKEMASK(8,S_BCM1480_HSP_TX_CALENDAR_LEN)
#define V_BCM1480_HSP_TX_CALENDAR_LEN(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_CALENDAR_LEN)
#define G_BCM1480_HSP_TX_CALENDAR_LEN(x)        _SB_GETVALUE(x,S_BCM1480_HSP_TX_CALENDAR_LEN,M_BCM1480_HSP_TX_CALENDAR_LEN)

#define S_BCM1480_HSP_TX_CALENDAR_M           16
#define M_BCM1480_HSP_TX_CALENDAR_M           _SB_MAKEMASK(8,S_BCM1480_HSP_TX_CALENDAR_M)
#define V_BCM1480_HSP_TX_CALENDAR_M(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_CALENDAR_M)
#define G_BCM1480_HSP_TX_CALENDAR_M(x)        _SB_GETVALUE(x,S_BCM1480_HSP_TX_CALENDAR_M,M_BCM1480_HSP_TX_CALENDAR_M)

#define S_BCM1480_HSP_TX_MAXBURST1           24
#define M_BCM1480_HSP_TX_MAXBURST1           _SB_MAKEMASK(8,S_BCM1480_HSP_TX_MAXBURST1)
#define V_BCM1480_HSP_TX_MAXBURST1(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_MAXBURST1)
#define G_BCM1480_HSP_TX_MAXBURST1(x)        _SB_GETVALUE(x,S_BCM1480_HSP_TX_MAXBURST1,M_BCM1480_HSP_TX_MAXBURST1)

#define S_BCM1480_HSP_TX_MAXBURST2           32
#define M_BCM1480_HSP_TX_MAXBURST2           _SB_MAKEMASK(8,S_BCM1480_HSP_TX_MAXBURST2)
#define V_BCM1480_HSP_TX_MAXBURST2(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_MAXBURST2)
#define G_BCM1480_HSP_TX_MAXBURST2(x)        _SB_GETVALUE(x,S_BCM1480_HSP_TX_MAXBURST2,M_BCM1480_HSP_TX_MAXBURST2)


#define S_BCM1480_HSP_TX_ALPHA           40
#define M_BCM1480_HSP_TX_ALPHA           _SB_MAKEMASK(12,S_BCM1480_HSP_TX_ALPHA)
#define V_BCM1480_HSP_TX_ALPHA(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_ALPHA)
#define G_BCM1480_HSP_TX_ALPHA(x)        _SB_GETVALUE(x,S_BCM1480_HSP_TX_ALPHA,M_BCM1480_HSP_TX_ALPHA)

#define S_BCM1480_HSP_TX_ACTIVE_CHANNELS           56
#define M_BCM1480_HSP_TX_ACTIVE_CHANNELS           _SB_MAKEMASK(8,S_BCM1480_HSP_TX_ACTIVE_CHANNELS)
#define V_BCM1480_HSP_TX_ACTIVE_CHANNELS(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_ACTIVE_CHANNELS)
#define G_BCM1480_HSP_TX_ACTIVE_CHANNELS(x)        _SB_GETVALUE(x,S_BCM1480_HSP_TX_ACTIVE_CHANNELS,M_BCM1480_HSP_TX_ACTIVE_CHANNELS)


/*
 * TX SPI4 Calendar registers (Table 367)
 * Use these macros for both the _0 and _1 registers.  The arg 'c' is the calendar location
 */

#define S_BCM1480_HSP_TX_CALENDAR_X(c)	(((c)&7)*8)
#define M_BCM1480_HSP_TX_CALENDAR_X(c)      _SB_MAKEMASK(12,S_BCM1480_HSP_TX_CALENDAR_X(c))
#define V_BCM1480_HSP_TX_CALENDAR_X(c,x)    _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_CALENDAR_X(c))
#define G_BCM1480_HSP_TX_CALENDAR_X(c,x)    _SB_GETVALUE(x,S_BCM1480_HSP_TX_CALENDAR_X(c),M_BCM1480_HSP_TX_CALENDAR_X(c))

/*
 * TX Packet Buffer Allocation Physical Unit Count Registers (Table 368)
 */

#define S_BCM1480_HSP_RX_PHITCNT_0          0
#define M_BCM1480_HSP_RX_PHITCNT_0          _SB_MAKEMASK(10,S_BCM1480_HSP_RX_PHITCNT_0)
#define V_BCM1480_HSP_RX_PHITCNT_0(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PHITCNT_0)
#define G_BCM1480_HSP_RX_PHITCNT_0(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RX_PHITCNT_0,M_BCM1480_HSP_RX_PHITCNT_0)

#define S_BCM1480_HSP_RX_PHITCNT_1          16
#define M_BCM1480_HSP_RX_PHITCNT_1          _SB_MAKEMASK(10,S_BCM1480_HSP_RX_PHITCNT_1)
#define V_BCM1480_HSP_RX_PHITCNT_1(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PHITCNT_1)
#define G_BCM1480_HSP_RX_PHITCNT_1(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RX_PHITCNT_1,M_BCM1480_HSP_RX_PHITCNT_1)

#define S_BCM1480_HSP_RX_PHITCNT_2          32
#define M_BCM1480_HSP_RX_PHITCNT_2          _SB_MAKEMASK(10,S_BCM1480_HSP_RX_PHITCNT_2)
#define V_BCM1480_HSP_RX_PHITCNT_2(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PHITCNT_2)
#define G_BCM1480_HSP_RX_PHITCNT_2(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RX_PHITCNT_2,M_BCM1480_HSP_RX_PHITCNT_2)

#define S_BCM1480_HSP_RX_PHITCNT_3          48
#define M_BCM1480_HSP_RX_PHITCNT_3          _SB_MAKEMASK(10,S_BCM1480_HSP_RX_PHITCNT_3)
#define V_BCM1480_HSP_RX_PHITCNT_3(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PHITCNT_3)
#define G_BCM1480_HSP_RX_PHITCNT_3(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RX_PHITCNT_3,M_BCM1480_HSP_RX_PHITCNT_3)

/*
 * TX HT I/O Physical Unit Count Register (Table 369)
 */

#define S_BCM1480_HSP_RX_NPC_CMD_PHITCNT    0
#define M_BCM1480_HSP_RX_NPC_CMD_PHITCNT    _SB_MAKEMASK(8,S_BCM1480_HSP_RX_NPC_CMD_PHITCNT)
#define V_BCM1480_HSP_RX_NPC_CMD_PHITCNT(x) _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_NPC_CMD_PHITCNT)
#define G_BCM1480_HSP_RX_NPC_CMD_PHITCNT(x) _SB_GETVALUE(x,S_BCM1480_HSP_RX_NPC_CMD_PHITCNT,M_BCM1480_HSP_RX_NPC_CMD_PHITCNT)

#define S_BCM1480_HSP_RX_NPC_DAT_PHITCNT    8
#define M_BCM1480_HSP_RX_NPC_DAT_PHITCNT    _SB_MAKEMASK(8,S_BCM1480_HSP_RX_NPC_DAT_PHITCNT)
#define V_BCM1480_HSP_RX_NPC_DAT_PHITCNT(x) _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_NPC_DAT_PHITCNT)
#define G_BCM1480_HSP_RX_NPC_DAT_PHITCNT(x) _SB_GETVALUE(x,S_BCM1480_HSP_RX_NPC_DAT_PHITCNT,M_BCM1480_HSP_RX_NPC_DAT_PHITCNT)

#define S_BCM1480_HSP_RX_RSP_DAT_PHITCNT    24
#define M_BCM1480_HSP_RX_RSP_DAT_PHITCNT    _SB_MAKEMASK(8,S_BCM1480_HSP_RX_RSP_DAT_PHITCNT)
#define V_BCM1480_HSP_RX_RSP_DAT_PHITCNT(x) _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_RSP_DAT_PHITCNT)
#define G_BCM1480_HSP_RX_RSP_DAT_PHITCNT(x) _SB_GETVALUE(x,S_BCM1480_HSP_RX_RSP_DAT_PHITCNT,M_BCM1480_HSP_RX_RSP_DAT_PHITCNT)

#define S_BCM1480_HSP_RX_PC_CMD_PHITCNT     32
#define M_BCM1480_HSP_RX_PC_CMD_PHITCNT     _SB_MAKEMASK(8,S_BCM1480_HSP_RX_PC_CMD_PHITCNT)
#define V_BCM1480_HSP_RX_PC_CMD_PHITCNT(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PC_CMD_PHITCNT)
#define G_BCM1480_HSP_RX_PC_CMD_PHITCNT(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_PC_CMD_PHITCNT,M_BCM1480_HSP_RX_PC_CMD_PHITCNT)

#define S_BCM1480_HSP_RX_PC_DAT_PHITCNT     48
#define M_BCM1480_HSP_RX_PC_DAT_PHITCNT     _SB_MAKEMASK(8,S_BCM1480_HSP_RX_PC_DAT_PHITCNT)
#define V_BCM1480_HSP_RX_PC_DAT_PHITCNT(x)  _SB_MAKEVALUE(x,S_BCM1480_HSP_RX_PC_DAT_PHITCNT)
#define G_BCM1480_HSP_RX_PC_DAT_PHITCNT(x)  _SB_GETVALUE(x,S_BCM1480_HSP_RX_PC_DAT_PHITCNT,M_BCM1480_HSP_RX_PC_DAT_PHITCNT)

/*
 * TX HTCC Buffer Allocation Registers (Table 370)
 */

#define S_BCM1480_HSP_TX_HTCC_PRB_PHITCNT          0
#define M_BCM1480_HSP_TX_HTCC_PRB_PHITCNT          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_HTCC_PRB_PHITCNT)
#define V_BCM1480_HSP_TX_HTCC_PRB_PHITCNT(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_HTCC_PRB_PHITCNT)
#define G_BCM1480_HSP_TX_HTCC_PRB_PHITCNT(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_HTCC_PRB_PHITCNT,M_BCM1480_HSP_TX_HTCC_PRB_PHITCNT)

#define S_BCM1480_HSP_TX_HTCC_ACK_PHITCNT          8
#define M_BCM1480_HSP_TX_HTCC_ACK_PHITCNT          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_HTCC_ACK_PHITCNT)
#define V_BCM1480_HSP_TX_HTCC_ACK_PHITCNT(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_HTCC_ACK_PHITCNT)
#define G_BCM1480_HSP_TX_HTCC_ACK_PHITCNT(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_HTCC_ACK_PHITCNT,M_BCM1480_HSP_TX_HTCC_ACK_PHITCNT)

#define S_BCM1480_HSP_TX_HTCC_WB_PHITCNT          24
#define M_BCM1480_HSP_TX_HTCC_WB_PHITCNT          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_HTCC_WB_PHITCNT)
#define V_BCM1480_HSP_TX_HTCC_WB_PHITCNT(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_HTCC_WB_PHITCNT)
#define G_BCM1480_HSP_TX_HTCC_WB_PHITCNT(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_HTCC_WB_PHITCNT,M_BCM1480_HSP_TX_HTCC_WB_PHITCNT)

#define S_BCM1480_HSP_TX_HTCC_CFILL_PHITCNT          32
#define M_BCM1480_HSP_TX_HTCC_CFILL_PHITCNT          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_HTCC_CFILL_PHITCNT)
#define V_BCM1480_HSP_TX_HTCC_CFILL_PHITCNT(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_HTCC_CFILL_PHITCNT)
#define G_BCM1480_HSP_TX_HTCC_CFILL_PHITCNT(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_HTCC_CFILL_PHITCNT,M_BCM1480_HSP_TX_HTCC_CFILL_PHITCNT)

#define S_BCM1480_HSP_TX_HTCC_CRD_PHITCNT          40
#define M_BCM1480_HSP_TX_HTCC_CRD_PHITCNT          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_HTCC_CRD_PHITCNT)
#define V_BCM1480_HSP_TX_HTCC_CRD_PHITCNT(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_HTCC_CRD_PHITCNT)
#define G_BCM1480_HSP_TX_HTCC_CRD_PHITCNT(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_HTCC_CRD_PHITCNT,M_BCM1480_HSP_TX_HTCC_CRD_PHITCNT)

/*
 * TX Packet Buffer Allocation Registers (Table 371)
 */

#define S_BCM1480_HSP_TX_PHITCNT_0          0
#define M_BCM1480_HSP_TX_PHITCNT_0          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_PHITCNT_0)
#define V_BCM1480_HSP_TX_PHITCNT_0(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_PHITCNT_0)
#define G_BCM1480_HSP_TX_PHITCNT_0(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_PHITCNT_0,M_BCM1480_HSP_TX_PHITCNT_0)

#define S_BCM1480_HSP_TX_PHITCNT_1          16
#define M_BCM1480_HSP_TX_PHITCNT_1          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_PHITCNT_1)
#define V_BCM1480_HSP_TX_PHITCNT_1(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_PHITCNT_1)
#define G_BCM1480_HSP_TX_PHITCNT_1(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_PHITCNT_1,M_BCM1480_HSP_TX_RAMPHITCNT_1)

#define S_BCM1480_HSP_TX_PHITCNT_2          32
#define M_BCM1480_HSP_TX_PHITCNT_2          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_PHITCNT_2)
#define V_BCM1480_HSP_TX_PHITCNT_2(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_PHITCNT_2)
#define G_BCM1480_HSP_TX_PHITCNT_2(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_PHITCNT_2,M_BCM1480_HSP_TX_PHITCNT_2)

#define S_BCM1480_HSP_TX_PHITCNT_3          48
#define M_BCM1480_HSP_TX_PHITCNT_3          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_PHITCNT_3)
#define V_BCM1480_HSP_TX_PHITCNT_3(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_PHITCNT_3)
#define G_BCM1480_HSP_TX_PHITCNT_3(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_PHITCNT_3,M_BCM1480_HSP_TX_RAMPHITCNT_3)

/*
 * TX Non-Posted Command (NPC) Allocation Register (Table 372)
 */

#define S_BCM1480_HSP_TX_NPC_PHITCNT          0
#define M_BCM1480_HSP_TX_NPC_PHITCNT          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_NPC_PHITCNT)
#define V_BCM1480_HSP_TX_NPC_PHITCNT(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_NPC_PHITCNT)
#define G_BCM1480_HSP_TX_NPC_PHITCNT(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_NPC_PHITCNT,M_BCM1480_HSP_TX_NPC_PHITCNT)

#define S_BCM1480_HSP_TX_RSP_PHITCNT          24
#define M_BCM1480_HSP_TX_RSP_PHITCNT          _SB_MAKEMASK(8,S_BCM1480_HSP_TX_RSP_PHITCNT)
#define V_BCM1480_HSP_TX_RSP_PHITCNT(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_RSP_PHITCNT)
#define G_BCM1480_HSP_TX_RSP_PHITCNT(x)       _SB_GETVALUE(x,S_BCM1480_HSP_TX_RSP_PHITCNT,M_BCM1480_HSP_TX_RSP_PHITCNT)

#define S_BCM1480_HSP_TX_PC_PHITCNT           48
#define M_BCM1480_HSP_TX_PC_PHITCNT           _SB_MAKEMASK(8,S_BCM1480_HSP_TX_PC_PHITCNT)
#define V_BCM1480_HSP_TX_PC_PHITCNT(x)        _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_PC_PHITCNT)
#define G_BCM1480_HSP_TX_PC_PHITCNT(x)        _SB_GETVALUE(x,S_BCM1480_HSP_TX_PC_PHITCNT,M_BCM1480_HSP_TX_PC_PHITCNT)

#define S_BCM1480_HSP_TX_NEXT_ADDR_EVEN       0
#define M_BCM1480_HSP_TX_NEXT_ADDR_EVEN       _SB_MAKEMASK(32,S_BCM1480_HSP_TX_NEXT_ADDR_EVEN)
#define V_BCM1480_HSP_TX_NEXT_ADDR_EVEN(x)    _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_NEXT_ADDR_EVEN)
#define G_BCM1480_HSP_TX_NEXT_ADDR_EVEN(x)    _SB_GETVALUE(x,S_BCM1480_HSP_TX_NEXT_ADDR_EVEN,M_BCM1480_HSP_TX_NEXT_ADDR_EVEN)

#define S_BCM1480_HSP_TX_NEXT_ADDR_ODD       32
#define M_BCM1480_HSP_TX_NEXT_ADDR_ODD       _SB_MAKEMASK(32,S_BCM1480_HSP_TX_NEXT_ADDR_ODD)
#define V_BCM1480_HSP_TX_NEXT_ADDR_ODD(x)    _SB_MAKEVALUE(x,S_BCM1480_HSP_TX_NEXT_ADDR_ODD)
#define G_BCM1480_HSP_TX_NEXT_ADDR_ODD(x)    _SB_GETVALUE(x,S_BCM1480_HSP_TX_NEXT_ADDR_ODD,M_BCM1480_HSP_TX_NEXT_ADDR_ODD)

/*
 * TX HTCC Physical Unot Count (Table 373)
 */

/* See definitions for table 370. */

/*  *********************************************************************
    *  Managability/Testability registers
    *  BROADCOM USE ONLY
    ********************************************************************* */

/*
 * RX PLL Config (Table 374)
 * BROADCOM USE ONLY
 */

#define S_BCM1480_HSP_RXPLL_FREQF_SEL                0
#define M_BCM1480_HSP_RXPLL_FREQF_SEL                _SB_MAKEMASK(4,S_BCM1480_HSP_RXPLL_FREQF_SEL)
#define V_BCM1480_HSP_RXPLL_FREQF_SEL(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_RXPLL_FREQF_SEL)
#define G_BCM1480_HSP_RXPLL_FREQF_SEL(x)             _SB_GETVALUE(x,S_BCM1480_HSP_RXPLL_FREQF_SEL,M_BCM1480_HSP_RXPLL_FREQF_SEL)

#define S_BCM1480_HSP_RXPLL_FDBK_SEL                4
#define M_BCM1480_HSP_RXPLL_FDBK_SEL                _SB_MAKEMASK(4,S_BCM1480_HSP_RXPLL_FDBK_SEL)
#define V_BCM1480_HSP_RXPLL_FDBK_SEL(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_RXPLL_FDBK_SEL)
#define G_BCM1480_HSP_RXPLL_FDBK_SEL(x)             _SB_GETVALUE(x,S_BCM1480_HSP_RXPLL_FDBK_SEL,M_BCM1480_HSP_RXPLL_FDBK_SEL)

#define S_BCM1480_HSP_RXPLL_VCO_RANGE                8
#define M_BCM1480_HSP_RXPLL_VCO_RANGE                _SB_MAKEMASK(2,S_BCM1480_HSP_RXPLL_VCO_RANGE)
#define V_BCM1480_HSP_RXPLL_VCO_RANGE(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_RXPLL_VCO_RANGE)
#define G_BCM1480_HSP_RXPLL_VCO_RANGE(x)             _SB_GETVALUE(x,S_BCM1480_HSP_RXPLL_VCO_RANGE,M_BCM1480_HSP_RXPLL_VCO_RANGE)

#define M_BCM1480_HSP_RXPLL_DIV4 		_SB_MAKEMASK1(10)
#define M_BCM1480_HSP_RXPLL_PLLOVERRIDE		_SB_MAKEMASK1(12)
#define M_BCM1480_HSP_RXPLL_VCOOVERRIDE		_SB_MAKEMASK1(13)

#define S_BCM1480_HSP_RXPLL_RX_PLLTEST                14
#define M_BCM1480_HSP_RXPLL_RX_PLLTEST                _SB_MAKEMASK(2,S_BCM1480_HSP_RXPLL_RX_PLLTEST)
#define V_BCM1480_HSP_RXPLL_RX_PLLTEST(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_RXPLL_RX_PLLTEST)
#define G_BCM1480_HSP_RXPLL_RX_PLLTEST(x)             _SB_GETVALUE(x,S_BCM1480_HSP_RXPLL_RX_PLLTEST,M_BCM1480_HSP_RXPLL_RX_PLLTEST)

#define S_BCM1480_HSP_RXPLL_RX_PLLCTRL                16
#define M_BCM1480_HSP_RXPLL_RX_PLLCTRL                _SB_MAKEMASK(6,S_BCM1480_HSP_RXPLL_RX_PLLCTRL)
#define V_BCM1480_HSP_RXPLL_RX_PLLCTRL(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_RXPLL_RX_PLLCTRL)
#define G_BCM1480_HSP_RXPLL_RX_PLLCTRL(x)             _SB_GETVALUE(x,S_BCM1480_HSP_RXPLL_RX_PLLCTRL,M_BCM1480_HSP_RXPLL_RX_PLLCTRL)


/*
 * TX PLL Config (Table 375)
 * BROADCOM USE ONLY
 */

#define S_BCM1480_HSP_TXPLL_FREQF_SEL                0
#define M_BCM1480_HSP_TXPLL_FREQF_SEL                _SB_MAKEMASK(4,S_BCM1480_HSP_TXPLL_FREQF_SEL)
#define V_BCM1480_HSP_TXPLL_FREQF_SEL(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_TXPLL_FREQF_SEL)
#define G_BCM1480_HSP_TXPLL_FREQF_SEL(x)             _SB_GETVALUE(x,S_BCM1480_HSP_TXPLL_FREQF_SEL,M_BCM1480_HSP_TXPLL_FREQF_SEL)

#define S_BCM1480_HSP_TXPLL_FDBK_SEL                4
#define M_BCM1480_HSP_TXPLL_FDBK_SEL                _SB_MAKEMASK(4,S_BCM1480_HSP_TXPLL_FDBK_SEL)
#define V_BCM1480_HSP_TXPLL_FDBK_SEL(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_TXPLL_FDBK_SEL)
#define G_BCM1480_HSP_TXPLL_FDBK_SEL(x)             _SB_GETVALUE(x,S_BCM1480_HSP_TXPLL_FDBK_SEL,M_BCM1480_HSP_TXPLL_FDBK_SEL)

#define S_BCM1480_HSP_TXPLL_VCO_RANGE                8
#define M_BCM1480_HSP_TXPLL_VCO_RANGE                _SB_MAKEMASK(2,S_BCM1480_HSP_TXPLL_VCO_RANGE)
#define V_BCM1480_HSP_TXPLL_VCO_RANGE(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_TXPLL_VCO_RANGE)
#define G_BCM1480_HSP_TXPLL_VCO_RANGE(x)             _SB_GETVALUE(x,S_BCM1480_HSP_TXPLL_VCO_RANGE,M_BCM1480_HSP_TXPLL_VCO_RANGE)

#define M_BCM1480_HSP_TXPLL_DIV4 		_SB_MAKEMASK1(10)
#define M_BCM1480_HSP_TXPLL_ESTOREDEPTH8	_SB_MAKEMASK1(11)
#define M_BCM1480_HSP_TXPLL_PLLOVERRIDE		_SB_MAKEMASK1(12)
#define M_BCM1480_HSP_TXPLL_VCOOVERRIDE		_SB_MAKEMASK1(13)

#define S_BCM1480_HSP_TXPLL_TX_PLLTEST                14
#define M_BCM1480_HSP_TXPLL_TX_PLLTEST                _SB_MAKEMASK(2,S_BCM1480_HSP_TXPLL_TX_PLLTEST)
#define V_BCM1480_HSP_TXPLL_TX_PLLTEST(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_TXPLL_TX_PLLTEST)
#define G_BCM1480_HSP_TXPLL_TX_PLLTEST(x)             _SB_GETVALUE(x,S_BCM1480_HSP_TXPLL_TX_PLLTEST,M_BCM1480_HSP_TXPLL_TX_PLLTEST)

#define S_BCM1480_HSP_TXPLL_TX_PLLCTRL                16
#define M_BCM1480_HSP_TXPLL_TX_PLLCTRL                _SB_MAKEMASK(6,S_BCM1480_HSP_TXPLL_TX_PLLCTRL)
#define V_BCM1480_HSP_TXPLL_TX_PLLCTRL(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_TXPLL_TX_PLLCTRL)
#define G_BCM1480_HSP_TXPLL_TX_PLLCTRL(x)             _SB_GETVALUE(x,S_BCM1480_HSP_TXPLL_TX_PLLCTRL,M_BCM1480_HSP_TXPLL_TX_PLLCTRL)

/*
 * RX and TX calibration registers (Table 376)
 * BROADCOM USE ONLY
 */

#define M_BCM1480_HSP_CAL_STARTCAL2	_SB_MAKEMASK1(0)
#define M_BCM1480_HSP_CAL_PDTEST	_SB_MAKEMASK1(1)
#define M_BCM1480_HSP_CAL_CALFIN	_SB_MAKEMASK1(2)
#define M_BCM1480_HSP_CAL_S100M66M	_SB_MAKEMASK1(3)
#define M_BCM1480_HSP_CAL_NO_CALIB	_SB_MAKEMASK1(4)

#define S_BCM1480_HSP_CAL_BMODE                5
#define M_BCM1480_HSP_CAL_BMODE                _SB_MAKEMASK(2,S_BCM1480_HSP_CAL_BMODE)
#define V_BCM1480_HSP_CAL_BMODE(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_CAL_BMODE)
#define G_BCM1480_HSP_CAL_BMODE(x)             _SB_GETVALUE(x,S_BCM1480_HSP_CAL_BMODE,M_BCM1480_HSP_CAL_BMODE)

#define S_BCM1480_HSP_CAL_CALSETP                8
#define M_BCM1480_HSP_CAL_CALSETP                _SB_MAKEMASK(4,S_BCM1480_HSP_CAL_CALSETP)
#define V_BCM1480_HSP_CAL_CALSETP(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_CAL_CALSETP)
#define G_BCM1480_HSP_CAL_CALSETP(x)             _SB_GETVALUE(x,S_BCM1480_HSP_CAL_CALSETP,M_BCM1480_HSP_CAL_CALSETP)

#define S_BCM1480_HSP_CAL_CALSETN                12
#define M_BCM1480_HSP_CAL_CALSETN                _SB_MAKEMASK(4,S_BCM1480_HSP_CAL_CALSETN)
#define V_BCM1480_HSP_CAL_CALSETN(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_CAL_CALSETN)
#define G_BCM1480_HSP_CAL_CALSETN(x)             _SB_GETVALUE(x,S_BCM1480_HSP_CAL_CALSETN,M_BCM1480_HSP_CAL_CALSETN)

#define S_BCM1480_HSP_CAL_CALPSTAT                16
#define M_BCM1480_HSP_CAL_CALPSTAT                _SB_MAKEMASK(4,S_BCM1480_HSP_CAL_CALPSTAT)
#define V_BCM1480_HSP_CAL_CALPSTAT(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_CAL_CALPSTAT)
#define G_BCM1480_HSP_CAL_CALPSTAT(x)             _SB_GETVALUE(x,S_BCM1480_HSP_CAL_CALPSTAT,M_BCM1480_HSP_CAL_CALPSTAT)

#define S_BCM1480_HSP_CAL_CALNSTAT                20
#define M_BCM1480_HSP_CAL_CALNSTAT                _SB_MAKEMASK(4,S_BCM1480_HSP_CAL_CALNSTAT)
#define V_BCM1480_HSP_CAL_CALNSTAT(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_CAL_CALNSTAT)
#define G_BCM1480_HSP_CAL_CALNSTAT(x)             _SB_GETVALUE(x,S_BCM1480_HSP_CAL_CALNSTAT,M_BCM1480_HSP_CAL_CALNSTAT)


/*
 * RX Testability (Table 377)
 * BROADCOM USE ONLY
 */


#define S_BCM1480_HSP_RXTST_EWRAP                1
#define M_BCM1480_HSP_RXTST_EWRAP                _SB_MAKEMASK(2,S_BCM1480_HSP_RXTST_EWRAP)
#define V_BCM1480_HSP_RXTST_EWRAP(x)             _SB_MAKEVALUE(x,S_BCM1480_HSP_RXTST_EWRAP)
#define G_BCM1480_HSP_RXTST_EWRAP(x)             _SB_GETVALUE(x,S_BCM1480_HSP_RXTST_EWRAP,M_BCM1480_HSP_RXTST_EWRAP)

#define M_BCM1480_HSP_RXTST_RXDLL_FREEZE         _SB_MAKEMASK1(4)
#define M_BCM1480_HSP_RXTST_TX_PLL_BYPASS        _SB_MAKEMASK1(5)
#define M_BCM1480_HSP_RXTST_RX_PLL_BYPASS        _SB_MAKEMASK1(6)
#define M_BCM1480_HSP_RXTST_DLL_CHRESET_ENABLE   _SB_MAKEMASK1(7)

#define S_BCM1480_HSP_RXTST_RX_ICNTRL             8
#define M_BCM1480_HSP_RXTST_RX_ICNTRL             _SB_MAKEMASK(12,S_BCM1480_HSP_RXTST_RX_ICNTRL)
#define V_BCM1480_HSP_RXTST_RX_ICNTRL(x)          _SB_MAKEVALUE(x,S_BCM1480_HSP_RXTST_RX_ICNTRL)
#define G_BCM1480_HSP_RXTST_RX_ICNTRL(x)          _SB_GETVALUE(x,S_BCM1480_HSP_RXTST_RX_ICNTRL,M_BCM1480_HSP_RXTST_RX_ICNTRL)

#define S_BCM1480_HSP_RXTST_RX_RCNTRL            20
#define M_BCM1480_HSP_RXTST_RX_RCNTRL            _SB_MAKEMASK(3,S_BCM1480_HSP_RXTST_RX_RCNTRL)
#define V_BCM1480_HSP_RXTST_RX_RCNTRL(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_RXTST_RX_RCNTRL)
#define G_BCM1480_HSP_RXTST_RX_RCNTRL(x)         _SB_GETVALUE(x,S_BCM1480_HSP_RXTST_RX_RCNTRL,M_BCM1480_HSP_RXTST_RX_RCNTRL)

#define S_BCM1480_HSP_RXTST_RX_GCNTRL            24
#define M_BCM1480_HSP_RXTST_RX_GCNTRL            _SB_MAKEMASK(3,S_BCM1480_HSP_RXTST_RX_GCNTRL)
#define V_BCM1480_HSP_RXTST_RX_GCNTRL(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_RXTST_RX_GCNTRL)
#define G_BCM1480_HSP_RXTST_RX_GCNTRL(x)         _SB_GETVALUE(x,S_BCM1480_HSP_RXTST_RX_GCNTRL,M_BCM1480_HSP_RXTST_RX_GCNTRL)

#define S_BCM1480_HSP_RXTST_RX_OORCNTRL          28
#define M_BCM1480_HSP_RXTST_RX_OORCNTRL          _SB_MAKEMASK(2,S_BCM1480_HSP_RXTST_RX_OORCNTRL)
#define V_BCM1480_HSP_RXTST_RX_OORCNTRL(x)       _SB_MAKEVALUE(x,S_BCM1480_HSP_RXTST_RX_OORCNTRL)
#define G_BCM1480_HSP_RXTST_RX_OORCNTRL(x)       _SB_GETVALUE(x,S_BCM1480_HSP_RXTST_RX_OORCNTRL,M_BCM1480_HSP_RXTST_RX_OORCNTRL)

#define S_BCM1480_HSP_RXTST_RX_CNTRL             32
#define M_BCM1480_HSP_RXTST_RX_CNTRL             _SB_MAKEMASK(3,S_BCM1480_HSP_RXTST_RX_CNTRL)
#define V_BCM1480_HSP_RXTST_RX_CNTRL(x)          _SB_MAKEVALUE(x,S_BCM1480_HSP_RXTST_RX_CNTRL)
#define G_BCM1480_HSP_RXTST_RX_CNTRL(x)          _SB_GETVALUE(x,S_BCM1480_HSP_RXTST_RX_CNTRL,M_BCM1480_HSP_RXTST_RX_CNTRL)

#define S_BCM1480_HSP_RXTST_RX_LPBK_PHASE_SEL_RXA            35
#define M_BCM1480_HSP_RXTST_RX_LPBK_PHASE_SEL_RXA            _SB_MAKEMASK(3,S_BCM1480_HSP_RXTST_RX_LPBK_PHASE_SEL_RXA)
#define V_BCM1480_HSP_RXTST_RX_LPBK_PHASE_SEL_RXA(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_RXTST_RX_LPBK_PHASE_SEL_RXA)
#define G_BCM1480_HSP_RXTST_RX_LPBK_PHASE_SEL_RXA(x)         _SB_GETVALUE(x,S_BCM1480_HSP_RXTST_RX_LPBK_PHASE_SEL_RXA,M_BCM1480_HSP_RXTST_RX_LPBK_PHASE_SEL_RXA)

#define M_BCM1480_HSP_RXTST_DIP4_CHECK_DISABLE   _SB_MAKEMASK1(38)
#define M_BCM1480_HSP_RXTST_EBUF_WREN            _SB_MAKEMASK1(40)
#define M_BCM1480_HSP_RXTST_DIGITAL_LOOPBACK     _SB_MAKEMASK1(41)
#define M_BCM1480_HSP_RXTST_EBUF_BURST_MODE      _SB_MAKEMASK1(42)
#define M_BCM1480_HSP_RXTST_RESET_STOP_STREAM    _SB_MAKEMASK1(43)

#define S_BCM1480_HSP_RXTST_RX_BIAS            44
#define M_BCM1480_HSP_RXTST_RX_BIAS            _SB_MAKEMASK(2,S_BCM1480_HSP_RXTST_RX_BIAS)
#define V_BCM1480_HSP_RXTST_RX_BIAS(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_RXTST_RX_BIAS)
#define G_BCM1480_HSP_RXTST_RX_BIAS(x)         _SB_GETVALUE(x,S_BCM1480_HSP_RXTST_RX_BIAS,M_BCM1480_HSP_RXTST_RX_BIAS)

/*
 * TX Testability (Table 378)
 * BROADCOM USE ONLY
 */

#define S_BCM1480_HSP_TXTST_CTL            0
#define M_BCM1480_HSP_TXTST_CTL            _SB_MAKEMASK(3,S_BCM1480_HSP_TXTST_CTL)
#define V_BCM1480_HSP_TXTST_CTL(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_TXTST_CTL)
#define G_BCM1480_HSP_TXTST_CTL(x)         _SB_GETVALUE(x,S_BCM1480_HSP_TXTST_CTL,M_BCM1480_HSP_TXTST_CTL)

#define S_BCM1480_HSP_TXTST_BIAS            4
#define M_BCM1480_HSP_TXTST_BIAS            _SB_MAKEMASK(4,S_BCM1480_HSP_TXTST_BIAS)
#define V_BCM1480_HSP_TXTST_BIAS(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_TXTST_BIAS)
#define G_BCM1480_HSP_TXTST_BIAS(x)         _SB_GETVALUE(x,S_BCM1480_HSP_TXTST_BIAS,M_BCM1480_HSP_TXTST_BIAS)

#define S_BCM1480_HSP_TXTST_VCOM_CTL            8
#define M_BCM1480_HSP_TXTST_VCOM_CTL            _SB_MAKEMASK(4,S_BCM1480_HSP_TXTST_VCOM_CTL)
#define V_BCM1480_HSP_TXTST_VCOM_CTL(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_TXTST_VCOM_CTL)
#define G_BCM1480_HSP_TXTST_VCOM_CTL(x)         _SB_GETVALUE(x,S_BCM1480_HSP_TXTST_VCOM_CTL,M_BCM1480_HSP_TXTST_VCOM_CTL)

#define S_BCM1480_HSP_TXTST_MUX_CTL            12
#define M_BCM1480_HSP_TXTST_MUX_CTL            _SB_MAKEMASK(4,S_BCM1480_HSP_TXTST_MUX_CTL)
#define V_BCM1480_HSP_TXTST_MUX_CTL(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_TXTST_MUX_CTL)
#define G_BCM1480_HSP_TXTST_MUX_CTL(x)         _SB_GETVALUE(x,S_BCM1480_HSP_TXTST_MUX_CTL,M_BCM1480_HSP_TXTST_MUX_CTL)

#define S_BCM1480_HSP_TXTST_SLEWP_CTL            16
#define M_BCM1480_HSP_TXTST_SLEWP_CTL            _SB_MAKEMASK(2,S_BCM1480_HSP_TXTST_SLEWP_CTL)
#define V_BCM1480_HSP_TXTST_SLEWP_CTL(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_TXTST_SLEWP_CTL)
#define G_BCM1480_HSP_TXTST_SLEWP_CTL(x)         _SB_GETVALUE(x,S_BCM1480_HSP_TXTST_SLEWP_CTL,M_BCM1480_HSP_TXTST_SLEWP_CTL)

#define S_BCM1480_HSP_TXTST_SLEWN_CTL            18
#define M_BCM1480_HSP_TXTST_SLEWN_CTL            _SB_MAKEMASK(2,S_BCM1480_HSP_TXTST_SLEWN_CTL)
#define V_BCM1480_HSP_TXTST_SLEWN_CTL(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_TXTST_SLEWN_CTL)
#define G_BCM1480_HSP_TXTST_SLEWN_CTL(x)         _SB_GETVALUE(x,S_BCM1480_HSP_TXTST_SLEWN_CTL,M_BCM1480_HSP_TXTST_SLEWN_CTL)

#define S_BCM1480_HSP_TXTST_CURR_CTL            20
#define M_BCM1480_HSP_TXTST_CURR_CTL            _SB_MAKEMASK(2,S_BCM1480_HSP_TXTST_CURR_CTL)
#define V_BCM1480_HSP_TXTST_CURR_CTL(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_TXTST_CURR_CTL)
#define G_BCM1480_HSP_TXTST_CURR_CTL(x)         _SB_GETVALUE(x,S_BCM1480_HSP_TXTST_CURR_CTL,M_BCM1480_HSP_TXTST_CURR_CTL)

/*
 * XXX TBD: TABLES 379, 380, 381
 * BROADCOM USE ONLY
 */

/*
 * RX RAM Visibility (Table 382, 383)
 * BROADCOM USE ONLY
 */

#define S_BCM1480_HSP_RXVIS_RAM            0
#define M_BCM1480_HSP_RXVIS_RAM            _SB_MAKEMASK(3,S_BCM1480_HSP_RXVIS_RAM)
#define V_BCM1480_HSP_RXVIS_RAM(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_RXVIS_RAM)
#define G_BCM1480_HSP_RXVIS_RAM(x)         _SB_GETVALUE(x,S_BCM1480_HSP_RXVIS_RAM,M_BCM1480_HSP_RXVIS_RAM)

#define K_BCM1480_HSP_RXVIS_RAM_ERAM	0
#define K_BCM1480_HSP_RXVIS_RAM_HRAM	1
#define K_BCM1480_HSP_RXVIS_RAM_DRAM_0_63	3
#define K_BCM1480_HSP_RXVIS_RAM_DRAM_64_127	4
#define K_BCM1480_HSP_RXVIS_RAM_DRAM_128_151	5

#define S_BCM1480_HSP_RXVIS_RAM_ADDR            16
#define M_BCM1480_HSP_RXVIS_RAM_ADDR            _SB_MAKEMASK(16,S_BCM1480_HSP_RXVIS_RAM_ADDR)
#define V_BCM1480_HSP_RXVIS_RAM_ADDR(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_RXVIS_RAM_ADDR)
#define G_BCM1480_HSP_RXVIS_RAM_ADDR(x)         _SB_GETVALUE(x,S_BCM1480_HSP_RXVIS_RAM_ADDR,M_BCM1480_HSP_RXVIS_RAM_ADDR)


/*
 * RX RF RAM Visibility (Table 384, 385)
 * BROADCOM USE ONLY
 */

#define S_BCM1480_HSP_RXRFVIS_RAM            0
#define M_BCM1480_HSP_RXRFVIS_RAM            _SB_MAKEMASK(4,S_BCM1480_HSP_RXRFVIS_RAM)
#define V_BCM1480_HSP_RXRFVIS_RAM(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_RXRFVIS_RAM)
#define G_BCM1480_HSP_RXRFVIS_RAM(x)         _SB_GETVALUE(x,S_BCM1480_HSP_RXRFVIS_RAM,M_BCM1480_HSP_RXRFVIS_RAM)

#define K_BCM1480_HSP_RXRFVIS_RAM_REASS_0_63	0
#define K_BCM1480_HSP_RXRFVIS_RAM_REASS_64_127	1
#define K_BCM1480_HSP_RXRFVIS_RAM_REASS_META	2
#define K_BCM1480_HSP_RXRFVIS_RAM_PL12_RF	3
#define K_BCM1480_HSP_RXRFVIS_RAM_PL12_FLOPS	4
#define K_BCM1480_HSP_RXRFVIS_RAM_HEADPTRARRAY	5
#define K_BCM1480_HSP_RXRFVIS_RAM_TAILPTRARRAY	6
#define K_BCM1480_HSP_RXRFVIS_RAM_PRECABVAL	7
#define K_BCM1480_HSP_RXRFVIS_RAM_PHITCNTARRAY	8

#define S_BCM1480_HSP_RXRFVIS_RAM_ADDR            8
#define M_BCM1480_HSP_RXRFVIS_RAM_ADDR            _SB_MAKEMASK(8,S_BCM1480_HSP_RXRFVIS_RAM_ADDR)
#define V_BCM1480_HSP_RXRFVIS_RAM_ADDR(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_RXRFVIS_RAM_ADDR)
#define G_BCM1480_HSP_RXRFVIS_RAM_ADDR(x)         _SB_GETVALUE(x,S_BCM1480_HSP_RXRFVIS_RAM_ADDR,M_BCM1480_HSP_RXRFVIS_RAM_ADDR)


/*
 * XXX TBD: Tables  386, 387, 388, 389
 * BROADCOM USE ONLY
 */

/*
 * TX RAM Visibility (Table 390, 391)
 * BROADCOM USE ONLY
 */

#define S_BCM1480_HSP_TXVIS_RAM            0
#define M_BCM1480_HSP_TXVIS_RAM            _SB_MAKEMASK(3,S_BCM1480_HSP_TXVIS_RAM)
#define V_BCM1480_HSP_TXVIS_RAM(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_TXVIS_RAM)
#define G_BCM1480_HSP_TXVIS_RAM(x)         _SB_GETVALUE(x,S_BCM1480_HSP_TXVIS_RAM,M_BCM1480_HSP_TXVIS_RAM)

#define K_BCM1480_HSP_TXVIS_RAM_DRAM_0_63	0
#define K_BCM1480_HSP_TXVIS_RAM_DRAM_64_127	1
#define K_BCM1480_HSP_TXVIS_RAM_DRAM_128_151	2

#define S_BCM1480_HSP_TXVIS_RAM_ADDR            16
#define M_BCM1480_HSP_TXVIS_RAM_ADDR            _SB_MAKEMASK(16,S_BCM1480_HSP_TXVIS_RAM_ADDR)
#define V_BCM1480_HSP_TXVIS_RAM_ADDR(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_TXVIS_RAM_ADDR)
#define G_BCM1480_HSP_TXVIS_RAM_ADDR(x)         _SB_GETVALUE(x,S_BCM1480_HSP_TXVIS_RAM_ADDR,M_BCM1480_HSP_TXVIS_RAM_ADDR)


/*
 * TX RF RAM Visibility (Table 392,393)
 * BROADCOM USE ONLY
 */

#define S_BCM1480_HSP_TXRFVIS_RAM            0
#define M_BCM1480_HSP_TXRFVIS_RAM            _SB_MAKEMASK(4,S_BCM1480_HSP_TXRFVIS_RAM)
#define V_BCM1480_HSP_TXRFVIS_RAM(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_TXRFVIS_RAM)
#define G_BCM1480_HSP_TXRFVIS_RAM(x)         _SB_GETVALUE(x,S_BCM1480_HSP_TXRFVIS_RAM,M_BCM1480_HSP_TXRFVIS_RAM)

#define K_BCM1480_HSP_TXRFVIS_RAM_HEADPTRARRAY	   	0
#define K_BCM1480_HSP_TXRFVIS_RAM_TAILPTRARRAY     	1
#define K_BCM1480_HSP_TXRFVIS_RAM_RFEVENDATA_0_63 	2
#define K_BCM1480_HSP_TXRFVIS_RAM_RFEVENDATA_64_71	3
#define K_BCM1480_HSP_TXRFVIS_RAM_RFEVENMETADATA	4
#define K_BCM1480_HSP_TXRFVIS_RAM_RFODDDATA_0_63	5
#define K_BCM1480_HSP_TXRFVIS_RAM_RFODDDATA_64_71	6
#define K_BCM1480_HSP_TXRFVIS_RAM_RFODDMETADATA		7
#define K_BCM1480_HSP_TXRFVIS_RAM_PHITCNTARRAY		8
#define K_BCM1480_HSP_TXRFVIS_RAM_PUSHPOP		9
#define K_BCM1480_HSP_TXRFVIS_RAM_IVCOK			10

#define S_BCM1480_HSP_TXRFVIS_RAM_ADDR            8
#define M_BCM1480_HSP_TXRFVIS_RAM_ADDR            _SB_MAKEMASK(8,S_BCM1480_HSP_TXRFVIS_RAM_ADDR)
#define V_BCM1480_HSP_TXRFVIS_RAM_ADDR(x)         _SB_MAKEVALUE(x,S_BCM1480_HSP_TXRFVIS_RAM_ADDR)
#define G_BCM1480_HSP_TXRFVIS_RAM_ADDR(x)         _SB_GETVALUE(x,S_BCM1480_HSP_TXRFVIS_RAM_ADDR,M_BCM1480_HSP_TXRFVIS_RAM_ADDR)


#endif /* _BCM1480_HSP_H */
