.TH XMB N "20 May 1990" "X Version 11"
.SH NAME
xmb, xnetmb \- fast mandelbrot generator for X-windows
.SH SYNOPSIS
.B xmb
[
.B \-display
.I display
]
[
.B \-geometry
.I geometry
]
[
.B \-zebra
]
.if n .ti +5
.if t .ti +.5i
[
.B \-nice
.I value
]
[
.B \-iters
.I i
]
[
.B \-colors
.I number
]
.if n .ti +5
.if t .ti +.5i
[
.B \-z
.I x+yi
]
[
.B \-j
.I cx+cyi
]
[
.B \-x
.I scale
]
.LP
.B xnetmb
[
.B \-display
.I display
]
[
.B \-geometry
.I geometry
]
.if n .ti +5
.if t .ti +.5i
[
.B \-zebra
]
[
.B \-nice
.I value
]
[
.B \-iters
.I i
]
.if n .ti +5
.if t .ti +.5i
[
.B \-colors
.I number
]
[
.B \-z
.I x+yi
]
[
.B \-j
.I cx+cyi
]
.if n .ti +5
.if t .ti +.5i
[
.B \-x
.I scale
]
[
.B \-server
.I name
]
[
.B \-port
.I port
]
.if n .ti +5
.if t .ti +.5i
[
.B \-machines
.I list of rsh machines
]

.SH DESCRIPTION
.LP
.IR xmb 
and
.IR xnetmb 
are fast and nice programs for generating Mandelbrot and Julia sets.
.\"If you do not know what these sets are, tough.
.IR xmb 
and
.IR xnetmb
use a few tricks to gain extra speed,
namely
fixed-point math,
contour-crawling algorithm,
and in the case of
.IR xnetmb,
distributed processing in a number of machines in a network.

.IR xmb
and
.IR xnetmb
are almost identical,
so the following explanation applies to both.
When started,
.IR xmb
will open a window and display the Mandelbrot set
in its initial form.
One can zoom into the set
by pressing the left mouse button
and dragging it over the set.
When middle mouse button is pressed,
.IR xmb
will calculate a Julia set,
using the point under the pointer
as the magical constant
.IR c.
Another press of the middle mouse button
will return the Mandelbrot image.

The right mouse button will open and close a
.IR control
.IR window,
which contains some
.IR gadgets,
a colormap
.IR slider
and a 
.IR spectrum
showing the current colormap.

The sliders can be moved by pressing the left mouse button
and dragging.
The leftmost three sliders control 
the single color
that represents the interior of the set
while the remaining three
control the continuous colormap
that is used when colouring
the exterior of the set.

The changes to the colormap do not take effect until
the middle mouse button or the
.IR Apply
gadget is pressed.
This in turn may damage the colors of the actual
image, in which case the
.IR Redraw
gadget may be used to redraw it.
The
.IR Previous
gadget causes
.IR xmb
to redraw the previous image, while
.IR Restart
causes it to draw the initial Mandelbrot set.
The
.IR Quit
gadget, of course, quits the program.

The spectrum not only shows the current colormap,
it can also be used to shift the mapping
between iterations and colors.
This is achieved by pressing the left mouse button
over the spectrum,
moving it to another position
and releasing the button.
For example, if there is an area that is coloured in red
and you would like to see it blue,
press the mouse button when it is over red on the spectrum
and release it when it is over blue.
(This should be done only once,
consequent changes accumulate.)
Then you may wish to press the
.IR Redraw
gadget to see the new colors take effect.


.SH OPTIONS
.LP
All options may be abbreviated.
.TP 1i
.BI \-display " name"
specifies the connection to X server, see
.BR X (1).
.TP
.BI \-geometry " geometry"
defines the initial window geometry, see
.BR X (1).
.TP
.BI \-zebra
causes
.IR xmb
to go into zebra-stripe mode. Useful mostly on black-and-white displays.
.TP
.BI \-nice " value"
defines how nice the program will be, see
.BR nice (1).
It is nice to use this option, especially with
.IR xnetmb
clients.
.TP
.BI \-iters " i"
specifies the number of iterations. Default is as huge as 500.
.TP
.BI \-colors " number"
specifies the number of color cells
.IR xmb
will try to allocate.
By default, it tries to allocate all colors available.
.TP
.BI \-z " x+yi"
specifies the point in complex plane that will be shown
at the center of the window.
Default is 0+0i.
.TP
.BI \-j " x+yi"
specifies the constant
.IR c
and causes
.IR xmb
to draw the corresponding Julia set.
.TP
.BI \-x " scale"
defines the scale of the picture.
.I scale
specifies the average distance in the complex plane
that is shown inside the window.
Default is 4.
The options
.I z,
.I j
and
.I x
are useful to display an interesting set whose coordinates
are known in advance.
.TP
.BI \-server " name"
causes
.IR xnetmb
to start client operation.
First it connects itself to specified
.I port
(see below) of server
.I name.
Then it waits for incoming calculation requests,
calculates them, and sends the results back to server.
.IR xnetmb
only.
.TP
.BI \-port " port"
specifies the
.I port
.IR xnetmb
will establish the server at.
Default port is 5358.
Do not override the default unless necessary.
Specifying a port number below 5000 may be dangerous.
Beware of other servers using fixed port numbers.
.IR xnetmb
only.
.TP
.BI \-machines " list of rsh machines"
will cause
.IR xnetmb
to start server operation.
First it establishes a specified port
(see above).
If there are any machines in the
.I list,
.IR xnetmb
will rsh to each of them and try to start a client,
see
.BR rsh (1C) .
If no clients can be found,
.IR xnetmb
will do the calculations itself.
.IR xnetmb
only.

NOTE: You must be able to use rsh to the
machines specified in the list.
It is also possible to start the clients
manually.
Note also that no client can connect to the server
unless the -m option is given (even with an empty list).

.SH EXAMPLES
.IP
.B
example% xmb -g 200x200+0+0 -z -i 1000
.LP
will open a small window at the top left corner
of the screen
and fill it with zebra-striped mandelbrot set.
.IP
.B
example% xmb -d foobar -c 100
.LP
will display the set on display foobar but use only 100 colors.
.IP
.B
server% xnetmb -m client
.LP
will start a server on machine
.B server
and try to start a client on machine
.B client.
.IP
.B
server% xnetmb -m -p 6535
.IP
client1% xnetmb -s server -p 6535
.IP
client2% xnetmb -s server -p 6535
.LP
will start server on machine
.B server
and two clients on machines
.B client1
and
.B client2
using an alternate port number 6535.

.SH SEE ALSO
.BR nice (1),
.BR rsh (1),
.BR X (1)

.SH BUGS
.IR xmb
will show an infinite number of Mandelbrot and Julia sets,
in addition to the real one that is centered at 0+0i.
These ghosts are due to fixed-point calculations and
are normally invisible, unless an abnormally
large
.I scale
is specified

There are some problems with the networking of
.IR xnetmb.
If you run
.IR xnetmb
with the -m -option twice in succession,
it may fail with error message
"establish: Address already in use".
Waiting a few seconds or specifying another port
number will probably correct the situation.

.SH AUTHOR
	Hannu Helminen -- dm@stekt.oulu.fi

