
/* Socket operations.
 * int establish(int portnum)
 * int get_connection(int s)
 * int call_socket(char *hostname, int portnum)
 * int read_data(int s, char *buf, int n)
 * int write_data(int s, char *buf, int n)
 */

#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include "soc.h"

extern int errno;

/* code to establish a socket; originally from bzs@bu-cs.bu.edu
 */

int establish(portnum)
u_short portnum;
{ char   myname[MAXHOSTNAMELEN+1];
  int    s;
  struct sockaddr_in sa;
  struct hostent *hp;

  bzero((char *)&sa,sizeof(struct sockaddr_in));      /* clear our address */
  gethostname(myname,MAXHOSTNAMELEN);            /* who are we? */
  hp= gethostbyname(myname);                  /* get our address info */
  if (hp == NULL)                             /* we don't exist !? */
    return(-1);
  sa.sin_family= hp->h_addrtype;              /* this is our host address */
  sa.sin_port= htons(portnum);                /* this is our port number */
  if ((s= socket(AF_INET,SOCK_STREAM,0)) < 0) /* create socket */
    return(-1);
  if (bind(s,(struct sockaddr *)&sa,sizeof sa) < 0) {
    close(s);
    return(-1);                               /* bind address to socket */
    }
  listen(s, 3);                               /* max # of queued connects */
  return(s);
}


int get_connection(s)
int s;                    /* socket created with establish() */
{ struct sockaddr_in isa; /* address of socket */
  int i;                  /* size of address */
  int t;                  /* socket of connection */

  i = sizeof(isa);                   /* find socket's address */
  getsockname(s,(struct sockaddr *)&isa,&i);            /* for accept() */

  if ((t = accept(s,(struct sockaddr *)&isa,&i)) < 0) /* accept connection if ... */
    return(-1);
  return(t);
}


int call_socket(hostname, portnum)
char *hostname;
{ struct sockaddr_in sa;
  struct hostent     *hp;
  int s;

  if ((hp= gethostbyname(hostname)) == NULL) { /* do we know the host's */
    errno= ECONNREFUSED;                       /* address? */
    return(-1);                                /* no */
}

  bzero((char *)&sa,sizeof(sa));
  bcopy(hp->h_addr,(char *)&sa.sin_addr,hp->h_length); /* set address */
  sa.sin_family= hp->h_addrtype;
  sa.sin_port= htons((u_short)portnum);

  if ((s= socket(hp->h_addrtype,SOCK_STREAM,0)) < 0)   /* get socket */
    return(-1);
  if (connect(s,(struct sockaddr *)&sa,sizeof sa) < 0)    /* connect */
    return(-1);
  return(s);
}


int read_data(s, buf, n)
int  s;                /* connected socket */
char *buf;             /* pointer to the buffer */
int  n;                /* number of characters (bytes) we want */
{ int bcount,          /* counts bytes read */
      br;              /* bytes read this pass */

  bcount= 0;
  br= 0;
  while (bcount < n) {             /* loop until full buffer */
    if ((br= read(s, buf, n-bcount)) > 0) {
      bcount += br;                /* increment byte counter */
      buf += br;                   /* move buffer ptr for next read */
    }
    if (br <= 0)                    /* signal an error to the caller */
      return(-1);
  }
  return(bcount);
}


int write_data(s, buf, n)
int  s;                /* connected socket */
char *buf;             /* pointer to the buffer */
int  n;                /* number of characters (bytes) */
{ int bcount,          /* counts bytes written */
      br;              /* bytes written this pass */

  bcount= 0;
  br= 0;
  while (bcount < n) {             /* loop until full buffer */
    if ((br= write(s, buf, n-bcount)) > 0) {
      bcount += br;                /* increment byte counter */
      buf += br;                   /* move buffer ptr for next write */
    }
    if (br <= 0)                    /* signal an error to the caller */
      return(-1);
  }
  return(bcount);
}

