/* File: tables.c */

/* Purpose: Angband Tables */

/*
 * Copyright (c) 1989 James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research, and
 * not for profit purposes provided that this copyright and statement are
 * included in all such copies.
 */

#include "angband.h"




/*
 * Global array for looping through the "keypad directions"
 */
s16b ddd[9] =
{ 2, 8, 6, 4, 3, 1, 9, 7, 5 };

/*
 * Global arrays for converting "keypad direction" into offsets
 */
s16b ddx[10] =
{ 0, -1, 0, 1, -1, 0, 1, -1, 0, 1 };

s16b ddy[10] =
{ 0, 1, 1, 1, 0, 0, 0, -1, -1, -1 };

/*
 * Global arrays for optimizing "ddx[ddd[i]]" and "ddy[ddd[i]]"
 */
s16b ddx_ddd[9] =
{ 0, 0, 1, -1, 1, -1, 1, -1, 0 };

s16b ddy_ddd[9] =
{ 1, -1, 0, 0, 1, 1, -1, -1, 0 };



/*
 * Global array for converting numbers to uppercase hecidecimal digit
 * This array can also be used to convert a number to an octal digit
 */
char hexsym[16] =
{
	'0', '1', '2', '3', '4', '5', '6', '7',
	'8', '9', 'A', 'B', 'C', 'D', 'E', 'F'
};


/*
 * Stat Table (INT/WIS/CON) -- Number of half-spells per level
 */
byte adj_mag_study[] =
{
	0    /* 3 */,
	0    /* 4 */,
	0    /* 5 */,
	0    /* 6 */,
	0    /* 7 */,
	1    /* 8 */,
	1    /* 9 */,
	1    /* 10 */,
	1    /* 11 */,
	2    /* 12 */,
	2    /* 13 */,
	2    /* 14 */,
	2    /* 15 */,
	2    /* 16 */,
	2    /* 17 */,
	2    /* 18/00-18/09 */,
	2    /* 18/10-18/19 */,
	2    /* 18/20-18/29 */,
	2    /* 18/30-18/39 */,
	2    /* 18/40-18/49 */,
	3    /* 18/50-18/59 */,
	3    /* 18/60-18/69 */,
	3    /* 18/70-18/79 */,
	3    /* 18/80-18/89 */,
	4    /* 18/90-18/99 */,
	4    /* 18/100-18/109 */,
	4    /* 18/110-18/119 */,
	5    /* 18/120-18/129 */,
	5    /* 18/130-18/139 */,
	5    /* 18/140-18/149 */,
	5    /* 18/150-18/159 */,
	5    /* 18/160-18/169 */,
	5    /* 18/170-18/179 */,
	5    /* 18/180-18/189 */,
	5    /* 18/190-18/199 */,
	5    /* 18/200-18/209 */,
	5    /* 18/210-18/219 */,
	5    /* 18/220+ */
};


/*
 * Stat Table (INT/WIS/CON) -- extra half-mana-points per level
 */
byte adj_mag_mana[] =
{
	0    /* 3 */,
	0    /* 4 */,
	0    /* 5 */,
	0    /* 6 */,
	0    /* 7 */,
	1    /* 8 */,
	2    /* 9 */,
	2    /* 10 */,
	2    /* 11 */,
	2    /* 12 */,
	2    /* 13 */,
	2    /* 14 */,
	2    /* 15 */,
	2    /* 16 */,
	2    /* 17 */,
	3    /* 18/00-18/09 */,
	3    /* 18/10-18/19 */,
	3    /* 18/20-18/29 */,
	3    /* 18/30-18/39 */,
	3    /* 18/40-18/49 */,
	4    /* 18/50-18/59 */,
	4    /* 18/60-18/69 */,
	5    /* 18/70-18/79 */,
	6    /* 18/80-18/89 */,
	7    /* 18/90-18/99 */,
	8    /* 18/100-18/109 */,
	9    /* 18/110-18/119 */,
	10   /* 18/120-18/129 */,
	11   /* 18/130-18/139 */,
	12   /* 18/140-18/149 */,
	13   /* 18/150-18/159 */,
	14   /* 18/160-18/169 */,
	15   /* 18/170-18/179 */,
	16   /* 18/180-18/189 */,
	16   /* 18/190-18/199 */,
	16   /* 18/200-18/209 */,
	16   /* 18/210-18/219 */,
	16   /* 18/220+ */
};


/*
 * Stat Table (INT/WIS/CON) -- Minimum failure rate (percentage)
 */
byte adj_mag_fail[] =
{
	99   /* 3 */,
	99   /* 4 */,
	99   /* 5 */,
	99   /* 6 */,
	99   /* 7 */,
	50   /* 8 */,
	30   /* 9 */,
	20   /* 10 */,
	15   /* 11 */,
	12   /* 12 */,
	11   /* 13 */,
	10   /* 14 */,
	9    /* 15 */,
	8    /* 16 */,
	7    /* 17 */,
	6    /* 18/00-18/09 */,
	6    /* 18/10-18/19 */,
	5    /* 18/20-18/29 */,
	5    /* 18/30-18/39 */,
	5    /* 18/40-18/49 */,
	4    /* 18/50-18/59 */,
	4    /* 18/60-18/69 */,
	4    /* 18/70-18/79 */,
	4    /* 18/80-18/89 */,
	3    /* 18/90-18/99 */,
	3    /* 18/100-18/109 */,
	2    /* 18/110-18/119 */,
	2    /* 18/120-18/129 */,
	2    /* 18/130-18/139 */,
	2    /* 18/140-18/149 */,
	1    /* 18/150-18/159 */,
	1    /* 18/160-18/169 */,
	1    /* 18/170-18/179 */,
	1    /* 18/180-18/189 */,
	1    /* 18/190-18/199 */,
	0    /* 18/200-18/209 */,
	0    /* 18/210-18/219 */,
	0    /* 18/220+ */
};


/*
 * Stat Table (INT/WIS/CON) -- Various things
 */
byte adj_mag_stat[] =
{
	0    /* 3 */,
	0    /* 4 */,
	0    /* 5 */,
	0    /* 6 */,
	0    /* 7 */,
	1    /* 8 */,
	1    /* 9 */,
	1    /* 10 */,
	1    /* 11 */,
	1    /* 12 */,
	1    /* 13 */,
	1    /* 14 */,
	2    /* 15 */,
	2    /* 16 */,
	2    /* 17 */,
	3    /* 18/00-18/09 */,
	3    /* 18/10-18/19 */,
	3    /* 18/20-18/29 */,
	3    /* 18/30-18/39 */,
	3    /* 18/40-18/49 */,
	4    /* 18/50-18/59 */,
	4    /* 18/60-18/69 */,
	5    /* 18/70-18/79 */,
	6    /* 18/80-18/89 */,
	7    /* 18/90-18/99 */,
	8    /* 18/100-18/109 */,
	9    /* 18/110-18/119 */,
	10   /* 18/120-18/129 */,
	11   /* 18/130-18/139 */,
	12   /* 18/140-18/149 */,
	13   /* 18/150-18/159 */,
	14   /* 18/160-18/169 */,
	15   /* 18/170-18/179 */,
	16   /* 18/180-18/189 */,
	17   /* 18/190-18/199 */,
	18   /* 18/200-18/209 */,
	19   /* 18/210-18/219 */,
	20   /* 18/220+ */
};


/*
 * Stat Table (CHR) -- payment percentages
 */
byte adj_chr_gold[] =
{
	130  /* 3 */,
	125  /* 4 */,
	122  /* 5 */,
	120  /* 6 */,
	118  /* 7 */,
	116  /* 8 */,
	114  /* 9 */,
	112  /* 10 */,
	110  /* 11 */,
	108  /* 12 */,
	106  /* 13 */,
	104  /* 14 */,
	103  /* 15 */,
	102  /* 16 */,
	101  /* 17 */,
	100  /* 18/00-18/09 */,
	99   /* 18/10-18/19 */,
	98   /* 18/20-18/29 */,
	97   /* 18/30-18/39 */,
	96   /* 18/40-18/49 */,
	95   /* 18/50-18/59 */,
	94   /* 18/60-18/69 */,
	93   /* 18/70-18/79 */,
	92   /* 18/80-18/89 */,
	91   /* 18/90-18/99 */,
	90   /* 18/100-18/109 */,
	89   /* 18/110-18/119 */,
	88   /* 18/120-18/129 */,
	87   /* 18/130-18/139 */,
	86   /* 18/140-18/149 */,
	85   /* 18/150-18/159 */,
	84   /* 18/160-18/169 */,
	83   /* 18/170-18/179 */,
	82   /* 18/180-18/189 */,
	81   /* 18/190-18/199 */,
	80   /* 18/200-18/209 */,
	80   /* 18/210-18/219 */,
	80   /* 18/220+ */
};


/*
 * Stat Table (INT) -- Magic devices
 */
byte adj_int_dev[] =
{
	0    /* 3 */,
	0    /* 4 */,
	0    /* 5 */,
	0    /* 6 */,
	0    /* 7 */,
	1    /* 8 */,
	1    /* 9 */,
	1    /* 10 */,
	1    /* 11 */,
	1    /* 12 */,
	1    /* 13 */,
	1    /* 14 */,
	2    /* 15 */,
	2    /* 16 */,
	2    /* 17 */,
	3    /* 18/00-18/09 */,
	3    /* 18/10-18/19 */,
	4    /* 18/20-18/29 */,
	4    /* 18/30-18/39 */,
	5    /* 18/40-18/49 */,
	5    /* 18/50-18/59 */,
	6    /* 18/60-18/69 */,
	6    /* 18/70-18/79 */,
	7    /* 18/80-18/89 */,
	7    /* 18/90-18/99 */,
	8    /* 18/100-18/109 */,
	9    /* 18/110-18/119 */,
	10   /* 18/120-18/129 */,
	11   /* 18/130-18/139 */,
	12   /* 18/140-18/149 */,
	13   /* 18/150-18/159 */,
	14   /* 18/160-18/169 */,
	15   /* 18/170-18/179 */,
	16   /* 18/180-18/189 */,
	17   /* 18/190-18/199 */,
	18   /* 18/200-18/209 */,
	19   /* 18/210-18/219 */,
	20   /* 18/220+ */
};


/*
 * Stat Table (WIS) -- Saving throw
 */
byte adj_wis_sav[] =
{
	0    /* 3 */,
	0    /* 4 */,
	0    /* 5 */,
	0    /* 6 */,
	0    /* 7 */,
	1    /* 8 */,
	1    /* 9 */,
	1    /* 10 */,
	1    /* 11 */,
	1    /* 12 */,
	1    /* 13 */,
	1    /* 14 */,
	2    /* 15 */,
	2    /* 16 */,
	2    /* 17 */,
	3    /* 18/00-18/09 */,
	3    /* 18/10-18/19 */,
	3    /* 18/20-18/29 */,
	3    /* 18/30-18/39 */,
	3    /* 18/40-18/49 */,
	4    /* 18/50-18/59 */,
	4    /* 18/60-18/69 */,
	5    /* 18/70-18/79 */,
	5    /* 18/80-18/89 */,
	6    /* 18/90-18/99 */,
	7    /* 18/100-18/109 */,
	8    /* 18/110-18/119 */,
	9    /* 18/120-18/129 */,
	10   /* 18/130-18/139 */,
	11   /* 18/140-18/149 */,
	12   /* 18/150-18/159 */,
	13   /* 18/160-18/169 */,
	14   /* 18/170-18/179 */,
	15   /* 18/180-18/189 */,
	16   /* 18/190-18/199 */,
	17   /* 18/200-18/209 */,
	18   /* 18/210-18/219 */,
	19   /* 18/220+ */
};


/*
 * Stat Table (DEX) -- disarming
 */
byte adj_dex_dis[] =
{
	0    /* 3 */,
	0    /* 4 */,
	0    /* 5 */,
	0    /* 6 */,
	0    /* 7 */,
	0    /* 8 */,
	0    /* 9 */,
	0    /* 10 */,
	0    /* 11 */,
	0    /* 12 */,
	1    /* 13 */,
	1    /* 14 */,
	1    /* 15 */,
	2    /* 16 */,
	2    /* 17 */,
	4    /* 18/00-18/09 */,
	4    /* 18/10-18/19 */,
	4    /* 18/20-18/29 */,
	4    /* 18/30-18/39 */,
	5    /* 18/40-18/49 */,
	5    /* 18/50-18/59 */,
	5    /* 18/60-18/69 */,
	6    /* 18/70-18/79 */,
	6    /* 18/80-18/89 */,
	7    /* 18/90-18/99 */,
	8    /* 18/100-18/109 */,
	8    /* 18/110-18/119 */,
	8    /* 18/120-18/129 */,
	8    /* 18/130-18/139 */,
	8    /* 18/140-18/149 */,
	9    /* 18/150-18/159 */,
	9    /* 18/160-18/169 */,
	9    /* 18/170-18/179 */,
	9    /* 18/180-18/189 */,
	9    /* 18/190-18/199 */,
	10   /* 18/200-18/209 */,
	10   /* 18/210-18/219 */,
	10   /* 18/220+ */
};


/*
 * Stat Table (INT) -- disarming
 */
byte adj_int_dis[] =
{
	0    /* 3 */,
	0    /* 4 */,
	0    /* 5 */,
	0    /* 6 */,
	0    /* 7 */,
	1    /* 8 */,
	1    /* 9 */,
	1    /* 10 */,
	1    /* 11 */,
	1    /* 12 */,
	1    /* 13 */,
	1    /* 14 */,
	2    /* 15 */,
	2    /* 16 */,
	2    /* 17 */,
	3    /* 18/00-18/09 */,
	3    /* 18/10-18/19 */,
	3    /* 18/20-18/29 */,
	4    /* 18/30-18/39 */,
	4    /* 18/40-18/49 */,
	5    /* 18/50-18/59 */,
	6    /* 18/60-18/69 */,
	7    /* 18/70-18/79 */,
	8    /* 18/80-18/89 */,
	9    /* 18/90-18/99 */,
	10   /* 18/100-18/109 */,
	10   /* 18/110-18/119 */,
	11   /* 18/120-18/129 */,
	12   /* 18/130-18/139 */,
	13   /* 18/140-18/149 */,
	14   /* 18/150-18/159 */,
	15   /* 18/160-18/169 */,
	16   /* 18/170-18/179 */,
	17   /* 18/180-18/189 */,
	18   /* 18/190-18/199 */,
	19   /* 18/200-18/209 */,
	19   /* 18/210-18/219 */,
	19   /* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to ac (plus 128)
 */
byte adj_dex_ta[] =
{
	128 + -4  /* 3 */,
	128 + -3  /* 4 */,
	128 + -2  /* 5 */,
	128 + -1  /* 6 */,
	128 + 0   /* 7 */,
	128 + 0   /* 8 */,
	128 + 0   /* 9 */,
	128 + 0   /* 10 */,
	128 + 0   /* 11 */,
	128 + 0   /* 12 */,
	128 + 0   /* 13 */,
	128 + 0   /* 14 */,
	128 + 1   /* 15 */,
	128 + 1   /* 16 */,
	128 + 1   /* 17 */,
	128 + 2   /* 18/00-18/09 */,
	128 + 2   /* 18/10-18/19 */,
	128 + 2   /* 18/20-18/29 */,
	128 + 2   /* 18/30-18/39 */,
	128 + 2   /* 18/40-18/49 */,
	128 + 3   /* 18/50-18/59 */,
	128 + 3   /* 18/60-18/69 */,
	128 + 3   /* 18/70-18/79 */,
	128 + 4   /* 18/80-18/89 */,
	128 + 5   /* 18/90-18/99 */,
	128 + 6   /* 18/100-18/109 */,
	128 + 7   /* 18/110-18/119 */,
	128 + 8   /* 18/120-18/129 */,
	128 + 9   /* 18/130-18/139 */,
	128 + 9   /* 18/140-18/149 */,
	128 + 10  /* 18/150-18/159 */,
	128 + 11  /* 18/160-18/169 */,
	128 + 12  /* 18/170-18/179 */,
	128 + 13  /* 18/180-18/189 */,
	128 + 14  /* 18/190-18/199 */,
	128 + 15  /* 18/200-18/209 */,
	128 + 15  /* 18/210-18/219 */,
	128 + 15  /* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to dam (plus 128)
 */
byte adj_str_td[] =
{
	128 + -2  /* 3 */,
	128 + -2  /* 4 */,
	128 + -1  /* 5 */,
	128 + -1  /* 6 */,
	128 + 0   /* 7 */,
	128 + 0   /* 8 */,
	128 + 0   /* 9 */,
	128 + 0   /* 10 */,
	128 + 0   /* 11 */,
	128 + 0   /* 12 */,
	128 + 0   /* 13 */,
	128 + 0   /* 14 */,
	128 + 0   /* 15 */,
	128 + 1   /* 16 */,
	128 + 2   /* 17 */,
	128 + 2   /* 18/00-18/09 */,
	128 + 2   /* 18/10-18/19 */,
	128 + 3   /* 18/20-18/29 */,
	128 + 3   /* 18/30-18/39 */,
	128 + 3   /* 18/40-18/49 */,
	128 + 3   /* 18/50-18/59 */,
	128 + 3   /* 18/60-18/69 */,
	128 + 4   /* 18/70-18/79 */,
	128 + 5   /* 18/80-18/89 */,
	128 + 5   /* 18/90-18/99 */,
	128 + 6   /* 18/100-18/109 */,
	128 + 7   /* 18/110-18/119 */,
	128 + 8   /* 18/120-18/129 */,
	128 + 9   /* 18/130-18/139 */,
	128 + 10  /* 18/140-18/149 */,
	128 + 11  /* 18/150-18/159 */,
	128 + 12  /* 18/160-18/169 */,
	128 + 13  /* 18/170-18/179 */,
	128 + 14  /* 18/180-18/189 */,
	128 + 15  /* 18/190-18/199 */,
	128 + 16  /* 18/200-18/209 */,
	128 + 18  /* 18/210-18/219 */,
	128 + 20  /* 18/220+ */
};


/*
 * Stat Table (DEX) -- bonus to hit (plus 128)
 */
byte adj_dex_th[] =
{
	128 + -3  /* 3 */,
	128 + -2  /* 4 */,
	128 + -2  /* 5 */,
	128 + -1  /* 6 */,
	128 + -1  /* 7 */,
	128 + 0   /* 8 */,
	128 + 0   /* 9 */,
	128 + 0   /* 10 */,
	128 + 0   /* 11 */,
	128 + 0   /* 12 */,
	128 + 0   /* 13 */,
	128 + 0   /* 14 */,
	128 + 0   /* 15 */,
	128 + 1   /* 16 */,
	128 + 2   /* 17 */,
	128 + 3   /* 18/00-18/09 */,
	128 + 3   /* 18/10-18/19 */,
	128 + 3   /* 18/20-18/29 */,
	128 + 3   /* 18/30-18/39 */,
	128 + 3   /* 18/40-18/49 */,
	128 + 4   /* 18/50-18/59 */,
	128 + 4   /* 18/60-18/69 */,
	128 + 4   /* 18/70-18/79 */,
	128 + 4   /* 18/80-18/89 */,
	128 + 5   /* 18/90-18/99 */,
	128 + 6   /* 18/100-18/109 */,
	128 + 7   /* 18/110-18/119 */,
	128 + 8   /* 18/120-18/129 */,
	128 + 9   /* 18/130-18/139 */,
	128 + 9   /* 18/140-18/149 */,
	128 + 10  /* 18/150-18/159 */,
	128 + 11  /* 18/160-18/169 */,
	128 + 12  /* 18/170-18/179 */,
	128 + 13  /* 18/180-18/189 */,
	128 + 14  /* 18/190-18/199 */,
	128 + 15  /* 18/200-18/209 */,
	128 + 15  /* 18/210-18/219 */,
	128 + 15  /* 18/220+ */
};


/*
 * Stat Table (STR) -- bonus to hit (plus 128)
 */
byte adj_str_th[] =
{
	128 + -3  /* 3 */,
	128 + -2  /* 4 */,
	128 + -1  /* 5 */,
	128 + -1  /* 6 */,
	128 + 0   /* 7 */,
	128 + 0   /* 8 */,
	128 + 0   /* 9 */,
	128 + 0   /* 10 */,
	128 + 0   /* 11 */,
	128 + 0   /* 12 */,
	128 + 0   /* 13 */,
	128 + 0   /* 14 */,
	128 + 0   /* 15 */,
	128 + 0   /* 16 */,
	128 + 0   /* 17 */,
	128 + 1   /* 18/00-18/09 */,
	128 + 1   /* 18/10-18/19 */,
	128 + 1   /* 18/20-18/29 */,
	128 + 1   /* 18/30-18/39 */,
	128 + 1   /* 18/40-18/49 */,
	128 + 1   /* 18/50-18/59 */,
	128 + 1   /* 18/60-18/69 */,
	128 + 2   /* 18/70-18/79 */,
	128 + 3   /* 18/80-18/89 */,
	128 + 4   /* 18/90-18/99 */,
	128 + 5   /* 18/100-18/109 */,
	128 + 6   /* 18/110-18/119 */,
	128 + 7   /* 18/120-18/129 */,
	128 + 8   /* 18/130-18/139 */,
	128 + 9   /* 18/140-18/149 */,
	128 + 10  /* 18/150-18/159 */,
	128 + 11  /* 18/160-18/169 */,
	128 + 12  /* 18/170-18/179 */,
	128 + 13  /* 18/180-18/189 */,
	128 + 14  /* 18/190-18/199 */,
	128 + 15  /* 18/200-18/209 */,
	128 + 15  /* 18/210-18/219 */,
	128 + 15  /* 18/220+ */
};


/*
 * Stat Table (STR) -- weight limit in deca-pounds
 */
byte adj_str_wgt[] =
{
	5    /* 3 */,
	6    /* 4 */,
	7    /* 5 */,
	8    /* 6 */,
	9    /* 7 */,
	10   /* 8 */,
	11   /* 9 */,
	12   /* 10 */,
	13   /* 11 */,
	14   /* 12 */,
	15   /* 13 */,
	16   /* 14 */,
	17   /* 15 */,
	18   /* 16 */,
	19   /* 17 */,
	20   /* 18/00-18/09 */,
	22   /* 18/10-18/19 */,
	24   /* 18/20-18/29 */,
	26   /* 18/30-18/39 */,
	28   /* 18/40-18/49 */,
	30   /* 18/50-18/59 */,
	30   /* 18/60-18/69 */,
	30   /* 18/70-18/79 */,
	30   /* 18/80-18/89 */,
	30   /* 18/90-18/99 */,
	30   /* 18/100-18/109 */,
	30   /* 18/110-18/119 */,
	30   /* 18/120-18/129 */,
	30   /* 18/130-18/139 */,
	30   /* 18/140-18/149 */,
	30   /* 18/150-18/159 */,
	30   /* 18/160-18/169 */,
	30   /* 18/170-18/179 */,
	30   /* 18/180-18/189 */,
	30   /* 18/190-18/199 */,
	30   /* 18/200-18/209 */,
	30   /* 18/210-18/219 */,
	30   /* 18/220+ */
};


/*
 * Stat Table (STR) -- weapon weight limit in pounds
 */
byte adj_str_hold[] =
{
	4    /* 3 */,
	5    /* 4 */,
	6    /* 5 */,
	7    /* 6 */,
	8    /* 7 */,
	10   /* 8 */,
	12   /* 9 */,
	14   /* 10 */,
	16   /* 11 */,
	18   /* 12 */,
	20   /* 13 */,
	22   /* 14 */,
	24   /* 15 */,
	26   /* 16 */,
	28   /* 17 */,
	30   /* 18/00-18/09 */,
	30   /* 18/10-18/19 */,
	35   /* 18/20-18/29 */,
	40   /* 18/30-18/39 */,
	45   /* 18/40-18/49 */,
	50   /* 18/50-18/59 */,
	55   /* 18/60-18/69 */,
	60   /* 18/70-18/79 */,
	65   /* 18/80-18/89 */,
	70   /* 18/90-18/99 */,
	80   /* 18/100-18/109 */,
	80   /* 18/110-18/119 */,
	80   /* 18/120-18/129 */,
	80   /* 18/130-18/139 */,
	80   /* 18/140-18/149 */,
	90   /* 18/150-18/159 */,
	90   /* 18/160-18/169 */,
	90   /* 18/170-18/179 */,
	90   /* 18/180-18/189 */,
	90   /* 18/190-18/199 */,
	100  /* 18/200-18/209 */,
	100  /* 18/210-18/219 */,
	100  /* 18/220+ */
};


/*
 * Stat Table (STR) -- digging value
 */
byte adj_str_dig[] =
{
	0    /* 3 */,
	0    /* 4 */,
	1    /* 5 */,
	2    /* 6 */,
	3    /* 7 */,
	4    /* 8 */,
	4    /* 9 */,
	5    /* 10 */,
	5    /* 11 */,
	6    /* 12 */,
	6    /* 13 */,
	7    /* 14 */,
	7    /* 15 */,
	8    /* 16 */,
	8    /* 17 */,
	9    /* 18/00-18/09 */,
	10   /* 18/10-18/19 */,
	12   /* 18/20-18/29 */,
	15   /* 18/30-18/39 */,
	20   /* 18/40-18/49 */,
	25   /* 18/50-18/59 */,
	30   /* 18/60-18/69 */,
	35   /* 18/70-18/79 */,
	40   /* 18/80-18/89 */,
	45   /* 18/90-18/99 */,
	50   /* 18/100-18/109 */,
	55   /* 18/110-18/119 */,
	60   /* 18/120-18/129 */,
	65   /* 18/130-18/139 */,
	70   /* 18/140-18/149 */,
	75   /* 18/150-18/159 */,
	80   /* 18/160-18/169 */,
	85   /* 18/170-18/179 */,
	90   /* 18/180-18/189 */,
	95   /* 18/190-18/199 */,
	100  /* 18/200-18/209 */,
	100  /* 18/210-18/219 */,
	100  /* 18/220+ */
};

/*
 * Stat Table (STR) -- wrestling (# sides on die)
 */
byte adj_str_wr[] =
{
	1	/* 3 */,
	1	/* 4 */,
	1	/* 5 */,
	1	/* 6 */,
	1	/* 7 */,
	1	/* 8 */,
	1	/* 9 */,
	1	/* 10 */,
	1	/* 11 */,
	1	/* 12 */,
	1	/* 13 */,
	2	/* 14 */,
	2	/* 15 */,
	3	/* 16 */,
	4	/* 17 */,
	5	/* 18/00 - 18/09 */,
	6	/* 18/10-18/19 */,
	7	/* 18/20-18/29 */,
	8	/* 18/30-18/39 */,
	9	/* 18/40-18/49 */,
	10	/* 18/50-18/59 */,
	11	/* 18/60-18/69 */,
	12	/* 18/70-18/79 */,
	13	/* 18/80-18/89 */,
	14	/* 18/90-18/99 */,
	15	/* 18/100-18/109 */,
	16	/* 18/110-18/119 */,
	17	/* 18/120-18/129 */,
	18	/* 18/130-18/139 */,
	19	/* 18/140-18/149 */,
	21	/* 18/150-18/159 */,
	22	/* 18/160-18/169 */,
	23	/* 18/170-18/179 */,
	24	/* 18/180-18/189 */,
	25	/* 18/190-18/199 */,
	27	/* 18/200-18/209 */,
	28	/* 18/210-18/219 */,
	30	/* 18/220+ */
};
	
/*
 * Stat Table (STR) -- help index into the "blow" table
 */
byte adj_str_blow[] =
{
	3    /* 3 */,
	4    /* 4 */,
	5    /* 5 */,
	6    /* 6 */,
	7    /* 7 */,
	8    /* 8 */,
	9    /* 9 */,
	10   /* 10 */,
	11   /* 11 */,
	12   /* 12 */,
	13   /* 13 */,
	14   /* 14 */,
	15   /* 15 */,
	16   /* 16 */,
	17   /* 17 */,
	20 /* 18/00-18/09 */,
	30 /* 18/10-18/19 */,
	40 /* 18/20-18/29 */,
	50 /* 18/30-18/39 */,
	60 /* 18/40-18/49 */,
	70 /* 18/50-18/59 */,
	80 /* 18/60-18/69 */,
	90 /* 18/70-18/79 */,
	100 /* 18/80-18/89 */,
	110 /* 18/90-18/99 */,
	120 /* 18/100-18/109 */,
	130 /* 18/110-18/119 */,
	140 /* 18/120-18/129 */,
	150 /* 18/130-18/139 */,
	160 /* 18/140-18/149 */,
	170 /* 18/150-18/159 */,
	180 /* 18/160-18/169 */,
	190 /* 18/170-18/179 */,
	200 /* 18/180-18/189 */,
	210 /* 18/190-18/199 */,
	220 /* 18/200-18/209 */,
	230 /* 18/210-18/219 */,
	240 /* 18/220+ */
};


/*
 * Stat Table (DEX) -- index into the "blow" table
 */
byte adj_dex_blow[] =
{
	0    /* 3 */,
	0    /* 4 */,
	0    /* 5 */,
	0    /* 6 */,
	0    /* 7 */,
	0    /* 8 */,
	0    /* 9 */,
	1    /* 10 */,
	1    /* 11 */,
	1    /* 12 */,
	1    /* 13 */,
	1    /* 14 */,
	1    /* 15 */,
	1    /* 16 */,
	1    /* 17 */,
	1    /* 18/00-18/09 */,
	2    /* 18/10-18/19 */,
	2    /* 18/20-18/29 */,
	2    /* 18/30-18/39 */,
	2    /* 18/40-18/49 */,
	3    /* 18/50-18/59 */,
	3    /* 18/60-18/69 */,
	4    /* 18/70-18/79 */,
	4    /* 18/80-18/89 */,
	5    /* 18/90-18/99 */,
	6    /* 18/100-18/109 */,
	7    /* 18/110-18/119 */,
	8    /* 18/120-18/129 */,
	9    /* 18/130-18/139 */,
	10   /* 18/140-18/149 */,
	11   /* 18/150-18/159 */,
	12   /* 18/160-18/169 */,
	14   /* 18/170-18/179 */,
	16   /* 18/180-18/189 */,
	18   /* 18/190-18/199 */,
	20   /* 18/200-18/209 */,
	20   /* 18/210-18/219 */,
	20   /* 18/220+ */
};

/* Stat Table (DEX) -- number of blows/rounds when using karate */
byte adj_dex_kb[] =
{
	1    /* 3 */,
	1    /* 4 */,
	1    /* 5 */,
	1    /* 6 */,
	1    /* 7 */,
	1    /* 8 */,
	1    /* 9 */,
	1    /* 10 */,
	1    /* 11 */,
	1    /* 12 */,
	1    /* 13 */,
	1    /* 14 */,
	1    /* 15 */,
	1    /* 16 */,
	1    /* 17 */,
	1    /* 18/00-18/09 */,
	1    /* 18/10-18/19 */,
	1    /* 18/20-18/29 */,
	1    /* 18/30-18/39 */,
	1    /* 18/40-18/49 */,
	2    /* 18/50-18/59 */,
	2    /* 18/60-18/69 */,
	2    /* 18/70-18/79 */,
	2    /* 18/80-18/89 */,
	2    /* 18/90-18/99 */,
	3    /* 18/100-18/109 */,
	3    /* 18/110-18/119 */,
	3    /* 18/120-18/129 */,
	3    /* 18/130-18/139 */,
	3   /* 18/140-18/149 */,
	4   /* 18/150-18/159 */,
	4   /* 18/160-18/169 */,
	4   /* 18/170-18/179 */,
	4   /* 18/180-18/189 */,
	4   /* 18/190-18/199 */,
	5  /* 18/200-18/209 */,
	5   /* 18/210-18/219 */,
	5   /* 18/220+ */
};

/*
 * Stat Table (DEX) -- chance of avoiding "theft" and "falling"
 */
byte adj_dex_safe[] =
{
	0    /* 3 */,
	1    /* 4 */,
	2    /* 5 */,
	3    /* 6 */,
	4    /* 7 */,
	5    /* 8 */,
	5    /* 9 */,
	6    /* 10 */,
	6    /* 11 */,
	7    /* 12 */,
	7    /* 13 */,
	8    /* 14 */,
	8    /* 15 */,
	9    /* 16 */,
	9    /* 17 */,
	10   /* 18/00-18/09 */,
	10   /* 18/10-18/19 */,
	15   /* 18/20-18/29 */,
	15   /* 18/30-18/39 */,
	20   /* 18/40-18/49 */,
	25   /* 18/50-18/59 */,
	30   /* 18/60-18/69 */,
	35   /* 18/70-18/79 */,
	40   /* 18/80-18/89 */,
	45   /* 18/90-18/99 */,
	50   /* 18/100-18/109 */,
	60   /* 18/110-18/119 */,
	70   /* 18/120-18/129 */,
	80   /* 18/130-18/139 */,
	90   /* 18/140-18/149 */,
	100  /* 18/150-18/159 */,
	100  /* 18/160-18/169 */,
	100  /* 18/170-18/179 */,
	100  /* 18/180-18/189 */,
	100  /* 18/190-18/199 */,
	100  /* 18/200-18/209 */,
	100  /* 18/210-18/219 */,
	100  /* 18/220+ */
};


/*
 * Stat Table (CON) -- base regeneration rate
 */
byte adj_con_fix[] =
{
	0    /* 3 */,
	0    /* 4 */,
	0    /* 5 */,
	0    /* 6 */,
	0    /* 7 */,
	0    /* 8 */,
	0    /* 9 */,
	0    /* 10 */,
	0    /* 11 */,
	0    /* 12 */,
	0    /* 13 */,
	1    /* 14 */,
	1    /* 15 */,
	1    /* 16 */,
	1    /* 17 */,
	2    /* 18/00-18/09 */,
	2    /* 18/10-18/19 */,
	2    /* 18/20-18/29 */,
	2    /* 18/30-18/39 */,
	2    /* 18/40-18/49 */,
	3    /* 18/50-18/59 */,
	3    /* 18/60-18/69 */,
	3    /* 18/70-18/79 */,
	3    /* 18/80-18/89 */,
	3    /* 18/90-18/99 */,
	4    /* 18/100-18/109 */,
	4    /* 18/110-18/119 */,
	5    /* 18/120-18/129 */,
	6    /* 18/130-18/139 */,
	6    /* 18/140-18/149 */,
	7    /* 18/150-18/159 */,
	7    /* 18/160-18/169 */,
	8    /* 18/170-18/179 */,
	8    /* 18/180-18/189 */,
	8    /* 18/190-18/199 */,
	9    /* 18/200-18/209 */,
	9    /* 18/210-18/219 */,
	9    /* 18/220+ */
};
/*
 * Stat Table (CON) -- extra half-hitpoints per level (plus 128)
 */
byte adj_con_mhp[] =
{
	128 + -5  /* 3 */,
	128 + -3  /* 4 */,
	128 + -2  /* 5 */,
	128 + -1  /* 6 */,
	128 + 0   /* 7 */,
	128 + 0   /* 8 */,
	128 + 0   /* 9 */,
	128 + 0   /* 10 */,
	128 + 0   /* 11 */,
	128 + 0   /* 12 */,
	128 + 0   /* 13 */,
	128 + 0   /* 14 */,
	128 + 1   /* 15 */,
	128 + 1   /* 16 */,
	128 + 2   /* 17 */,
	128 + 3   /* 18/00-18/09 */,
	128 + 4   /* 18/10-18/19 */,
	128 + 4   /* 18/20-18/29 */,
	128 + 4   /* 18/30-18/39 */,
	128 + 4   /* 18/40-18/49 */,
	128 + 5   /* 18/50-18/59 */,
	128 + 6   /* 18/60-18/69 */,
	128 + 7   /* 18/70-18/79 */,
	128 + 8   /* 18/80-18/89 */,
	128 + 9   /* 18/90-18/99 */,
	128 + 10  /* 18/100-18/109 */,
	128 + 11  /* 18/110-18/119 */,
	128 + 12  /* 18/120-18/129 */,
	128 + 13  /* 18/130-18/139 */,
	128 + 14  /* 18/140-18/149 */,
	128 + 15  /* 18/150-18/159 */,
	128 + 16  /* 18/160-18/169 */,
	128 + 18  /* 18/170-18/179 */,
	128 + 20  /* 18/180-18/189 */,
	128 + 22  /* 18/190-18/199 */,
	128 + 25  /* 18/200-18/209 */,
	128 + 25  /* 18/210-18/219 */,
	128 + 25  /* 18/220+ */
};


/*
 * This table is used to help calculate the number of blows the player can
 * make in a single round of attacks (one player turn) with a normal weapon.
 *
 * This number ranges from a single blow/round for weak players to up to six
 * blows/round for powerful warriors.
 *
 * Note that certain artifacts and ego-items give "bonus" blows/round.
 *
 * First, from the player class, we extract some values:
 *
 *    Warrior --> num = 6; mul = 5; div = MAX(30, weapon_weight);
 *    Mage    --> num = 4; mul = 2; div = MAX(40, weapon_weight);
 *    Priest  --> num = 5; mul = 3; div = MAX(35, weapon_weight);
 *    Rogue   --> num = 5; mul = 3; div = MAX(30, weapon_weight);
 *    Ranger  --> num = 5; mul = 4; div = MAX(35, weapon_weight);
 *    Paladin --> num = 5; mul = 4; div = MAX(30, weapon_weight);
 *
 * To get "P", we look up the relevant "adj_str_blow[]" (see above),
 * multiply it by "mul", and then divide it by "div", rounding down.
 *
 * To get "D", we look up the relevant "adj_dex_blow[]" (see above),
 * note especially column 6 (DEX 18/101) and 11 (DEX 18/150).
 *
 * The player gets "blows_table[P][D]" blows/round, as shown below,
 * up to a maximum of "num" blows/round, plus any "bonus" blows/round.
 */
byte blows_table[12][12] =
{
	/* P/D */
	/* 0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11+ */

	/* 0  */
	{  1,   1,   1,   1,   1,   1,   2,   2,   2,   2,   2,   3 },

	/* 1  */
	{  1,   1,   1,   1,   2,   2,   3,   3,   3,   4,   4,   4 },

	/* 2  */
	{  1,   1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5 },

	/* 3  */
	{  1,   2,   2,   3,   3,   4,   4,   4,   5,   5,   5,   5 },

	/* 4  */
	{  1,   2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5 },

	/* 5  */
	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 6  */
	{  2,   2,   3,   3,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 7  */
	{  2,   3,   3,   4,   4,   4,   5,   5,   5,   5,   5,   6 },

	/* 8  */
	{  3,   3,   3,   4,   4,   4,   5,   5,   5,   5,   6,   6 },

	/* 9  */
	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   5,   6,   6 },
	/* 10 */
	{  3,   3,   4,   4,   4,   4,   5,   5,   5,   6,   6,   6 },

	/* 11+ */
	{  3,   3,   4,   4,   4,   4,   5,   5,   6,   6,   6,   6 },
};


/*
 * Store owners (exactly four "possible" owners per store, chosen randomly)
 * { name, purse, max greed, min greed, haggle_per, tolerance, race, unused }
 */
owner_type owners[MAX_STORES][MAX_OWNERS] =
{
	{
		/* General store */
		{ "Bilbo the Friendly",	  200, 170, 108,  5, 15, RACE_HOBBIT},
		{ "Rincewind the Chicken",    200, 175, 108,  4, 12, RACE_HUMAN},
		{ "Sultan the Midget",	   300, 170, 107,  5, 15, RACE_GNOME},
		{ "Lyar-el the Comely",	  300, 165, 107,  6, 18, RACE_ELF},
	},
	{
		/* Armoury */
		{ "Kon-Dar the Ugly",	    5000,	210, 115,  5,  7,
RACE_HALF_ORC},
		{ "Darg-Low the Grim",	   10000,    190, 111,  4,  9,
RACE_HUMAN},
		{ "Decado the Handsome", 25000,  200, 112,  4, 10, RACE_DUNADAN},
		{ "Mauglin the Grumpy",	  30000,    200, 112,  4,  5,
RACE_DWARF},
	},
	{
		/* Weapon Smith */
		{ "Ithyl-Mak the Beastly",    5000,	210, 115,  6,  6,
RACE_HALF_TROLL},
		{ "Arndal Beast-Slayer", 10000,    185, 110,  5,  9,
RACE_HALF_ELF},
		{ "Tarl Beast-Master",	   25000,    190, 115,  5,  7,
RACE_HOBBIT},
		{ "Oglign Dragon-Slayer",	30000,    195, 112,  4,  8,
RACE_DWARF},
	},
	{
		/* Temple */
		{ "Ludwig the Humble",	   5000,	175, 109,  6, 15,
RACE_HUMAN},
		{ "Gunnar the Paladin",	  10000,    185, 110,  5, 23,
RACE_HUMAN},
		{ "Delilah the Pure",	    25000,    180, 107,  6, 20,
RACE_ELF},
		{ "Bosk the Wise",		  30000,    185, 109,  5, 15,
RACE_DWARF},
	},
	{
		{ "Mauser the Chemist",	  10000,    190, 111,  5,  8,
RACE_HALF_ELF},
		{ "Wizzle the Chaotic",	  10000,    190, 110,  6,  8,
RACE_HOBBIT},
		{ "Ga-nat the Greedy",	   15000,    200, 116,  6,  9,
RACE_GNOME},
		{ "Sasha the Slender",	   15000,    220, 111,  4,  9,
RACE_ELF},
	},
	{
		/* Magic Shop */
		{ "Ariel the Sorceress", 20000,    200, 110,  7,  8,
RACE_HALF_ELF},
		{ "Buggerby the Great",	  20000,    215, 113,  6, 10,
RACE_GNOME},
		{ "Inglorian the Mage",	  30000,    200, 110,  7, 10,
RACE_HUMAN},
		{ "Luthien Starshine",	   30000,    175, 110,  5, 11,
RACE_HIGH_ELF},
	},
	{
		/* Black Market */
		{ "Lo-Hak the Awful",	    20000,    250, 150, 10,  5,
RACE_HALF_TROLL},
		{ "Histor the Goblin",	   20000,    250, 150, 10,  5,
RACE_HALF_ORC},
		{ "Durwin the Shifty",	   30000,    250, 150, 10,  5,
RACE_HUMAN},
		{ "Drago the Fair",		 30000,    250, 150, 10,  5,
RACE_ELF},
	},
	{
		/* Home */
		{ "Your home",			 0,	 100, 100,  0, 99, 99},
		{ "Your home",			 0,	 100, 100,  0, 99, 99},
		{ "Your home",			 0,	 100, 100,  0, 99, 99},
		{ "Your home",			 0,	 100, 100,  0, 99, 99}
	},
	{
		/* Bookstore */
		{ "Dolaf the Greedy", 10000, 175, 108, 4, 12, RACE_HUMAN},
		{ "Odnar the Sage", 15000, 120, 105, 6, 16, RACE_HIGH_ELF},
		{ "Gandar the Neutral", 25000, 120, 110, 7, 19, RACE_DARK_ELF},
		{ "Ro-sha the Patient", 30000, 140, 105, 6, 12, RACE_ELF},
	}
};



/*
 * This table allows quick conversion from "speed" to "energy"
 * The basic function WAS ((S>=110) ? (S-110) : (100 / (120-S)))
 * Note that table access is *much* quicker than computation.
 *
 * Note that the table has been changed at high speeds.  From
 * "Slow (-40)" to "Fast (+30)" is pretty much unchanged, but
 * at speeds above "Fast (+30)", one approaches an asymptotic
 * effective limit of 50 energy per turn.  This means that it
 * is relatively easy to reach "Fast (+30)" and get about 40
 * energy per turn, but then speed becomes very "expensive",
 * and you must get all the way to "Fast (+50)" to reach the
 * point of getting 45 energy per turn.  After that point,
 * furthur increases in speed are more or less pointless,
 * except to balance out heavy inventory.
 *
 * Note that currently the fastest monster is "Fast (+30)".
 *
 * It should be possible to lower the energy threshhold from
 * 100 units to 50 units, though this may interact badly with
 * the (compiled out) small random energy boost code.  It may
 * also tend to cause more "clumping" at high speeds.
 */
byte extract_energy[200] =
{
	/* Slow */	1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */	1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */	1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */	1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */	1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* Slow */	1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-50 */	1,  1,  1,  1,  1,  1,  1,  1,  1,  1,
	/* S-40 */	2,  2,  2,  2,  2,  2,  2,  2,  2,  2,
	/* S-30 */	2,  2,  2,  2,  2,  2,  2,  3,  3,  3,
	/* S-20 */	3,  3,  3,  3,  3,  4,  4,  4,  4,  4,
	/* S-10 */	5,  5,  5,  5,  6,  6,  7,  7,  8,  9,
	/* Norm */    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
	/* F+10 */    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
	/* F+20 */    30, 31, 32, 33, 34, 35, 36, 36, 37, 37,
	/* F+30 */    38, 38, 39, 39, 40, 40, 40, 41, 41, 41,
	/* F+40 */    42, 42, 42, 43, 43, 43, 44, 44, 44, 44,
	/* F+50 */    45, 45, 45, 45, 45, 46, 46, 46, 46, 46,
	/* F+60 */    47, 47, 47, 47, 47, 48, 48, 48, 48, 48,
	/* F+70 */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
	/* Fast */    49, 49, 49, 49, 49, 49, 49, 49, 49, 49,
};



/*
 * Player Sexes
 *
 *	Title,
 *	Winner
 */
player_sex sex_info[MAX_SEXES] =
{
	{
		"Female",
		"Queen"
	},
	
	{
		"Male",
		"King"
	}
};


/*
 * Player Races
 *
 *    Title,
 *    {STR,INT,WIS,DEX,CON,CHR, LUC},
 *    r_srh, r_thn, r_thb,
 *    hitdie, life exp,
 *    Age (Base, Mod),
 *    Male (Hgt, Wgt),
 *    Female (Hgt, Wgt)
 *    infra,
 *    class-choices
 */
player_race race_info[MAX_RACES] =
{
	{
		"Human",
		{  0,  0,  0,  0,  0,  0,  5 },
		0,  0,
		10,  38,
		14,  6,
		72,  6, 180, 25,
		66,  4, 150, 20,
		0,
		/* Advancement Speed, 1-9 */
		{7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7},
		/* Starting values (these are all max starting values) */
		{9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
		 9,9,9,9,9,9,9,9,9,
		 9,9,0,0,0,0}
	},

	{
		"Half-Elf",
		{ -1,  1,  0,  1, -1,  1,  1 },
		-1,  5,
		9,  12,
		24, 16,
		66,  6, 130, 15,
		62,  6, 100, 10,
		2,
		{6,5,5,5,7,7,8,7,8,7,8,8,5,7,6,8,8,7,8,8,8,6,4,7,6,8,1,1,1,1},
		{28,20,19,20,28,28,27,29,29,19,28,28,10,20,29,
		 28,27,19,10,10,10,19,10,28,
		 29,28,0,0,0,0}
	},

	{
		"Elf",
		{ -1,  2,  1,  1, -2,  1, 2 },
		-5, 15,
		8,  11,
		75, 75,
		60,  4, 100,  6,
		54,  4, 80,  6,
		3,
		{4,3,5,3,8,8,8,8,8,7,9,8,4,7,4,7,9,7,7,8,8,7,2,7,4,9,1,1,1,1},
		{47,10,28,10,28,27,37,28,19,20,37,37,10,27,27,
		 27,46,28,10,10,10,29,10,37,
		 19,37,0,0,0,0}
	},

	{
		"Hobbit",
		{ -2,  2,  1,  3,  2,  1,  2 },
		-10, 20,
		7,  10,
		21, 12,
		36,  3, 60,  3,
		33,  3, 50,  3,
		4,
		{3,3,8,8,10,4,6,10,10,6,10,7,6,10,10,6,6,10,7,7,7,8,4,10,8,5,1,
		 1,1,1},
		{11,11,29,19,46,20,20,29,29,19,55,20,10,46,46,
		 20,20,37,10,19,20,19,10,46,
		 27,19,0,0,0,0}
	},

	{
		"Gnome",
		{ -1,  2,  0,  2,  1, -2,  4 },
		-8, 12,
		8,  11,
		50, 40,
		42,  3, 90,  6,
		39,  3, 75,  3,
		4,
		{3,3,7,3,7,7,7,8,7,7,7,7,3,8,7,3,3,7,8,8,8,7,3,7,9,7,1,1,1,1},
		{19,19,27,19,47,37,27,28,27,27,46,27,19,37,37,
		 19,19,37,20,19,20,29,20,37,
		 37,29,0,0,0,0}
	},

	{
		"Dwarf",
		{  2, -3,  2, -2,  2, -3, 0 },
		15,  0,
		11,  10,
		35, 15,
		48,  3, 150, 10,
		46,  3, 120, 10,
		5,
		{8,8,6,8,6,6,7,7,4,4,4,7,4,4,4,10,8,4,9,9,9,8,9,4,3,6,1,1,1,1},
		{27,27,19,27,19,19,19,28,20,19,10,19,11,10,10,
		 45,37,20,19,19,29,20,27,20,
		 10,20,0,0,0,0}
	},

	{
		"Half-Orc",
		{  2, -1,  0,  0,  1, -4 -1 },
		12, -5,
		10,  10,
		11,  4,
		66,  1, 150,  5,
		62,  1, 120,  5,
		3,
		{10,8,8,9,4,4,4,4,3,3,3,4,3,3,4,8,8,3,4,7,7,7,6,7,4,4,4,1,1,1},
		{55,46,10,47,10,19,20,19,10,19,10,20,11,10,10,
		 28,28,10,19,19,19,10,46,10,
		 20,10,0,0,0,0}
	},

	{
		"Half-Troll",
		{ 4, -4, -2, -4,  3, -6, -2 },
		20, -10,
		12,  9,
		20, 10,
		96, 10, 250, 50,
		84,  8, 225, 40,
		3,
		{9,10,4,10,4,4,4,6,4,4,4,6,4,4,4,6,6,4,4,9,8,8,8,8,7,4,3,1,1,1},
		{45,64,10,64,10,19,20,10,10,29,11,10,11,10,11,
		 19,19,11,19,19,19,11,64,11,
		 10,11,0,0,0,0}
	},
	{
		"Dunadan",
		{  1,  2,  2,  2,  3,  2, 1 },
		15, 10,
		10,  45,
		50, 20,
		82, 5, 190, 20,
		78,  6, 180, 15,
		0,
		{4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4},
		{46,46,46,46,46,46,46,46,46,46,46,46,19,46,46,
		 46,46,46,46,46,46,46,46,46,
		 46,46,0,0,0,0}
	},

	{
		"High-Elf",
		{  1,  3, -1,  3,  1,  5, 3 },
		10, 25,
		10,  45,
		100, 30,
		90, 10, 190, 20,
		82, 10, 180, 15,
		4,
		{5,4,4,4,5,5,5,5,4,4,4,4,5,5,4,5,5,4,4,7,7,6,3,3,5,5,5,1,1,1},
		{45,46,45,47,55,45,45,45,45,46,46,45,29,55,55,
		 64,64,46,46,46,46,46,37,55,
		 46,64,0,0,0,0}
	},

	{
		"Dark-Elf",
		{ -1,  3,  0,  2, -3, -2,  -1},
		 0, 10,
		8, 7,
		80, 150,
		40, 10, 90, 20,
		35, 15, 70, 10,
		6,
		{8,2,6,3,8,9,10,10,6,8,8,10,10,6,3,2,2,9,2,8,8,8,2,4,7,10,1,1,1,1},
		{47,10,19,11,37,55,45,46,28,27,28,47,55,29,37,
		 20,20,27,11,19,10,20,11,27,
		 20,45,0,0,0,0}
	},

	{
		"Giant",
		{ 2, -1,  2, -3,  4, -2,  1 },
		 20, -10,
		15,  0,
		20, 10,
		120, 70, 255, 50,
		114, 12, 255, 40,
		2,
		{7,10,3,10,3,6,5,5,3,3,3,5,9,3,3,6,6,3,3,10,8,8,10,4,3,5,1,1,1,1},
		{28,53,20,64,11,37,28,10,11,11,19,28,37,11,11,
		 19,19,10,19,19,19,10,55,10,
		 11,19,0,0,0,0}
	}
};


/*
 * Hack -- the spell information table.
 *
 *   Realm Name
 *   Spell Book
 *   Spell Stat,
 *   Spell Encumbrance,
 * Skill required.
 *   Array of { Lev, Mana, Fail, Exp/Lev }
 */
player_magic magic_info[MAX_REALM+1] =
{
		/*** None (warrior?) ***/
	{
		"",
		0,
		0,
		0,
		0,
		{
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},

			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0},
			{ 99,  0,  0,   0}
		}
	},

	{
		/*** Wizard ***/

		"Wizard",
		TV_MAGIC_BOOK,
		A_INT,
		300,
		S_MPOWER,
		{
			/* Beginners Magic */
			{    1,  1, 22,   1},
			{    1,  1, 23,   1},
			{    1,  2, 24,   1},
			{    3,  2, 26,   1},
			{  3,  2, 27,   1},
			{  3,  2, 25,   2},
			{  3,  2, 30,   2},
			{    3,  2, 25,   2},
			{    3,  3, 27,   2},
			/* Conjuring and Tricks */
			{    5,  3, 30,   3},
			{    5,  3, 30,   3},
			{    9,  5, 70,   4},
			{    9,  4, 30,   5},
			{ 11,  4, 35,   6},
			{ 11,  5, 35,   7},
			{ 13, 10, 70,   8},
			{ 11,  4, 35,   9},
			{ 15,  6, 44,  12},
			/* Incantations and Illusions */
			{ 17,  6, 45,  14},
			{ 19,  6, 75,  16},
			{ 21,  7, 45,  18},
			{ 23,  7, 45,  20},
			{ 25,  7, 75,  22},
			{ 21,  6, 40,  20},
			{ 23,  7, 45,  22},
			{ 31,  9, 50,  28},
			/* Sorcery and Evocations */
			{ 33, 10, 55,  30},
			{ 35, 11, 90,  32},
			{ 37, 12, 60,  34},
			{ 39, 14, 65,  36},
			{ 41, 16, 65,  38},
			{ 43, 18, 70,  50},
			{ 45, 20, 85,  55},

			{ 15,5,  50,   100},
			{ 15,5,  50,   100},
			{ 15,5,  50,   100},
			{ 15,10, 75,   200},
			{ 25, 20,  85, 1000},
			{ 20,  7, 20,  50},
			{ 25, 12, 40, 100},
			{ 30, 17, 60, 110},

			{ 15, 5,  50,  10},
			{ 20, 10, 70,  100},
			{ 25, 30, 95, 1000},
			{ 30, 50, 70,  300},
			{ 35, 50, 80, 1000},

			{25, 5,  50,   100},
			{30, 12, 75,  300},
			{35, 20, 80,  800},
			{40, 30, 50, 2000},
			{45, 70, 75, 5000},

			{ 35, 25, 50, 120},
			{ 37, 27, 55, 120},
			{ 39, 29, 60,  30},
			{ 41, 31, 65,  50},
			{ 43, 33, 70, 100},
			{ 45, 35, 75, 200},
			{ 47, 37, 80, 300},
			{ 49, 50, 85,2000},
			{ 99, 0,  0,   0},
			{ 99, 0,  0,   0},
			{ 99, 0,  0,   0},
			{ 99, 0,  0,   0}
		}
	},

	{
		/*** Priest ***/
		"Priest",
		TV_PRAYER_BOOK,
		A_WIS,
		350,
		S_SLAY_EVIL,
		{
			{    1,  1, 10,   1},
			{    1,  2, 15,   1},
			{    1,  2, 20,   1},
			{    3,  2, 25,   1},
			{    3,  2, 25,   1},
			{    3,  3, 27,   2},
			{    3,  3, 27,   2},
			{    5,  3, 28,   3},
			{    5,  4, 29,   4},
			{    5,  4, 30,   5},
			{    7,  4, 32,   5},
			{    7,  5, 34,   5},
			{    7,  5, 36,   6},
			{    9,  5, 38,   7},
			{    9,  6, 38,   9},
			{ 11,  7, 38,   9},
			{ 11,  6, 38,  10},
			{ 13,  9, 48,  10},
			{ 13,  7, 40,  10},
			{ 15,  8, 42,  10},
			{ 17,  8, 42,  12},
			{ 19,  9, 55,  15},
			{ 21, 10, 45,  15},
			{ 23, 11, 45,  16},
			{ 25, 12, 50,  20},
			{ 27, 14, 50,  22},
			{ 29, 14, 55,  32},
			{ 31, 16, 60,  38},
			{ 33, 20, 70,  75},
			{ 39, 55, 90, 125},
			{ 45, 32, 85, 200},

			{ 30,  3, 50,   5},
			{ 33, 10, 50,  20},
			{ 36, 20, 80,  80},
			{ 39, 40, 75, 1000},
			{ 42, 50, 75, 100},
			{ 45, 60, 75, 3000},

			{ 30, 10, 50,   2},
			{ 33, 20, 60,   50},
			{ 36, 40, 70,   100},
			{ 43, 50, 80,  1000},
			{ 45, 70, 90,  2000},

			{ 35,  5, 50,   100},
			{ 38,  7, 60,   200},
			{ 41, 50, 70,  1000},
			{ 43, 60, 80,  2000},
			{ 45, 70, 90,  3000},

			{ 31, 6,  50,   50},
			{ 33, 10, 55,  100},
			{ 35, 20, 60,  1000},
			{ 37, 30, 65,  2000},
			{ 40, 40, 70,  3000},
			{ 43, 50, 75,  6000},

			{ 35, 25, 60,  100},
			{ 38, 28, 65,  300},
			{ 41, 31, 70,  1500},
			{ 43, 33, 75,  1000},
			{ 45, 45, 80,  4000},
			{ 99, 0,  0,   0},
			{ 99, 0,  0,   0},
			{ 99, 0,  0,   0},
			{ 99, 0,  0,   0},
			{ 99, 0,  0,   0}
		}
	},

	{
		/*** Druid ***/
		"Druid",
		TV_NATURE_BOOK,
		A_WIS,
		300,
		S_PERCEPTION,
		{
			{  1,  1, 15,   1},
			{    1,  1, 17,   1},
			{  1,  1, 19,   1},
			{    1,  2, 21,   1},
			{    3,  2, 23,   1},
			{    3,  2, 25,   2},
			{    3,  3, 27,   2},
			{  3,  3, 29,   3},
			{  5,  3, 31,   3},
			{  5,  4, 33,   4},
			{    7,  4, 35,   5},
			{  7,  5, 37,   5},
			{  9,  5, 39,   6},
			{  9,  5, 41,   7},
			{ 11,  6, 43,   8},
			{ 11,  6, 45,   9},
			{ 13,  7, 47,  10},
			{ 13,  7, 49,  10},
			{ 15,  7, 51,  10},
			{ 15,  8, 53,  10},
			{ 17,  9, 55,  12},
			{ 19, 10, 57,  14},
			{ 21, 11, 59,  16},
			{ 23, 12, 61,  18},
			{ 25, 13, 63,  20},
			{ 27, 14, 65,  22},
			{ 29, 15, 67,  26},
			{ 31, 16, 69,  30},
			{ 35, 17, 71,  34},
			{ 37, 18, 73,  40},
			{ 39, 19, 75,  60},
			{ 33, 20, 77, 400},

			{ 35,  3, 20,	2},
			{ 38,  5, 30,    50},
			{ 41,  3, 25,   100},
			{ 44, 13, 50,  1000},
			{ 47, 30, 60,  2000},
			{ 30,  3, 30,   100},
			{ 33,  5, 40,   200},
			{ 36,  9, 50,  1000},
			{ 39, 30, 60,  2000},
			{ 42, 50, 70,  3000},
			{ 35, 17, 40,   300},
			{ 38, 19, 50,   500},
			{ 41, 21, 60,   700},
			{ 44, 23, 70,  1000},
			{ 47, 25, 80,  1300},

			{ 30, 15, 30,   100},
			{ 32, 18, 40,   300},
			{ 34, 25, 50,   800},
			{ 36, 29, 60,  1200},
			{ 38, 35, 70,  1800},

			{ 36, 25, 40, 500},
			{ 38, 28, 50, 700},
			{ 40, 31, 60, 900},
			{ 42, 35, 70,1300},
			{ 44, 40, 80,1700}
		}
	},

	{
		/*** Necros ***/
		"Necro",
		TV_DARK_BOOK,
		A_CON,
		300,
		S_SLAY_UNDEAD,
		{
			{    1,  1, 25,   1},
			{    1,  1, 27,   1},
			{    1,  1, 29,   1},
			{    1,  2, 31,   1},
			{  3,  2, 33,   2},
			{    3,  2, 35,   2},
			{  3,  3, 37,   2},
			{    3,  3, 39,   2},
			{    5,  4, 41,   2},
			{    5,  4, 43,   3},
			{    7,  5, 45,   3},
			{    7,  6, 47,   4},
			{    9,  6, 49,   5},
			{    9,  7, 51,   6},
			{ 11,  8, 53,   7},
			{ 11,  9, 55,   2},
			{ 13, 10, 57,  10},
			{ 13, 11, 59,  12},
			{ 15, 12, 61,  14},
			{ 17, 13, 63,  16},
			{ 19, 14, 65,  18},
			{ 21, 15, 67,  20},
			{ 23, 16, 69,  22},
			{ 25, 17, 71,  24},
			{ 27, 19, 73,  26},
			{ 29, 21, 75,  28},
			{ 31, 23, 77,  30},
			{ 33, 25, 79,  32},
			{ 35, 27, 81,  34},
			{ 37, 29, 83,  36},
			{ 45, 31, 85,  38},

	 /* Mastery of the Undead */
			{ 38, 20, 60, 350},
			{ 41, 25, 65, 455},
			{ 44, 30, 70, 650},
			{ 47, 35, 75,1000},

	 /* Protection from Undead */
			{ 40, 40, 70, 410},
			{ 42, 45, 75, 620},
			{ 44, 50, 80,1120},
			{ 46, 55, 85,1530},

	 /* Mastery of Life Force */
			{ 38, 20, 60, 300},
			{ 40, 25, 70, 500},
			{ 42, 30, 75, 700},
			{ 44, 35, 85,1200},
			{ 46, 40, 95,1800},
	 /* Bodily Infusions */
			{ 30, 30, 60,  600},
			{ 35, 35, 65,  900},
			{ 40, 40, 70, 1500},
			{ 45, 45, 75, 2500},

	 /* Unholy Perceptions */
			{ 25,30,  60,   100},
			{ 35,35,  70,   300},
			{ 40,40,  80,   900},
			{ 45,45,  90,  1500},

	
			{ 35, 10, 75,   200},
			{ 40, 20,  85, 1000},

			{ 15, 5,  50,  100},
			{ 20, 12, 75,  300},
			{ 25, 20, 80,  800},
			{ 30, 30, 50, 2000},
			{ 40, 40, 75, 5000},

			{ 99, 0,  0,   0},
			{ 99, 0,  0,   0},
			{ 99, 0,  0,   0},
			{ 99, 0,  0,   0}
		}
	}
};


/*
 * Spells in each book (mage spells then priest spells)
 */
u32b spell_flags[4][9][2] =
{
	{
		/*** Mage spell books ***/
		{ 0x000001ff, 0x00000000 },
		{ 0x0003fe00, 0x00000000 },
		{ 0x03fc0000, 0x00000000 },
		{ 0xfc000000, 0x00000001 },
		{ 0x00000000, 0x0000003e },
		{ 0x00000000, 0x000001c0 },
		{ 0x00000000, 0x00003e00 },
		{ 0x00000000, 0x0007c000 },
		{ 0x00000000, 0x07f80000 }
	},

  {
    /*** Priest spell books ***/
    { 0x000000ff, 0x00000000 },
    { 0x0000ff00, 0x00000000 },
    { 0x01ff0000, 0x00000000 },
    { 0x7e000000, 0x00000000 },
    { 0x80000000, 0x0000001f },
    { 0x00000000, 0x000003e0 },
    { 0x00000000, 0x00007c00 },
    { 0x00000000, 0x001f8000 },
    { 0x00000000, 0x03e00000 }
  },

	{
		/*** Druid spell books ***/
		{ 0x000001ff, 0x00000000 },
		{ 0x0003fe00, 0x00000000 },
		{ 0x03fc0000, 0x00000000 },
		{ 0xfc000000, 0x00000000 },
		{ 0x00000000, 0x0000001f },
		{ 0x00000000, 0x000003e0 },
		{ 0x00000000, 0x00007c00 },
		{ 0x00000000, 0x000f8000 },
		{ 0x00000000, 0x01f00000 }
	},

	{
		/*** Necro spell books */
		{ 0x000000ff, 0x00000000 },
		{ 0x0000ff00, 0x00000000 },
		{ 0x00ff0000, 0x00000000 },
		{ 0x7f000000, 0x00000000 },
		{ 0x80000000, 0x00000007 },
		{ 0x00000000, 0x00000078 },
		{ 0x00000000, 0x00000f80 },
		{ 0x00000000, 0x0000f000 },
		{ 0x00000000, 0x000f0000 }
	}
};


/*
 * Names of the spells (mage spells then priest spells)
 */
cptr spell_names[4][64] =
{
  /*** Mage Spells ***/

  {
    /* Magic for Beginners (sval 0) */
    "Magic Missile",
    "Detect Monsters",
    "Phase Door",
    "Light Area",
    "Treasure/Object Detection",
    "Find Hidden Traps/Doors",
    "Fetch Object",
    "Reinforce Door",
    "Stinking Cloud",

		/* Conjurings and Tricks (sval 1) */
    "Induce Terror",
    "Lightning Bolt",
    "Magic Storm",
    "Sleep I",
    "Cure Poison",
    "Teleport Self",
    "Mana Bolt",
    "Frost Bolt",
    "Turn Stone to Mud",

    /* Incantations and Illusions (sval 2) */
    "Sustinence",
    "Recharge Item I",
    "Sleep II",
    "Polymorph Other",
    "Identify",
    "Lightning Ball",
    "Fire Bolt",
    "Slow Monster",

		/* Sorcery and Evocations (sval 3) */
    "Frost Ball",
    "Recharge Item II",
    "Teleport Other",
    "Haste Self",
    "Fire Ball",
    "Word of Destruction",
    "Regain Mana",

    /* Resistance of Scarabtarices (sval 4) */
    "Resist Fire",
    "Resist Cold",
    "Resist Acid",
    "Resist Poison",
    "Resistance",

    /* Mordenkainen's Escapes (sval 5) */
    "Door Creation",
    "Stair Creation",
    "Word of Recall",

    /* Kelek's Grimoire of Power (sval 6) */
    "Detect Evil",
    "Detect Enchantment",
    "Recharge Item III",
    "Genocide",
    "Mass Genocide",

    /* Tenser's transformations... (sval 7) */
    "Heroism",
    "Shield",
    "Berserker",
    "Essence of Speed",
    "Globe of Invulnerability",

    /* Raal's Tome of Destruction (sval 8) */
    "Sonic Storm",
    "Acid Ball",
    "Plasma Vortex",
    "Mana Storm",
    "Chaos Vortex",
    "Charge Floor",
    "Creeping Walls",
    "Hellfire",

    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)"
  },


  /*** Priest Spells ***/
  {
    /* Beginners Handbook (sval 0) */
    "Detect Evil",
    "Cure Light Wounds",
    "Bless",
    "Remove Fear",
    "Radiance",
    "Find Doors/Traps",
    "Spiritual Hammer",
    "Dispel Poison",

    /* Words of Wisdom (sval 1) */
    "Induce Peace",
    "Portal",
    "Cure Medium Wounds",
    "Chant",
    "Banish Animals",
    "Sustinence",
    "Remove Curse",
    "Resist Heat and Cold",

    /* Chants and Blessings (sval 2) */
    "Return Home",
    "Orb of Draining",
    "Cure Serious Wounds",
    "True Invisibility",
    "Protection from Evil",
    "Earthquake",
    "Sense Surroundings",
    "Cure Critical Wounds",
    "Turn Undead",
    /* Exorcism and Dispelling (sval 3) */
    "Banish Evil",
    "Dispel Undead",
    "Heal",
    "Dispel Evil",
    "Glyph of Warding",
    "Holy Word",

    /* Ethereal openings (sval 4) */
    "Blink",
    "Teleport",
    "Teleport Away",
    "Teleport Level",
    "Survive Death",
    "Alter Reality",

    /* Godly Insights... (sval 5) */
    "Detection",
    "Perception",
    "Probing",
    "Clairvoyance",
    "Self-Knowledge",

    /* Purifications and Healing (sval 6) */
    "Resistance",
    "Holy Shield",
    "Restoration",
    "Remembrance",
    "Damage Immunity",

    /* Holy Infusions (sval 7) */
    "Recharging",
    "Dispel Curse",
    "Battle Speed",
    "Enchant Weapon",
    "Enchant Armour",
    "Elemental Brand",
    /* Wrath of God (sval 8) */
    "Stun Bolt",
    "Dispel Evil",
    "Annihilate Evil",
    "Word of Destruction",
    "Annihilation",

    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)"
  },
  /*** Druid spells ***/
  {
    "Sense Life",
    "Sense Weather",
    "Blessing",
    "Remove Fear",
    "Call Sunlight",
    "Find Traps/Doors",
    "Cure Light Wounds",
    "Dispel Poison",
    "Return Home",
    "Induce Peace",
    "Cure Medium Wounds",
    "Banish Animals",
    "Phase Rock",
    "Resist Elements",
    "Cure Serious Wounds",
    "Sustain Self",
    "Putrid Vapors",
    "Chain Lightning",
    "Sense Area",
    "Icy Spear",
    "Major Cure",
    "Flaming Stone",
    "Gust of Wind",
    "Blizzard",
    "Heat Wave",
    "Thunderstorm",
    "Sickening Mists",
    "Form of the Sheep",
    "Form of the Goat",
    "Total Healing",
    "Super Speed",
    "Regain Harmony",

    /* Shapeshifting */
    "Form of the Bear",
    "Form of the Lion",
    "Form of the Gazelle",
    "Form of the Cheetah",
    "Form of the Dragon",
    /* Dungeon Insights */
    "Understand Item",
    "Find Material Goods",
    "Probing",
    "Magical Staircase",
    "View Dungeon",

    /* Primal Forces */
    "Battle Blessing",
    "Iron Will",
    "Fighting Fury",
    "Mystic Shield",
    "Mass Sleep",

    /* Elemental Mastery */
    "Essence of Flame",
    "Absolute Zero",
    "Lethal Plague",
    "Hurricane",
    "Thunder Strike",
   
    /* Weather Control */
    "Arid Wastes",
    "Torrential Downpour",
    "Wind Songs",
    "Calm Winds",
    "Call Frost",
    "Scorch Earth",

    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)"
  },

  /*** Necro spells ***/
  {
    "Sense Undead",
    "Blink",
    "Undo Curse",
    "Brighten Room",
    "Confuse",
    "Find Doors/Traps",
    "Slow Poison",
    "Sleep Other",
    "Destroy Undead",
    "Find Food",
    "Block Heat/Cold",
    "Slow Undead",
    "Iron Will",
    "Shift Position",
    "Return",
    "Detect Life",
    "True Sight",
    "Disrupt Life",
    "Remove Wounds",
    "Block Undead",
    "Insight",
    "Drain Life",
    "Weaken Others",
    "Repel Other",
    "Curse Weapon",
    "Battle Power",
    "Poison Shield",
    "Mystic Barrier",
    "Slay Living",
    "Infuse Weapon",
    "Destroy Cavern",

    /* Mastery of the Undead (sval 4) */
    "Banish Non-Living",
    "Annihilate Undead",
    "Destroy Life",
    "Summon Holy Spirits",
    /* Protection from Undead (sval 5) */
    "Partial Restoration",
    "Rememberance",
    "Restoration",
    "Retake life",

    /* Mastery of Life Force (sval 6) */
    "Regain Mana",
    "Annihilate Animals",
    "Vampiric Drain",
    "Genocide",
    "Total Genocide",

    /* Bodily Infusions (sval 7) */
    "Regeneration",
    "Fighting Rage",
    "Lich Form",
    "Barrier",

    /* Unholy Perceptions (sval 8) */
    "Detection",
    "Probing",
    "Sense Room",
    "Detect Dungeon",

    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)",
    "(blank)"
  }
};

/*
 * Each chest has a certain set of traps, determined by pval
 * Each chest has a "pval" from 1 to the chest level (max 55)
 * If the "pval" is negative then the trap has been disarmed
 * The "pval" of a chest determines the quality of its treasure
 * Note that disarming a trap on a chest also removes the lock.
 */
byte chest_traps[64] =
{
	0,				   /* 0 == empty */
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),		   /* 5 == best small wooden */
	0,
	(CHEST_POISON),
	(CHEST_POISON),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_POISON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),			/* 15 == best large wooden */
	0,
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_LOSE_STR),
	(CHEST_LOSE_CON),
	(CHEST_EXPLODE),		    /* 25 == best small iron */
	0,
	(CHEST_POISON | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_PARALYZE),
	(CHEST_POISON | CHEST_SUMMON),
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),    /* 35 == best large iron */
	0,
	(CHEST_SUMMON),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_EXPLODE),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_POISON | CHEST_PARALYZE),   /* 45 == best small steel */
	0,
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE | CHEST_LOSE_STR | CHEST_LOSE_CON),
	(CHEST_POISON | CHEST_PARALYZE),
	(CHEST_POISON | CHEST_PARALYZE),   /* 55 == best large steel */
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
	(CHEST_EXPLODE | CHEST_SUMMON),
};
/*
 * Hack -- the "basic" color names (see "TERM_xxx")
 */
cptr color_names[16] =
{
	"Dark",
	"White",
	"Slate",
	"Orange",
	"Red",
	"Green",
	"Blue",
	"Umber",
	"Light Dark",
	"Light Slate",
	"Violet",
	"Yellow",
	"Light Red",
	"Light Green",
	"Light Blue",
	"Light Umber",
};


/*
 * Abbreviations of healthy stats
 */
cptr stat_names[7] =
{
	"STR: ", "INT: ", "WIS: ", "DEX: ", "CON: ", "CHR: ", "LUC: "
};

/*
 * Abbreviations of damaged stats
 */
cptr stat_names_reduced[7] =
{
	"Str: ", "Int: ", "Wis: ", "Dex: ", "Con: ", "Chr: ", "Luc: "
};

/*
 * Certain "screens" always use the main screen, including News, Birth,
 * Dungeon, Tomb-stone, High-scores, Macros, Colors, Visuals, Options.
 *
 * Later, special flags may allow sub-windows to "steal" stuff from the
 * main window, including File dump (help), File dump (artifacts, uniques),
 * Character screen, Small scale map, Previous Messages, Store screen, etc.
 *
 * The "ctrl-i" (tab) command flips the "Display inven/equip" and "Display
 * equip/inven" flags for all windows.
 *
 * The "ctrl-g" command (or pseudo-command) should perhaps grab a snapshot
 * of the main screen into any interested windows.
 */
cptr window_flag_desc[32] =
{
	"Display inven/equip",
	"Display equip/inven",
	"Display spell list",
	"Display character",
	NULL,
	NULL,
	"Display messages",
	"Display overhead view",
	"Display monster recall",
	"Display object recall",
	NULL,
	"Display snap-shot",
	NULL,
	NULL,
	"Display borg messages",
	"Display borg status",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL
};


/*
 * Available Options
 *
 * Option Screen Sets:
 *
 *   Set 1: User Interface
 *   Set 2: Disturbance
 *   Set 3: Inventory
 *   Set 4: Game Play
 *
 *   Set 255: Cheating
 *
 * Bit pairs not used in savefiles:
 *
 *   Set 1: 9, 16-19, 21, 26-31
 *   Set 2: 25, 31
 *   Set 3: 12
 *   Set 4: 8-15, 30-31
 *
 * XXX XXX XXX Note that the "cheating options" can only be set in
 * the "do_cmd_prefs()" function, since they must set the special
 * "I am a cheater" flags.
 *
 * XXX XXX XXX Option to add:
 *   auto-grab interesting snap-shots
 *
 * XXX XXX XXX Note that the "page 99" options are needed only to parse
 * Angband 2.7.9v6 savefiles until Angband 2.8.0 is ready.
 */
option_type option_info[] =
{
	/*** User-Interface ***/

	{ &rogue_like_commands,	FALSE,	1,	0, 0,
	"rogue_like_commands",	"Rogue-like commands" },

	{ &quick_messages,	 	FALSE,	1,	0, 1,
	"quick_messages",		"Activate quick messages" },
	{ &other_query_flag,	FALSE,	1,	0, 2,
	"other_query_flag",		"Prompt for various information" },

	{ &carry_query_flag,	FALSE,	1,	0, 3,
	"carry_query_flag",		"Prompt before picking things up" },

	{ &use_old_target,		FALSE,	1,	0, 4,
	"use_old_target",		"Use old target by default" },

	{ &always_pickup,		TRUE,	1,	0, 5,
	"always_pickup",		"Pick things up by default" },

	{ &always_repeat,		TRUE,	1,	0, 6,
	"always_repeat",		"Repeat obvious commands" },

	{ &depth_in_feet,		FALSE,	1,	0, 7,
	"depth_in_feet",		"Show dungeon level in feet" },

	{ &stack_force_notes,	FALSE,	1,	0, 8,
	"stack_force_notes",	"Merge inscriptions when stacking" },

	{ &stack_force_costs,	FALSE,	1,	0, 9,
	"stack_force_costs",	"Merge discounts when stacking" },

	{ &show_labels,			TRUE,	1,	0, 10,
	"show_labels",			"Show labels in object listings" },

	{ &show_weights,		FALSE,	1,	0, 11,
	"show_weights",			"Show weights in object listings" },

	{ &show_choices,		FALSE,	1,	0, 12,
	"show_choices",			"Show choices in certain sub-windows" },

	{ &show_details,		FALSE,	1,	0, 13,
	"show_details",			"Show details in certain sub-windows" },

	{ &ring_bell,			TRUE,	1,	0, 14,
	"ring_bell",			"Audible bell (on errors, etc)" },

	{ &use_color,			TRUE,	1,	0, 15,
	"use_color",			"Use color if possible (slow)" },

	/*** Disturbance ***/

	{ &find_ignore_stairs,	TRUE,	2,	0, 16,
	"find_ignore_stairs",	"Run past stairs" },

	{ &find_ignore_doors,	TRUE,	2,	0, 17,
	"find_ignore_doors",	"Run through open doors" },

	{ &find_cut,			TRUE,	2,	0, 18,
	"find_cut",				"Run past known corners" },

	{ &find_examine,		TRUE,	2,	0, 19,
	"find_examine",			"Run into potential corners" },

	{ &disturb_move,		TRUE,	2,	0, 20,
	"disturb_move",			"Disturb whenever any monster moves" },

	{ &disturb_near,		TRUE,	2,	0, 21,
	"disturb_near",			"Disturb whenever viewable monster moves" },

	{ &disturb_panel,		TRUE,	2,	0, 22,
	"disturb_panel",		"Disturb whenever map panel changes" },

	{ &disturb_state,		TRUE,	2,	0, 23,
	"disturb_state",		"Disturb whenever player state changes" },

	{ &disturb_minor,		TRUE,	2,	0, 24,
	"disturb_minor",		"Disturb whenever boring things happen" },

	{ &disturb_other,		TRUE,	2,	0, 25,
	"disturb_other",		"Disturb whenever various things happen" },

	{ &alert_hitpoint,		FALSE,	2,	0, 26,
	"alert_hitpoint",		"Alert user to critical hitpoints" },

	{ &alert_failure,		FALSE,	2,	0, 27,
	"alert_failure",		"Alert user to various failures" },


	/*** Game-Play ***/

	{ &auto_haggle,			FALSE,	3,	1, 0,
	"auto_haggle",			"Auto-haggle in stores" },
	{ &auto_scum,			FALSE,	3,	1, 1,
	"auto_scum",			"Auto-scum for good levels" },

	{ &stack_allow_items,	TRUE,	3,	1, 2,
	"stack_allow_items",	"Allow weapons and armor to stack" },

	{ &stack_allow_wands,	TRUE,	3,	1, 3,
	"stack_allow_wands",	"Allow wands/staffs/rods to stack" },

	{ &expand_look,			FALSE,	3,	1, 4,
	"expand_look",			"Expand the power of the look command" },

	{ &expand_list,			FALSE,	3,	1, 5,
	"expand_list",			"Expand the power of the list commands" },

	{ &view_perma_grids,	TRUE,	3,	1, 6,
	"view_perma_grids",		"Map remembers all perma-lit grids" },

	{ &view_torch_grids,	FALSE,	3,	1, 7,
	"view_torch_grids",		"Map remembers all torch-lit grids" },

	{ &dungeon_align,		TRUE,	3,	1, 8,
	"dungeon_align",		"Generate dungeons with aligned rooms" },

	{ &dungeon_stair,		TRUE,	3,	1, 9,
	"dungeon_stair",		"Generate dungeons with connected stairs" },

	{ &flow_by_sound,		FALSE,	3,	1, 10,
	"flow_by_sound",		"Monsters chase current location (v.slow)" },

	{ &flow_by_smell,		FALSE,	3,	1, 11,
	"flow_by_smell",		"Monsters chase recent locations (v.slow)" },

	{ &track_follow,		FALSE,	3,	1, 12,
	"track_follow",			"Monsters follow the player (broken)" },

	{ &track_target,		FALSE,	3,	1, 13,
	"track_target",			"Monsters target the player (broken)" },

	{ &smart_learn,			FALSE,	3,	1, 14,
	"smart_learn",			"Monsters learn from their mistakes" },

	{ &smart_cheat,			FALSE,	3,	1, 15,
	"smart_cheat",			"Monsters exploit players weaknesses" },


	/*** Efficiency ***/

	{ &view_reduce_lite,	FALSE,	4,	1, 16,
	"view_reduce_lite",		"Reduce lite-radius when running" },

	{ &view_reduce_view,	FALSE,	4,	1, 17,
	"view_reduce_view",		"Reduce view-radius in town" },

	{ &avoid_abort,			FALSE,	4,	1, 18,
	"avoid_abort",			"Avoid checking for user abort" },

	{ &avoid_other,			FALSE,	4,	1, 19,
	"avoid_other",			"Avoid processing special colors" },

	{ &flush_failure,		TRUE,	4,	1, 20,
	"flush_failure",		"Flush input on various failures" },

	{ &flush_disturb,		FALSE,	4,	1, 21,
	"flush_disturb",		"Flush input whenever disturbed" },

	{ &flush_command,		FALSE,	4,	1, 22,
	"flush_command",		"Flush input before every command" },

	{ &fresh_before,		TRUE,	4,	1, 23,
	"fresh_before",			"Flush output before every command" },

	{ &fresh_after,			FALSE,	4,	1, 24,
	"fresh_after",			"Flush output after every command" },

	{ &fresh_message,		FALSE,	4,	1, 25,
	"fresh_message",		"Flush output after every message" },

	{ &compress_savefile,	TRUE,	4,	1, 26,
	"compress_savefile",	"Compress messages in savefiles" },

	{ &hilite_player,		FALSE,	4,	1, 27,
	"hilite_player",		"Hilite the player with the cursor" },

	{ &view_yellow_lite,	FALSE,	4,	1, 28,
	"view_yellow_lite",		"Use special colors for torch-lit grids" },

	{ &view_bright_lite,	FALSE,	4,	1, 29,
	"view_bright_lite",		"Use special colors for 'viewable' grids" },

	{ &view_granite_lite,	FALSE,	4,	1, 30,
	"view_granite_lite",	"Use special colors for wall grids (slow)" },

	{ &view_special_lite,	FALSE,	4,	1, 31,
	"view_special_lite",	"Use special colors for floor grids (slow)" },


	/*** Testing ***/

	{ &testing_stack,		FALSE,	255, 7, 30,
	"testing_stack",		"Testing -- allow objects to stack on floor" },

	{ &testing_carry,		FALSE,	255, 7, 31,
	"testing_carry",		"Testing -- allow monsters to carry objects" },


	/*** End of Table ***/

	{ NULL,			0, 0, 0, 0,
	NULL,			NULL }
};

/* This holds the 'relative' level of each attribute.	First 32 are the
	 levels for the 'flags' bit flags.	Level 255 means not a valid flag.
	 Also used for weapons appraisal */
byte levels[96]=
{30, 35, 35, 30, 30, 25,255,255, 25, 35, 50, 10, 90,255,255,255,
 25, 45, 20, 35, 25, 30, 25, 30, 65,255,110, 40,255,255, 15, 15,

 45, 45, 45, 45, 45, 45,255,255, 80, 80, 80, 80,255,255, 55, 80,
 15, 10, 10, 10, 75, 80, 45, 45, 45, 55, 50, 45, 70, 90, 50, 85,
255,255,255,255,255,255,255,255,255,255,255,255, 15, 20, 35, 60,
 20, 40,255,255,255,255,255,255,255,255,100,100,255,100,100,100
};
