/* Private header file for XCXAPP.C */

extern GLOBALOPTIONS GlobalOptions;

static int init_visual(int screen, Display *display, Visual **visual, int *depth);
static int init_toolbox(TOOLBOX *toolbox);
static int init_colormap(Widget widget);
static int init_ximages(int numpages, int width, int height, Display *display, Visual *visual);

static XrmOptionDescRec Options[] = {
		/* Use private colormap */
	{"-private", ".private", XrmoptionNoArg, (caddr_t) "1"},
		/* Verbose mode */
	{"-verbose", ".verbose", XrmoptionNoArg, (caddr_t) "1" },
	{"-v", ".verbose", XrmoptionNoArg, (caddr_t) "1" },
		/* Print out fps timings info */
	{"-timing", ".timing", XrmoptionNoArg, (caddr_t) "1" },
		/* Flip output from frame/sec to sec/frame */
	{"-flip", ".flip", XrmoptionNoArg, (caddr_t) "1" },

	{"-pages", ".pages", XrmoptionSepArg, (caddr_t) NULL },
	{"-resolution", ".resolution", XrmoptionSepArg, NULL },
	{"-device", ".device", XrmoptionSepArg, (caddr_t) NULL }
};

#define DEFAULT_RES_PRIVATE			0
#define DEFAULT_RES_VERBOSE			0
#define DEFAULT_RES_TIMING				0
#define DEFAULT_RES_FLIP				0
#define DEFAULT_RES_RESOLUTION		0

static char *FallbackResources[] = {
	".private: 0",
	".verbose: 0",
	".timing: 0",
	".flip: 0",
	".pages: 1",
	".resolution: 0",
	".device: /dev/cx100",
	NULL
};

static int One = 1;
static int Zero = 0;

static XtResource Resources[] = {
	{ "pages", "Pages", XtRInt, sizeof(GlobalOptions.pages),
		XtOffsetOf(GLOBALOPTIONS, pages), XtRInt, &Zero },
	{ "private", "Private", XtRInt, sizeof(GlobalOptions.private),
		XtOffsetOf(GLOBALOPTIONS, private), XtRInt, &Zero },
	{ "verbose", "Verbose", XtRInt, sizeof(GlobalOptions.verbose),
		XtOffsetOf(GLOBALOPTIONS, verbose), XtRInt, DEFAULT_RES_VERBOSE },
	{ "pages", "Pages", XtRInt, sizeof(GlobalOptions.pages),
		XtOffsetOf(GLOBALOPTIONS, pages), XtRInt, &One },
	{ "timing", "Timing", XtRInt, sizeof(GlobalOptions.timing),
		XtOffsetOf(GLOBALOPTIONS, timing), XtRInt, DEFAULT_RES_TIMING },
	{ "flip", "Flip", XtRInt, sizeof(GlobalOptions.flip),
		XtOffsetOf(GLOBALOPTIONS, flip), XtRInt, &Zero },
	{ "resolution", "Resolution", XtRInt,
		sizeof(GlobalOptions.resolution),
		XtOffsetOf(GLOBALOPTIONS, resolution), XtRInt, &Zero },
	{ "device", "Device", XtRString, sizeof(GlobalOptions.device),
		XtOffsetOf(GLOBALOPTIONS, device), XtRString, "/dev/cx100" }
};

