//  grabber.C: initialize the PMS-board and
//             grabbing captured frames from the PMS-board
//  a part of PMS-grabber package
// the "GNU Public Lincense" policy applies to all programs of this package
// (c) Wolfgang Koehler, wolf@first.gmd.de, Dec. 1994
//     Kiefernring 15
//     14478 Potsdam, Germany
//     0331-863238
//     wolf@first.gmd.de 11/94

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h> // iopl,ioperm
#include "memmap.h"

/* #include <asm/io.h> /usr/linux/include -> undefined symbols __outb !*/
#ifdef SPARC
  // define dummies -> only for compile test -> never run it !!!
  void outb(unsigned char value, unsigned short port) {}
  void outw(unsigned short value, unsigned short port) {}
  unsigned int inb(unsigned short port) {}
  int iopl(...) {}
  int ioperm(...) {}
#else
// #define DEBUG_PORTS 
inline static void outb(unsigned char value, unsigned short port) {
  __asm__ volatile ("outb %b0,%w1"
		    : /* no outputs */
		    :"a" (value),"d" (port));
#ifdef DEBUG_PORTS
  printf("outb %2x -> %4x\n",value,port);
#endif
}

inline void outw(unsigned short value, unsigned short port) {
  __asm__ volatile ("outw %w0,%w1"
		    : /* no outputs */
		    :"a" (value),"d" (port));
#ifdef DEBUG_PORTS
  printf("outw %4x -> %4x\n",value,port);
#endif
}

inline static unsigned int inb(unsigned short port) {
  unsigned int _v;
  __asm__ volatile ("inb %w1,%b0"
		    :"=a" (_v):"d" (port),"0" (0));
#ifdef DEBUG_PORTS
  printf("inb %2x <- %4x\n",_v,port);
#endif
  return _v;
}
#endif // not SPARC


#include "mvv_parms.h" // definition of port, irq, address

static
int mvpi = ProMoviePort, // the mvv port : index/ interrupt status
    mvpd = mvpi+1, // data register
    mvps = mvpi+2; // irq/dma select

int mvv_base = ProMovieAddr; // def = 0xc8000; // 0xd0000; 

#define OUT_MVV(val) outb(val, mvpi)
#define IN_MVV (inb(mvpd))

// write value to mvv-register [index]
void mvv_write(char index, char value) {
  outw(index | (value << 8),mvpi);
}

unsigned char mvv_read(char index) {
  outb(index, mvpi);
  return(inb(mvpd));
}

int i2cstat(unsigned char slave) { // .. 405ff
  OUT_MVV(0x28); 
  unsigned short cx = 0;
  while ((IN_MVV & 1) == 0) if (--cx == 0) break;
  while ((IN_MVV & 1) != 0) if (--cx == 0) break;
  outb(slave, mvpd);
  cx = 0;
  while ((IN_MVV & 1) == 0) if (--cx == 0) break;
  while ((IN_MVV & 1) != 0) if (--cx == 0) break;
//  printf("test slave %x\n",slave);
  int i;
  for (i=0; i < 12; i++) {
    char st = IN_MVV;
    if ((st & 2) != 0) return -1;
    if ((st & 1) == 0) break;
  }
  OUT_MVV(0x29);
  return (IN_MVV); 
}

#include "SetMVV.C"

void *mvv_buf;

#define MVVBUFSZ 0x1000
int mvv_init() {
  mvv_buf = pmem_map(mvv_base, MVVBUFSZ);
  if (mvv_buf == (void*) -1) {
    printf(" no mvv_buf !\n"); exit(1);
  }
  // Init .. 
  {  // WakeUpMVV... 
    {   // SetPort ...
       iopl(3); // the only level to get through here
       outb(0xb8, 0x9a01);
       outb(mvpi >> 4, 0x9a01);            // assign port 0x250 (>>4)
       iopl(0); // reset to normal permissions
       printf("io-port is set to %x\n",mvpi);
       ioperm(mvpi,3,1);               // 3 ports permission level 1
    }
    printf("MVV ID = %d ",mvv_read(3)); 
    int idec,decst = i2cstat(0x43); 
    if (decst != -1) idec = 2; else
    if (i2cstat(0xb9) != -1) idec = 3; else
      if (i2cstat(0x8b) != -1) idec = 1; else idec = 0;
    printf("Decoder = %d \n",idec);
    if (idec == 0) exit(1);
  }
  // SetAddr ... 
    mvv_write(0x04,mvv_base >> 12);    // set PC memory address to 0xyy000
  // SetIrq ...
  // int temp = inb(ProMoviePort);
  // outw(0x882E,ProMoviePort);
  // outb(temp,ProMoviePort);
  // outb((inb(ProMoviePort + 2) & 0xF0) | ProMovieIRQ, ProMoviePort + 2);
  // IdentifyBoard 
 
      I2CWrite(0x8A,0x00,0x4C);
      I2CWrite(0x8A,0x01,0x30);
      I2CWrite(0x8A,0x02,0x00);
      I2CWrite(0x8A,0x03,0xE8);
      I2CWrite(0x8A,0x04,0xB6);
      I2CWrite(0x8A,0x05,0xE2);  //0xF2
      I2CWrite(0x8A,0x06,0x00);
      I2CWrite(0x8A,0x07,0x00);
      I2CAndOr(0x8A,0x08,0x07,0x00);  //QUAM
      I2CAndOr(0x8A,0x09,0x07,0x00);  //SECAM
      I2CWrite(0x8A,0x0A,0x00);    //0x40
      I2CWrite(0x8A,0x0B,0x00);    //0x50
      I2CWrite(0x8A,0x0C,0x00);
      I2CWrite(0x8A,0x0D,0x00);
      I2CWrite(0x8A,0x0E,0x78);
      I2CWrite(0x8A,0x0F,0x98 | 0x00);
      I2CWrite(0x8A,0x10,0x00);
      I2CWrite(0x8A,0x11,0x00);
      I2CWrite(0x8A,0x12,0x00);
      I2CWrite(0x8A,0x13,0x00);
      I2CWrite(0x8A,0x14,0x34);
      I2CWrite(0x8A,0x15,0x0A);
      I2CWrite(0x8A,0x16,0xF4);
      I2CWrite(0x8A,0x17,0xCE);
      I2CWrite(0x8A,0x18,0xE4);  //0xF4

      I2CWrite(0xB8,0x00,0x12 | 0x00);
      I2CWrite(0xB8,0x04,0x00);
      I2CWrite(0xB8,0x07,0x00);
      I2CWrite(0xB8,0x08,0x00);

      I2CWrite(0xB8,0x09,0xFF);
      I2CWrite(0xB8,0x0A,0x00);
      I2CWrite(0xB8,0x0B,0x10);
      I2CWrite(0xB8,0x10,0x03);

    mvv_write(0x01,0x00);    //Interrupt Mask: Enable Field/Compression interrupts
//    mvv_write(0x05,0x20);    //Refresh Ctrl
    mvv_write(0x05,0xA0);    //Refresh Ctrl
    mvv_write(0x08,0x25);    //PC Access: Enabled, RGB555
    mvv_write(0x09,0x00);    //Mem Page Ctrl: 0000h
    mvv_write(0x0A,0x20 | MVVMEMORYWIDTH);  //Mem Page Slct: 1024 WORDs, Auto incr
    mvv_write(0x10,0x02);    //Capture Ctrl: continuous capture enable, RGB565
    mvv_write(0x1E,0x0C);    //Cap Horz Total:magic PLL number
    mvv_write(0x1F,0x03);    //Cap Horz Total:magic PLL number
    mvv_write(0x26,0x06);    //????
    mvv_write(0x2B,0x00);    //????
    mvv_write(0x2C,0x20);    //Clamp Offset
    mvv_write(0x2D,0x00);    //Clamp Length
//    mvv_write(0x2E,0x31);    //Composite input
    mvv_write(0x2F,0x70);    //Re-sync enable (H,V,F)
//    mvv_write(0x30,0x22);    //Comp 
    mvv_write(0x32,0x00);    //Comp Mem Page Ctrl: 0000h
    mvv_write(0x33,MVVMEMORYWIDTH);  //Comp Mem Page Slct: 1024 WORDs
    mvv_write(0x34,0x00);    //Comp DMA Count (L)
    mvv_write(0x35,0x00);    //Comp DMA Count (H)

    mvv_write(0x3A,0x80);    //Compressor Luminance Control
    mvv_write(0x3B,0x10);   //Compressor Chrominance Control


    mvv_write(0x20,0x00);
    mvv_write(0x21,0x00);

    mvv_write(0x30,0x22);    //Comp 

    return (1);
}

void set_default(option_struct *opti) {
    int val = opti->iDefault;
    opti->iCurrent = val;
    opti->SetFunction(val);
    // char *modestr = (opti->OptionList) ? opti->OptionList[val] : "";
    // printf("setting %s to %d (%s)\n",opti->Desc, val, modestr);
}

void all_defaults() {
  int i;
  for(i=0; i< noptions;i++) set_default(option_vector+i);
}

/* old versions of capture
void capturex(void * buf) {
  unsigned char ist; 
  int ww = biWidth, wh = biHeight;
  //  char al = inb(mvpi);
  mvv_write(0x08,0x25);
  short i,ax,skip = 4*biWidth;
  
  short *dst = (short *) buf;
  short *src = (short *) mvv_buf;
c15loop:
  for (i=0; i < 8; i++)  ax = *src; // discard 8 word 
  for (i=0; i < ww; i++)  *dst++ = *src;
  if (--wh == 0) return;
  *src = skip;
  for (i=0; i<4;i++) inb(mvpi);
  goto c15loop;
 // OUT_MVV(al & 0x7f);
} 

void capture(void * buf, int rgb555) {
  unsigned char ist; 
  int i,y,ww = biWidth, wh = biHeight, dinc, zz, dw = 2*ww, loops;
  short *dst = (short *) buf;
  short *src = (short *) mvv_buf;

  if (wh > 256) { dinc = 2*ww; zz = wh/2; loops = 2; } 
    else { dinc = ww; zz = wh; loops = 1; }
  
  unsigned char r8 = 0x5; // value for reg8 
  if (rgb555) r8 |= 0x20; // else use untranslated rgb = 565

field_cap:  // capture one field
  
  mvv_write(0x08,r8); // capture rgb555/565, init DRAM, PC enable

  for (y = 0; y < zz; y++) {
    memcpy(dst,src, 16); // discard 8 word 
    memcpy(dst,src, dw); dst += dinc; 
    *src = 0;  // synchronisiert neue Zeile
  }
  
  if (--loops > 0) {
    mvv_write(0x14, mvv_read(0x14) | 0xC0 ); // capture odd fields (b7,b6)=(11)
    dst = (short*) buf + ww; // address odd lines
    goto field_cap;
  }
  // the next time capture even fields (b7,b6)=(10)
  if (wh > 256) mvv_write(0x14, (mvv_read(0x14) | 0x80) & ~0x40); 
} 
*/


// the image is in y direction stretched for the ratio ystretch/fg_heigth
// fg_height is the actually cpatured line number (global)
// (in pixels = 16bit), either rgb =  555 or 565
void fast_capture(unsigned short *dst, int width, int ystretch, int rgb555) {
  int y, dw = 2*width;
  short *src = (short *) mvv_buf;

  unsigned char r8 = 0x5; // value for reg8 
  if (rgb555) r8 |= 0x20; // else use untranslated rgb = 565
  mvv_write(0x08,r8); // capture rgb555/565, init DRAM, PC enable

  char tmp[dw+16]; // using a temp buffer is faster than direct 
  int cnt = 0;
  // printf("%d %d %d %d %d %x %x\n",width,height,voff,nom,den,mvv_buf); 
  
  for (y = 0; y < fg_height; y++ ) {
    *src = 0;  // synchronisiert neue Zeile
    memcpy(tmp, src, dw+16); // discard 8 word 
    cnt -= ystretch;
    while (cnt < 0) { 
      cnt += fg_height;
      memcpy(dst, tmp+16, dw);  dst += width;    
    }
  }
} 




