# == Class: vmms::client
#
# Installs vmms python client.
#
# === Parameters
#
# [*package_ensure*]
#   Ensure state for package. Defaults to 'present'.
#
class vmms::client(
  $package_ensure = 'present'
) {

  include vmms::deps
  include vmms::params

  package { 'python-vmmsclient':
    ensure => $package_ensure,
    name   => $::vmms::params::client_package,
    tag    => ['openstack', 'openstackclient'],
  }

  include openstacklib::openstackclient
}
